/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.CloseTracking;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.Milestone;
import com.spotify.github.v3.User;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Milestone", generator="Immutables")
@Immutable
public final class ImmutableMilestone
implements Milestone {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final GitHubInstant closedAt;
    @Nullable
    private final URI url;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final URI labelsUrl;
    @Nullable
    private final Integer id;
    @Nullable
    private final Integer number;
    @Nullable
    private final String state;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final User creator;
    @Nullable
    private final Integer openIssues;
    @Nullable
    private final Integer closedIssues;
    @Nullable
    private final GitHubInstant dueOn;

    private ImmutableMilestone(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable GitHubInstant closedAt, @Nullable URI url, @Nullable URI htmlUrl, @Nullable URI labelsUrl, @Nullable Integer id, @Nullable Integer number, @Nullable String state, @Nullable String title, @Nullable String description, @Nullable User creator, @Nullable Integer openIssues, @Nullable Integer closedIssues, @Nullable GitHubInstant dueOn) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.url = url;
        this.htmlUrl = htmlUrl;
        this.labelsUrl = labelsUrl;
        this.id = id;
        this.number = number;
        this.state = state;
        this.title = title;
        this.description = description;
        this.creator = creator;
        this.openIssues = openIssues;
        this.closedIssues = closedIssues;
        this.dueOn = dueOn;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> closedAt() {
        return Optional.ofNullable(this.closedAt);
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI labelsUrl() {
        return this.labelsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer number() {
        return this.number;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    @Nullable
    public User creator() {
        return this.creator;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer openIssues() {
        return this.openIssues;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer closedIssues() {
        return this.closedIssues;
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> dueOn() {
        return Optional.ofNullable(this.dueOn);
    }

    public final ImmutableMilestone withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableMilestone(value, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, value, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withClosedAt(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
        if (this.closedAt == newValue) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, newValue, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withClosedAt(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.closedAt == value) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, value, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, value, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, value, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withLabelsUrl(@Nullable URI value) {
        if (this.labelsUrl == value) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, value, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withId(@Nullable Integer value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, value, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withNumber(@Nullable Integer value) {
        if (Objects.equals(this.number, value)) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, value, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, value, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, value, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, newValue, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, value, this.creator, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withCreator(@Nullable User value) {
        if (this.creator == value) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, value, this.openIssues, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withOpenIssues(@Nullable Integer value) {
        if (Objects.equals(this.openIssues, value)) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, value, this.closedIssues, this.dueOn);
    }

    public final ImmutableMilestone withClosedIssues(@Nullable Integer value) {
        if (Objects.equals(this.closedIssues, value)) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, value, this.dueOn);
    }

    public final ImmutableMilestone withDueOn(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "dueOn");
        if (this.dueOn == newValue) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, newValue);
    }

    public final ImmutableMilestone withDueOn(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.dueOn == value) {
            return this;
        }
        return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMilestone && this.equalTo((ImmutableMilestone)another);
    }

    private boolean equalTo(ImmutableMilestone another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.closedAt, another.closedAt) && Objects.equals(this.url, another.url) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.labelsUrl, another.labelsUrl) && Objects.equals(this.id, another.id) && Objects.equals(this.number, another.number) && Objects.equals(this.state, another.state) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.creator, another.creator) && Objects.equals(this.openIssues, another.openIssues) && Objects.equals(this.closedIssues, another.closedIssues) && Objects.equals(this.dueOn, another.dueOn);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.closedAt);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.labelsUrl);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.number);
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.creator);
        h += (h << 5) + Objects.hashCode(this.openIssues);
        h += (h << 5) + Objects.hashCode(this.closedIssues);
        h += (h << 5) + Objects.hashCode(this.dueOn);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Milestone{");
        if (this.createdAt != null) {
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.updatedAt != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("updatedAt=").append(this.updatedAt);
        }
        if (this.closedAt != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("closedAt=").append(this.closedAt);
        }
        if (this.url != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.htmlUrl != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("htmlUrl=").append(this.htmlUrl);
        }
        if (this.labelsUrl != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("labelsUrl=").append(this.labelsUrl);
        }
        if (this.id != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("id=").append(this.id);
        }
        if (this.number != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("number=").append(this.number);
        }
        if (this.state != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("state=").append(this.state);
        }
        if (this.title != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("title=").append(this.title);
        }
        if (this.description != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("description=").append(this.description);
        }
        if (this.creator != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("creator=").append(this.creator);
        }
        if (this.openIssues != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("openIssues=").append(this.openIssues);
        }
        if (this.closedIssues != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("closedIssues=").append(this.closedIssues);
        }
        if (this.dueOn != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("dueOn=").append(this.dueOn);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMilestone fromJson(Json json) {
        Builder builder = ImmutableMilestone.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.closedAt != null) {
            builder.closedAt(json.closedAt);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.labelsUrl != null) {
            builder.labelsUrl(json.labelsUrl);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.number != null) {
            builder.number(json.number);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.creator != null) {
            builder.creator(json.creator);
        }
        if (json.openIssues != null) {
            builder.openIssues(json.openIssues);
        }
        if (json.closedIssues != null) {
            builder.closedIssues(json.closedIssues);
        }
        if (json.dueOn != null) {
            builder.dueOn(json.dueOn);
        }
        return builder.build();
    }

    public static ImmutableMilestone copyOf(Milestone instance) {
        if (instance instanceof ImmutableMilestone) {
            return (ImmutableMilestone)instance;
        }
        return ImmutableMilestone.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Milestone", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private GitHubInstant closedAt;
        @Nullable
        private URI url;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private URI labelsUrl;
        @Nullable
        private Integer id;
        @Nullable
        private Integer number;
        @Nullable
        private String state;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private User creator;
        @Nullable
        private Integer openIssues;
        @Nullable
        private Integer closedIssues;
        @Nullable
        private GitHubInstant dueOn;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Milestone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CloseTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<GitHubInstant> closedAtOptional;
            UpdateTracking instance;
            if (object instanceof Milestone) {
                URI urlValue;
                Integer openIssuesValue;
                String titleValue;
                String stateValue;
                Integer idValue;
                Optional<String> descriptionOptional;
                URI htmlUrlValue;
                Optional<GitHubInstant> dueOnOptional;
                URI labelsUrlValue;
                User creatorValue;
                Integer numberValue;
                instance = (Milestone)object;
                Integer closedIssuesValue = instance.closedIssues();
                if (closedIssuesValue != null) {
                    this.closedIssues(closedIssuesValue);
                }
                if ((numberValue = instance.number()) != null) {
                    this.number(numberValue);
                }
                if ((creatorValue = instance.creator()) != null) {
                    this.creator(creatorValue);
                }
                if ((labelsUrlValue = instance.labelsUrl()) != null) {
                    this.labelsUrl(labelsUrlValue);
                }
                if ((dueOnOptional = instance.dueOn()).isPresent()) {
                    this.dueOn(dueOnOptional);
                }
                if ((htmlUrlValue = instance.htmlUrl()) != null) {
                    this.htmlUrl(htmlUrlValue);
                }
                if ((descriptionOptional = instance.description()).isPresent()) {
                    this.description(descriptionOptional);
                }
                if ((idValue = instance.id()) != null) {
                    this.id(idValue);
                }
                if ((stateValue = instance.state()) != null) {
                    this.state(stateValue);
                }
                if ((titleValue = instance.title()) != null) {
                    this.title(titleValue);
                }
                if ((openIssuesValue = instance.openIssues()) != null) {
                    this.openIssues(openIssuesValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
            }
            if (object instanceof CloseTracking && (closedAtOptional = (instance = (CloseTracking)object).closedAt()).isPresent()) {
                this.closedAt(closedAtOptional);
            }
            if (object instanceof UpdateTracking) {
                GitHubInstant updatedAtValue;
                instance = (UpdateTracking)object;
                GitHubInstant createdAtValue = instance.createdAt();
                if (createdAtValue != null) {
                    this.createdAt(createdAtValue);
                }
                if ((updatedAtValue = instance.updatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closedAt(GitHubInstant closedAt) {
            this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
            this.closedAt = closedAt.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder labelsUrl(@Nullable URI labelsUrl) {
            this.labelsUrl = labelsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Integer id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder number(@Nullable Integer number) {
            this.number = number;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder creator(@Nullable User creator) {
            this.creator = creator;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder openIssues(@Nullable Integer openIssues) {
            this.openIssues = openIssues;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder closedIssues(@Nullable Integer closedIssues) {
            this.closedIssues = closedIssues;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dueOn(GitHubInstant dueOn) {
            this.dueOn = Objects.requireNonNull(dueOn, "dueOn");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder dueOn(Optional<? extends GitHubInstant> dueOn) {
            this.dueOn = dueOn.orElse(null);
            return this;
        }

        public ImmutableMilestone build() {
            return new ImmutableMilestone(this.createdAt, this.updatedAt, this.closedAt, this.url, this.htmlUrl, this.labelsUrl, this.id, this.number, this.state, this.title, this.description, this.creator, this.openIssues, this.closedIssues, this.dueOn);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Milestone", generator="Immutables")
    static final class Json
    implements Milestone {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        Optional<GitHubInstant> closedAt = Optional.empty();
        @Nullable
        URI url;
        @Nullable
        URI htmlUrl;
        @Nullable
        URI labelsUrl;
        @Nullable
        Integer id;
        @Nullable
        Integer number;
        @Nullable
        String state;
        @Nullable
        String title;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        User creator;
        @Nullable
        Integer openIssues;
        @Nullable
        Integer closedIssues;
        @Nullable
        Optional<GitHubInstant> dueOn = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setClosedAt(Optional<GitHubInstant> closedAt) {
            this.closedAt = closedAt;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setLabelsUrl(@Nullable URI labelsUrl) {
            this.labelsUrl = labelsUrl;
        }

        @JsonProperty
        public void setId(@Nullable Integer id) {
            this.id = id;
        }

        @JsonProperty
        public void setNumber(@Nullable Integer number) {
            this.number = number;
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setCreator(@Nullable User creator) {
            this.creator = creator;
        }

        @JsonProperty
        public void setOpenIssues(@Nullable Integer openIssues) {
            this.openIssues = openIssues;
        }

        @JsonProperty
        public void setClosedIssues(@Nullable Integer closedIssues) {
            this.closedIssues = closedIssues;
        }

        @JsonProperty
        public void setDueOn(Optional<GitHubInstant> dueOn) {
            this.dueOn = dueOn;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> closedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI labelsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer number() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User creator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer openIssues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer closedIssues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> dueOn() {
            throw new UnsupportedOperationException();
        }
    }
}

