/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.google.common.collect.ImmutableMap;
import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.git.Reference;
import com.spotify.github.v3.git.Tag;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class GitDataClient {
    private static final String TAG_REFERENCE_URI = "/repos/%s/%s/git/refs/tags/%s";
    private static final String TAG_URI = "/repos/%s/%s/git/tags/%s";
    private static final String CREATE_REFERENCE_URI = "/repos/%s/%s/git/refs";
    private static final String CREATE_REFERENCE_TAG = "/repos/%s/%s/git/tags";
    private final GitHubClient github;
    private final String owner;
    private final String repo;

    GitDataClient(GitHubClient github, String owner, String repo) {
        this.github = github;
        this.owner = owner;
        this.repo = repo;
    }

    static GitDataClient create(GitHubClient github, String owner, String repo) {
        return new GitDataClient(github, owner, repo);
    }

    public CompletableFuture<Void> delete(String ref) {
        String path = String.format("/repos/%s/%s/git/refs/heads/%s", this.owner, this.repo, ref.replaceAll("refs/heads/", ""));
        return this.github.delete(path).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    public CompletableFuture<Reference> getTagReference(String tag) {
        String path = String.format(TAG_REFERENCE_URI, this.owner, this.repo, tag);
        return this.github.request(path, Reference.class);
    }

    public CompletableFuture<Tag> getTag(String tag) {
        String path = String.format(TAG_URI, this.owner, this.repo, tag);
        return this.github.request(path, Tag.class);
    }

    public CompletableFuture<Reference> createTagReference(String tag, String sha) {
        String path = String.format(CREATE_REFERENCE_URI, this.owner, this.repo);
        ImmutableMap body = ImmutableMap.of((Object)"ref", (Object)String.format("refs/tags/%s", tag), (Object)"sha", (Object)sha);
        return this.github.post(path, this.github.json().toJsonUnchecked(body), Reference.class);
    }

    public CompletableFuture<Tag> createAnnotatedTag(String tag, String sha, String tagMessage, String taggerName, String taggerEmail) {
        String tagPath = String.format(CREATE_REFERENCE_TAG, this.owner, this.repo);
        ImmutableMap body = ImmutableMap.of((Object)"tag", (Object)tag, (Object)"message", (Object)tagMessage, (Object)"object", (Object)sha, (Object)"type", (Object)"commit", (Object)"tagger", (Object)ImmutableMap.of((Object)"name", (Object)taggerName, (Object)"email", (Object)taggerEmail, (Object)"date", (Object)Instant.now().toString()));
        return this.createTagReference(tag, sha).thenCompose(reference -> this.github.post(tagPath, this.github.json().toJsonUnchecked(body), Tag.class));
    }
}

