/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.spotify.github.v3.checks.AccessToken;
import com.spotify.github.v3.checks.Installation;
import com.spotify.github.v3.clients.GitHubClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class GithubAppClient {
    private static final String GET_ACCESS_TOKEN_URL = "/app/installations/%s/access_tokens";
    private static final String GET_INSTALLATIONS_URL = "/app/installations?per_page=100";
    private static final String GET_INSTALLATION_REPO_URL = "/repos/%s/%s/installation";
    private final GitHubClient github;
    private final String owner;
    private final String repo;
    private final Map<String, String> extraHeaders = ImmutableMap.of((Object)"Accept", (Object)"application/vnd.github.machine-man-preview+json");
    private static final TypeReference<List<Installation>> INSTALLATION_LIST_TYPE_REFERENCE = new TypeReference<List<Installation>>(){};

    GithubAppClient(GitHubClient github, String owner, String repo) {
        this.github = github;
        this.owner = owner;
        this.repo = repo;
    }

    public CompletableFuture<List<Installation>> getInstallations() {
        return this.github.request(GET_INSTALLATIONS_URL, INSTALLATION_LIST_TYPE_REFERENCE, this.extraHeaders);
    }

    public CompletableFuture<Installation> getInstallation() {
        return this.github.request(String.format(GET_INSTALLATION_REPO_URL, this.owner, this.repo), Installation.class, this.extraHeaders);
    }

    public CompletableFuture<AccessToken> getAccessToken(Integer installationId) {
        String path = String.format(GET_ACCESS_TOKEN_URL, installationId);
        return this.github.post(path, "", AccessToken.class, this.extraHeaders);
    }
}

