/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class JwtTokenIssuer {
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;
    private final PrivateKey signingKey;
    private static final long TOKEN_TTL = 600000L;

    public JwtTokenIssuer(File privateKeyFile) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        byte[] apiKeySecretBytes = FileUtils.readFileToByteArray((File)privateKeyFile);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(apiKeySecretBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        this.signingKey = kf.generatePrivate(spec);
    }

    public String getToken(Integer appId) {
        return Jwts.builder().setId("github-auth").setSubject("authenticating via private key").setIssuer(String.valueOf(appId)).signWith((Key)this.signingKey, SIGNATURE_ALGORITHM).setExpiration(new Date(System.currentTimeMillis() + 600000L)).setIssuedAt(new Date()).compact();
    }
}

