/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.prs.PullRequest;
import com.spotify.github.v3.prs.PullRequestItem;
import com.spotify.github.v3.prs.requests.PullRequestCreate;
import com.spotify.github.v3.prs.requests.PullRequestParameters;
import com.spotify.github.v3.prs.requests.PullRequestUpdate;
import com.spotify.github.v3.repos.CommitItem;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PR_TEMPLATE = "/repos/%s/%s/pulls";
    private static final String PR_NUMBER_TEMPLATE = "/repos/%s/%s/pulls/%s";
    private static final String PR_COMMITS_TEMPLATE = "/repos/%s/%s/pulls/%s/commits";
    private final GitHubClient github;
    private final String owner;
    private final String repo;

    PullRequestClient(GitHubClient github, String owner, String repo) {
        this.github = github;
        this.owner = owner;
        this.repo = repo;
    }

    static PullRequestClient create(GitHubClient github, String owner, String repo) {
        return new PullRequestClient(github, owner, repo);
    }

    public CompletableFuture<List<PullRequestItem>> list() {
        return this.list("");
    }

    public CompletableFuture<List<PullRequestItem>> list(PullRequestParameters parameters) {
        String serial = parameters.serialize();
        Object path = Strings.isNullOrEmpty((String)serial) ? "" : "?" + serial;
        return this.list((String)path);
    }

    public CompletableFuture<PullRequest> get(int number) {
        String path = String.format(PR_NUMBER_TEMPLATE, this.owner, this.repo, number);
        log.debug("Fetching pull request from " + path);
        return this.github.request(path, PullRequest.class);
    }

    public CompletableFuture<Void> create(PullRequestCreate request) {
        String path = String.format(PR_TEMPLATE, this.owner, this.repo);
        return this.github.post(path, this.github.json().toJsonUnchecked(request)).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    public CompletableFuture<Void> update(int number, PullRequestUpdate request) {
        String path = String.format(PR_NUMBER_TEMPLATE, this.owner, this.repo, number);
        return this.github.patch(path, this.github.json().toJsonUnchecked(request)).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    public CompletableFuture<List<CommitItem>> listCommits(int number) {
        String path = String.format(PR_COMMITS_TEMPLATE, this.owner, this.repo, number);
        log.debug("Fetching pull request commits from " + path);
        return this.github.request(path, GitHubClient.LIST_COMMIT_TYPE_REFERENCE);
    }

    public CompletableFuture<Void> merge(int number, String sha) {
        String path = String.format("/repos/%s/%s/pulls/%s/merge", this.owner, this.repo, number);
        log.debug("Merging pr, running: {}", (Object)path);
        return this.github.put(path, this.github.json().toJsonUnchecked(ImmutableMap.of((Object)"sha", (Object)sha))).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    private CompletableFuture<List<PullRequestItem>> list(String parameterPath) {
        String path = String.format(PR_TEMPLATE + parameterPath, this.owner, this.repo);
        log.debug("Fetching pull requests from " + path);
        return this.github.request(path, GitHubClient.LIST_PR_TYPE_REFERENCE);
    }
}

