/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.google.common.collect.ImmutableMap;
import com.spotify.github.v3.clients.ChecksClient;
import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.clients.GithubAppClient;
import com.spotify.github.v3.clients.IssueClient;
import com.spotify.github.v3.clients.PullRequestClient;
import com.spotify.github.v3.comment.Comment;
import com.spotify.github.v3.exceptions.RequestNotOkException;
import com.spotify.github.v3.git.Tree;
import com.spotify.github.v3.hooks.requests.WebhookCreate;
import com.spotify.github.v3.repos.Branch;
import com.spotify.github.v3.repos.Commit;
import com.spotify.github.v3.repos.CommitComparison;
import com.spotify.github.v3.repos.CommitItem;
import com.spotify.github.v3.repos.CommitStatus;
import com.spotify.github.v3.repos.Content;
import com.spotify.github.v3.repos.FolderContent;
import com.spotify.github.v3.repos.Repository;
import com.spotify.github.v3.repos.Status;
import com.spotify.github.v3.repos.requests.RepositoryCreateStatus;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int CONFLICT = 409;
    private static final int UNPROCESSABLE_ENTITY = 422;
    private static final String REPOSITORY_URI_TEMPLATE = "/repos/%s/%s";
    private static final String HOOK_URI_TEMPLATE = "/repos/%s/%s/hooks";
    private static final String CONTENTS_URI_TEMPLATE = "/repos/%s/%s/contents/%s%s";
    private static final String STATUS_URI_TEMPLATE = "/repos/%s/%s/statuses/%s";
    private static final String COMMITS_URI_TEMPLATE = "/repos/%s/%s/commits";
    private static final String COMMIT_SHA_URI_TEMPLATE = "/repos/%s/%s/commits/%s";
    private static final String COMMIT_STATUS_URI_TEMPLATE = "/repos/%s/%s/commits/%s/status";
    private static final String TREE_SHA_URI_TEMPLATE = "/repos/%s/%s/git/trees/%s";
    private static final String COMPARE_COMMIT_TEMPLATE = "/repos/%s/%s/compare/%s...%s";
    private static final String BRANCH_TEMPLATE = "/repos/%s/%s/branches/%s";
    private static final String CREATE_COMMENT_TEMPLATE = "/repos/%s/%s/commits/%s/comments";
    private static final String COMMENT_TEMPLATE = "/repos/%s/%s/comments/%s";
    private final String owner;
    private final String repo;
    private final GitHubClient github;

    RepositoryClient(GitHubClient github, String owner, String repo) {
        this.github = github;
        this.owner = owner;
        this.repo = repo;
    }

    static RepositoryClient create(GitHubClient github, String owner, String repo) {
        return new RepositoryClient(github, owner, repo);
    }

    public IssueClient createIssueClient() {
        return IssueClient.create(this.github, this.owner, this.repo);
    }

    public PullRequestClient createPullRequestClient() {
        return PullRequestClient.create(this.github, this.owner, this.repo);
    }

    public GithubAppClient createGithubAppClient() {
        return new GithubAppClient(this.github, this.owner, this.repo);
    }

    public ChecksClient createChecksApiClient() {
        if (!this.github.getPrivateKey().isPresent()) {
            throw new IllegalArgumentException("Checks Client needs a private key");
        }
        return new ChecksClient(this.github, this.owner, this.repo);
    }

    public CompletableFuture<Repository> getRepository() {
        String path = String.format(REPOSITORY_URI_TEMPLATE, this.owner, this.repo);
        return this.github.request(path, Repository.class);
    }

    public CompletableFuture<Void> createWebhook(WebhookCreate request, boolean ignoreExisting) {
        String path = String.format(HOOK_URI_TEMPLATE, this.owner, this.repo);
        return ((CompletableFuture)this.github.post(path, this.github.json().toJsonUnchecked(request)).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER)).exceptionally(e -> {
            if (e instanceof RequestNotOkException) {
                RequestNotOkException e1 = (RequestNotOkException)e;
                int code = e1.statusCode();
                if (ignoreExisting && (code == 409 || code == 422)) {
                    log.debug("Webhook {} for {} already exists, ignoring.", (Object)request.name(), (Object)this);
                    return null;
                }
                throw new RequestNotOkException(e1.path(), e1.statusCode(), "Failed creating a webhook: " + request, (Throwable)e);
            }
            throw new CompletionException((Throwable)e);
        });
    }

    public CompletableFuture<Void> setCommitStatus(String sha, RepositoryCreateStatus request) {
        String path = String.format(STATUS_URI_TEMPLATE, this.owner, this.repo, sha);
        return this.github.post(path, this.github.json().toJsonUnchecked(request)).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    public CompletableFuture<CommitStatus> getCommitStatus(String ref) {
        String path = String.format(COMMIT_STATUS_URI_TEMPLATE, this.owner, this.repo, ref);
        return this.github.request(path, CommitStatus.class);
    }

    public CompletableFuture<List<Status>> listCommitStatuses(String sha) {
        String path = String.format(STATUS_URI_TEMPLATE, this.owner, this.repo, sha);
        return this.github.request(path, GitHubClient.LIST_STATUS_TYPE_REFERENCE);
    }

    public CompletableFuture<List<CommitItem>> listCommits() {
        String path = String.format(COMMITS_URI_TEMPLATE, this.owner, this.repo);
        return this.github.request(path, GitHubClient.LIST_COMMIT_TYPE_REFERENCE);
    }

    public CompletableFuture<Commit> getCommit(String sha) {
        String path = String.format(COMMIT_SHA_URI_TEMPLATE, this.owner, this.repo, sha);
        return this.github.request(path, Commit.class);
    }

    public CompletableFuture<Tree> getTree(String sha) {
        String path = String.format(TREE_SHA_URI_TEMPLATE, this.owner, this.repo, sha);
        return this.github.request(path, Tree.class);
    }

    public CompletableFuture<Content> getFileContent(String path) {
        return this.github.request(this.getContentPath(path, ""), Content.class);
    }

    public CompletableFuture<Content> getFileContent(String path, String ref) {
        return this.github.request(this.getContentPath(path, "?ref=" + ref), Content.class);
    }

    public CompletableFuture<List<FolderContent>> getFolderContent(String path) {
        return this.github.request(this.getContentPath(path, ""), GitHubClient.LIST_FOLDERCONTENT_TYPE_REFERENCE);
    }

    public CompletableFuture<Comment> createComment(String sha, String body) {
        String path = String.format(CREATE_COMMENT_TEMPLATE, this.owner, this.repo, sha);
        String requestBody = this.github.json().toJsonUnchecked(ImmutableMap.of((Object)"body", (Object)body));
        return this.github.post(path, requestBody, Comment.class);
    }

    public CompletableFuture<Comment> getComment(int id) {
        String path = String.format(COMMENT_TEMPLATE, this.owner, this.repo, id);
        return this.github.request(path, Comment.class);
    }

    public CompletableFuture<List<FolderContent>> getFolderContent(String path, String ref) {
        return this.github.request(this.getContentPath(path, "?ref=" + ref), GitHubClient.LIST_FOLDERCONTENT_TYPE_REFERENCE);
    }

    public CompletableFuture<CommitComparison> compareCommits(String base, String head) {
        String path = String.format(COMPARE_COMMIT_TEMPLATE, this.owner, this.repo, base, head);
        return this.github.request(path, CommitComparison.class);
    }

    public CompletableFuture<Branch> getBranch(String branch) {
        String path = String.format(BRANCH_TEMPLATE, this.owner, this.repo, branch);
        return this.github.request(path, Branch.class);
    }

    public CompletableFuture<Void> deleteComment(int id) {
        String path = String.format(COMMENT_TEMPLATE, this.owner, this.repo, id);
        return this.github.delete(path).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    public CompletableFuture<Void> editComment(int id, String body) {
        String path = String.format(COMMENT_TEMPLATE, this.owner, this.repo, id);
        return this.github.patch(path, this.github.json().toJsonUnchecked(ImmutableMap.of((Object)"body", (Object)body))).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    private String getContentPath(String path, String query) {
        if (path.startsWith("/") || path.endsWith("/")) {
            throw new IllegalArgumentException(path + " starts or ends with '/'");
        }
        return String.format(CONTENTS_URI_TEMPLATE, this.owner, this.repo, path, query);
    }
}

