/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.v3.git.Author;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Author", generator="Immutables")
@Immutable
public final class ImmutableAuthor
implements Author {
    @Nullable
    private final String name;
    @Nullable
    private final String email;
    @Nullable
    private final String username;
    @Nullable
    private final GitHubInstant date;

    private ImmutableAuthor(@Nullable String name, @Nullable String email, @Nullable String username, @Nullable GitHubInstant date) {
        this.name = name;
        this.email = email;
        this.username = username;
        this.date = date;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<String> email() {
        return Optional.ofNullable(this.email);
    }

    @Override
    @JsonProperty
    public Optional<String> username() {
        return Optional.ofNullable(this.username);
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> date() {
        return Optional.ofNullable(this.date);
    }

    public final ImmutableAuthor withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableAuthor(value, this.email, this.username, this.date);
    }

    public final ImmutableAuthor withEmail(String value) {
        String newValue = Objects.requireNonNull(value, "email");
        if (Objects.equals(this.email, newValue)) {
            return this;
        }
        return new ImmutableAuthor(this.name, newValue, this.username, this.date);
    }

    public final ImmutableAuthor withEmail(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.email, value)) {
            return this;
        }
        return new ImmutableAuthor(this.name, value, this.username, this.date);
    }

    public final ImmutableAuthor withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return new ImmutableAuthor(this.name, this.email, newValue, this.date);
    }

    public final ImmutableAuthor withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new ImmutableAuthor(this.name, this.email, value, this.date);
    }

    public final ImmutableAuthor withDate(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "date");
        if (this.date == newValue) {
            return this;
        }
        return new ImmutableAuthor(this.name, this.email, this.username, newValue);
    }

    public final ImmutableAuthor withDate(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.date == value) {
            return this;
        }
        return new ImmutableAuthor(this.name, this.email, this.username, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthor && this.equalTo((ImmutableAuthor)another);
    }

    private boolean equalTo(ImmutableAuthor another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.email, another.email) && Objects.equals(this.username, another.username) && Objects.equals(this.date, another.date);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.email);
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + Objects.hashCode(this.date);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Author{");
        if (this.name != null) {
            builder.append("name=").append(this.name);
        }
        if (this.email != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("email=").append(this.email);
        }
        if (this.username != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("username=").append(this.username);
        }
        if (this.date != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("date=").append(this.date);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuthor fromJson(Json json) {
        Builder builder = ImmutableAuthor.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.email != null) {
            builder.email(json.email);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.date != null) {
            builder.date(json.date);
        }
        return builder.build();
    }

    public static ImmutableAuthor copyOf(Author instance) {
        if (instance instanceof ImmutableAuthor) {
            return (ImmutableAuthor)instance;
        }
        return ImmutableAuthor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Author", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String email;
        @Nullable
        private String username;
        @Nullable
        private GitHubInstant date;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Author instance) {
            Optional<GitHubInstant> dateOptional;
            Optional<String> usernameOptional;
            Optional<String> emailOptional;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((emailOptional = instance.email()).isPresent()) {
                this.email(emailOptional);
            }
            if ((usernameOptional = instance.username()).isPresent()) {
                this.username(usernameOptional);
            }
            if ((dateOptional = instance.date()).isPresent()) {
                this.date(dateOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder email(String email) {
            this.email = Objects.requireNonNull(email, "email");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder email(Optional<String> email) {
            this.email = email.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder username(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder date(GitHubInstant date) {
            this.date = Objects.requireNonNull(date, "date");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder date(Optional<? extends GitHubInstant> date) {
            this.date = date.orElse(null);
            return this;
        }

        public ImmutableAuthor build() {
            return new ImmutableAuthor(this.name, this.email, this.username, this.date);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Author", generator="Immutables")
    static final class Json
    implements Author {
        @Nullable
        String name;
        @Nullable
        Optional<String> email = Optional.empty();
        @Nullable
        Optional<String> username = Optional.empty();
        @Nullable
        Optional<GitHubInstant> date = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty
        public void setEmail(Optional<String> email) {
            this.email = email;
        }

        @JsonProperty
        public void setUsername(Optional<String> username) {
            this.username = username;
        }

        @JsonProperty
        public void setDate(Optional<GitHubInstant> date) {
            this.date = date;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> email() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> username() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> date() {
            throw new UnsupportedOperationException();
        }
    }
}

