/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.prs.requests.PullRequestCreate;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequestCreate", generator="Immutables")
@Immutable
public final class ImmutablePullRequestCreate
implements PullRequestCreate {
    @Nullable
    private final String title;
    @Nullable
    private final String body;
    @Nullable
    private final String head;
    @Nullable
    private final String base;

    private ImmutablePullRequestCreate(@Nullable String title, @Nullable String body, @Nullable String head, @Nullable String base) {
        this.title = title;
        this.body = body;
        this.head = head;
        this.base = base;
    }

    @Override
    @JsonProperty
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty
    public Optional<String> body() {
        return Optional.ofNullable(this.body);
    }

    @Override
    @JsonProperty
    @Nullable
    public String head() {
        return this.head;
    }

    @Override
    @JsonProperty
    @Nullable
    public String base() {
        return this.base;
    }

    public final ImmutablePullRequestCreate withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutablePullRequestCreate(value, this.body, this.head, this.base);
    }

    public final ImmutablePullRequestCreate withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (Objects.equals(this.body, newValue)) {
            return this;
        }
        return new ImmutablePullRequestCreate(this.title, newValue, this.head, this.base);
    }

    public final ImmutablePullRequestCreate withBody(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutablePullRequestCreate(this.title, value, this.head, this.base);
    }

    public final ImmutablePullRequestCreate withHead(@Nullable String value) {
        if (Objects.equals(this.head, value)) {
            return this;
        }
        return new ImmutablePullRequestCreate(this.title, this.body, value, this.base);
    }

    public final ImmutablePullRequestCreate withBase(@Nullable String value) {
        if (Objects.equals(this.base, value)) {
            return this;
        }
        return new ImmutablePullRequestCreate(this.title, this.body, this.head, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequestCreate && this.equalTo((ImmutablePullRequestCreate)another);
    }

    private boolean equalTo(ImmutablePullRequestCreate another) {
        return Objects.equals(this.title, another.title) && Objects.equals(this.body, another.body) && Objects.equals(this.head, another.head) && Objects.equals(this.base, another.base);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + Objects.hashCode(this.head);
        h += (h << 5) + Objects.hashCode(this.base);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PullRequestCreate{");
        if (this.title != null) {
            builder.append("title=").append(this.title);
        }
        if (this.body != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("body=").append(this.body);
        }
        if (this.head != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("head=").append(this.head);
        }
        if (this.base != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("base=").append(this.base);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequestCreate fromJson(Json json) {
        Builder builder = ImmutablePullRequestCreate.builder();
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.head != null) {
            builder.head(json.head);
        }
        if (json.base != null) {
            builder.base(json.base);
        }
        return builder.build();
    }

    public static ImmutablePullRequestCreate copyOf(PullRequestCreate instance) {
        if (instance instanceof ImmutablePullRequestCreate) {
            return (ImmutablePullRequestCreate)instance;
        }
        return ImmutablePullRequestCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PullRequestCreate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String title;
        @Nullable
        private String body;
        @Nullable
        private String head;
        @Nullable
        private String base;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestCreate instance) {
            String baseValue;
            String headValue;
            Optional<String> bodyOptional;
            Objects.requireNonNull(instance, "instance");
            String titleValue = instance.title();
            if (titleValue != null) {
                this.title(titleValue);
            }
            if ((bodyOptional = instance.body()).isPresent()) {
                this.body(bodyOptional);
            }
            if ((headValue = instance.head()) != null) {
                this.head(headValue);
            }
            if ((baseValue = instance.base()) != null) {
                this.base(baseValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(Optional<String> body) {
            this.body = body.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder head(@Nullable String head) {
            this.head = head;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder base(@Nullable String base) {
            this.base = base;
            return this;
        }

        public ImmutablePullRequestCreate build() {
            return new ImmutablePullRequestCreate(this.title, this.body, this.head, this.base);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequestCreate", generator="Immutables")
    static final class Json
    implements PullRequestCreate {
        @Nullable
        String title;
        @Nullable
        Optional<String> body = Optional.empty();
        @Nullable
        String head;
        @Nullable
        String base;

        Json() {
        }

        @JsonProperty
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty
        public void setBody(Optional<String> body) {
            this.body = body;
        }

        @JsonProperty
        public void setHead(@Nullable String head) {
            this.head = head;
        }

        @JsonProperty
        public void setBase(@Nullable String base) {
            this.base = base;
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String head() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String base() {
            throw new UnsupportedOperationException();
        }
    }
}

