/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.githubclient.shade.okhttp3.mockwebserver;

import com.spotify.githubclient.shade.okhttp3.Headers;
import com.spotify.githubclient.shade.okhttp3.HttpUrl;
import com.spotify.githubclient.shade.okhttp3.Protocol;
import com.spotify.githubclient.shade.okhttp3.Request;
import com.spotify.githubclient.shade.okhttp3.Response;
import com.spotify.githubclient.shade.okhttp3.WebSocketListener;
import com.spotify.githubclient.shade.okhttp3.internal.Internal;
import com.spotify.githubclient.shade.okhttp3.internal.Util;
import com.spotify.githubclient.shade.okhttp3.internal.concurrent.Task;
import com.spotify.githubclient.shade.okhttp3.internal.concurrent.TaskQueue;
import com.spotify.githubclient.shade.okhttp3.internal.concurrent.TaskRunner;
import com.spotify.githubclient.shade.okhttp3.internal.duplex.MwsDuplexAccess;
import com.spotify.githubclient.shade.okhttp3.internal.http.HttpMethod;
import com.spotify.githubclient.shade.okhttp3.internal.http2.ErrorCode;
import com.spotify.githubclient.shade.okhttp3.internal.http2.Header;
import com.spotify.githubclient.shade.okhttp3.internal.http2.Http2Connection;
import com.spotify.githubclient.shade.okhttp3.internal.http2.Http2Stream;
import com.spotify.githubclient.shade.okhttp3.internal.http2.Settings;
import com.spotify.githubclient.shade.okhttp3.internal.platform.Platform;
import com.spotify.githubclient.shade.okhttp3.internal.ws.RealWebSocket;
import com.spotify.githubclient.shade.okhttp3.internal.ws.WebSocketProtocol;
import com.spotify.githubclient.shade.okhttp3.mockwebserver.Dispatcher;
import com.spotify.githubclient.shade.okhttp3.mockwebserver.MockResponse;
import com.spotify.githubclient.shade.okhttp3.mockwebserver.MockWebServer;
import com.spotify.githubclient.shade.okhttp3.mockwebserver.MockWebServer$SocketHandler$WhenMappings;
import com.spotify.githubclient.shade.okhttp3.mockwebserver.PushPromise;
import com.spotify.githubclient.shade.okhttp3.mockwebserver.QueueDispatcher;
import com.spotify.githubclient.shade.okhttp3.mockwebserver.RecordedRequest;
import com.spotify.githubclient.shade.okhttp3.mockwebserver.SocketPolicy;
import com.spotify.githubclient.shade.okhttp3.mockwebserver.internal.duplex.DuplexResponseBody;
import com.spotify.githubclient.shade.okio.Buffer;
import com.spotify.githubclient.shade.okio.BufferedSink;
import com.spotify.githubclient.shade.okio.BufferedSource;
import com.spotify.githubclient.shade.okio.ByteString;
import com.spotify.githubclient.shade.okio.Okio;
import com.spotify.githubclient.shade.okio.Sink;
import com.spotify.githubclient.shade.okio.Timeout;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u007f2\u00020\u00012\u00020\u0002:\u0007\u007f\u0080\u0001\u0081\u0001\u0082\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010G\u001a\u00020HH\u0002J\b\u0010I\u001a\u00020HH\u0014J\b\u0010J\u001a\u00020HH\u0014J\b\u0010K\u001a\u00020HH\u0016J\u0018\u0010L\u001a\u00020H2\u0006\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\u001cH\u0002J\u000e\u0010O\u001a\u00020H2\u0006\u0010P\u001a\u00020QJ\r\u0010\"\u001a\u00020\rH\u0007\u00a2\u0006\u0002\bRJ\r\u00103\u001a\u00020\rH\u0007\u00a2\u0006\u0002\bSJ0\u0010T\u001a\u00020H2\u0006\u0010N\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u0002062\u0006\u0010P\u001a\u00020QH\u0002J\u0006\u0010Z\u001a\u00020HJ\u0010\u0010[\u001a\u00020H2\u0006\u0010\\\u001a\u00020\u001cH\u0002J\u0013\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007\u00a2\u0006\u0002\b]J\u0010\u0010^\u001a\u00020H2\u0006\u0010U\u001a\u00020VH\u0002J(\u0010_\u001a\u0002062\u0006\u0010N\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010M\u001a\u00020\rH\u0002J\u0006\u0010`\u001a\u00020HJ\u0006\u0010a\u001a\u00020HJ\u0010\u0010b\u001a\u00020H2\u0006\u0010\\\u001a\u00020\u001cH\u0002J\u0015\u0010\n\u001a\u00020H2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\bcJ\u0015\u0010)\u001a\u00020H2\u0006\u0010%\u001a\u00020&H\u0007\u00a2\u0006\u0002\bdJ\u001b\u00100\u001a\u00020H2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007\u00a2\u0006\u0002\b]J\u0015\u0010=\u001a\u00020H2\u0006\u0010:\u001a\u000209H\u0007\u00a2\u0006\u0002\beJ\u0006\u0010f\u001a\u00020HJ\u0010\u0010g\u001a\u00020H2\u0006\u0010h\u001a\u00020\u0007H\u0002J\u0016\u0010i\u001a\u00020H2\u0006\u0010j\u001a\u00020k2\u0006\u0010!\u001a\u00020\rJ\u0010\u0010i\u001a\u00020H2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010i\u001a\u00020H2\b\b\u0002\u0010!\u001a\u00020\rH\u0007J\u0006\u0010l\u001a\u000206J\u0018\u0010l\u001a\u0004\u0018\u0001062\u0006\u0010m\u001a\u00020\u00072\u0006\u0010n\u001a\u00020oJ8\u0010p\u001a\u00020H2\u0006\u0010q\u001a\u00020Q2\u0006\u0010N\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010r\u001a\u00020\u00072\u0006\u0010s\u001a\u00020&H\u0002J\u0006\u0010t\u001a\u00020uJ\b\u0010v\u001a\u00020\u0015H\u0016J\u000e\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020\u0015J\u0016\u0010z\u001a\u00020H2\u0006\u0010?\u001a\u00020@2\u0006\u0010F\u001a\u00020&J\u0018\u0010{\u001a\u00020H2\u0006\u0010W\u001a\u00020X2\u0006\u0010|\u001a\u00020}H\u0002J \u0010~\u001a\u00020H2\u0006\u0010N\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020X2\u0006\u0010P\u001a\u00020QH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u001a\u001a&\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c \u001d*\u0012\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001f\u001a&\u0012\f\u0012\n \u001d*\u0004\u0018\u00010 0  \u001d*\u0012\u0012\f\u0012\n \u001d*\u0004\u0018\u00010 0 \u0018\u00010\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R2\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,8G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0011\u00102\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010#R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020605X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010:\u001a\u0004\u0018\u0001092\b\u0010+\u001a\u0004\u0018\u0001098F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0083\u0001"}, d2={"Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/MockWebServer;", "Lorg/junit/rules/ExternalResource;", "Ljava/io/Closeable;", "()V", "atomicRequestCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "bodyLimit", "", "getBodyLimit", "()J", "setBodyLimit", "(J)V", "clientAuth", "", "dispatcher", "Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/Dispatcher;", "getDispatcher", "()Lokhttp3/mockwebserver/Dispatcher;", "setDispatcher", "(Lokhttp3/mockwebserver/Dispatcher;)V", "hostName", "", "getHostName", "()Ljava/lang/String;", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "openClientSockets", "", "Ljava/net/Socket;", "kotlin.jvm.PlatformType", "", "openConnections", "Lcom/spotify/githubclient/shade/okhttp3/internal/http2/Http2Connection;", "port", "getPort", "()I", "portField", "protocolNegotiationEnabled", "", "getProtocolNegotiationEnabled", "()Z", "setProtocolNegotiationEnabled", "(Z)V", "value", "", "Lcom/spotify/githubclient/shade/okhttp3/Protocol;", "protocols", "()Ljava/util/List;", "setProtocols", "(Ljava/util/List;)V", "requestCount", "getRequestCount", "requestQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/RecordedRequest;", "serverSocket", "Ljava/net/ServerSocket;", "Ljavax/net/ServerSocketFactory;", "serverSocketFactory", "getServerSocketFactory", "()Ljavax/net/ServerSocketFactory;", "setServerSocketFactory", "(Ljavax/net/ServerSocketFactory;)V", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "started", "taskRunner", "Lcom/spotify/githubclient/shade/okhttp3/internal/concurrent/TaskRunner;", "taskRunnerBackend", "Lcom/spotify/githubclient/shade/okhttp3/internal/concurrent/TaskRunner$RealBackend;", "tunnelProxy", "acceptConnections", "", "after", "before", "close", "dispatchBookkeepingRequest", "sequenceNumber", "socket", "enqueue", "response", "Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/MockResponse;", "-deprecated_port", "-deprecated_requestCount", "handleWebSocketUpgrade", "source", "Lcom/spotify/githubclient/shade/okio/BufferedSource;", "sink", "Lcom/spotify/githubclient/shade/okio/BufferedSink;", "request", "noClientAuth", "processHandshakeFailure", "raw", "-deprecated_protocols", "readEmptyLine", "readRequest", "requestClientAuth", "requireClientAuth", "serveConnection", "-deprecated_bodyLimit", "-deprecated_protocolNegotiationEnabled", "-deprecated_serverSocketFactory", "shutdown", "sleepIfDelayed", "delayMs", "start", "inetAddress", "Ljava/net/InetAddress;", "takeRequest", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "throttledTransfer", "policy", "byteCount", "isRequest", "toProxyAddress", "Ljava/net/Proxy;", "toString", "url", "Lcom/spotify/githubclient/shade/okhttp3/HttpUrl;", "path", "useHttps", "writeHeaders", "headers", "Lcom/spotify/githubclient/shade/okhttp3/Headers;", "writeHttpResponse", "Companion", "Http2SocketHandler", "SocketHandler", "TruncatingBuffer", "mockwebserver"})
public final class MockWebServer
extends ExternalResource
implements Closeable {
    private final TaskRunner.RealBackend taskRunnerBackend = new TaskRunner.RealBackend(Util.threadFactory("MockWebServer TaskRunner", false));
    private final TaskRunner taskRunner = new TaskRunner(this.taskRunnerBackend);
    private final LinkedBlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue();
    private final Set<Socket> openClientSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Http2Connection> openConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger atomicRequestCount = new AtomicInteger();
    private long bodyLimit = Long.MAX_VALUE;
    @Nullable
    private ServerSocketFactory serverSocketFactory;
    private ServerSocket serverSocket;
    private SSLSocketFactory sslSocketFactory;
    private boolean tunnelProxy;
    private int clientAuth;
    @NotNull
    private Dispatcher dispatcher = new QueueDispatcher();
    private int portField = -1;
    private InetSocketAddress inetSocketAddress;
    private boolean protocolNegotiationEnabled = true;
    @NotNull
    private List<? extends Protocol> protocols = Util.immutableListOf(Protocol.HTTP_2, Protocol.HTTP_1_1);
    private boolean started;
    private static final int CLIENT_AUTH_NONE = 0;
    private static final int CLIENT_AUTH_REQUESTED = 1;
    private static final int CLIENT_AUTH_REQUIRED = 2;
    private static final Companion.UNTRUSTED_TRUST_MANAGER.1 UNTRUSTED_TRUST_MANAGER;
    private static final Logger logger;
    public static final Companion Companion;

    public final int getRequestCount() {
        return this.atomicRequestCount.get();
    }

    public final long getBodyLimit() {
        return this.bodyLimit;
    }

    public final void setBodyLimit(long l) {
        this.bodyLimit = l;
    }

    @Nullable
    public final ServerSocketFactory getServerSocketFactory() {
        if (this.serverSocketFactory == null && this.started) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        return this.serverSocketFactory;
    }

    public final void setServerSocketFactory(@Nullable ServerSocketFactory value) {
        boolean bl = !this.started;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "serverSocketFactory must not be set after start()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.serverSocketFactory = value;
    }

    @NotNull
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final void setDispatcher(@NotNull Dispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"<set-?>");
        this.dispatcher = dispatcher;
    }

    public final int getPort() {
        this.before();
        return this.portField;
    }

    @NotNull
    public final String getHostName() {
        this.before();
        InetSocketAddress inetSocketAddress = this.inetSocketAddress;
        if (inetSocketAddress == null) {
            Intrinsics.throwNpe();
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"inetSocketAddress!!.address");
        String string = inetAddress.getCanonicalHostName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inetSocketAddress!!.address.canonicalHostName");
        return string;
    }

    public final boolean getProtocolNegotiationEnabled() {
        return this.protocolNegotiationEnabled;
    }

    public final void setProtocolNegotiationEnabled(boolean bl) {
        this.protocolNegotiationEnabled = bl;
    }

    @JvmName(name="protocols")
    @NotNull
    public final List<Protocol> protocols() {
        return this.protocols;
    }

    public final void setProtocols(@NotNull List<? extends Protocol> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        List<? extends Protocol> protocolList = Util.toImmutableList(value);
        boolean bl = !protocolList.contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) || protocolList.size() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "protocols containing h2_prior_knowledge cannot use other protocols: " + protocolList;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = protocolList.contains((Object)Protocol.HTTP_1_1) || protocolList.contains((Object)Protocol.H2_PRIOR_KNOWLEDGE);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "protocols doesn't contain http/1.1: " + protocolList;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List<? extends Protocol> list = protocolList;
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<okhttp3.Protocol?>");
        }
        bl = !list.contains(null);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "protocols must not contain null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.protocols = protocolList;
    }

    protected synchronized void before() {
        if (this.started) {
            return;
        }
        try {
            MockWebServer.start$default(this, 0, 1, null);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="port"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_port")
    public final int -deprecated_port() {
        return this.getPort();
    }

    @NotNull
    public final Proxy toProxyAddress() {
        this.before();
        InetSocketAddress inetSocketAddress = this.inetSocketAddress;
        if (inetSocketAddress == null) {
            Intrinsics.throwNpe();
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"inetSocketAddress!!.address");
        InetSocketAddress address = new InetSocketAddress(inetAddress.getCanonicalHostName(), this.getPort());
        return new Proxy(Proxy.Type.HTTP, address);
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(imports={}, expression="run { this.serverSocketFactory = serverSocketFactory }"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_serverSocketFactory")
    public final void -deprecated_serverSocketFactory(@NotNull ServerSocketFactory serverSocketFactory) {
        Intrinsics.checkParameterIsNotNull((Object)serverSocketFactory, (String)"serverSocketFactory");
        MockWebServer mockWebServer = this;
        boolean bl = false;
        boolean bl2 = false;
        MockWebServer $this$run = mockWebServer;
        boolean bl3 = false;
        $this$run.setServerSocketFactory(serverSocketFactory);
    }

    @NotNull
    public final HttpUrl url(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(this.sslSocketFactory != null ? "https" : "http").host(this.getHostName()).port(this.getPort()).build().resolve(path);
        if (httpUrl == null) {
            Intrinsics.throwNpe();
        }
        return httpUrl;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(imports={}, expression="run { this.bodyLimit = bodyLimit }"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_bodyLimit")
    public final void -deprecated_bodyLimit(long bodyLimit) {
        MockWebServer mockWebServer = this;
        boolean bl = false;
        boolean bl2 = false;
        MockWebServer $this$run = mockWebServer;
        boolean bl3 = false;
        $this$run.bodyLimit = bodyLimit;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(imports={}, expression="run { this.protocolNegotiationEnabled = protocolNegotiationEnabled }"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocolNegotiationEnabled")
    public final void -deprecated_protocolNegotiationEnabled(boolean protocolNegotiationEnabled) {
        MockWebServer mockWebServer = this;
        boolean bl = false;
        boolean bl2 = false;
        MockWebServer $this$run = mockWebServer;
        boolean bl3 = false;
        $this$run.protocolNegotiationEnabled = protocolNegotiationEnabled;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(imports={}, expression="run { this.protocols = protocols }"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocols")
    public final void -deprecated_protocols(@NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkParameterIsNotNull(protocols, (String)"protocols");
        MockWebServer mockWebServer = this;
        boolean bl = false;
        boolean bl2 = false;
        MockWebServer $this$run = mockWebServer;
        boolean bl3 = false;
        $this$run.setProtocols(protocols);
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(imports={}, expression="protocols"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocols")
    @NotNull
    public final List<Protocol> -deprecated_protocols() {
        return this.protocols;
    }

    public final void useHttps(@NotNull SSLSocketFactory sslSocketFactory, boolean tunnelProxy) {
        Intrinsics.checkParameterIsNotNull((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.sslSocketFactory = sslSocketFactory;
        this.tunnelProxy = tunnelProxy;
    }

    public final void noClientAuth() {
        this.clientAuth = 0;
    }

    public final void requestClientAuth() {
        this.clientAuth = 1;
    }

    public final void requireClientAuth() {
        this.clientAuth = 2;
    }

    @NotNull
    public final RecordedRequest takeRequest() throws InterruptedException {
        RecordedRequest recordedRequest = this.requestQueue.take();
        Intrinsics.checkExpressionValueIsNotNull((Object)recordedRequest, (String)"requestQueue.take()");
        return recordedRequest;
    }

    @Nullable
    public final RecordedRequest takeRequest(long timeout2, @NotNull TimeUnit unit) throws InterruptedException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        return this.requestQueue.poll(timeout2, unit);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="requestCount"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_requestCount")
    public final int -deprecated_requestCount() {
        return this.getRequestCount();
    }

    public final void enqueue(@NotNull MockResponse response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Dispatcher dispatcher = this.dispatcher;
        if (dispatcher == null) {
            throw new TypeCastException("null cannot be cast to non-null type okhttp3.mockwebserver.QueueDispatcher");
        }
        ((QueueDispatcher)dispatcher).enqueueResponse(response.clone());
    }

    @JvmOverloads
    public final void start(int port) throws IOException {
        InetAddress inetAddress = InetAddress.getByName("localhost");
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"InetAddress.getByName(\"localhost\")");
        this.start(inetAddress, port);
    }

    public static /* synthetic */ void start$default(MockWebServer mockWebServer, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        mockWebServer.start(n);
    }

    @JvmOverloads
    public final void start() throws IOException {
        MockWebServer.start$default(this, 0, 1, null);
    }

    public final void start(@NotNull InetAddress inetAddress, int port) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)inetAddress, (String)"inetAddress");
        this.start(new InetSocketAddress(inetAddress, port));
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void start(InetSocketAddress inetSocketAddress) throws IOException {
        void name$iv;
        void this_$iv;
        boolean bl = !this.started;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "start() already called";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.started = true;
        this.inetSocketAddress = inetSocketAddress;
        ServerSocketFactory serverSocketFactory = this.getServerSocketFactory();
        if (serverSocketFactory == null) {
            Intrinsics.throwNpe();
        }
        ServerSocket serverSocket = this.serverSocket = serverSocketFactory.createServerSocket();
        if (serverSocket == null) {
            Intrinsics.throwNpe();
        }
        serverSocket.setReuseAddress(inetSocketAddress.getPort() != 0);
        ServerSocket serverSocket2 = this.serverSocket;
        if (serverSocket2 == null) {
            Intrinsics.throwNpe();
        }
        serverSocket2.bind(inetSocketAddress, 50);
        ServerSocket serverSocket3 = this.serverSocket;
        if (serverSocket3 == null) {
            Intrinsics.throwNpe();
        }
        this.portField = serverSocket3.getLocalPort();
        TaskQueue taskQueue = this.taskRunner.newQueue();
        String string = "MockWebServer " + this.portField;
        boolean cancelable$iv = false;
        long delayNanos$iv = 0L;
        boolean $i$f$execute = false;
        this_$iv.schedule(new Task((String)name$iv, cancelable$iv, (String)name$iv, cancelable$iv, this){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ MockWebServer this$0;
            {
                this.$name = $captured_local_variable$1;
                this.$cancelable = $captured_local_variable$2;
                this.this$0 = mockWebServer;
                super($super_call_param$3, $super_call_param$4);
            }

            public long runOnce() {
                boolean bl = false;
                try {
                    MockWebServer.access$getLogger$cp().fine(this.this$0 + " starting to accept connections");
                    MockWebServer.access$acceptConnections(this.this$0);
                }
                catch (Throwable e) {
                    MockWebServer.access$getLogger$cp().log(Level.WARNING, this.this$0 + " failed unexpectedly", e);
                }
                ServerSocket serverSocket = MockWebServer.access$getServerSocket$p(this.this$0);
                if (serverSocket != null) {
                    Util.closeQuietly(serverSocket);
                }
                Iterator<E> openClientSocket = MockWebServer.access$getOpenClientSockets$p(this.this$0).iterator();
                while (openClientSocket.hasNext()) {
                    E e = openClientSocket.next();
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"openClientSocket.next()");
                    Util.closeQuietly((Socket)e);
                    openClientSocket.remove();
                }
                Iterator<E> httpConnection = MockWebServer.access$getOpenConnections$p(this.this$0).iterator();
                while (httpConnection.hasNext()) {
                    E e = httpConnection.next();
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"httpConnection.next()");
                    Util.closeQuietly((Closeable)e);
                    httpConnection.remove();
                }
                this.this$0.getDispatcher().shutdown();
                return -1L;
            }
        }, delayNanos$iv);
    }

    private final void acceptConnections() throws Exception {
        while (true) {
            Socket socket = null;
            try {
                ServerSocket serverSocket = this.serverSocket;
                if (serverSocket == null) {
                    Intrinsics.throwNpe();
                }
                Socket socket2 = serverSocket.accept();
                Intrinsics.checkExpressionValueIsNotNull((Object)socket2, (String)"serverSocket!!.accept()");
                socket = socket2;
            }
            catch (SocketException e) {
                logger.fine(this + " done accepting connections: " + e.getMessage());
                return;
            }
            SocketPolicy socketPolicy = this.dispatcher.peek().getSocketPolicy();
            if (socketPolicy == SocketPolicy.DISCONNECT_AT_START) {
                this.dispatchBookkeepingRequest(0, socket);
                socket.close();
                continue;
            }
            this.openClientSockets.add(socket);
            this.serveConnection(socket);
        }
    }

    public final synchronized void shutdown() throws IOException {
        if (!this.started) {
            return;
        }
        boolean bl = this.serverSocket != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "shutdown() before start()";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket == null) {
            Intrinsics.throwNpe();
        }
        serverSocket.close();
        for (TaskQueue queue : this.taskRunner.activeQueues()) {
            if (queue.idleLatch().await(5L, TimeUnit.SECONDS)) continue;
            throw (Throwable)new IOException("Gave up waiting for queue to shut down");
        }
        this.taskRunnerBackend.shutdown();
    }

    protected synchronized void after() {
        try {
            this.shutdown();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "MockWebServer shutdown failed", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void serveConnection(Socket raw) {
        void name$iv;
        void this_$iv;
        TaskQueue taskQueue = this.taskRunner.newQueue();
        String string = "MockWebServer " + raw.getRemoteSocketAddress();
        boolean cancelable$iv = false;
        long delayNanos$iv = 0L;
        boolean $i$f$execute = false;
        this_$iv.schedule(new Task((String)name$iv, cancelable$iv, (String)name$iv, cancelable$iv, this, raw){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ MockWebServer this$0;
            final /* synthetic */ Socket $raw$inlined;
            {
                this.$name = $captured_local_variable$1;
                this.$cancelable = $captured_local_variable$2;
                this.this$0 = mockWebServer;
                this.$raw$inlined = socket;
                super($super_call_param$3, $super_call_param$4);
            }

            public long runOnce() {
                boolean bl = false;
                try {
                    this.this$0.new SocketHandler(this.$raw$inlined).handle();
                }
                catch (IOException e) {
                    MockWebServer.access$getLogger$cp().fine(this.this$0 + " connection from " + this.$raw$inlined.getInetAddress() + " failed: " + e);
                }
                catch (Exception e) {
                    MockWebServer.access$getLogger$cp().log(Level.SEVERE, this.this$0 + " connection from " + this.$raw$inlined.getInetAddress() + " crashed", e);
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    private final void processHandshakeFailure(Socket raw) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{UNTRUSTED_TRUST_MANAGER}, new SecureRandom());
        SSLContext sSLContext = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext, (String)"context");
        SSLSocketFactory sslSocketFactory = sSLContext.getSocketFactory();
        InetAddress inetAddress = raw.getInetAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"raw.inetAddress");
        Socket socket = sslSocketFactory.createSocket(raw, inetAddress.getHostAddress(), raw.getPort(), true);
        if (socket == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        }
        SSLSocket socket2 = (SSLSocket)socket;
        try {
            socket2.startHandshake();
            throw (Throwable)((Object)new AssertionError());
        }
        catch (IOException iOException) {
            socket2.close();
            return;
        }
    }

    private final void dispatchBookkeepingRequest(int sequenceNumber, Socket socket) throws InterruptedException {
        RecordedRequest request = new RecordedRequest("", Headers.Companion.of(new String[0]), CollectionsKt.emptyList(), 0L, new Buffer(), sequenceNumber, socket, null, 128, null);
        this.atomicRequestCount.incrementAndGet();
        this.requestQueue.add(request);
        this.dispatcher.dispatch(request);
    }

    private final RecordedRequest readRequest(Socket socket, BufferedSource source2, BufferedSink sink2, int sequenceNumber) throws IOException {
        String request = "";
        Headers.Builder headers = new Headers.Builder();
        long contentLength = -1L;
        boolean chunked = false;
        boolean expectContinue = false;
        TruncatingBuffer requestBody = new TruncatingBuffer(this.bodyLimit);
        boolean bl = false;
        List chunkSizes = new ArrayList();
        IOException failure = null;
        try {
            boolean bl2;
            int n;
            request = source2.readUtf8LineStrict();
            CharSequence charSequence = request;
            boolean bl3 = false;
            if (charSequence.length() == 0) {
                throw (Throwable)new ProtocolException("no request because the stream is exhausted");
            }
            while (true) {
                String lowercaseHeader;
                Locale locale;
                String header = source2.readUtf8LineStrict();
                CharSequence charSequence2 = header;
                boolean bl4 = false;
                if (charSequence2.length() == 0) break;
                Internal.addHeaderLenient(headers, header);
                String string = header;
                Intrinsics.checkExpressionValueIsNotNull((Object)Locale.US, (String)"Locale.US");
                boolean bl5 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.toLowerCase(locale), (String)"(this as java.lang.String).toLowerCase(locale)");
                if (contentLength == -1L && StringsKt.startsWith$default((String)lowercaseHeader, (String)"content-length:", (boolean)false, (int)2, null)) {
                    string = header;
                    int n2 = 15;
                    bl5 = false;
                    String string3 = string;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    string = string4;
                    n2 = 0;
                    String string5 = string;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                    n2 = 0;
                    contentLength = Long.parseLong(string);
                }
                if (StringsKt.startsWith$default((String)lowercaseHeader, (String)"transfer-encoding:", (boolean)false, (int)2, null)) {
                    string = lowercaseHeader;
                    int n3 = 18;
                    bl5 = false;
                    String string6 = string;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                    string = string7;
                    n3 = 0;
                    String string8 = string;
                    if (string8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string8)).toString(), (Object)"chunked")) {
                        chunked = true;
                    }
                }
                if (!StringsKt.startsWith$default((String)lowercaseHeader, (String)"expect:", (boolean)false, (int)2, null)) continue;
                string = lowercaseHeader;
                int n4 = 7;
                bl5 = false;
                String string9 = string;
                if (string9 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.substring(n4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
                string = string10;
                n4 = 0;
                String string11 = string;
                if (string11 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                if (!StringsKt.equals((String)((Object)StringsKt.trim((CharSequence)string11)).toString(), (String)"100-continue", (boolean)true)) continue;
                expectContinue = true;
            }
            SocketPolicy socketPolicy = this.dispatcher.peek().getSocketPolicy();
            if (expectContinue && socketPolicy == SocketPolicy.EXPECT_CONTINUE || socketPolicy == SocketPolicy.CONTINUE_ALWAYS) {
                sink2.writeUtf8("HTTP/1.1 100 Continue\r\n");
                sink2.writeUtf8("Content-Length: 0\r\n");
                sink2.writeUtf8("\r\n");
                sink2.flush();
            }
            boolean hasBody = false;
            MockResponse policy = this.dispatcher.peek();
            if (contentLength != -1L) {
                hasBody = contentLength > 0L;
                this.throttledTransfer(policy, socket, source2, Okio.buffer(requestBody), contentLength, true);
            } else if (chunked) {
                hasBody = true;
                while (true) {
                    String string = source2.readUtf8LineStrict();
                    n = 0;
                    String string12 = string;
                    if (string12 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string = ((Object)StringsKt.trim((CharSequence)string12)).toString();
                    n = 16;
                    bl2 = false;
                    int chunkSize = Integer.parseInt(string, CharsKt.checkRadix((int)n));
                    if (chunkSize == 0) {
                        this.readEmptyLine(source2);
                        break;
                    }
                    chunkSizes.add(chunkSize);
                    this.throttledTransfer(policy, socket, source2, Okio.buffer(requestBody), chunkSize, true);
                    this.readEmptyLine(source2);
                }
            }
            String method = StringsKt.substringBefore$default((String)request, (char)' ', null, (int)2, null);
            boolean bl6 = !hasBody || HttpMethod.permitsRequestBody(method);
            n = 0;
            bl2 = false;
            if (!bl6) {
                boolean bl7 = false;
                String string = "Request must not have a body: " + request;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        catch (IOException e) {
            failure = e;
        }
        return new RecordedRequest(request, headers.build(), chunkSizes, requestBody.getReceivedByteCount$mockwebserver(), requestBody.getBuffer$mockwebserver(), sequenceNumber, socket, failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleWebSocketUpgrade(Socket socket, BufferedSource source2, BufferedSink sink2, RecordedRequest request, MockResponse response) throws IOException {
        String key;
        String string = key = request.getHeader("Sec-WebSocket-Key");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        response.setHeader("Sec-WebSocket-Accept", WebSocketProtocol.INSTANCE.acceptHeader(string));
        this.writeHttpResponse(socket, sink2, response);
        String scheme = request.getTlsVersion() != null ? "https" : "http";
        String authority = request.getHeader("Host");
        Request fancyRequest = new Request.Builder().url(scheme + "://" + authority + '/').headers(request.getHeaders()).build();
        char[] cArray = new char[]{' '};
        boolean bl = false;
        int n = 3;
        List statusParts = StringsKt.split$default((CharSequence)response.getStatus(), (char[])cArray, (boolean)bl, (int)n, (int)2, null);
        String string2 = (String)statusParts.get(1);
        Response.Builder builder = new Response.Builder();
        n = 0;
        int n2 = Integer.parseInt(string2);
        Response fancyResponse = builder.code(n2).message((String)statusParts.get(2)).headers(response.getHeaders()).request(fancyRequest).protocol(Protocol.HTTP_1_1).build();
        CountDownLatch connectionClose = new CountDownLatch(1);
        RealWebSocket.Streams streams2 = new RealWebSocket.Streams(connectionClose, source2, sink2, false, source2, sink2){
            final /* synthetic */ CountDownLatch $connectionClose;
            final /* synthetic */ BufferedSource $source;
            final /* synthetic */ BufferedSink $sink;

            public void close() {
                this.$connectionClose.countDown();
            }
            {
                this.$connectionClose = $captured_local_variable$0;
                this.$source = $captured_local_variable$1;
                this.$sink = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
        WebSocketListener webSocketListener = response.getWebSocketListener();
        if (webSocketListener == null) {
            Intrinsics.throwNpe();
        }
        RealWebSocket webSocket = new RealWebSocket(this.taskRunner, fancyRequest, webSocketListener, new SecureRandom(), 0L);
        WebSocketListener webSocketListener2 = response.getWebSocketListener();
        if (webSocketListener2 == null) {
            Intrinsics.throwNpe();
        }
        webSocketListener2.onOpen(webSocket, fancyResponse);
        StringBuilder stringBuilder = new StringBuilder().append("MockWebServer WebSocket ");
        String string3 = request.getPath();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        String name = stringBuilder.append(string3).toString();
        webSocket.initReaderAndWriter(name, streams2);
        try {
            webSocket.loopReader();
            connectionClose.await();
        }
        catch (IOException e) {
            webSocket.failWebSocket(e, null);
        }
        finally {
            Util.closeQuietly(source2);
        }
    }

    private final void writeHttpResponse(Socket socket, BufferedSink sink2, MockResponse response) throws IOException {
        this.sleepIfDelayed(response.getHeadersDelay(TimeUnit.MILLISECONDS));
        sink2.writeUtf8(response.getStatus());
        sink2.writeUtf8("\r\n");
        this.writeHeaders(sink2, response.getHeaders());
        Buffer buffer = response.getBody();
        if (buffer == null) {
            return;
        }
        Buffer body = buffer;
        this.sleepIfDelayed(response.getBodyDelay(TimeUnit.MILLISECONDS));
        this.throttledTransfer(response, socket, body, sink2, body.size(), false);
        if (StringsKt.equals((String)"chunked", (String)response.getHeaders().get("Transfer-Encoding"), (boolean)true)) {
            this.writeHeaders(sink2, response.getTrailers());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeHeaders(BufferedSink sink2, Headers headers) throws IOException {
        for (Pair<String, String> pair : headers) {
            void name;
            String string = (String)pair.component1();
            String value = (String)pair.component2();
            sink2.writeUtf8((String)name);
            sink2.writeUtf8(": ");
            sink2.writeUtf8(value);
            sink2.writeUtf8("\r\n");
        }
        sink2.writeUtf8("\r\n");
        sink2.flush();
    }

    private final void sleepIfDelayed(long delayMs) {
        if (delayMs != 0L) {
            Thread.sleep(delayMs);
        }
    }

    private final void throttledTransfer(MockResponse policy, Socket socket, BufferedSource source2, BufferedSink sink2, long byteCount, boolean isRequest) throws IOException {
        boolean disconnectHalfway;
        long byteCountNum = byteCount;
        if (byteCountNum == 0L) {
            return;
        }
        Buffer buffer = new Buffer();
        long bytesPerPeriod = policy.getThrottleBytesPerPeriod();
        long periodDelayMs = policy.getThrottlePeriod(TimeUnit.MILLISECONDS);
        long halfByteCount = byteCountNum / (long)2;
        boolean bl = isRequest ? policy.getSocketPolicy() == SocketPolicy.DISCONNECT_DURING_REQUEST_BODY : (disconnectHalfway = policy.getSocketPolicy() == SocketPolicy.DISCONNECT_DURING_RESPONSE_BODY);
        while (!socket.isClosed()) {
            long read;
            for (long b = 0L; b < bytesPerPeriod; b += read) {
                long l = bytesPerPeriod - b;
                boolean bl2 = false;
                long toRead = Math.min(byteCountNum, l);
                if (disconnectHalfway) {
                    l = byteCountNum - halfByteCount;
                    bl2 = false;
                    toRead = Math.min(toRead, l);
                }
                if ((read = source2.read(buffer, toRead)) == -1L) {
                    return;
                }
                sink2.write(buffer, read);
                sink2.flush();
                if (!disconnectHalfway || (byteCountNum -= read) != halfByteCount) continue;
                socket.close();
                return;
            }
            this.sleepIfDelayed(periodDelayMs);
        }
    }

    private final void readEmptyLine(BufferedSource source2) throws IOException {
        String line = source2.readUtf8LineStrict();
        CharSequence charSequence = line;
        boolean bl = false;
        boolean bl2 = charSequence.length() == 0;
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Expected empty but was: " + line;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public String toString() {
        return "MockWebServer[" + this.portField + ']';
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    static {
        Companion = new Companion(null);
        MwsDuplexAccess.instance = new MwsDuplexAccess(){

            public void setBody(@NotNull MockResponse mockResponse, @NotNull DuplexResponseBody duplexResponseBody) {
                Intrinsics.checkParameterIsNotNull((Object)mockResponse, (String)"mockResponse");
                Intrinsics.checkParameterIsNotNull((Object)duplexResponseBody, (String)"duplexResponseBody");
                mockResponse.setBody(duplexResponseBody);
            }
        };
        UNTRUSTED_TRUST_MANAGER = new X509TrustManager(){

            @NotNull
            public Void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
                throw (Throwable)new CertificateException();
            }

            @NotNull
            public Void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
                throw (Throwable)((Object)new AssertionError());
            }

            @NotNull
            public X509Certificate[] getAcceptedIssuers() {
                throw (Throwable)((Object)new AssertionError());
            }
        };
        logger = Logger.getLogger(MockWebServer.class.getName());
    }

    public static final /* synthetic */ void access$setSslSocketFactory$p(MockWebServer $this, SSLSocketFactory sSLSocketFactory) {
        $this.sslSocketFactory = sSLSocketFactory;
    }

    public static final /* synthetic */ void access$setTunnelProxy$p(MockWebServer $this, boolean bl) {
        $this.tunnelProxy = bl;
    }

    public static final /* synthetic */ void access$setClientAuth$p(MockWebServer $this, int n) {
        $this.clientAuth = n;
    }

    public static final /* synthetic */ void access$acceptConnections(MockWebServer $this) {
        $this.acceptConnections();
    }

    public static final /* synthetic */ ServerSocket access$getServerSocket$p(MockWebServer $this) {
        return $this.serverSocket;
    }

    public static final /* synthetic */ void access$setServerSocket$p(MockWebServer $this, ServerSocket serverSocket) {
        $this.serverSocket = serverSocket;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\bJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/MockWebServer$SocketHandler;", "", "raw", "Ljava/net/Socket;", "(Lokhttp3/mockwebserver/MockWebServer;Ljava/net/Socket;)V", "sequenceNumber", "", "createTunnel", "", "handle", "processOneRequest", "", "socket", "source", "Lcom/spotify/githubclient/shade/okio/BufferedSource;", "sink", "Lcom/spotify/githubclient/shade/okio/BufferedSink;", "mockwebserver"})
    public final class SocketHandler {
        private int sequenceNumber;
        private final Socket raw;

        public final void handle() throws Exception {
            SocketPolicy socketPolicy = MockWebServer.this.getDispatcher().peek().getSocketPolicy();
            Protocol protocol = Protocol.HTTP_1_1;
            Socket socket = null;
            if (MockWebServer.this.sslSocketFactory != null) {
                if (MockWebServer.this.tunnelProxy) {
                    this.createTunnel();
                }
                if (socketPolicy == SocketPolicy.FAIL_HANDSHAKE) {
                    MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, this.raw);
                    MockWebServer.this.processHandshakeFailure(this.raw);
                    return;
                }
                SSLSocketFactory sSLSocketFactory = MockWebServer.this.sslSocketFactory;
                if (sSLSocketFactory == null) {
                    Intrinsics.throwNpe();
                }
                InetAddress inetAddress = this.raw.getInetAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"raw.inetAddress");
                Socket socket2 = sSLSocketFactory.createSocket(this.raw, inetAddress.getHostAddress(), this.raw.getPort(), true);
                Intrinsics.checkExpressionValueIsNotNull((Object)socket2, (String)"sslSocketFactory!!.creat\u2026          raw.port, true)");
                Socket socket3 = socket = socket2;
                if (socket3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.SSLSocket");
                }
                SSLSocket sslSocket = (SSLSocket)socket3;
                sslSocket.setUseClientMode(false);
                if (MockWebServer.this.clientAuth == 2) {
                    sslSocket.setNeedClientAuth(true);
                } else if (MockWebServer.this.clientAuth == 1) {
                    sslSocket.setWantClientAuth(true);
                }
                MockWebServer.this.openClientSockets.add(socket);
                if (MockWebServer.this.getProtocolNegotiationEnabled()) {
                    Platform.Companion.get().configureTlsExtensions(sslSocket, null, MockWebServer.this.protocols());
                }
                sslSocket.startHandshake();
                if (MockWebServer.this.getProtocolNegotiationEnabled()) {
                    String protocolString = Platform.Companion.get().getSelectedProtocol(sslSocket);
                    protocol = protocolString != null ? Protocol.Companion.get(protocolString) : Protocol.HTTP_1_1;
                    Platform.Companion.get().afterHandshake(sslSocket);
                }
                MockWebServer.this.openClientSockets.remove(this.raw);
            } else if (MockWebServer.this.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
                socket = this.raw;
                protocol = Protocol.H2_PRIOR_KNOWLEDGE;
            } else {
                socket = this.raw;
            }
            if (socketPolicy == SocketPolicy.STALL_SOCKET_AT_START) {
                MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, socket);
                return;
            }
            if (protocol == Protocol.HTTP_2 || protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                Http2SocketHandler http2SocketHandler = new Http2SocketHandler(socket, protocol);
                Http2Connection connection = Http2Connection.Builder.socket$default(new Http2Connection.Builder(false, MockWebServer.this.taskRunner), socket, null, null, null, 14, null).listener(http2SocketHandler).build();
                Http2Connection.start$default(connection, false, 1, null);
                MockWebServer.this.openConnections.add(connection);
                MockWebServer.this.openClientSockets.remove(socket);
                return;
            }
            if (protocol != Protocol.HTTP_1_1) {
                throw (Throwable)((Object)new AssertionError());
            }
            BufferedSource source2 = Okio.buffer(Okio.source(socket));
            BufferedSink sink2 = Okio.buffer(Okio.sink(socket));
            while (this.processOneRequest(socket, source2, sink2)) {
            }
            if (this.sequenceNumber == 0) {
                logger.warning(MockWebServer.this + " connection from " + this.raw.getInetAddress() + " didn't make a request");
            }
            socket.close();
            MockWebServer.this.openClientSockets.remove(socket);
        }

        private final void createTunnel() throws IOException, InterruptedException {
            SocketPolicy socketPolicy;
            BufferedSource source2 = Okio.buffer(Okio.source(this.raw));
            BufferedSink sink2 = Okio.buffer(Okio.sink(this.raw));
            do {
                socketPolicy = MockWebServer.this.getDispatcher().peek().getSocketPolicy();
                boolean bl = this.processOneRequest(this.raw, source2, sink2);
                boolean bl2 = false;
                boolean bl3 = false;
                if (bl) continue;
                boolean bl4 = false;
                String string = "Tunnel without any CONNECT!";
                throw (Throwable)new IllegalStateException(string.toString());
            } while (socketPolicy != SocketPolicy.UPGRADE_TO_SSL_AT_END);
        }

        private final boolean processOneRequest(Socket socket, BufferedSource source2, BufferedSink sink2) throws IOException, InterruptedException {
            boolean responseWantsWebSockets;
            if (source2.exhausted()) {
                return false;
            }
            RecordedRequest request = MockWebServer.this.readRequest(socket, source2, sink2, this.sequenceNumber);
            MockWebServer.this.atomicRequestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request);
            if (request.getFailure() != null) {
                return false;
            }
            MockResponse response = MockWebServer.this.getDispatcher().dispatch(request);
            if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                socket.close();
                return false;
            }
            if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                if (source2.exhausted()) {
                    return false;
                }
                throw (Throwable)new ProtocolException("unexpected data");
            }
            boolean reuseSocket = true;
            boolean requestWantsWebSockets = StringsKt.equals((String)"Upgrade", (String)request.getHeader("Connection"), (boolean)true) && StringsKt.equals((String)"websocket", (String)request.getHeader("Upgrade"), (boolean)true);
            boolean bl = responseWantsWebSockets = response.getWebSocketListener() != null;
            if (requestWantsWebSockets && responseWantsWebSockets) {
                MockWebServer.this.handleWebSocketUpgrade(socket, source2, sink2, request, response);
                reuseSocket = false;
            } else {
                MockWebServer.this.writeHttpResponse(socket, sink2, response);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MockWebServer.this + " received request: " + request + " and responded: " + response);
            }
            switch (MockWebServer$SocketHandler$WhenMappings.$EnumSwitchMapping$0[response.getSocketPolicy().ordinal()]) {
                case 1: {
                    socket.close();
                    return false;
                }
                case 2: {
                    socket.shutdownInput();
                    break;
                }
                case 3: {
                    socket.shutdownOutput();
                    break;
                }
                case 4: {
                    MockWebServer.this.shutdown();
                }
            }
            int n = this.sequenceNumber;
            this.sequenceNumber = n + 1;
            return reuseSocket;
        }

        public SocketHandler(Socket raw) {
            Intrinsics.checkParameterIsNotNull((Object)raw, (String)"raw");
            this.raw = raw;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/MockWebServer$TruncatingBuffer;", "Lcom/spotify/githubclient/shade/okio/Sink;", "remainingByteCount", "", "(J)V", "buffer", "Lcom/spotify/githubclient/shade/okio/Buffer;", "getBuffer$mockwebserver", "()Lokio/Buffer;", "receivedByteCount", "getReceivedByteCount$mockwebserver", "()J", "setReceivedByteCount$mockwebserver", "close", "", "flush", "timeout", "Lcom/spotify/githubclient/shade/okio/Timeout;", "write", "source", "byteCount", "mockwebserver"})
    private static final class TruncatingBuffer
    implements Sink {
        @NotNull
        private final Buffer buffer;
        private long receivedByteCount;
        private long remainingByteCount;

        @NotNull
        public final Buffer getBuffer$mockwebserver() {
            return this.buffer;
        }

        public final long getReceivedByteCount$mockwebserver() {
            return this.receivedByteCount;
        }

        public final void setReceivedByteCount$mockwebserver(long l) {
            this.receivedByteCount = l;
        }

        @Override
        public void write(@NotNull Buffer source2, long byteCount) throws IOException {
            long toSkip;
            Intrinsics.checkParameterIsNotNull((Object)source2, (String)"source");
            long l = this.remainingByteCount;
            boolean bl = false;
            long toRead = Math.min(l, byteCount);
            if (toRead > 0L) {
                source2.read(this.buffer, toRead);
            }
            if ((toSkip = byteCount - toRead) > 0L) {
                source2.skip(toSkip);
            }
            this.remainingByteCount -= toRead;
            this.receivedByteCount += byteCount;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        @Override
        public void close() throws IOException {
        }

        public TruncatingBuffer(long remainingByteCount) {
            this.remainingByteCount = remainingByteCount;
            this.buffer = new Buffer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/MockWebServer$Http2SocketHandler;", "Lcom/spotify/githubclient/shade/okhttp3/internal/http2/Http2Connection$Listener;", "socket", "Ljava/net/Socket;", "protocol", "Lcom/spotify/githubclient/shade/okhttp3/Protocol;", "(Lokhttp3/mockwebserver/MockWebServer;Ljava/net/Socket;Lokhttp3/Protocol;)V", "sequenceNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "onStream", "", "stream", "Lcom/spotify/githubclient/shade/okhttp3/internal/http2/Http2Stream;", "pushPromises", "request", "Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/RecordedRequest;", "promises", "", "Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/PushPromise;", "readRequest", "writeResponse", "response", "Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/MockResponse;", "mockwebserver"})
    private final class Http2SocketHandler
    extends Http2Connection.Listener {
        private final AtomicInteger sequenceNumber;
        private final Socket socket;
        private final Protocol protocol;

        @Override
        public void onStream(@NotNull Http2Stream stream) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            MockResponse peekedResponse = MockWebServer.this.getDispatcher().peek();
            if (peekedResponse.getSocketPolicy() == SocketPolicy.RESET_STREAM_AT_START) {
                MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber.getAndIncrement(), this.socket);
                ErrorCode errorCode = ErrorCode.Companion.fromHttp2(peekedResponse.getHttp2ErrorCode());
                if (errorCode == null) {
                    Intrinsics.throwNpe();
                }
                stream.close(errorCode, null);
                return;
            }
            RecordedRequest request = this.readRequest(stream);
            MockWebServer.this.atomicRequestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request);
            if (request.getFailure() != null) {
                return;
            }
            MockResponse response = MockWebServer.this.getDispatcher().dispatch(request);
            if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                this.socket.close();
                return;
            }
            this.writeResponse(stream, request, response);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MockWebServer.this + " received request: " + request + ' ' + "and responded: " + response + " protocol is " + (Object)((Object)this.protocol));
            }
            if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AT_END) {
                Http2Connection connection = stream.getConnection();
                connection.shutdown(ErrorCode.NO_ERROR);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final RecordedRequest readRequest(Http2Stream stream) throws IOException {
            Headers streamHeaders = stream.takeHeaders();
            Headers.Builder httpHeaders = new Headers.Builder();
            String method = "<:method omitted>";
            String path = "<:path omitted>";
            boolean readBody = true;
            for (Pair<String, String> pair : streamHeaders) {
                void name;
                String string = (String)pair.component1();
                String value = (String)pair.component2();
                if (Intrinsics.areEqual((Object)name, (Object)":method")) {
                    method = value;
                } else if (Intrinsics.areEqual((Object)name, (Object)":path")) {
                    path = value;
                } else if (this.protocol == Protocol.HTTP_2 || this.protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                    httpHeaders.add((String)name, value);
                } else {
                    throw (Throwable)new IllegalStateException();
                }
                if (!Intrinsics.areEqual((Object)name, (Object)"expect") || !StringsKt.equals((String)value, (String)"100-continue", (boolean)true)) continue;
                readBody = false;
            }
            Headers headers = httpHeaders.build();
            MockResponse peek = MockWebServer.this.getDispatcher().peek();
            if (!readBody && peek.getSocketPolicy() == SocketPolicy.EXPECT_CONTINUE) {
                List continueHeaders = CollectionsKt.listOf((Object)new Header(Header.RESPONSE_STATUS, ByteString.Companion.encodeUtf8("100 Continue")));
                stream.writeHeaders(continueHeaders, false, true);
                stream.getConnection().flush();
                readBody = true;
            }
            Buffer body = new Buffer();
            String requestLine = method + ' ' + path + " HTTP/1.1";
            IOException exception = null;
            if (readBody && !peek.isDuplex()) {
                try {
                    long l;
                    String contentLengthString;
                    String string = contentLengthString = headers.get("content-length");
                    if (string != null) {
                        String string2 = string;
                        boolean bl = false;
                        l = Long.parseLong(string2);
                    } else {
                        l = Long.MAX_VALUE;
                    }
                    long byteCount = l;
                    MockWebServer.this.throttledTransfer(peek, this.socket, Okio.buffer(stream.getSource()), body, byteCount, true);
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            return new RecordedRequest(requestLine, headers, CollectionsKt.emptyList(), body.size(), body, this.sequenceNumber.getAndIncrement(), this.socket, exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void writeResponse(Http2Stream stream, RecordedRequest request, MockResponse response) throws IOException {
            Settings settings = response.getSettings();
            stream.getConnection().setSettings(settings);
            if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                return;
            }
            boolean bl = false;
            List http2Headers = new ArrayList();
            char[] cArray = new char[]{' '};
            boolean bl2 = false;
            int n = 3;
            List statusParts = StringsKt.split$default((CharSequence)response.getStatus(), (char[])cArray, (boolean)bl2, (int)n, (int)2, null);
            long headersDelayMs = response.getHeadersDelay(TimeUnit.MILLISECONDS);
            long bodyDelayMs = response.getBodyDelay(TimeUnit.MILLISECONDS);
            if (statusParts.size() < 2) {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected status: " + response.getStatus())));
            }
            http2Headers.add(new Header(Header.RESPONSE_STATUS, (String)statusParts.get(1)));
            Headers headers = response.getHeaders();
            for (Pair<String, String> pair : headers) {
                void name;
                String string = (String)pair.component1();
                String value = (String)pair.component2();
                http2Headers.add(new Header((String)name, value));
            }
            Headers trailers = response.getTrailers();
            MockWebServer.this.sleepIfDelayed(headersDelayMs);
            Buffer body = response.getBody();
            boolean outFinished = body == null && response.getPushPromises().isEmpty() && !response.isDuplex();
            boolean flushHeaders = body == null || bodyDelayMs != 0L;
            boolean bl3 = !outFinished || trailers.size() == 0;
            boolean bl4 = false;
            boolean bl5 = false;
            if (!bl3) {
                boolean bl6 = false;
                String string = "unsupported: no body and non-empty trailers " + trailers;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            stream.writeHeaders(http2Headers, outFinished, flushHeaders);
            if (trailers.size() > 0) {
                stream.enqueueTrailers(trailers);
            }
            this.pushPromises(stream, request, response.getPushPromises());
            if (body != null) {
                Closeable closeable = Okio.buffer(stream.getSink());
                bl4 = false;
                Throwable throwable = null;
                try {
                    BufferedSink sink2 = (BufferedSink)closeable;
                    boolean bl7 = false;
                    MockWebServer.this.sleepIfDelayed(bodyDelayMs);
                    MockWebServer.this.throttledTransfer(response, this.socket, body, sink2, body.size(), false);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else if (response.isDuplex()) {
                DuplexResponseBody duplexResponseBody = response.getDuplexResponseBody();
                if (duplexResponseBody == null) {
                    Intrinsics.throwNpe();
                }
                DuplexResponseBody duplexResponseBody2 = duplexResponseBody;
                duplexResponseBody2.onRequest(request, stream);
            } else if (!outFinished) {
                stream.close(ErrorCode.NO_ERROR, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void pushPromises(Http2Stream stream, RecordedRequest request, List<PushPromise> promises) throws IOException {
            for (PushPromise pushPromise : promises) {
                boolean bl = false;
                List pushedHeaders = new ArrayList();
                pushedHeaders.add(new Header(Header.TARGET_AUTHORITY, MockWebServer.this.url(pushPromise.path()).host()));
                pushedHeaders.add(new Header(Header.TARGET_METHOD, pushPromise.method()));
                pushedHeaders.add(new Header(Header.TARGET_PATH, pushPromise.path()));
                Headers pushPromiseHeaders = pushPromise.headers();
                for (Pair<String, String> pair : pushPromiseHeaders) {
                    void name;
                    String string = (String)pair.component1();
                    String value = (String)pair.component2();
                    pushedHeaders.add(new Header((String)name, value));
                }
                String requestLine = pushPromise.method() + ' ' + pushPromise.path() + " HTTP/1.1";
                List chunkSizes = CollectionsKt.emptyList();
                MockWebServer.this.requestQueue.add(new RecordedRequest(requestLine, pushPromise.headers(), chunkSizes, 0L, new Buffer(), this.sequenceNumber.getAndIncrement(), this.socket, null, 128, null));
                boolean hasBody = pushPromise.response().getBody() != null;
                Http2Stream pushedStream = stream.getConnection().pushStream(stream.getId(), pushedHeaders, hasBody);
                this.writeResponse(pushedStream, request, pushPromise.response());
            }
        }

        public Http2SocketHandler(@NotNull Socket socket, Protocol protocol) {
            Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
            Intrinsics.checkParameterIsNotNull((Object)((Object)protocol), (String)"protocol");
            this.socket = socket;
            this.protocol = protocol;
            this.sequenceNumber = new AtomicInteger();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000#\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/MockWebServer$Companion;", "", "()V", "CLIENT_AUTH_NONE", "", "CLIENT_AUTH_REQUESTED", "CLIENT_AUTH_REQUIRED", "UNTRUSTED_TRUST_MANAGER", "com/spotify/githubclient/shade/okhttp3/mockwebserver/MockWebServer$Companion$UNTRUSTED_TRUST_MANAGER$1", "Lcom/spotify/githubclient/shade/okhttp3/mockwebserver/MockWebServer$Companion$UNTRUSTED_TRUST_MANAGER$1;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "mockwebserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

