/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.http;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.http.Link;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Link", generator="Immutables")
@Immutable
public final class ImmutableLink
implements Link {
    private final URI url;
    @Nullable
    private final String rel;
    @Nullable
    private final String rev;
    @Nullable
    private final String type;
    @Nullable
    private final String media;
    @Nullable
    private final String title;
    @Nullable
    private final String anchor;

    private ImmutableLink(URI url, @Nullable String rel, @Nullable String rev, @Nullable String type, @Nullable String media, @Nullable String title, @Nullable String anchor) {
        this.url = url;
        this.rel = rel;
        this.rev = rev;
        this.type = type;
        this.media = media;
        this.title = title;
        this.anchor = anchor;
    }

    @Override
    @JsonProperty
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    public Optional<String> rel() {
        return Optional.ofNullable(this.rel);
    }

    @Override
    @JsonProperty
    public Optional<String> rev() {
        return Optional.ofNullable(this.rev);
    }

    @Override
    @JsonProperty
    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    @Override
    @JsonProperty
    public Optional<String> media() {
        return Optional.ofNullable(this.media);
    }

    @Override
    @JsonProperty
    public Optional<String> title() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public Optional<String> anchor() {
        return Optional.ofNullable(this.anchor);
    }

    public final ImmutableLink withUrl(URI value) {
        if (this.url == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "url");
        return new ImmutableLink(newValue, this.rel, this.rev, this.type, this.media, this.title, this.anchor);
    }

    public final ImmutableLink withRel(String value) {
        String newValue = Objects.requireNonNull(value, "rel");
        if (Objects.equals(this.rel, newValue)) {
            return this;
        }
        return new ImmutableLink(this.url, newValue, this.rev, this.type, this.media, this.title, this.anchor);
    }

    public final ImmutableLink withRel(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.rel, value)) {
            return this;
        }
        return new ImmutableLink(this.url, value, this.rev, this.type, this.media, this.title, this.anchor);
    }

    public final ImmutableLink withRev(String value) {
        String newValue = Objects.requireNonNull(value, "rev");
        if (Objects.equals(this.rev, newValue)) {
            return this;
        }
        return new ImmutableLink(this.url, this.rel, newValue, this.type, this.media, this.title, this.anchor);
    }

    public final ImmutableLink withRev(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.rev, value)) {
            return this;
        }
        return new ImmutableLink(this.url, this.rel, value, this.type, this.media, this.title, this.anchor);
    }

    public final ImmutableLink withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (Objects.equals(this.type, newValue)) {
            return this;
        }
        return new ImmutableLink(this.url, this.rel, this.rev, newValue, this.media, this.title, this.anchor);
    }

    public final ImmutableLink withType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableLink(this.url, this.rel, this.rev, value, this.media, this.title, this.anchor);
    }

    public final ImmutableLink withMedia(String value) {
        String newValue = Objects.requireNonNull(value, "media");
        if (Objects.equals(this.media, newValue)) {
            return this;
        }
        return new ImmutableLink(this.url, this.rel, this.rev, this.type, newValue, this.title, this.anchor);
    }

    public final ImmutableLink withMedia(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.media, value)) {
            return this;
        }
        return new ImmutableLink(this.url, this.rel, this.rev, this.type, value, this.title, this.anchor);
    }

    public final ImmutableLink withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new ImmutableLink(this.url, this.rel, this.rev, this.type, this.media, newValue, this.anchor);
    }

    public final ImmutableLink withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableLink(this.url, this.rel, this.rev, this.type, this.media, value, this.anchor);
    }

    public final ImmutableLink withAnchor(String value) {
        String newValue = Objects.requireNonNull(value, "anchor");
        if (Objects.equals(this.anchor, newValue)) {
            return this;
        }
        return new ImmutableLink(this.url, this.rel, this.rev, this.type, this.media, this.title, newValue);
    }

    public final ImmutableLink withAnchor(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.anchor, value)) {
            return this;
        }
        return new ImmutableLink(this.url, this.rel, this.rev, this.type, this.media, this.title, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLink && this.equalTo((ImmutableLink)another);
    }

    private boolean equalTo(ImmutableLink another) {
        return this.url.equals(another.url) && Objects.equals(this.rel, another.rel) && Objects.equals(this.rev, another.rev) && Objects.equals(this.type, another.type) && Objects.equals(this.media, another.media) && Objects.equals(this.title, another.title) && Objects.equals(this.anchor, another.anchor);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Objects.hashCode(this.rel);
        h += (h << 5) + Objects.hashCode(this.rev);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.media);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.anchor);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Link{");
        builder.append("url=").append(this.url);
        if (this.rel != null) {
            builder.append(", ");
            builder.append("rel=").append(this.rel);
        }
        if (this.rev != null) {
            builder.append(", ");
            builder.append("rev=").append(this.rev);
        }
        if (this.type != null) {
            builder.append(", ");
            builder.append("type=").append(this.type);
        }
        if (this.media != null) {
            builder.append(", ");
            builder.append("media=").append(this.media);
        }
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        if (this.anchor != null) {
            builder.append(", ");
            builder.append("anchor=").append(this.anchor);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLink fromJson(Json json) {
        Builder builder = ImmutableLink.builder();
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.rel != null) {
            builder.rel(json.rel);
        }
        if (json.rev != null) {
            builder.rev(json.rev);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.media != null) {
            builder.media(json.media);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.anchor != null) {
            builder.anchor(json.anchor);
        }
        return builder.build();
    }

    public static ImmutableLink copyOf(Link instance) {
        if (instance instanceof ImmutableLink) {
            return (ImmutableLink)instance;
        }
        return ImmutableLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Link", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private long initBits = 1L;
        @Nullable
        private URI url;
        @Nullable
        private String rel;
        @Nullable
        private String rev;
        @Nullable
        private String type;
        @Nullable
        private String media;
        @Nullable
        private String title;
        @Nullable
        private String anchor;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Link instance) {
            Optional<String> anchorOptional;
            Optional<String> titleOptional;
            Optional<String> mediaOptional;
            Optional<String> typeOptional;
            Optional<String> revOptional;
            Objects.requireNonNull(instance, "instance");
            this.url(instance.url());
            Optional<String> relOptional = instance.rel();
            if (relOptional.isPresent()) {
                this.rel(relOptional);
            }
            if ((revOptional = instance.rev()).isPresent()) {
                this.rev(revOptional);
            }
            if ((typeOptional = instance.type()).isPresent()) {
                this.type(typeOptional);
            }
            if ((mediaOptional = instance.media()).isPresent()) {
                this.media(mediaOptional);
            }
            if ((titleOptional = instance.title()).isPresent()) {
                this.title(titleOptional);
            }
            if ((anchorOptional = instance.anchor()).isPresent()) {
                this.anchor(anchorOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(URI url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rel(String rel) {
            this.rel = Objects.requireNonNull(rel, "rel");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder rel(Optional<String> rel) {
            this.rel = rel.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rev(String rev) {
            this.rev = Objects.requireNonNull(rev, "rev");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder rev(Optional<String> rev) {
            this.rev = rev.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder type(Optional<String> type) {
            this.type = type.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder media(String media) {
            this.media = Objects.requireNonNull(media, "media");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder media(Optional<String> media) {
            this.media = media.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder anchor(String anchor) {
            this.anchor = Objects.requireNonNull(anchor, "anchor");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder anchor(Optional<String> anchor) {
            this.anchor = anchor.orElse(null);
            return this;
        }

        public ImmutableLink build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLink(this.url, this.rel, this.rev, this.type, this.media, this.title, this.anchor);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build Link, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Link", generator="Immutables")
    static final class Json
    implements Link {
        @Nullable
        URI url;
        @Nullable
        Optional<String> rel = Optional.empty();
        @Nullable
        Optional<String> rev = Optional.empty();
        @Nullable
        Optional<String> type = Optional.empty();
        @Nullable
        Optional<String> media = Optional.empty();
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        Optional<String> anchor = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setUrl(URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setRel(Optional<String> rel) {
            this.rel = rel;
        }

        @JsonProperty
        public void setRev(Optional<String> rev) {
            this.rev = rev;
        }

        @JsonProperty
        public void setType(Optional<String> type) {
            this.type = type;
        }

        @JsonProperty
        public void setMedia(Optional<String> media) {
            this.media = media;
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty
        public void setAnchor(Optional<String> anchor) {
            this.anchor = anchor;
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> rel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> rev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> media() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> anchor() {
            throw new UnsupportedOperationException();
        }
    }
}

