/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.Annotation;
import com.spotify.github.v3.checks.AnnotationLevel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Annotation", generator="Immutables")
@Immutable
public final class ImmutableAnnotation
implements Annotation {
    private final String path;
    @Nullable
    private final String blobHref;
    private final AnnotationLevel annotationLevel;
    private final String message;
    @Nullable
    private final String title;
    @Nullable
    private final String rawDetails;
    private final int startLine;
    private final int endLine;
    @Nullable
    private final Integer startColumn;
    @Nullable
    private final Integer endColumn;

    private ImmutableAnnotation(String path, @Nullable String blobHref, AnnotationLevel annotationLevel, String message, @Nullable String title, @Nullable String rawDetails, int startLine, int endLine, @Nullable Integer startColumn, @Nullable Integer endColumn) {
        this.path = path;
        this.blobHref = blobHref;
        this.annotationLevel = annotationLevel;
        this.message = message;
        this.title = title;
        this.rawDetails = rawDetails;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
    }

    @Override
    @JsonProperty
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty
    public Optional<String> blobHref() {
        return Optional.ofNullable(this.blobHref);
    }

    @Override
    @JsonProperty
    public AnnotationLevel annotationLevel() {
        return this.annotationLevel;
    }

    @Override
    @JsonProperty
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty
    public Optional<String> title() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public Optional<String> rawDetails() {
        return Optional.ofNullable(this.rawDetails);
    }

    @Override
    @JsonProperty
    public int startLine() {
        return this.startLine;
    }

    @Override
    @JsonProperty
    public int endLine() {
        return this.endLine;
    }

    @Override
    @JsonProperty
    public Optional<Integer> startColumn() {
        return Optional.ofNullable(this.startColumn);
    }

    @Override
    @JsonProperty
    public Optional<Integer> endColumn() {
        return Optional.ofNullable(this.endColumn);
    }

    public final ImmutableAnnotation withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableAnnotation(newValue, this.blobHref, this.annotationLevel, this.message, this.title, this.rawDetails, this.startLine, this.endLine, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withBlobHref(String value) {
        String newValue = Objects.requireNonNull(value, "blobHref");
        if (Objects.equals(this.blobHref, newValue)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, newValue, this.annotationLevel, this.message, this.title, this.rawDetails, this.startLine, this.endLine, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withBlobHref(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blobHref, value)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, value, this.annotationLevel, this.message, this.title, this.rawDetails, this.startLine, this.endLine, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withAnnotationLevel(AnnotationLevel value) {
        if (this.annotationLevel == value) {
            return this;
        }
        AnnotationLevel newValue = Objects.requireNonNull(value, "annotationLevel");
        if (this.annotationLevel.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, newValue, this.message, this.title, this.rawDetails, this.startLine, this.endLine, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, newValue, this.title, this.rawDetails, this.startLine, this.endLine, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, newValue, this.rawDetails, this.startLine, this.endLine, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, value, this.rawDetails, this.startLine, this.endLine, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withRawDetails(String value) {
        String newValue = Objects.requireNonNull(value, "rawDetails");
        if (Objects.equals(this.rawDetails, newValue)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, this.title, newValue, this.startLine, this.endLine, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withRawDetails(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.rawDetails, value)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, this.title, value, this.startLine, this.endLine, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withStartLine(int value) {
        if (this.startLine == value) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, this.title, this.rawDetails, value, this.endLine, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withEndLine(int value) {
        if (this.endLine == value) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, this.title, this.rawDetails, this.startLine, value, this.startColumn, this.endColumn);
    }

    public final ImmutableAnnotation withStartColumn(int value) {
        Integer newValue = value;
        if (Objects.equals(this.startColumn, newValue)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, this.title, this.rawDetails, this.startLine, this.endLine, newValue, this.endColumn);
    }

    public final ImmutableAnnotation withStartColumn(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.startColumn, value)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, this.title, this.rawDetails, this.startLine, this.endLine, value, this.endColumn);
    }

    public final ImmutableAnnotation withEndColumn(int value) {
        Integer newValue = value;
        if (Objects.equals(this.endColumn, newValue)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, this.title, this.rawDetails, this.startLine, this.endLine, this.startColumn, newValue);
    }

    public final ImmutableAnnotation withEndColumn(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.endColumn, value)) {
            return this;
        }
        return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, this.title, this.rawDetails, this.startLine, this.endLine, this.startColumn, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnnotation && this.equalTo((ImmutableAnnotation)another);
    }

    private boolean equalTo(ImmutableAnnotation another) {
        return this.path.equals(another.path) && Objects.equals(this.blobHref, another.blobHref) && this.annotationLevel.equals((Object)another.annotationLevel) && this.message.equals(another.message) && Objects.equals(this.title, another.title) && Objects.equals(this.rawDetails, another.rawDetails) && this.startLine == another.startLine && this.endLine == another.endLine && Objects.equals(this.startColumn, another.startColumn) && Objects.equals(this.endColumn, another.endColumn);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + Objects.hashCode(this.blobHref);
        h += (h << 5) + this.annotationLevel.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.rawDetails);
        h += (h << 5) + this.startLine;
        h += (h << 5) + this.endLine;
        h += (h << 5) + Objects.hashCode(this.startColumn);
        h += (h << 5) + Objects.hashCode(this.endColumn);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Annotation{");
        builder.append("path=").append(this.path);
        if (this.blobHref != null) {
            builder.append(", ");
            builder.append("blobHref=").append(this.blobHref);
        }
        builder.append(", ");
        builder.append("annotationLevel=").append((Object)this.annotationLevel);
        builder.append(", ");
        builder.append("message=").append(this.message);
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        if (this.rawDetails != null) {
            builder.append(", ");
            builder.append("rawDetails=").append(this.rawDetails);
        }
        builder.append(", ");
        builder.append("startLine=").append(this.startLine);
        builder.append(", ");
        builder.append("endLine=").append(this.endLine);
        if (this.startColumn != null) {
            builder.append(", ");
            builder.append("startColumn=").append(this.startColumn);
        }
        if (this.endColumn != null) {
            builder.append(", ");
            builder.append("endColumn=").append(this.endColumn);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAnnotation fromJson(Json json) {
        Builder builder = ImmutableAnnotation.builder();
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.blobHref != null) {
            builder.blobHref(json.blobHref);
        }
        if (json.annotationLevel != null) {
            builder.annotationLevel(json.annotationLevel);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.rawDetails != null) {
            builder.rawDetails(json.rawDetails);
        }
        if (json.startLineIsSet) {
            builder.startLine(json.startLine);
        }
        if (json.endLineIsSet) {
            builder.endLine(json.endLine);
        }
        if (json.startColumn != null) {
            builder.startColumn(json.startColumn);
        }
        if (json.endColumn != null) {
            builder.endColumn(json.endColumn);
        }
        return builder.build();
    }

    public static ImmutableAnnotation copyOf(Annotation instance) {
        if (instance instanceof ImmutableAnnotation) {
            return (ImmutableAnnotation)instance;
        }
        return ImmutableAnnotation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Annotation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_ANNOTATION_LEVEL = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private static final long INIT_BIT_START_LINE = 8L;
        private static final long INIT_BIT_END_LINE = 16L;
        private long initBits = 31L;
        @Nullable
        private String path;
        @Nullable
        private String blobHref;
        @Nullable
        private AnnotationLevel annotationLevel;
        @Nullable
        private String message;
        @Nullable
        private String title;
        @Nullable
        private String rawDetails;
        private int startLine;
        private int endLine;
        @Nullable
        private Integer startColumn;
        @Nullable
        private Integer endColumn;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Annotation instance) {
            Optional<Integer> endColumnOptional;
            Optional<String> rawDetailsOptional;
            Objects.requireNonNull(instance, "instance");
            this.path(instance.path());
            Optional<String> blobHrefOptional = instance.blobHref();
            if (blobHrefOptional.isPresent()) {
                this.blobHref(blobHrefOptional);
            }
            this.annotationLevel(instance.annotationLevel());
            this.message(instance.message());
            Optional<String> titleOptional = instance.title();
            if (titleOptional.isPresent()) {
                this.title(titleOptional);
            }
            if ((rawDetailsOptional = instance.rawDetails()).isPresent()) {
                this.rawDetails(rawDetailsOptional);
            }
            this.startLine(instance.startLine());
            this.endLine(instance.endLine());
            Optional<Integer> startColumnOptional = instance.startColumn();
            if (startColumnOptional.isPresent()) {
                this.startColumn(startColumnOptional);
            }
            if ((endColumnOptional = instance.endColumn()).isPresent()) {
                this.endColumn(endColumnOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blobHref(String blobHref) {
            this.blobHref = Objects.requireNonNull(blobHref, "blobHref");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder blobHref(Optional<String> blobHref) {
            this.blobHref = blobHref.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder annotationLevel(AnnotationLevel annotationLevel) {
            this.annotationLevel = Objects.requireNonNull(annotationLevel, "annotationLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rawDetails(String rawDetails) {
            this.rawDetails = Objects.requireNonNull(rawDetails, "rawDetails");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder rawDetails(Optional<String> rawDetails) {
            this.rawDetails = rawDetails.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder startLine(int startLine) {
            this.startLine = startLine;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder endLine(int endLine) {
            this.endLine = endLine;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startColumn(int startColumn) {
            this.startColumn = startColumn;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder startColumn(Optional<Integer> startColumn) {
            this.startColumn = startColumn.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder endColumn(int endColumn) {
            this.endColumn = endColumn;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder endColumn(Optional<Integer> endColumn) {
            this.endColumn = endColumn.orElse(null);
            return this;
        }

        public ImmutableAnnotation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAnnotation(this.path, this.blobHref, this.annotationLevel, this.message, this.title, this.rawDetails, this.startLine, this.endLine, this.startColumn, this.endColumn);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("annotationLevel");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("startLine");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("endLine");
            }
            return "Cannot build Annotation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Annotation", generator="Immutables")
    static final class Json
    implements Annotation {
        @Nullable
        String path;
        @Nullable
        Optional<String> blobHref = Optional.empty();
        @Nullable
        AnnotationLevel annotationLevel;
        @Nullable
        String message;
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        Optional<String> rawDetails = Optional.empty();
        int startLine;
        boolean startLineIsSet;
        int endLine;
        boolean endLineIsSet;
        @Nullable
        Optional<Integer> startColumn = Optional.empty();
        @Nullable
        Optional<Integer> endColumn = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setPath(String path) {
            this.path = path;
        }

        @JsonProperty
        public void setBlobHref(Optional<String> blobHref) {
            this.blobHref = blobHref;
        }

        @JsonProperty
        public void setAnnotationLevel(AnnotationLevel annotationLevel) {
            this.annotationLevel = annotationLevel;
        }

        @JsonProperty
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty
        public void setRawDetails(Optional<String> rawDetails) {
            this.rawDetails = rawDetails;
        }

        @JsonProperty
        public void setStartLine(int startLine) {
            this.startLine = startLine;
            this.startLineIsSet = true;
        }

        @JsonProperty
        public void setEndLine(int endLine) {
            this.endLine = endLine;
            this.endLineIsSet = true;
        }

        @JsonProperty
        public void setStartColumn(Optional<Integer> startColumn) {
            this.startColumn = startColumn;
        }

        @JsonProperty
        public void setEndColumn(Optional<Integer> endColumn) {
            this.endColumn = endColumn;
        }

        @Override
        public String path() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> blobHref() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AnnotationLevel annotationLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> rawDetails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int startLine() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int endLine() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> startColumn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> endColumn() {
            throw new UnsupportedOperationException();
        }
    }
}

