/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.ReferenceObject;
import com.spotify.github.v3.git.ShaLink;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReferenceObject", generator="Immutables")
@Immutable
public final class ImmutableReferenceObject
implements ReferenceObject {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;
    @Nullable
    private final String type;

    private ImmutableReferenceObject(@Nullable String sha, @Nullable URI url, @Nullable String type) {
        this.sha = sha;
        this.url = url;
        this.type = type;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String type() {
        return this.type;
    }

    public final ImmutableReferenceObject withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableReferenceObject(value, this.url, this.type);
    }

    public final ImmutableReferenceObject withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableReferenceObject(this.sha, value, this.type);
    }

    public final ImmutableReferenceObject withType(@Nullable String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableReferenceObject(this.sha, this.url, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferenceObject && this.equalTo((ImmutableReferenceObject)another);
    }

    private boolean equalTo(ImmutableReferenceObject another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url) && Objects.equals(this.type, another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.type);
        return h;
    }

    public String toString() {
        return "ReferenceObject{sha=" + this.sha + ", url=" + this.url + ", type=" + this.type + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReferenceObject fromJson(Json json) {
        Builder builder = ImmutableReferenceObject.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableReferenceObject copyOf(ReferenceObject instance) {
        if (instance instanceof ImmutableReferenceObject) {
            return (ImmutableReferenceObject)instance;
        }
        return ImmutableReferenceObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReferenceObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;
        @Nullable
        private String type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReferenceObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ShaLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ShaLink instance;
            String typeValue;
            if (object instanceof ReferenceObject && (typeValue = (instance = (ReferenceObject)object).type()) != null) {
                this.type(typeValue);
            }
            if (object instanceof ShaLink) {
                URI urlValue;
                instance = (ShaLink)object;
                String shaValue = instance.sha();
                if (shaValue != null) {
                    this.sha(shaValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public ImmutableReferenceObject build() {
            return new ImmutableReferenceObject(this.sha, this.url, this.type);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReferenceObject", generator="Immutables")
    static final class Json
    implements ReferenceObject {
        @Nullable
        String sha;
        @Nullable
        URI url;
        @Nullable
        String type;

        Json() {
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }
    }
}

