/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.prs.PullRequestRef;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequestRef", generator="Immutables")
@Immutable
public final class ImmutablePullRequestRef
implements PullRequestRef {
    @Nullable
    private final String label;
    @Nullable
    private final String ref;
    @Nullable
    private final String sha;
    @Nullable
    private final User user;
    @Nullable
    private final Repository repo;

    private ImmutablePullRequestRef(@Nullable String label, @Nullable String ref, @Nullable String sha, @Nullable User user, @Nullable Repository repo) {
        this.label = label;
        this.ref = ref;
        this.sha = sha;
        this.user = user;
        this.repo = repo;
    }

    @Override
    @JsonProperty
    public Optional<String> label() {
        return Optional.ofNullable(this.label);
    }

    @Override
    @JsonProperty
    @Nullable
    public String ref() {
        return this.ref;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    public Optional<User> user() {
        return Optional.ofNullable(this.user);
    }

    @Override
    @JsonProperty
    public Optional<Repository> repo() {
        return Optional.ofNullable(this.repo);
    }

    public final ImmutablePullRequestRef withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (Objects.equals(this.label, newValue)) {
            return this;
        }
        return new ImmutablePullRequestRef(newValue, this.ref, this.sha, this.user, this.repo);
    }

    public final ImmutablePullRequestRef withLabel(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.label, value)) {
            return this;
        }
        return new ImmutablePullRequestRef(value, this.ref, this.sha, this.user, this.repo);
    }

    public final ImmutablePullRequestRef withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutablePullRequestRef(this.label, value, this.sha, this.user, this.repo);
    }

    public final ImmutablePullRequestRef withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutablePullRequestRef(this.label, this.ref, value, this.user, this.repo);
    }

    public final ImmutablePullRequestRef withUser(User value) {
        User newValue = Objects.requireNonNull(value, "user");
        if (this.user == newValue) {
            return this;
        }
        return new ImmutablePullRequestRef(this.label, this.ref, this.sha, newValue, this.repo);
    }

    public final ImmutablePullRequestRef withUser(Optional<? extends User> optional) {
        User value = optional.orElse(null);
        if (this.user == value) {
            return this;
        }
        return new ImmutablePullRequestRef(this.label, this.ref, this.sha, value, this.repo);
    }

    public final ImmutablePullRequestRef withRepo(Repository value) {
        Repository newValue = Objects.requireNonNull(value, "repo");
        if (this.repo == newValue) {
            return this;
        }
        return new ImmutablePullRequestRef(this.label, this.ref, this.sha, this.user, newValue);
    }

    public final ImmutablePullRequestRef withRepo(Optional<? extends Repository> optional) {
        Repository value = optional.orElse(null);
        if (this.repo == value) {
            return this;
        }
        return new ImmutablePullRequestRef(this.label, this.ref, this.sha, this.user, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequestRef && this.equalTo((ImmutablePullRequestRef)another);
    }

    private boolean equalTo(ImmutablePullRequestRef another) {
        return Objects.equals(this.label, another.label) && Objects.equals(this.ref, another.ref) && Objects.equals(this.sha, another.sha) && Objects.equals(this.user, another.user) && Objects.equals(this.repo, another.repo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.label);
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.repo);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PullRequestRef{");
        if (this.label != null) {
            builder.append("label=").append(this.label);
        }
        if (this.ref != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("ref=").append(this.ref);
        }
        if (this.sha != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("sha=").append(this.sha);
        }
        if (this.user != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("user=").append(this.user);
        }
        if (this.repo != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("repo=").append(this.repo);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequestRef fromJson(Json json) {
        Builder builder = ImmutablePullRequestRef.builder();
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.ref != null) {
            builder.ref(json.ref);
        }
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.repo != null) {
            builder.repo(json.repo);
        }
        return builder.build();
    }

    public static ImmutablePullRequestRef copyOf(PullRequestRef instance) {
        if (instance instanceof ImmutablePullRequestRef) {
            return (ImmutablePullRequestRef)instance;
        }
        return ImmutablePullRequestRef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PullRequestRef", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String label;
        @Nullable
        private String ref;
        @Nullable
        private String sha;
        @Nullable
        private User user;
        @Nullable
        private Repository repo;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestRef instance) {
            Optional<Repository> repoOptional;
            Optional<User> userOptional;
            String shaValue;
            String refValue;
            Objects.requireNonNull(instance, "instance");
            Optional<String> labelOptional = instance.label();
            if (labelOptional.isPresent()) {
                this.label(labelOptional);
            }
            if ((refValue = instance.ref()) != null) {
                this.ref(refValue);
            }
            if ((shaValue = instance.sha()) != null) {
                this.sha(shaValue);
            }
            if ((userOptional = instance.user()).isPresent()) {
                this.user(userOptional);
            }
            if ((repoOptional = instance.repo()).isPresent()) {
                this.repo(repoOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder label(Optional<String> label) {
            this.label = label.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder user(User user) {
            this.user = Objects.requireNonNull(user, "user");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder user(Optional<? extends User> user) {
            this.user = user.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(Repository repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repo(Optional<? extends Repository> repo) {
            this.repo = repo.orElse(null);
            return this;
        }

        public ImmutablePullRequestRef build() {
            return new ImmutablePullRequestRef(this.label, this.ref, this.sha, this.user, this.repo);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequestRef", generator="Immutables")
    static final class Json
    implements PullRequestRef {
        @Nullable
        Optional<String> label = Optional.empty();
        @Nullable
        String ref;
        @Nullable
        String sha;
        @Nullable
        Optional<User> user = Optional.empty();
        @Nullable
        Optional<Repository> repo = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setLabel(Optional<String> label) {
            this.label = label;
        }

        @JsonProperty
        public void setRef(@Nullable String ref) {
            this.ref = ref;
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUser(Optional<User> user) {
            this.user = user;
        }

        @JsonProperty
        public void setRepo(Optional<Repository> repo) {
            this.repo = repo;
        }

        @Override
        public Optional<String> label() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ref() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<User> user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Repository> repo() {
            throw new UnsupportedOperationException();
        }
    }
}

