/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.prs.RequestReviewParameters;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RequestReviewParameters", generator="Immutables")
@Immutable
public final class ImmutableRequestReviewParameters
extends RequestReviewParameters {
    @Nullable
    private final List<String> reviewers;
    @Nullable
    private final List<String> teamReviewers;

    private ImmutableRequestReviewParameters(@Nullable List<String> reviewers, @Nullable List<String> teamReviewers) {
        this.reviewers = reviewers;
        this.teamReviewers = teamReviewers;
    }

    @Override
    @JsonProperty
    public Optional<List<String>> reviewers() {
        return Optional.ofNullable(this.reviewers);
    }

    @Override
    @JsonProperty(value="team_reviewers")
    public Optional<List<String>> teamReviewers() {
        return Optional.ofNullable(this.teamReviewers);
    }

    public final ImmutableRequestReviewParameters withReviewers(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "reviewers");
        if (this.reviewers == newValue) {
            return this;
        }
        return new ImmutableRequestReviewParameters(newValue, this.teamReviewers);
    }

    public final ImmutableRequestReviewParameters withReviewers(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.reviewers == value) {
            return this;
        }
        return new ImmutableRequestReviewParameters(value, this.teamReviewers);
    }

    public final ImmutableRequestReviewParameters withTeamReviewers(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "teamReviewers");
        if (this.teamReviewers == newValue) {
            return this;
        }
        return new ImmutableRequestReviewParameters(this.reviewers, newValue);
    }

    public final ImmutableRequestReviewParameters withTeamReviewers(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.teamReviewers == value) {
            return this;
        }
        return new ImmutableRequestReviewParameters(this.reviewers, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequestReviewParameters && this.equalTo((ImmutableRequestReviewParameters)another);
    }

    private boolean equalTo(ImmutableRequestReviewParameters another) {
        return Objects.equals(this.reviewers, another.reviewers) && Objects.equals(this.teamReviewers, another.teamReviewers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reviewers);
        h += (h << 5) + Objects.hashCode(this.teamReviewers);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RequestReviewParameters{");
        if (this.reviewers != null) {
            builder.append("reviewers=").append(this.reviewers);
        }
        if (this.teamReviewers != null) {
            if (builder.length() > 24) {
                builder.append(", ");
            }
            builder.append("teamReviewers=").append(this.teamReviewers);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRequestReviewParameters fromJson(Json json) {
        Builder builder = ImmutableRequestReviewParameters.builder();
        if (json.reviewers != null) {
            builder.reviewers(json.reviewers);
        }
        if (json.teamReviewers != null) {
            builder.teamReviewers(json.teamReviewers);
        }
        return builder.build();
    }

    public static ImmutableRequestReviewParameters copyOf(RequestReviewParameters instance) {
        if (instance instanceof ImmutableRequestReviewParameters) {
            return (ImmutableRequestReviewParameters)instance;
        }
        return ImmutableRequestReviewParameters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RequestReviewParameters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private List<String> reviewers;
        @Nullable
        private List<String> teamReviewers;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RequestReviewParameters instance) {
            Optional<List<String>> teamReviewersOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<List<String>> reviewersOptional = instance.reviewers();
            if (reviewersOptional.isPresent()) {
                this.reviewers(reviewersOptional);
            }
            if ((teamReviewersOptional = instance.teamReviewers()).isPresent()) {
                this.teamReviewers(teamReviewersOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reviewers(List<String> reviewers) {
            this.reviewers = Objects.requireNonNull(reviewers, "reviewers");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder reviewers(Optional<? extends List<String>> reviewers) {
            this.reviewers = reviewers.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder teamReviewers(List<String> teamReviewers) {
            this.teamReviewers = Objects.requireNonNull(teamReviewers, "teamReviewers");
            return this;
        }

        @JsonProperty(value="team_reviewers")
        @CanIgnoreReturnValue
        public final Builder teamReviewers(Optional<? extends List<String>> teamReviewers) {
            this.teamReviewers = teamReviewers.orElse(null);
            return this;
        }

        public ImmutableRequestReviewParameters build() {
            return new ImmutableRequestReviewParameters(this.reviewers, this.teamReviewers);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RequestReviewParameters", generator="Immutables")
    static final class Json
    extends RequestReviewParameters {
        @Nullable
        Optional<List<String>> reviewers = Optional.empty();
        @Nullable
        Optional<List<String>> teamReviewers = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setReviewers(Optional<List<String>> reviewers) {
            this.reviewers = reviewers;
        }

        @JsonProperty(value="team_reviewers")
        public void setTeamReviewers(Optional<List<String>> teamReviewers) {
            this.teamReviewers = teamReviewers;
        }

        @Override
        public Optional<List<String>> reviewers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> teamReviewers() {
            throw new UnsupportedOperationException();
        }
    }
}

