/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.prs.requests.PullRequestParameters;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequestParameters", generator="Immutables")
@Immutable
public final class ImmutablePullRequestParameters
implements PullRequestParameters {
    @Nullable
    private final String state;
    @Nullable
    private final String head;
    @Nullable
    private final String base;
    @Nullable
    private final String sort;
    @Nullable
    private final String direction;

    private ImmutablePullRequestParameters(@Nullable String state, @Nullable String head, @Nullable String base, @Nullable String sort, @Nullable String direction) {
        this.state = state;
        this.head = head;
        this.base = base;
        this.sort = sort;
        this.direction = direction;
    }

    @Override
    @JsonProperty
    public Optional<String> state() {
        return Optional.ofNullable(this.state);
    }

    @Override
    @JsonProperty
    public Optional<String> head() {
        return Optional.ofNullable(this.head);
    }

    @Override
    @JsonProperty
    public Optional<String> base() {
        return Optional.ofNullable(this.base);
    }

    @Override
    @JsonProperty
    public Optional<String> sort() {
        return Optional.ofNullable(this.sort);
    }

    @Override
    @JsonProperty
    public Optional<String> direction() {
        return Optional.ofNullable(this.direction);
    }

    public final ImmutablePullRequestParameters withState(String value) {
        String newValue = Objects.requireNonNull(value, "state");
        if (Objects.equals(this.state, newValue)) {
            return this;
        }
        return new ImmutablePullRequestParameters(newValue, this.head, this.base, this.sort, this.direction);
    }

    public final ImmutablePullRequestParameters withState(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutablePullRequestParameters(value, this.head, this.base, this.sort, this.direction);
    }

    public final ImmutablePullRequestParameters withHead(String value) {
        String newValue = Objects.requireNonNull(value, "head");
        if (Objects.equals(this.head, newValue)) {
            return this;
        }
        return new ImmutablePullRequestParameters(this.state, newValue, this.base, this.sort, this.direction);
    }

    public final ImmutablePullRequestParameters withHead(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.head, value)) {
            return this;
        }
        return new ImmutablePullRequestParameters(this.state, value, this.base, this.sort, this.direction);
    }

    public final ImmutablePullRequestParameters withBase(String value) {
        String newValue = Objects.requireNonNull(value, "base");
        if (Objects.equals(this.base, newValue)) {
            return this;
        }
        return new ImmutablePullRequestParameters(this.state, this.head, newValue, this.sort, this.direction);
    }

    public final ImmutablePullRequestParameters withBase(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.base, value)) {
            return this;
        }
        return new ImmutablePullRequestParameters(this.state, this.head, value, this.sort, this.direction);
    }

    public final ImmutablePullRequestParameters withSort(String value) {
        String newValue = Objects.requireNonNull(value, "sort");
        if (Objects.equals(this.sort, newValue)) {
            return this;
        }
        return new ImmutablePullRequestParameters(this.state, this.head, this.base, newValue, this.direction);
    }

    public final ImmutablePullRequestParameters withSort(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sort, value)) {
            return this;
        }
        return new ImmutablePullRequestParameters(this.state, this.head, this.base, value, this.direction);
    }

    public final ImmutablePullRequestParameters withDirection(String value) {
        String newValue = Objects.requireNonNull(value, "direction");
        if (Objects.equals(this.direction, newValue)) {
            return this;
        }
        return new ImmutablePullRequestParameters(this.state, this.head, this.base, this.sort, newValue);
    }

    public final ImmutablePullRequestParameters withDirection(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.direction, value)) {
            return this;
        }
        return new ImmutablePullRequestParameters(this.state, this.head, this.base, this.sort, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequestParameters && this.equalTo((ImmutablePullRequestParameters)another);
    }

    private boolean equalTo(ImmutablePullRequestParameters another) {
        return Objects.equals(this.state, another.state) && Objects.equals(this.head, another.head) && Objects.equals(this.base, another.base) && Objects.equals(this.sort, another.sort) && Objects.equals(this.direction, another.direction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.head);
        h += (h << 5) + Objects.hashCode(this.base);
        h += (h << 5) + Objects.hashCode(this.sort);
        h += (h << 5) + Objects.hashCode(this.direction);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PullRequestParameters{");
        if (this.state != null) {
            builder.append("state=").append(this.state);
        }
        if (this.head != null) {
            if (builder.length() > 22) {
                builder.append(", ");
            }
            builder.append("head=").append(this.head);
        }
        if (this.base != null) {
            if (builder.length() > 22) {
                builder.append(", ");
            }
            builder.append("base=").append(this.base);
        }
        if (this.sort != null) {
            if (builder.length() > 22) {
                builder.append(", ");
            }
            builder.append("sort=").append(this.sort);
        }
        if (this.direction != null) {
            if (builder.length() > 22) {
                builder.append(", ");
            }
            builder.append("direction=").append(this.direction);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequestParameters fromJson(Json json) {
        Builder builder = ImmutablePullRequestParameters.builder();
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.head != null) {
            builder.head(json.head);
        }
        if (json.base != null) {
            builder.base(json.base);
        }
        if (json.sort != null) {
            builder.sort(json.sort);
        }
        if (json.direction != null) {
            builder.direction(json.direction);
        }
        return builder.build();
    }

    public static ImmutablePullRequestParameters copyOf(PullRequestParameters instance) {
        if (instance instanceof ImmutablePullRequestParameters) {
            return (ImmutablePullRequestParameters)instance;
        }
        return ImmutablePullRequestParameters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PullRequestParameters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String state;
        @Nullable
        private String head;
        @Nullable
        private String base;
        @Nullable
        private String sort;
        @Nullable
        private String direction;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestParameters instance) {
            Optional<String> directionOptional;
            Optional<String> sortOptional;
            Optional<String> baseOptional;
            Optional<String> headOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> stateOptional = instance.state();
            if (stateOptional.isPresent()) {
                this.state(stateOptional);
            }
            if ((headOptional = instance.head()).isPresent()) {
                this.head(headOptional);
            }
            if ((baseOptional = instance.base()).isPresent()) {
                this.base(baseOptional);
            }
            if ((sortOptional = instance.sort()).isPresent()) {
                this.sort(sortOptional);
            }
            if ((directionOptional = instance.direction()).isPresent()) {
                this.direction(directionOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder state(String state) {
            this.state = Objects.requireNonNull(state, "state");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(Optional<String> state) {
            this.state = state.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder head(String head) {
            this.head = Objects.requireNonNull(head, "head");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder head(Optional<String> head) {
            this.head = head.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder base(String base) {
            this.base = Objects.requireNonNull(base, "base");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder base(Optional<String> base) {
            this.base = base.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sort(String sort) {
            this.sort = Objects.requireNonNull(sort, "sort");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sort(Optional<String> sort) {
            this.sort = sort.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder direction(String direction) {
            this.direction = Objects.requireNonNull(direction, "direction");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder direction(Optional<String> direction) {
            this.direction = direction.orElse(null);
            return this;
        }

        public ImmutablePullRequestParameters build() {
            return new ImmutablePullRequestParameters(this.state, this.head, this.base, this.sort, this.direction);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequestParameters", generator="Immutables")
    static final class Json
    implements PullRequestParameters {
        @Nullable
        Optional<String> state = Optional.empty();
        @Nullable
        Optional<String> head = Optional.empty();
        @Nullable
        Optional<String> base = Optional.empty();
        @Nullable
        Optional<String> sort = Optional.empty();
        @Nullable
        Optional<String> direction = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setState(Optional<String> state) {
            this.state = state;
        }

        @JsonProperty
        public void setHead(Optional<String> head) {
            this.head = head;
        }

        @JsonProperty
        public void setBase(Optional<String> base) {
            this.base = base;
        }

        @JsonProperty
        public void setSort(Optional<String> sort) {
            this.sort = sort;
        }

        @JsonProperty
        public void setDirection(Optional<String> direction) {
            this.direction = direction;
        }

        @Override
        public Optional<String> state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> head() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> base() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> sort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> direction() {
            throw new UnsupportedOperationException();
        }
    }
}

