/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.File;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="File", generator="Immutables")
@Immutable
public final class ImmutableFile
implements File {
    @Nullable
    private final String filename;
    @Nullable
    private final Integer additions;
    @Nullable
    private final Integer deletions;
    @Nullable
    private final Integer changes;
    @Nullable
    private final String status;
    @Nullable
    private final URI rawUrl;
    @Nullable
    private final URI blobUrl;
    @Nullable
    private final String patch;
    @Nullable
    private final String sha;
    @Nullable
    private final URI contentsUrl;

    private ImmutableFile(@Nullable String filename, @Nullable Integer additions, @Nullable Integer deletions, @Nullable Integer changes, @Nullable String status, @Nullable URI rawUrl, @Nullable URI blobUrl, @Nullable String patch, @Nullable String sha, @Nullable URI contentsUrl) {
        this.filename = filename;
        this.additions = additions;
        this.deletions = deletions;
        this.changes = changes;
        this.status = status;
        this.rawUrl = rawUrl;
        this.blobUrl = blobUrl;
        this.patch = patch;
        this.sha = sha;
        this.contentsUrl = contentsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String filename() {
        return this.filename;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer additions() {
        return this.additions;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer deletions() {
        return this.deletions;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer changes() {
        return this.changes;
    }

    @Override
    @JsonProperty
    @Nullable
    public String status() {
        return this.status;
    }

    @Override
    @JsonProperty
    public Optional<URI> rawUrl() {
        return Optional.ofNullable(this.rawUrl);
    }

    @Override
    @JsonProperty
    public Optional<URI> blobUrl() {
        return Optional.ofNullable(this.blobUrl);
    }

    @Override
    @JsonProperty
    public Optional<String> patch() {
        return Optional.ofNullable(this.patch);
    }

    @Override
    @JsonProperty
    public Optional<String> sha() {
        return Optional.ofNullable(this.sha);
    }

    @Override
    @JsonProperty
    public Optional<URI> contentsUrl() {
        return Optional.ofNullable(this.contentsUrl);
    }

    public final ImmutableFile withFilename(@Nullable String value) {
        if (Objects.equals(this.filename, value)) {
            return this;
        }
        return new ImmutableFile(value, this.additions, this.deletions, this.changes, this.status, this.rawUrl, this.blobUrl, this.patch, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withAdditions(@Nullable Integer value) {
        if (Objects.equals(this.additions, value)) {
            return this;
        }
        return new ImmutableFile(this.filename, value, this.deletions, this.changes, this.status, this.rawUrl, this.blobUrl, this.patch, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withDeletions(@Nullable Integer value) {
        if (Objects.equals(this.deletions, value)) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, value, this.changes, this.status, this.rawUrl, this.blobUrl, this.patch, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withChanges(@Nullable Integer value) {
        if (Objects.equals(this.changes, value)) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, value, this.status, this.rawUrl, this.blobUrl, this.patch, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withStatus(@Nullable String value) {
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, value, this.rawUrl, this.blobUrl, this.patch, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withRawUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "rawUrl");
        if (this.rawUrl == newValue) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, newValue, this.blobUrl, this.patch, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withRawUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.rawUrl == value) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, value, this.blobUrl, this.patch, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withBlobUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "blobUrl");
        if (this.blobUrl == newValue) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, this.rawUrl, newValue, this.patch, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withBlobUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.blobUrl == value) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, this.rawUrl, value, this.patch, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withPatch(String value) {
        String newValue = Objects.requireNonNull(value, "patch");
        if (Objects.equals(this.patch, newValue)) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, this.rawUrl, this.blobUrl, newValue, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withPatch(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.patch, value)) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, this.rawUrl, this.blobUrl, value, this.sha, this.contentsUrl);
    }

    public final ImmutableFile withSha(String value) {
        String newValue = Objects.requireNonNull(value, "sha");
        if (Objects.equals(this.sha, newValue)) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, this.rawUrl, this.blobUrl, this.patch, newValue, this.contentsUrl);
    }

    public final ImmutableFile withSha(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, this.rawUrl, this.blobUrl, this.patch, value, this.contentsUrl);
    }

    public final ImmutableFile withContentsUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "contentsUrl");
        if (this.contentsUrl == newValue) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, this.rawUrl, this.blobUrl, this.patch, this.sha, newValue);
    }

    public final ImmutableFile withContentsUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.contentsUrl == value) {
            return this;
        }
        return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, this.rawUrl, this.blobUrl, this.patch, this.sha, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFile && this.equalTo((ImmutableFile)another);
    }

    private boolean equalTo(ImmutableFile another) {
        return Objects.equals(this.filename, another.filename) && Objects.equals(this.additions, another.additions) && Objects.equals(this.deletions, another.deletions) && Objects.equals(this.changes, another.changes) && Objects.equals(this.status, another.status) && Objects.equals(this.rawUrl, another.rawUrl) && Objects.equals(this.blobUrl, another.blobUrl) && Objects.equals(this.patch, another.patch) && Objects.equals(this.sha, another.sha) && Objects.equals(this.contentsUrl, another.contentsUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.filename);
        h += (h << 5) + Objects.hashCode(this.additions);
        h += (h << 5) + Objects.hashCode(this.deletions);
        h += (h << 5) + Objects.hashCode(this.changes);
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Objects.hashCode(this.rawUrl);
        h += (h << 5) + Objects.hashCode(this.blobUrl);
        h += (h << 5) + Objects.hashCode(this.patch);
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.contentsUrl);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("File{");
        if (this.filename != null) {
            builder.append("filename=").append(this.filename);
        }
        if (this.additions != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("additions=").append(this.additions);
        }
        if (this.deletions != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("deletions=").append(this.deletions);
        }
        if (this.changes != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("changes=").append(this.changes);
        }
        if (this.status != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("status=").append(this.status);
        }
        if (this.rawUrl != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("rawUrl=").append(this.rawUrl);
        }
        if (this.blobUrl != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("blobUrl=").append(this.blobUrl);
        }
        if (this.patch != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("patch=").append(this.patch);
        }
        if (this.sha != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("sha=").append(this.sha);
        }
        if (this.contentsUrl != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("contentsUrl=").append(this.contentsUrl);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFile fromJson(Json json) {
        Builder builder = ImmutableFile.builder();
        if (json.filename != null) {
            builder.filename(json.filename);
        }
        if (json.additions != null) {
            builder.additions(json.additions);
        }
        if (json.deletions != null) {
            builder.deletions(json.deletions);
        }
        if (json.changes != null) {
            builder.changes(json.changes);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.rawUrl != null) {
            builder.rawUrl(json.rawUrl);
        }
        if (json.blobUrl != null) {
            builder.blobUrl(json.blobUrl);
        }
        if (json.patch != null) {
            builder.patch(json.patch);
        }
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.contentsUrl != null) {
            builder.contentsUrl(json.contentsUrl);
        }
        return builder.build();
    }

    public static ImmutableFile copyOf(File instance) {
        if (instance instanceof ImmutableFile) {
            return (ImmutableFile)instance;
        }
        return ImmutableFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="File", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String filename;
        @Nullable
        private Integer additions;
        @Nullable
        private Integer deletions;
        @Nullable
        private Integer changes;
        @Nullable
        private String status;
        @Nullable
        private URI rawUrl;
        @Nullable
        private URI blobUrl;
        @Nullable
        private String patch;
        @Nullable
        private String sha;
        @Nullable
        private URI contentsUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(File instance) {
            Optional<URI> contentsUrlOptional;
            Optional<String> shaOptional;
            Optional<String> patchOptional;
            Optional<URI> blobUrlOptional;
            Optional<URI> rawUrlOptional;
            String statusValue;
            Integer changesValue;
            Integer deletionsValue;
            Integer additionsValue;
            Objects.requireNonNull(instance, "instance");
            String filenameValue = instance.filename();
            if (filenameValue != null) {
                this.filename(filenameValue);
            }
            if ((additionsValue = instance.additions()) != null) {
                this.additions(additionsValue);
            }
            if ((deletionsValue = instance.deletions()) != null) {
                this.deletions(deletionsValue);
            }
            if ((changesValue = instance.changes()) != null) {
                this.changes(changesValue);
            }
            if ((statusValue = instance.status()) != null) {
                this.status(statusValue);
            }
            if ((rawUrlOptional = instance.rawUrl()).isPresent()) {
                this.rawUrl(rawUrlOptional);
            }
            if ((blobUrlOptional = instance.blobUrl()).isPresent()) {
                this.blobUrl(blobUrlOptional);
            }
            if ((patchOptional = instance.patch()).isPresent()) {
                this.patch(patchOptional);
            }
            if ((shaOptional = instance.sha()).isPresent()) {
                this.sha(shaOptional);
            }
            if ((contentsUrlOptional = instance.contentsUrl()).isPresent()) {
                this.contentsUrl(contentsUrlOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder filename(@Nullable String filename) {
            this.filename = filename;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder additions(@Nullable Integer additions) {
            this.additions = additions;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder deletions(@Nullable Integer deletions) {
            this.deletions = deletions;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder changes(@Nullable Integer changes) {
            this.changes = changes;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rawUrl(URI rawUrl) {
            this.rawUrl = Objects.requireNonNull(rawUrl, "rawUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder rawUrl(Optional<? extends URI> rawUrl) {
            this.rawUrl = rawUrl.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blobUrl(URI blobUrl) {
            this.blobUrl = Objects.requireNonNull(blobUrl, "blobUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder blobUrl(Optional<? extends URI> blobUrl) {
            this.blobUrl = blobUrl.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder patch(String patch) {
            this.patch = Objects.requireNonNull(patch, "patch");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder patch(Optional<String> patch) {
            this.patch = patch.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sha(String sha) {
            this.sha = Objects.requireNonNull(sha, "sha");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(Optional<String> sha) {
            this.sha = sha.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentsUrl(URI contentsUrl) {
            this.contentsUrl = Objects.requireNonNull(contentsUrl, "contentsUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder contentsUrl(Optional<? extends URI> contentsUrl) {
            this.contentsUrl = contentsUrl.orElse(null);
            return this;
        }

        public ImmutableFile build() {
            return new ImmutableFile(this.filename, this.additions, this.deletions, this.changes, this.status, this.rawUrl, this.blobUrl, this.patch, this.sha, this.contentsUrl);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="File", generator="Immutables")
    static final class Json
    implements File {
        @Nullable
        String filename;
        @Nullable
        Integer additions;
        @Nullable
        Integer deletions;
        @Nullable
        Integer changes;
        @Nullable
        String status;
        @Nullable
        Optional<URI> rawUrl = Optional.empty();
        @Nullable
        Optional<URI> blobUrl = Optional.empty();
        @Nullable
        Optional<String> patch = Optional.empty();
        @Nullable
        Optional<String> sha = Optional.empty();
        @Nullable
        Optional<URI> contentsUrl = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setFilename(@Nullable String filename) {
            this.filename = filename;
        }

        @JsonProperty
        public void setAdditions(@Nullable Integer additions) {
            this.additions = additions;
        }

        @JsonProperty
        public void setDeletions(@Nullable Integer deletions) {
            this.deletions = deletions;
        }

        @JsonProperty
        public void setChanges(@Nullable Integer changes) {
            this.changes = changes;
        }

        @JsonProperty
        public void setStatus(@Nullable String status) {
            this.status = status;
        }

        @JsonProperty
        public void setRawUrl(Optional<URI> rawUrl) {
            this.rawUrl = rawUrl;
        }

        @JsonProperty
        public void setBlobUrl(Optional<URI> blobUrl) {
            this.blobUrl = blobUrl;
        }

        @JsonProperty
        public void setPatch(Optional<String> patch) {
            this.patch = patch;
        }

        @JsonProperty
        public void setSha(Optional<String> sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setContentsUrl(Optional<URI> contentsUrl) {
            this.contentsUrl = contentsUrl;
        }

        @Override
        public String filename() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer additions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer deletions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer changes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> rawUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> blobUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> patch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> contentsUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

