/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.search.Search;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Search", generator="Immutables")
@Immutable
public final class ImmutableSearch
implements Search {
    @Nullable
    private final Integer totalCount;
    @Nullable
    private final Boolean incompleteResults;

    private ImmutableSearch(@Nullable Integer totalCount, @Nullable Boolean incompleteResults) {
        this.totalCount = totalCount;
        this.incompleteResults = incompleteResults;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer totalCount() {
        return this.totalCount;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean incompleteResults() {
        return this.incompleteResults;
    }

    public final ImmutableSearch withTotalCount(@Nullable Integer value) {
        if (Objects.equals(this.totalCount, value)) {
            return this;
        }
        return new ImmutableSearch(value, this.incompleteResults);
    }

    public final ImmutableSearch withIncompleteResults(@Nullable Boolean value) {
        if (Objects.equals(this.incompleteResults, value)) {
            return this;
        }
        return new ImmutableSearch(this.totalCount, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearch && this.equalTo((ImmutableSearch)another);
    }

    private boolean equalTo(ImmutableSearch another) {
        return Objects.equals(this.totalCount, another.totalCount) && Objects.equals(this.incompleteResults, another.incompleteResults);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.totalCount);
        h += (h << 5) + Objects.hashCode(this.incompleteResults);
        return h;
    }

    public String toString() {
        return "Search{totalCount=" + this.totalCount + ", incompleteResults=" + this.incompleteResults + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSearch fromJson(Json json) {
        Builder builder = ImmutableSearch.builder();
        if (json.totalCount != null) {
            builder.totalCount(json.totalCount);
        }
        if (json.incompleteResults != null) {
            builder.incompleteResults(json.incompleteResults);
        }
        return builder.build();
    }

    public static ImmutableSearch copyOf(Search instance) {
        if (instance instanceof ImmutableSearch) {
            return (ImmutableSearch)instance;
        }
        return ImmutableSearch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Search", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer totalCount;
        @Nullable
        private Boolean incompleteResults;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Search instance) {
            Boolean incompleteResultsValue;
            Objects.requireNonNull(instance, "instance");
            Integer totalCountValue = instance.totalCount();
            if (totalCountValue != null) {
                this.totalCount(totalCountValue);
            }
            if ((incompleteResultsValue = instance.incompleteResults()) != null) {
                this.incompleteResults(incompleteResultsValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder totalCount(@Nullable Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder incompleteResults(@Nullable Boolean incompleteResults) {
            this.incompleteResults = incompleteResults;
            return this;
        }

        public ImmutableSearch build() {
            return new ImmutableSearch(this.totalCount, this.incompleteResults);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Search", generator="Immutables")
    static final class Json
    implements Search {
        @Nullable
        Integer totalCount;
        @Nullable
        Boolean incompleteResults;

        Json() {
        }

        @JsonProperty
        public void setTotalCount(@Nullable Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty
        public void setIncompleteResults(@Nullable Boolean incompleteResults) {
            this.incompleteResults = incompleteResults;
        }

        @Override
        public Integer totalCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean incompleteResults() {
            throw new UnsupportedOperationException();
        }
    }
}

