package com.spotify.github.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Team}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTeam.builder()}.
 */
@Generated(from = "Team", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTeam implements Team {
  private final @Nullable Integer id;
  private final @Nullable String name;
  private final @Nullable String slug;
  private final @Nullable String description;
  private final @Nullable String privacy;
  private final @Nullable String permission;
  private final @Nullable String nodeId;
  private final @Nullable URI url;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI repositoriesUrl;

  private ImmutableTeam(
      @Nullable Integer id,
      @Nullable String name,
      @Nullable String slug,
      @Nullable String description,
      @Nullable String privacy,
      @Nullable String permission,
      @Nullable String nodeId,
      @Nullable URI url,
      @Nullable URI htmlUrl,
      @Nullable URI repositoriesUrl) {
    this.id = id;
    this.name = name;
    this.slug = slug;
    this.description = description;
    this.privacy = privacy;
    this.permission = permission;
    this.nodeId = nodeId;
    this.url = url;
    this.htmlUrl = htmlUrl;
    this.repositoriesUrl = repositoriesUrl;
  }

  /**
   *ID. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *Name. 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *Slug. 
   */
  @JsonProperty
  @Override
  public @Nullable String slug() {
    return slug;
  }

  /**
   *Description 
   */
  @JsonProperty
  @Override
  public @Nullable String description() {
    return description;
  }

  /**
   *Privacy 
   */
  @JsonProperty
  @Override
  public @Nullable String privacy() {
    return privacy;
  }

  /**
   *Permission 
   */
  @JsonProperty
  @Override
  public @Nullable String permission() {
    return permission;
  }

  /**
   *Node ID 
   */
  @JsonProperty
  @Override
  public @Nullable String nodeId() {
    return nodeId;
  }

  /**
   *URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *HTML URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Repositories URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI repositoriesUrl() {
    return repositoriesUrl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableTeam(
        value,
        this.name,
        this.slug,
        this.description,
        this.privacy,
        this.permission,
        this.nodeId,
        this.url,
        this.htmlUrl,
        this.repositoriesUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableTeam(
        this.id,
        value,
        this.slug,
        this.description,
        this.privacy,
        this.permission,
        this.nodeId,
        this.url,
        this.htmlUrl,
        this.repositoriesUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#slug() slug} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slug (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withSlug(@Nullable String value) {
    if (Objects.equals(this.slug, value)) return this;
    return new ImmutableTeam(
        this.id,
        this.name,
        value,
        this.description,
        this.privacy,
        this.permission,
        this.nodeId,
        this.url,
        this.htmlUrl,
        this.repositoriesUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableTeam(
        this.id,
        this.name,
        this.slug,
        value,
        this.privacy,
        this.permission,
        this.nodeId,
        this.url,
        this.htmlUrl,
        this.repositoriesUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#privacy() privacy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for privacy (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withPrivacy(@Nullable String value) {
    if (Objects.equals(this.privacy, value)) return this;
    return new ImmutableTeam(
        this.id,
        this.name,
        this.slug,
        this.description,
        value,
        this.permission,
        this.nodeId,
        this.url,
        this.htmlUrl,
        this.repositoriesUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#permission() permission} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for permission (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withPermission(@Nullable String value) {
    if (Objects.equals(this.permission, value)) return this;
    return new ImmutableTeam(
        this.id,
        this.name,
        this.slug,
        this.description,
        this.privacy,
        value,
        this.nodeId,
        this.url,
        this.htmlUrl,
        this.repositoriesUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#nodeId() nodeId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withNodeId(@Nullable String value) {
    if (Objects.equals(this.nodeId, value)) return this;
    return new ImmutableTeam(
        this.id,
        this.name,
        this.slug,
        this.description,
        this.privacy,
        this.permission,
        value,
        this.url,
        this.htmlUrl,
        this.repositoriesUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableTeam(
        this.id,
        this.name,
        this.slug,
        this.description,
        this.privacy,
        this.permission,
        this.nodeId,
        value,
        this.htmlUrl,
        this.repositoriesUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableTeam(
        this.id,
        this.name,
        this.slug,
        this.description,
        this.privacy,
        this.permission,
        this.nodeId,
        this.url,
        value,
        this.repositoriesUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#repositoriesUrl() repositoriesUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repositoriesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withRepositoriesUrl(@Nullable URI value) {
    if (this.repositoriesUrl == value) return this;
    return new ImmutableTeam(
        this.id,
        this.name,
        this.slug,
        this.description,
        this.privacy,
        this.permission,
        this.nodeId,
        this.url,
        this.htmlUrl,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTeam} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTeam
        && equalTo(0, (ImmutableTeam) another);
  }

  private boolean equalTo(int synthetic, ImmutableTeam another) {
    return Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(slug, another.slug)
        && Objects.equals(description, another.description)
        && Objects.equals(privacy, another.privacy)
        && Objects.equals(permission, another.permission)
        && Objects.equals(nodeId, another.nodeId)
        && Objects.equals(url, another.url)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(repositoriesUrl, another.repositoriesUrl);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code slug}, {@code description}, {@code privacy}, {@code permission}, {@code nodeId}, {@code url}, {@code htmlUrl}, {@code repositoriesUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(slug);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(privacy);
    h += (h << 5) + Objects.hashCode(permission);
    h += (h << 5) + Objects.hashCode(nodeId);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(repositoriesUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code Team} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Team{"
        + "id=" + id
        + ", name=" + name
        + ", slug=" + slug
        + ", description=" + description
        + ", privacy=" + privacy
        + ", permission=" + permission
        + ", nodeId=" + nodeId
        + ", url=" + url
        + ", htmlUrl=" + htmlUrl
        + ", repositoriesUrl=" + repositoriesUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Team", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Team {
    @Nullable Integer id;
    @Nullable String name;
    @Nullable String slug;
    @Nullable String description;
    @Nullable String privacy;
    @Nullable String permission;
    @Nullable String nodeId;
    @Nullable URI url;
    @Nullable URI htmlUrl;
    @Nullable URI repositoriesUrl;
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setSlug(@Nullable String slug) {
      this.slug = slug;
    }
    @JsonProperty
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty
    public void setPrivacy(@Nullable String privacy) {
      this.privacy = privacy;
    }
    @JsonProperty
    public void setPermission(@Nullable String permission) {
      this.permission = permission;
    }
    @JsonProperty
    public void setNodeId(@Nullable String nodeId) {
      this.nodeId = nodeId;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setRepositoriesUrl(@Nullable URI repositoriesUrl) {
      this.repositoriesUrl = repositoriesUrl;
    }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String slug() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
    @Override
    public String privacy() { throw new UnsupportedOperationException(); }
    @Override
    public String permission() { throw new UnsupportedOperationException(); }
    @Override
    public String nodeId() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI repositoriesUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTeam fromJson(Json json) {
    ImmutableTeam.Builder builder = ImmutableTeam.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.slug != null) {
      builder.slug(json.slug);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.privacy != null) {
      builder.privacy(json.privacy);
    }
    if (json.permission != null) {
      builder.permission(json.permission);
    }
    if (json.nodeId != null) {
      builder.nodeId(json.nodeId);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.repositoriesUrl != null) {
      builder.repositoriesUrl(json.repositoriesUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Team} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Team instance
   */
  public static ImmutableTeam copyOf(Team instance) {
    if (instance instanceof ImmutableTeam) {
      return (ImmutableTeam) instance;
    }
    return ImmutableTeam.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTeam ImmutableTeam}.
   * <pre>
   * ImmutableTeam.builder()
   *    .id(Integer | null) // nullable {@link Team#id() id}
   *    .name(String | null) // nullable {@link Team#name() name}
   *    .slug(String | null) // nullable {@link Team#slug() slug}
   *    .description(String | null) // nullable {@link Team#description() description}
   *    .privacy(String | null) // nullable {@link Team#privacy() privacy}
   *    .permission(String | null) // nullable {@link Team#permission() permission}
   *    .nodeId(String | null) // nullable {@link Team#nodeId() nodeId}
   *    .url(java.net.URI | null) // nullable {@link Team#url() url}
   *    .htmlUrl(java.net.URI | null) // nullable {@link Team#htmlUrl() htmlUrl}
   *    .repositoriesUrl(java.net.URI | null) // nullable {@link Team#repositoriesUrl() repositoriesUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableTeam builder
   */
  public static ImmutableTeam.Builder builder() {
    return new ImmutableTeam.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTeam ImmutableTeam}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Team", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer id;
    private @Nullable String name;
    private @Nullable String slug;
    private @Nullable String description;
    private @Nullable String privacy;
    private @Nullable String permission;
    private @Nullable String nodeId;
    private @Nullable URI url;
    private @Nullable URI htmlUrl;
    private @Nullable URI repositoriesUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Team} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Team instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String slugValue = instance.slug();
      if (slugValue != null) {
        slug(slugValue);
      }
      @Nullable String descriptionValue = instance.description();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable String privacyValue = instance.privacy();
      if (privacyValue != null) {
        privacy(privacyValue);
      }
      @Nullable String permissionValue = instance.permission();
      if (permissionValue != null) {
        permission(permissionValue);
      }
      @Nullable String nodeIdValue = instance.nodeId();
      if (nodeIdValue != null) {
        nodeId(nodeIdValue);
      }
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable URI htmlUrlValue = instance.htmlUrl();
      if (htmlUrlValue != null) {
        htmlUrl(htmlUrlValue);
      }
      @Nullable URI repositoriesUrlValue = instance.repositoriesUrl();
      if (repositoriesUrlValue != null) {
        repositoriesUrl(repositoriesUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Team#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Team#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Team#slug() slug} attribute.
     * @param slug The value for slug (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder slug(@Nullable String slug) {
      this.slug = slug;
      return this;
    }

    /**
     * Initializes the value for the {@link Team#description() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Team#privacy() privacy} attribute.
     * @param privacy The value for privacy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder privacy(@Nullable String privacy) {
      this.privacy = privacy;
      return this;
    }

    /**
     * Initializes the value for the {@link Team#permission() permission} attribute.
     * @param permission The value for permission (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder permission(@Nullable String permission) {
      this.permission = permission;
      return this;
    }

    /**
     * Initializes the value for the {@link Team#nodeId() nodeId} attribute.
     * @param nodeId The value for nodeId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder nodeId(@Nullable String nodeId) {
      this.nodeId = nodeId;
      return this;
    }

    /**
     * Initializes the value for the {@link Team#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Team#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Team#repositoriesUrl() repositoriesUrl} attribute.
     * @param repositoriesUrl The value for repositoriesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repositoriesUrl(@Nullable URI repositoriesUrl) {
      this.repositoriesUrl = repositoriesUrl;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTeam ImmutableTeam}.
     * @return An immutable instance of Team
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTeam build() {
      return new ImmutableTeam(id, name, slug, description, privacy, permission, nodeId, url, htmlUrl, repositoriesUrl);
    }
  }
}
