package com.spotify.github.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link User}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUser.builder()}.
 */
@Generated(from = "User", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUser implements User {
  private final @Nullable String login;
  private final @Nullable Integer id;
  private final @Nullable URI avatarUrl;
  private final @Nullable String gravatarId;
  private final @Nullable URI url;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI followersUrl;
  private final @Nullable String followingUrl;
  private final @Nullable String gistsUrl;
  private final @Nullable String starredUrl;
  private final @Nullable URI subscriptionsUrl;
  private final @Nullable URI organizationsUrl;
  private final @Nullable URI reposUrl;
  private final @Nullable String eventsUrl;
  private final @Nullable URI receivedEventsUrl;
  private final @Nullable String type;
  private final @Nullable Boolean siteAdmin;

  private ImmutableUser(
      @Nullable String login,
      @Nullable Integer id,
      @Nullable URI avatarUrl,
      @Nullable String gravatarId,
      @Nullable URI url,
      @Nullable URI htmlUrl,
      @Nullable URI followersUrl,
      @Nullable String followingUrl,
      @Nullable String gistsUrl,
      @Nullable String starredUrl,
      @Nullable URI subscriptionsUrl,
      @Nullable URI organizationsUrl,
      @Nullable URI reposUrl,
      @Nullable String eventsUrl,
      @Nullable URI receivedEventsUrl,
      @Nullable String type,
      @Nullable Boolean siteAdmin) {
    this.login = login;
    this.id = id;
    this.avatarUrl = avatarUrl;
    this.gravatarId = gravatarId;
    this.url = url;
    this.htmlUrl = htmlUrl;
    this.followersUrl = followersUrl;
    this.followingUrl = followingUrl;
    this.gistsUrl = gistsUrl;
    this.starredUrl = starredUrl;
    this.subscriptionsUrl = subscriptionsUrl;
    this.organizationsUrl = organizationsUrl;
    this.reposUrl = reposUrl;
    this.eventsUrl = eventsUrl;
    this.receivedEventsUrl = receivedEventsUrl;
    this.type = type;
    this.siteAdmin = siteAdmin;
  }

  /**
   *Login name. 
   */
  @JsonProperty
  @Override
  public @Nullable String login() {
    return login;
  }

  /**
   *ID. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *Avatar URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI avatarUrl() {
    return avatarUrl;
  }

  /**
   *Gravatar ID. 
   */
  @JsonProperty
  @Override
  public Optional<String> gravatarId() {
    return Optional.ofNullable(gravatarId);
  }

  /**
   *User resource API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *User resource URL returning HTML. 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Followers URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI followersUrl() {
    return followersUrl;
  }

  /**
   *Following URL template. 
   */
  @JsonProperty
  @Override
  public @Nullable String followingUrl() {
    return followingUrl;
  }

  /**
   *Gists URL template. 
   */
  @JsonProperty
  @Override
  public @Nullable String gistsUrl() {
    return gistsUrl;
  }

  /**
   *Starred URL template. 
   */
  @JsonProperty
  @Override
  public @Nullable String starredUrl() {
    return starredUrl;
  }

  /**
   *Subscriptions URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI subscriptionsUrl() {
    return subscriptionsUrl;
  }

  /**
   *Organizations URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI organizationsUrl() {
    return organizationsUrl;
  }

  /**
   *Repositories URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI reposUrl() {
    return reposUrl;
  }

  /**
   *Events URL template. 
   */
  @JsonProperty
  @Override
  public @Nullable String eventsUrl() {
    return eventsUrl;
  }

  /**
   *Received event URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI receivedEventsUrl() {
    return receivedEventsUrl;
  }

  /**
   *User type. 
   */
  @JsonProperty
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   *Is user a site admin. 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> siteAdmin() {
    return Optional.ofNullable(siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#login() login} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for login (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withLogin(@Nullable String value) {
    if (Objects.equals(this.login, value)) return this;
    return new ImmutableUser(
        value,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableUser(
        this.login,
        value,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#avatarUrl() avatarUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for avatarUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withAvatarUrl(@Nullable URI value) {
    if (this.avatarUrl == value) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        value,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link User#gravatarId() gravatarId} attribute.
   * @param value The value for gravatarId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withGravatarId(String value) {
    String newValue = Objects.requireNonNull(value, "gravatarId");
    if (Objects.equals(this.gravatarId, newValue)) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        newValue,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link User#gravatarId() gravatarId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for gravatarId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withGravatarId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.gravatarId, value)) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        value,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        value,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        value,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#followersUrl() followersUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for followersUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withFollowersUrl(@Nullable URI value) {
    if (this.followersUrl == value) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        value,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#followingUrl() followingUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for followingUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withFollowingUrl(@Nullable String value) {
    if (Objects.equals(this.followingUrl, value)) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        value,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#gistsUrl() gistsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gistsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withGistsUrl(@Nullable String value) {
    if (Objects.equals(this.gistsUrl, value)) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        value,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#starredUrl() starredUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for starredUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withStarredUrl(@Nullable String value) {
    if (Objects.equals(this.starredUrl, value)) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        value,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#subscriptionsUrl() subscriptionsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for subscriptionsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withSubscriptionsUrl(@Nullable URI value) {
    if (this.subscriptionsUrl == value) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        value,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#organizationsUrl() organizationsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for organizationsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withOrganizationsUrl(@Nullable URI value) {
    if (this.organizationsUrl == value) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        value,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#reposUrl() reposUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reposUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withReposUrl(@Nullable URI value) {
    if (this.reposUrl == value) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        value,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#eventsUrl() eventsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withEventsUrl(@Nullable String value) {
    if (Objects.equals(this.eventsUrl, value)) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        value,
        this.receivedEventsUrl,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#receivedEventsUrl() receivedEventsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for receivedEventsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withReceivedEventsUrl(@Nullable URI value) {
    if (this.receivedEventsUrl == value) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        value,
        this.type,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link User#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        value,
        this.siteAdmin);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link User#siteAdmin() siteAdmin} attribute.
   * @param value The value for siteAdmin
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withSiteAdmin(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.siteAdmin, newValue)) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link User#siteAdmin() siteAdmin} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for siteAdmin
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withSiteAdmin(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.siteAdmin, value)) return this;
    return new ImmutableUser(
        this.login,
        this.id,
        this.avatarUrl,
        this.gravatarId,
        this.url,
        this.htmlUrl,
        this.followersUrl,
        this.followingUrl,
        this.gistsUrl,
        this.starredUrl,
        this.subscriptionsUrl,
        this.organizationsUrl,
        this.reposUrl,
        this.eventsUrl,
        this.receivedEventsUrl,
        this.type,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUser
        && equalTo(0, (ImmutableUser) another);
  }

  private boolean equalTo(int synthetic, ImmutableUser another) {
    return Objects.equals(login, another.login)
        && Objects.equals(id, another.id)
        && Objects.equals(avatarUrl, another.avatarUrl)
        && Objects.equals(gravatarId, another.gravatarId)
        && Objects.equals(url, another.url)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(followersUrl, another.followersUrl)
        && Objects.equals(followingUrl, another.followingUrl)
        && Objects.equals(gistsUrl, another.gistsUrl)
        && Objects.equals(starredUrl, another.starredUrl)
        && Objects.equals(subscriptionsUrl, another.subscriptionsUrl)
        && Objects.equals(organizationsUrl, another.organizationsUrl)
        && Objects.equals(reposUrl, another.reposUrl)
        && Objects.equals(eventsUrl, another.eventsUrl)
        && Objects.equals(receivedEventsUrl, another.receivedEventsUrl)
        && Objects.equals(type, another.type)
        && Objects.equals(siteAdmin, another.siteAdmin);
  }

  /**
   * Computes a hash code from attributes: {@code login}, {@code id}, {@code avatarUrl}, {@code gravatarId}, {@code url}, {@code htmlUrl}, {@code followersUrl}, {@code followingUrl}, {@code gistsUrl}, {@code starredUrl}, {@code subscriptionsUrl}, {@code organizationsUrl}, {@code reposUrl}, {@code eventsUrl}, {@code receivedEventsUrl}, {@code type}, {@code siteAdmin}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(login);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(avatarUrl);
    h += (h << 5) + Objects.hashCode(gravatarId);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(followersUrl);
    h += (h << 5) + Objects.hashCode(followingUrl);
    h += (h << 5) + Objects.hashCode(gistsUrl);
    h += (h << 5) + Objects.hashCode(starredUrl);
    h += (h << 5) + Objects.hashCode(subscriptionsUrl);
    h += (h << 5) + Objects.hashCode(organizationsUrl);
    h += (h << 5) + Objects.hashCode(reposUrl);
    h += (h << 5) + Objects.hashCode(eventsUrl);
    h += (h << 5) + Objects.hashCode(receivedEventsUrl);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(siteAdmin);
    return h;
  }

  /**
   * Prints the immutable value {@code User} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("User{");
    if (login != null) {
      builder.append("login=").append(login);
    }
    if (id != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("id=").append(id);
    }
    if (avatarUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("avatarUrl=").append(avatarUrl);
    }
    if (gravatarId != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("gravatarId=").append(gravatarId);
    }
    if (url != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (htmlUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    if (followersUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("followersUrl=").append(followersUrl);
    }
    if (followingUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("followingUrl=").append(followingUrl);
    }
    if (gistsUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("gistsUrl=").append(gistsUrl);
    }
    if (starredUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("starredUrl=").append(starredUrl);
    }
    if (subscriptionsUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("subscriptionsUrl=").append(subscriptionsUrl);
    }
    if (organizationsUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("organizationsUrl=").append(organizationsUrl);
    }
    if (reposUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("reposUrl=").append(reposUrl);
    }
    if (eventsUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("eventsUrl=").append(eventsUrl);
    }
    if (receivedEventsUrl != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("receivedEventsUrl=").append(receivedEventsUrl);
    }
    if (type != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("type=").append(type);
    }
    if (siteAdmin != null) {
      if (builder.length() > 5) builder.append(", ");
      builder.append("siteAdmin=").append(siteAdmin);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "User", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements User {
    @Nullable String login;
    @Nullable Integer id;
    @Nullable URI avatarUrl;
    @Nullable Optional<String> gravatarId = Optional.empty();
    @Nullable URI url;
    @Nullable URI htmlUrl;
    @Nullable URI followersUrl;
    @Nullable String followingUrl;
    @Nullable String gistsUrl;
    @Nullable String starredUrl;
    @Nullable URI subscriptionsUrl;
    @Nullable URI organizationsUrl;
    @Nullable URI reposUrl;
    @Nullable String eventsUrl;
    @Nullable URI receivedEventsUrl;
    @Nullable String type;
    @Nullable Optional<Boolean> siteAdmin = Optional.empty();
    @JsonProperty
    public void setLogin(@Nullable String login) {
      this.login = login;
    }
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setAvatarUrl(@Nullable URI avatarUrl) {
      this.avatarUrl = avatarUrl;
    }
    @JsonProperty
    public void setGravatarId(Optional<String> gravatarId) {
      this.gravatarId = gravatarId;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setFollowersUrl(@Nullable URI followersUrl) {
      this.followersUrl = followersUrl;
    }
    @JsonProperty
    public void setFollowingUrl(@Nullable String followingUrl) {
      this.followingUrl = followingUrl;
    }
    @JsonProperty
    public void setGistsUrl(@Nullable String gistsUrl) {
      this.gistsUrl = gistsUrl;
    }
    @JsonProperty
    public void setStarredUrl(@Nullable String starredUrl) {
      this.starredUrl = starredUrl;
    }
    @JsonProperty
    public void setSubscriptionsUrl(@Nullable URI subscriptionsUrl) {
      this.subscriptionsUrl = subscriptionsUrl;
    }
    @JsonProperty
    public void setOrganizationsUrl(@Nullable URI organizationsUrl) {
      this.organizationsUrl = organizationsUrl;
    }
    @JsonProperty
    public void setReposUrl(@Nullable URI reposUrl) {
      this.reposUrl = reposUrl;
    }
    @JsonProperty
    public void setEventsUrl(@Nullable String eventsUrl) {
      this.eventsUrl = eventsUrl;
    }
    @JsonProperty
    public void setReceivedEventsUrl(@Nullable URI receivedEventsUrl) {
      this.receivedEventsUrl = receivedEventsUrl;
    }
    @JsonProperty
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty
    public void setSiteAdmin(Optional<Boolean> siteAdmin) {
      this.siteAdmin = siteAdmin;
    }
    @Override
    public String login() { throw new UnsupportedOperationException(); }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public URI avatarUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> gravatarId() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI followersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String followingUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String gistsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String starredUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI subscriptionsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI organizationsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI reposUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String eventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI receivedEventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> siteAdmin() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUser fromJson(Json json) {
    ImmutableUser.Builder builder = ImmutableUser.builder();
    if (json.login != null) {
      builder.login(json.login);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.avatarUrl != null) {
      builder.avatarUrl(json.avatarUrl);
    }
    if (json.gravatarId != null) {
      builder.gravatarId(json.gravatarId);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.followersUrl != null) {
      builder.followersUrl(json.followersUrl);
    }
    if (json.followingUrl != null) {
      builder.followingUrl(json.followingUrl);
    }
    if (json.gistsUrl != null) {
      builder.gistsUrl(json.gistsUrl);
    }
    if (json.starredUrl != null) {
      builder.starredUrl(json.starredUrl);
    }
    if (json.subscriptionsUrl != null) {
      builder.subscriptionsUrl(json.subscriptionsUrl);
    }
    if (json.organizationsUrl != null) {
      builder.organizationsUrl(json.organizationsUrl);
    }
    if (json.reposUrl != null) {
      builder.reposUrl(json.reposUrl);
    }
    if (json.eventsUrl != null) {
      builder.eventsUrl(json.eventsUrl);
    }
    if (json.receivedEventsUrl != null) {
      builder.receivedEventsUrl(json.receivedEventsUrl);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.siteAdmin != null) {
      builder.siteAdmin(json.siteAdmin);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link User} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable User instance
   */
  public static ImmutableUser copyOf(User instance) {
    if (instance instanceof ImmutableUser) {
      return (ImmutableUser) instance;
    }
    return ImmutableUser.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUser ImmutableUser}.
   * <pre>
   * ImmutableUser.builder()
   *    .login(String | null) // nullable {@link User#login() login}
   *    .id(Integer | null) // nullable {@link User#id() id}
   *    .avatarUrl(java.net.URI | null) // nullable {@link User#avatarUrl() avatarUrl}
   *    .gravatarId(String) // optional {@link User#gravatarId() gravatarId}
   *    .url(java.net.URI | null) // nullable {@link User#url() url}
   *    .htmlUrl(java.net.URI | null) // nullable {@link User#htmlUrl() htmlUrl}
   *    .followersUrl(java.net.URI | null) // nullable {@link User#followersUrl() followersUrl}
   *    .followingUrl(String | null) // nullable {@link User#followingUrl() followingUrl}
   *    .gistsUrl(String | null) // nullable {@link User#gistsUrl() gistsUrl}
   *    .starredUrl(String | null) // nullable {@link User#starredUrl() starredUrl}
   *    .subscriptionsUrl(java.net.URI | null) // nullable {@link User#subscriptionsUrl() subscriptionsUrl}
   *    .organizationsUrl(java.net.URI | null) // nullable {@link User#organizationsUrl() organizationsUrl}
   *    .reposUrl(java.net.URI | null) // nullable {@link User#reposUrl() reposUrl}
   *    .eventsUrl(String | null) // nullable {@link User#eventsUrl() eventsUrl}
   *    .receivedEventsUrl(java.net.URI | null) // nullable {@link User#receivedEventsUrl() receivedEventsUrl}
   *    .type(String | null) // nullable {@link User#type() type}
   *    .siteAdmin(Boolean) // optional {@link User#siteAdmin() siteAdmin}
   *    .build();
   * </pre>
   * @return A new ImmutableUser builder
   */
  public static ImmutableUser.Builder builder() {
    return new ImmutableUser.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUser ImmutableUser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "User", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String login;
    private @Nullable Integer id;
    private @Nullable URI avatarUrl;
    private @Nullable String gravatarId;
    private @Nullable URI url;
    private @Nullable URI htmlUrl;
    private @Nullable URI followersUrl;
    private @Nullable String followingUrl;
    private @Nullable String gistsUrl;
    private @Nullable String starredUrl;
    private @Nullable URI subscriptionsUrl;
    private @Nullable URI organizationsUrl;
    private @Nullable URI reposUrl;
    private @Nullable String eventsUrl;
    private @Nullable URI receivedEventsUrl;
    private @Nullable String type;
    private @Nullable Boolean siteAdmin;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code User} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(User instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String loginValue = instance.login();
      if (loginValue != null) {
        login(loginValue);
      }
      @Nullable Integer idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable URI avatarUrlValue = instance.avatarUrl();
      if (avatarUrlValue != null) {
        avatarUrl(avatarUrlValue);
      }
      Optional<String> gravatarIdOptional = instance.gravatarId();
      if (gravatarIdOptional.isPresent()) {
        gravatarId(gravatarIdOptional);
      }
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable URI htmlUrlValue = instance.htmlUrl();
      if (htmlUrlValue != null) {
        htmlUrl(htmlUrlValue);
      }
      @Nullable URI followersUrlValue = instance.followersUrl();
      if (followersUrlValue != null) {
        followersUrl(followersUrlValue);
      }
      @Nullable String followingUrlValue = instance.followingUrl();
      if (followingUrlValue != null) {
        followingUrl(followingUrlValue);
      }
      @Nullable String gistsUrlValue = instance.gistsUrl();
      if (gistsUrlValue != null) {
        gistsUrl(gistsUrlValue);
      }
      @Nullable String starredUrlValue = instance.starredUrl();
      if (starredUrlValue != null) {
        starredUrl(starredUrlValue);
      }
      @Nullable URI subscriptionsUrlValue = instance.subscriptionsUrl();
      if (subscriptionsUrlValue != null) {
        subscriptionsUrl(subscriptionsUrlValue);
      }
      @Nullable URI organizationsUrlValue = instance.organizationsUrl();
      if (organizationsUrlValue != null) {
        organizationsUrl(organizationsUrlValue);
      }
      @Nullable URI reposUrlValue = instance.reposUrl();
      if (reposUrlValue != null) {
        reposUrl(reposUrlValue);
      }
      @Nullable String eventsUrlValue = instance.eventsUrl();
      if (eventsUrlValue != null) {
        eventsUrl(eventsUrlValue);
      }
      @Nullable URI receivedEventsUrlValue = instance.receivedEventsUrl();
      if (receivedEventsUrlValue != null) {
        receivedEventsUrl(receivedEventsUrlValue);
      }
      @Nullable String typeValue = instance.type();
      if (typeValue != null) {
        type(typeValue);
      }
      Optional<Boolean> siteAdminOptional = instance.siteAdmin();
      if (siteAdminOptional.isPresent()) {
        siteAdmin(siteAdminOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link User#login() login} attribute.
     * @param login The value for login (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder login(@Nullable String login) {
      this.login = login;
      return this;
    }

    /**
     * Initializes the value for the {@link User#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link User#avatarUrl() avatarUrl} attribute.
     * @param avatarUrl The value for avatarUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder avatarUrl(@Nullable URI avatarUrl) {
      this.avatarUrl = avatarUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link User#gravatarId() gravatarId} to gravatarId.
     * @param gravatarId The value for gravatarId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gravatarId(String gravatarId) {
      this.gravatarId = Objects.requireNonNull(gravatarId, "gravatarId");
      return this;
    }

    /**
     * Initializes the optional value {@link User#gravatarId() gravatarId} to gravatarId.
     * @param gravatarId The value for gravatarId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder gravatarId(Optional<String> gravatarId) {
      this.gravatarId = gravatarId.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link User#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link User#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link User#followersUrl() followersUrl} attribute.
     * @param followersUrl The value for followersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder followersUrl(@Nullable URI followersUrl) {
      this.followersUrl = followersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link User#followingUrl() followingUrl} attribute.
     * @param followingUrl The value for followingUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder followingUrl(@Nullable String followingUrl) {
      this.followingUrl = followingUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link User#gistsUrl() gistsUrl} attribute.
     * @param gistsUrl The value for gistsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder gistsUrl(@Nullable String gistsUrl) {
      this.gistsUrl = gistsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link User#starredUrl() starredUrl} attribute.
     * @param starredUrl The value for starredUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder starredUrl(@Nullable String starredUrl) {
      this.starredUrl = starredUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link User#subscriptionsUrl() subscriptionsUrl} attribute.
     * @param subscriptionsUrl The value for subscriptionsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder subscriptionsUrl(@Nullable URI subscriptionsUrl) {
      this.subscriptionsUrl = subscriptionsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link User#organizationsUrl() organizationsUrl} attribute.
     * @param organizationsUrl The value for organizationsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder organizationsUrl(@Nullable URI organizationsUrl) {
      this.organizationsUrl = organizationsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link User#reposUrl() reposUrl} attribute.
     * @param reposUrl The value for reposUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reposUrl(@Nullable URI reposUrl) {
      this.reposUrl = reposUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link User#eventsUrl() eventsUrl} attribute.
     * @param eventsUrl The value for eventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder eventsUrl(@Nullable String eventsUrl) {
      this.eventsUrl = eventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link User#receivedEventsUrl() receivedEventsUrl} attribute.
     * @param receivedEventsUrl The value for receivedEventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder receivedEventsUrl(@Nullable URI receivedEventsUrl) {
      this.receivedEventsUrl = receivedEventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link User#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the optional value {@link User#siteAdmin() siteAdmin} to siteAdmin.
     * @param siteAdmin The value for siteAdmin
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder siteAdmin(boolean siteAdmin) {
      this.siteAdmin = siteAdmin;
      return this;
    }

    /**
     * Initializes the optional value {@link User#siteAdmin() siteAdmin} to siteAdmin.
     * @param siteAdmin The value for siteAdmin
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder siteAdmin(Optional<Boolean> siteAdmin) {
      this.siteAdmin = siteAdmin.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableUser ImmutableUser}.
     * @return An immutable instance of User
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUser build() {
      return new ImmutableUser(
          login,
          id,
          avatarUrl,
          gravatarId,
          url,
          htmlUrl,
          followersUrl,
          followingUrl,
          gistsUrl,
          starredUrl,
          subscriptionsUrl,
          organizationsUrl,
          reposUrl,
          eventsUrl,
          receivedEventsUrl,
          type,
          siteAdmin);
    }
  }
}
