package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BaseEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBaseEvent.builder()}.
 */
@Generated(from = "BaseEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBaseEvent implements BaseEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;

  private ImmutableBaseEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BaseEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBaseEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableBaseEvent(value, this.sender, this.eventInstallation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BaseEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBaseEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableBaseEvent(this.repository, value, this.eventInstallation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BaseEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBaseEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableBaseEvent(this.repository, this.sender, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBaseEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBaseEvent
        && equalTo(0, (ImmutableBaseEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutableBaseEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    return h;
  }

  /**
   * Prints the immutable value {@code BaseEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BaseEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "BaseEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements BaseEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBaseEvent fromJson(Json json) {
    ImmutableBaseEvent.Builder builder = ImmutableBaseEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link BaseEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BaseEvent instance
   */
  public static ImmutableBaseEvent copyOf(BaseEvent instance) {
    if (instance instanceof ImmutableBaseEvent) {
      return (ImmutableBaseEvent) instance;
    }
    return ImmutableBaseEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBaseEvent ImmutableBaseEvent}.
   * <pre>
   * ImmutableBaseEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link BaseEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link BaseEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link BaseEvent#eventInstallation() eventInstallation}
   *    .build();
   * </pre>
   * @return A new ImmutableBaseEvent builder
   */
  public static ImmutableBaseEvent.Builder builder() {
    return new ImmutableBaseEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBaseEvent ImmutableBaseEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BaseEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BaseEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Repository repositoryValue = instance.repository();
      if (repositoryValue != null) {
        repository(repositoryValue);
      }
      @Nullable User senderValue = instance.sender();
      if (senderValue != null) {
        sender(senderValue);
      }
      @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
      if (eventInstallationValue != null) {
        eventInstallation(eventInstallationValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BaseEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link BaseEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link BaseEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBaseEvent ImmutableBaseEvent}.
     * @return An immutable instance of BaseEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBaseEvent build() {
      return new ImmutableBaseEvent(repository, sender, eventInstallation);
    }
  }
}
