package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeleteEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeleteEvent.builder()}.
 */
@Generated(from = "DeleteEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeleteEvent implements DeleteEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable String ref;
  private final @Nullable String refType;
  private final @Nullable String pusherType;

  private ImmutableDeleteEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable String ref,
      @Nullable String refType,
      @Nullable String pusherType) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.ref = ref;
    this.refType = refType;
    this.pusherType = pusherType;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   *Full git reference 
   */
  @JsonProperty
  @Override
  public @Nullable String ref() {
    return ref;
  }

  /**
   *The object that was deleted. Can be "branch" or "tag". 
   */
  @JsonProperty
  @Override
  public @Nullable String refType() {
    return refType;
  }

  /**
   * Pusher type. E.g. user. The github api does not document any other types, yet. To be totally
   * honest, it does not document *ANYTHING* about this field, so leave it as string for now.
   */
  @JsonProperty
  @Override
  public @Nullable String pusherType() {
    return pusherType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableDeleteEvent(value, this.sender, this.eventInstallation, this.ref, this.refType, this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableDeleteEvent(this.repository, value, this.eventInstallation, this.ref, this.refType, this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableDeleteEvent(this.repository, this.sender, value, this.ref, this.refType, this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteEvent#ref() ref} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ref (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteEvent withRef(@Nullable String value) {
    if (Objects.equals(this.ref, value)) return this;
    return new ImmutableDeleteEvent(this.repository, this.sender, this.eventInstallation, value, this.refType, this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteEvent#refType() refType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteEvent withRefType(@Nullable String value) {
    if (Objects.equals(this.refType, value)) return this;
    return new ImmutableDeleteEvent(this.repository, this.sender, this.eventInstallation, this.ref, value, this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteEvent#pusherType() pusherType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pusherType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteEvent withPusherType(@Nullable String value) {
    if (Objects.equals(this.pusherType, value)) return this;
    return new ImmutableDeleteEvent(this.repository, this.sender, this.eventInstallation, this.ref, this.refType, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeleteEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeleteEvent
        && equalTo(0, (ImmutableDeleteEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutableDeleteEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(ref, another.ref)
        && Objects.equals(refType, another.refType)
        && Objects.equals(pusherType, another.pusherType);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code ref}, {@code refType}, {@code pusherType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(ref);
    h += (h << 5) + Objects.hashCode(refType);
    h += (h << 5) + Objects.hashCode(pusherType);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", ref=" + ref
        + ", refType=" + refType
        + ", pusherType=" + pusherType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DeleteEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DeleteEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable String ref;
    @Nullable String refType;
    @Nullable String pusherType;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setRef(@Nullable String ref) {
      this.ref = ref;
    }
    @JsonProperty
    public void setRefType(@Nullable String refType) {
      this.refType = refType;
    }
    @JsonProperty
    public void setPusherType(@Nullable String pusherType) {
      this.pusherType = pusherType;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public String ref() { throw new UnsupportedOperationException(); }
    @Override
    public String refType() { throw new UnsupportedOperationException(); }
    @Override
    public String pusherType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDeleteEvent fromJson(Json json) {
    ImmutableDeleteEvent.Builder builder = ImmutableDeleteEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.ref != null) {
      builder.ref(json.ref);
    }
    if (json.refType != null) {
      builder.refType(json.refType);
    }
    if (json.pusherType != null) {
      builder.pusherType(json.pusherType);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DeleteEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeleteEvent instance
   */
  public static ImmutableDeleteEvent copyOf(DeleteEvent instance) {
    if (instance instanceof ImmutableDeleteEvent) {
      return (ImmutableDeleteEvent) instance;
    }
    return ImmutableDeleteEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeleteEvent ImmutableDeleteEvent}.
   * <pre>
   * ImmutableDeleteEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link DeleteEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link DeleteEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link DeleteEvent#eventInstallation() eventInstallation}
   *    .ref(String | null) // nullable {@link DeleteEvent#ref() ref}
   *    .refType(String | null) // nullable {@link DeleteEvent#refType() refType}
   *    .pusherType(String | null) // nullable {@link DeleteEvent#pusherType() pusherType}
   *    .build();
   * </pre>
   * @return A new ImmutableDeleteEvent builder
   */
  public static ImmutableDeleteEvent.Builder builder() {
    return new ImmutableDeleteEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeleteEvent ImmutableDeleteEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeleteEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable String ref;
    private @Nullable String refType;
    private @Nullable String pusherType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.DeleteEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeleteEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof DeleteEvent) {
        DeleteEvent instance = (DeleteEvent) object;
        @Nullable String refTypeValue = instance.refType();
        if (refTypeValue != null) {
          refType(refTypeValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
        @Nullable String refValue = instance.ref();
        if (refValue != null) {
          ref(refValue);
        }
        if ((bits & 0x4L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x2L;
        }
        @Nullable String pusherTypeValue = instance.pusherType();
        if (pusherTypeValue != null) {
          pusherType(pusherTypeValue);
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        if ((bits & 0x4L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link DeleteEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteEvent#ref() ref} attribute.
     * @param ref The value for ref (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder ref(@Nullable String ref) {
      this.ref = ref;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteEvent#refType() refType} attribute.
     * @param refType The value for refType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder refType(@Nullable String refType) {
      this.refType = refType;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteEvent#pusherType() pusherType} attribute.
     * @param pusherType The value for pusherType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pusherType(@Nullable String pusherType) {
      this.pusherType = pusherType;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeleteEvent ImmutableDeleteEvent}.
     * @return An immutable instance of DeleteEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeleteEvent build() {
      return new ImmutableDeleteEvent(repository, sender, eventInstallation, ref, refType, pusherType);
    }
  }
}
