package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.comment.Comment;
import com.spotify.github.v3.issues.Issue;
import com.spotify.github.v3.issues.changes.Changes;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IssueCommentEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIssueCommentEvent.builder()}.
 */
@Generated(from = "IssueCommentEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableIssueCommentEvent
    implements IssueCommentEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable String action;
  private final @Nullable Changes changes;
  private final @Nullable Issue issue;
  private final @Nullable Comment comment;

  private ImmutableIssueCommentEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable String action,
      @Nullable Changes changes,
      @Nullable Issue issue,
      @Nullable Comment comment) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.action = action;
    this.changes = changes;
    this.issue = issue;
    this.comment = comment;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   * The action that was performed on the comment. Can be one of "created", "edited", or "deleted".
   */
  @JsonProperty
  @Override
  public @Nullable String action() {
    return action;
  }

  /**
   * The changes to the comment if the action was "edited".
   * <p>The GitHub API does also declare "changes" and "changes[body][from]" but it does not provide
   * any examples of that data.
   * @see "https://developer.github.com/v3/activity/events/types/#issuecommentevent"
   */
  @JsonProperty
  @Override
  public Optional<Changes> changes() {
    return Optional.ofNullable(changes);
  }

  /**
   *The {@link Issue} the comment belongs to. 
   */
  @JsonProperty
  @Override
  public @Nullable Issue issue() {
    return issue;
  }

  /**
   *The {@link Comment} itself. 
   */
  @JsonProperty
  @Override
  public @Nullable Comment comment() {
    return comment;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssueCommentEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssueCommentEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableIssueCommentEvent(value, this.sender, this.eventInstallation, this.action, this.changes, this.issue, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssueCommentEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssueCommentEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableIssueCommentEvent(
        this.repository,
        value,
        this.eventInstallation,
        this.action,
        this.changes,
        this.issue,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssueCommentEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssueCommentEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableIssueCommentEvent(this.repository, this.sender, value, this.action, this.changes, this.issue, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssueCommentEvent#action() action} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssueCommentEvent withAction(@Nullable String value) {
    if (Objects.equals(this.action, value)) return this;
    return new ImmutableIssueCommentEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        value,
        this.changes,
        this.issue,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link IssueCommentEvent#changes() changes} attribute.
   * @param value The value for changes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIssueCommentEvent withChanges(Changes value) {
    Changes newValue = Objects.requireNonNull(value, "changes");
    if (this.changes == newValue) return this;
    return new ImmutableIssueCommentEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.action,
        newValue,
        this.issue,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link IssueCommentEvent#changes() changes} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for changes
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableIssueCommentEvent withChanges(Optional<? extends Changes> optional) {
    @Nullable Changes value = optional.orElse(null);
    if (this.changes == value) return this;
    return new ImmutableIssueCommentEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.action,
        value,
        this.issue,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssueCommentEvent#issue() issue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for issue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssueCommentEvent withIssue(@Nullable Issue value) {
    if (this.issue == value) return this;
    return new ImmutableIssueCommentEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.action,
        this.changes,
        value,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssueCommentEvent#comment() comment} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssueCommentEvent withComment(@Nullable Comment value) {
    if (this.comment == value) return this;
    return new ImmutableIssueCommentEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.action,
        this.changes,
        this.issue,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIssueCommentEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIssueCommentEvent
        && equalTo(0, (ImmutableIssueCommentEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutableIssueCommentEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(action, another.action)
        && Objects.equals(changes, another.changes)
        && Objects.equals(issue, another.issue)
        && Objects.equals(comment, another.comment);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code action}, {@code changes}, {@code issue}, {@code comment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(changes);
    h += (h << 5) + Objects.hashCode(issue);
    h += (h << 5) + Objects.hashCode(comment);
    return h;
  }

  /**
   * Prints the immutable value {@code IssueCommentEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("IssueCommentEvent{");
    if (repository != null) {
      builder.append("repository=").append(repository);
    }
    if (sender != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("sender=").append(sender);
    }
    if (eventInstallation != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("eventInstallation=").append(eventInstallation);
    }
    if (action != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("action=").append(action);
    }
    if (changes != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("changes=").append(changes);
    }
    if (issue != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("issue=").append(issue);
    }
    if (comment != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("comment=").append(comment);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "IssueCommentEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements IssueCommentEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable String action;
    @Nullable Optional<Changes> changes = Optional.empty();
    @Nullable Issue issue;
    @Nullable Comment comment;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setAction(@Nullable String action) {
      this.action = action;
    }
    @JsonProperty
    public void setChanges(Optional<Changes> changes) {
      this.changes = changes;
    }
    @JsonProperty
    public void setIssue(@Nullable Issue issue) {
      this.issue = issue;
    }
    @JsonProperty
    public void setComment(@Nullable Comment comment) {
      this.comment = comment;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public String action() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Changes> changes() { throw new UnsupportedOperationException(); }
    @Override
    public Issue issue() { throw new UnsupportedOperationException(); }
    @Override
    public Comment comment() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableIssueCommentEvent fromJson(Json json) {
    ImmutableIssueCommentEvent.Builder builder = ImmutableIssueCommentEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.action != null) {
      builder.action(json.action);
    }
    if (json.changes != null) {
      builder.changes(json.changes);
    }
    if (json.issue != null) {
      builder.issue(json.issue);
    }
    if (json.comment != null) {
      builder.comment(json.comment);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link IssueCommentEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IssueCommentEvent instance
   */
  public static ImmutableIssueCommentEvent copyOf(IssueCommentEvent instance) {
    if (instance instanceof ImmutableIssueCommentEvent) {
      return (ImmutableIssueCommentEvent) instance;
    }
    return ImmutableIssueCommentEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIssueCommentEvent ImmutableIssueCommentEvent}.
   * <pre>
   * ImmutableIssueCommentEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link IssueCommentEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link IssueCommentEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link IssueCommentEvent#eventInstallation() eventInstallation}
   *    .action(String | null) // nullable {@link IssueCommentEvent#action() action}
   *    .changes(com.spotify.github.v3.issues.changes.Changes) // optional {@link IssueCommentEvent#changes() changes}
   *    .issue(com.spotify.github.v3.issues.Issue | null) // nullable {@link IssueCommentEvent#issue() issue}
   *    .comment(com.spotify.github.v3.comment.Comment | null) // nullable {@link IssueCommentEvent#comment() comment}
   *    .build();
   * </pre>
   * @return A new ImmutableIssueCommentEvent builder
   */
  public static ImmutableIssueCommentEvent.Builder builder() {
    return new ImmutableIssueCommentEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIssueCommentEvent ImmutableIssueCommentEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IssueCommentEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable String action;
    private @Nullable Changes changes;
    private @Nullable Issue issue;
    private @Nullable Comment comment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.IssueCommentEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IssueCommentEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof IssueCommentEvent) {
        IssueCommentEvent instance = (IssueCommentEvent) object;
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
        @Nullable Issue issueValue = instance.issue();
        if (issueValue != null) {
          issue(issueValue);
        }
        if ((bits & 0x2L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x2L;
        }
        Optional<Changes> changesOptional = instance.changes();
        if (changesOptional.isPresent()) {
          changes(changesOptional);
        }
        @Nullable String actionValue = instance.action();
        if (actionValue != null) {
          action(actionValue);
        }
        @Nullable Comment commentValue = instance.comment();
        if (commentValue != null) {
          comment(commentValue);
        }
        if ((bits & 0x4L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x4L;
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        if ((bits & 0x4L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link IssueCommentEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link IssueCommentEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link IssueCommentEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link IssueCommentEvent#action() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder action(@Nullable String action) {
      this.action = action;
      return this;
    }

    /**
     * Initializes the optional value {@link IssueCommentEvent#changes() changes} to changes.
     * @param changes The value for changes
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder changes(Changes changes) {
      this.changes = Objects.requireNonNull(changes, "changes");
      return this;
    }

    /**
     * Initializes the optional value {@link IssueCommentEvent#changes() changes} to changes.
     * @param changes The value for changes
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder changes(Optional<? extends Changes> changes) {
      this.changes = changes.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link IssueCommentEvent#issue() issue} attribute.
     * @param issue The value for issue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder issue(@Nullable Issue issue) {
      this.issue = issue;
      return this;
    }

    /**
     * Initializes the value for the {@link IssueCommentEvent#comment() comment} attribute.
     * @param comment The value for comment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder comment(@Nullable Comment comment) {
      this.comment = comment;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIssueCommentEvent ImmutableIssueCommentEvent}.
     * @return An immutable instance of IssueCommentEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIssueCommentEvent build() {
      return new ImmutableIssueCommentEvent(repository, sender, eventInstallation, action, changes, issue, comment);
    }
  }
}
