package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckRunAction}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckRunAction.builder()}.
 */
@Generated(from = "CheckRunAction", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckRunAction implements CheckRunAction {
  private final String label;
  private final String identifier;
  private final String description;

  private ImmutableCheckRunAction(String label, String identifier, String description) {
    this.label = label;
    this.identifier = identifier;
    this.description = description;
  }

  /**
   * The label to be shown at the action button.
   * @return the string
   */
  @JsonProperty
  @Override
  public String label() {
    return label;
  }

  /**
   * The identifier to be sent at the event When a user clicks the button, GitHub sends the
   * check_run.requested_action webhook to your app. When your app receives a
   * check_run.requested_action webhook event, it can look for the requested_action.identifier key
   * in the webhook payload to determine which button was clicked and perform the requested task.
   * @return the string
   */
  @JsonProperty
  @Override
  public String identifier() {
    return identifier;
  }

  /**
   * Description string.
   * @return the string
   */
  @JsonProperty
  @Override
  public String description() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunAction#label() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunAction withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return validate(new ImmutableCheckRunAction(newValue, this.identifier, this.description));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunAction#identifier() identifier} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for identifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunAction withIdentifier(String value) {
    String newValue = Objects.requireNonNull(value, "identifier");
    if (this.identifier.equals(newValue)) return this;
    return validate(new ImmutableCheckRunAction(this.label, newValue, this.description));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunAction#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunAction withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return validate(new ImmutableCheckRunAction(this.label, this.identifier, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckRunAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckRunAction
        && equalTo(0, (ImmutableCheckRunAction) another);
  }

  private boolean equalTo(int synthetic, ImmutableCheckRunAction another) {
    return label.equals(another.label)
        && identifier.equals(another.identifier)
        && description.equals(another.description);
  }

  /**
   * Computes a hash code from attributes: {@code label}, {@code identifier}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + label.hashCode();
    h += (h << 5) + identifier.hashCode();
    h += (h << 5) + description.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CheckRunAction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckRunAction{"
        + "label=" + label
        + ", identifier=" + identifier
        + ", description=" + description
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CheckRunAction", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CheckRunAction {
    @Nullable String label;
    @Nullable String identifier;
    @Nullable String description;
    @JsonProperty
    public void setLabel(String label) {
      this.label = label;
    }
    @JsonProperty
    public void setIdentifier(String identifier) {
      this.identifier = identifier;
    }
    @JsonProperty
    public void setDescription(String description) {
      this.description = description;
    }
    @Override
    public String label() { throw new UnsupportedOperationException(); }
    @Override
    public String identifier() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCheckRunAction fromJson(Json json) {
    ImmutableCheckRunAction.Builder builder = ImmutableCheckRunAction.builder();
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.identifier != null) {
      builder.identifier(json.identifier);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  private static ImmutableCheckRunAction validate(ImmutableCheckRunAction instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link CheckRunAction} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckRunAction instance
   */
  public static ImmutableCheckRunAction copyOf(CheckRunAction instance) {
    if (instance instanceof ImmutableCheckRunAction) {
      return (ImmutableCheckRunAction) instance;
    }
    return ImmutableCheckRunAction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckRunAction ImmutableCheckRunAction}.
   * <pre>
   * ImmutableCheckRunAction.builder()
   *    .label(String) // required {@link CheckRunAction#label() label}
   *    .identifier(String) // required {@link CheckRunAction#identifier() identifier}
   *    .description(String) // required {@link CheckRunAction#description() description}
   *    .build();
   * </pre>
   * @return A new ImmutableCheckRunAction builder
   */
  public static ImmutableCheckRunAction.Builder builder() {
    return new ImmutableCheckRunAction.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckRunAction ImmutableCheckRunAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckRunAction", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LABEL = 0x1L;
    private static final long INIT_BIT_IDENTIFIER = 0x2L;
    private static final long INIT_BIT_DESCRIPTION = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String label;
    private @Nullable String identifier;
    private @Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckRunAction} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckRunAction instance) {
      Objects.requireNonNull(instance, "instance");
      label(instance.label());
      identifier(instance.identifier());
      description(instance.description());
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunAction#label() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunAction#identifier() identifier} attribute.
     * @param identifier The value for identifier 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder identifier(String identifier) {
      this.identifier = Objects.requireNonNull(identifier, "identifier");
      initBits &= ~INIT_BIT_IDENTIFIER;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunAction#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckRunAction ImmutableCheckRunAction}.
     * @return An immutable instance of CheckRunAction
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckRunAction build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableCheckRunAction.validate(new ImmutableCheckRunAction(label, identifier, description));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      if ((initBits & INIT_BIT_IDENTIFIER) != 0) attributes.add("identifier");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      return "Cannot build CheckRunAction, some of required attributes are not set " + attributes;
    }
  }
}
