/*-
 * -\-\-
 * github-api
 * --
 * Copyright (C) 2016 - 2020 Spotify AB
 * --
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * -/-/-
 */

package com.spotify.github.v3.exceptions;

/** Marks deserialization issues */
public class DeserializationException extends GithubException {

  /**
   * Constructor for setting data and message
   *
   * @param data usually json data
   * @param msg error message
   */
  public DeserializationException(final String data, final String msg) {
    super("Failed deserializing: " + data + ":\n" + msg);
  }

  /**
   * Constructor for setting data
   *
   * @param data usually json date
   */
  public DeserializationException(final String data) {
    super("Failed deserializing: " + data);
  }
}
