package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Author}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAuthor.builder()}.
 */
@Generated(from = "Author", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAuthor implements Author {
  private final @Nullable String name;
  private final @Nullable String email;
  private final @Nullable String username;
  private final @Nullable GitHubInstant date;

  private ImmutableAuthor(
      @Nullable String name,
      @Nullable String email,
      @Nullable String username,
      @Nullable GitHubInstant date) {
    this.name = name;
    this.email = email;
    this.username = username;
    this.date = date;
  }

  /**
   *The name of the author. 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *The email of the author. 
   */
  @JsonProperty
  @Override
  public Optional<String> email() {
    return Optional.ofNullable(email);
  }

  /**
   *The username of the author, not always set. 
   */
  @JsonProperty
  @Override
  public Optional<String> username() {
    return Optional.ofNullable(username);
  }

  /**
   *Date when action occurred. 
   */
  @JsonProperty
  @Override
  public Optional<GitHubInstant> date() {
    return Optional.ofNullable(date);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Author#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthor withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableAuthor(value, this.email, this.username, this.date);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Author#email() email} attribute.
   * @param value The value for email
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAuthor withEmail(String value) {
    String newValue = Objects.requireNonNull(value, "email");
    if (Objects.equals(this.email, newValue)) return this;
    return new ImmutableAuthor(this.name, newValue, this.username, this.date);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Author#email() email} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for email
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAuthor withEmail(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.email, value)) return this;
    return new ImmutableAuthor(this.name, value, this.username, this.date);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Author#username() username} attribute.
   * @param value The value for username
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAuthor withUsername(String value) {
    String newValue = Objects.requireNonNull(value, "username");
    if (Objects.equals(this.username, newValue)) return this;
    return new ImmutableAuthor(this.name, this.email, newValue, this.date);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Author#username() username} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for username
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAuthor withUsername(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.username, value)) return this;
    return new ImmutableAuthor(this.name, this.email, value, this.date);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Author#date() date} attribute.
   * @param value The value for date
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAuthor withDate(GitHubInstant value) {
    GitHubInstant newValue = Objects.requireNonNull(value, "date");
    if (this.date == newValue) return this;
    return new ImmutableAuthor(this.name, this.email, this.username, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Author#date() date} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for date
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableAuthor withDate(Optional<? extends GitHubInstant> optional) {
    @Nullable GitHubInstant value = optional.orElse(null);
    if (this.date == value) return this;
    return new ImmutableAuthor(this.name, this.email, this.username, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAuthor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAuthor
        && equalTo(0, (ImmutableAuthor) another);
  }

  private boolean equalTo(int synthetic, ImmutableAuthor another) {
    return Objects.equals(name, another.name)
        && Objects.equals(email, another.email)
        && Objects.equals(username, another.username)
        && Objects.equals(date, another.date);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code email}, {@code username}, {@code date}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(email);
    h += (h << 5) + Objects.hashCode(username);
    h += (h << 5) + Objects.hashCode(date);
    return h;
  }

  /**
   * Prints the immutable value {@code Author} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Author{");
    if (name != null) {
      builder.append("name=").append(name);
    }
    if (email != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("email=").append(email);
    }
    if (username != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("username=").append(username);
    }
    if (date != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("date=").append(date);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Author", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Author {
    @Nullable String name;
    @Nullable Optional<String> email = Optional.empty();
    @Nullable Optional<String> username = Optional.empty();
    @Nullable Optional<GitHubInstant> date = Optional.empty();
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setEmail(Optional<String> email) {
      this.email = email;
    }
    @JsonProperty
    public void setUsername(Optional<String> username) {
      this.username = username;
    }
    @JsonProperty
    public void setDate(Optional<GitHubInstant> date) {
      this.date = date;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> email() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> username() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GitHubInstant> date() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAuthor fromJson(Json json) {
    ImmutableAuthor.Builder builder = ImmutableAuthor.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.email != null) {
      builder.email(json.email);
    }
    if (json.username != null) {
      builder.username(json.username);
    }
    if (json.date != null) {
      builder.date(json.date);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Author} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Author instance
   */
  public static ImmutableAuthor copyOf(Author instance) {
    if (instance instanceof ImmutableAuthor) {
      return (ImmutableAuthor) instance;
    }
    return ImmutableAuthor.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAuthor ImmutableAuthor}.
   * <pre>
   * ImmutableAuthor.builder()
   *    .name(String | null) // nullable {@link Author#name() name}
   *    .email(String) // optional {@link Author#email() email}
   *    .username(String) // optional {@link Author#username() username}
   *    .date(com.spotify.github.GitHubInstant) // optional {@link Author#date() date}
   *    .build();
   * </pre>
   * @return A new ImmutableAuthor builder
   */
  public static ImmutableAuthor.Builder builder() {
    return new ImmutableAuthor.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAuthor ImmutableAuthor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Author", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String name;
    private @Nullable String email;
    private @Nullable String username;
    private @Nullable GitHubInstant date;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Author} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Author instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      Optional<String> emailOptional = instance.email();
      if (emailOptional.isPresent()) {
        email(emailOptional);
      }
      Optional<String> usernameOptional = instance.username();
      if (usernameOptional.isPresent()) {
        username(usernameOptional);
      }
      Optional<GitHubInstant> dateOptional = instance.date();
      if (dateOptional.isPresent()) {
        date(dateOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Author#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the optional value {@link Author#email() email} to email.
     * @param email The value for email
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder email(String email) {
      this.email = Objects.requireNonNull(email, "email");
      return this;
    }

    /**
     * Initializes the optional value {@link Author#email() email} to email.
     * @param email The value for email
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder email(Optional<String> email) {
      this.email = email.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Author#username() username} to username.
     * @param username The value for username
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      return this;
    }

    /**
     * Initializes the optional value {@link Author#username() username} to username.
     * @param username The value for username
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder username(Optional<String> username) {
      this.username = username.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Author#date() date} to date.
     * @param date The value for date
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder date(GitHubInstant date) {
      this.date = Objects.requireNonNull(date, "date");
      return this;
    }

    /**
     * Initializes the optional value {@link Author#date() date} to date.
     * @param date The value for date
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder date(Optional<? extends GitHubInstant> date) {
      this.date = date.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAuthor ImmutableAuthor}.
     * @return An immutable instance of Author
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAuthor build() {
      return new ImmutableAuthor(name, email, username, date);
    }
  }
}
