package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FileItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFileItem.builder()}.
 */
@Generated(from = "FileItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFileItem implements FileItem {
  private final String sha;
  private final String filename;
  private final @Nullable String status;
  private final @Nullable Integer additions;
  private final @Nullable Integer deletions;
  private final @Nullable Integer changes;
  private final @Nullable URI blobUrl;
  private final @Nullable URI rawUrl;
  private final @Nullable URI contentsUrl;
  private final @Nullable String patch;

  private ImmutableFileItem(
      String sha,
      String filename,
      @Nullable String status,
      @Nullable Integer additions,
      @Nullable Integer deletions,
      @Nullable Integer changes,
      @Nullable URI blobUrl,
      @Nullable URI rawUrl,
      @Nullable URI contentsUrl,
      @Nullable String patch) {
    this.sha = sha;
    this.filename = filename;
    this.status = status;
    this.additions = additions;
    this.deletions = deletions;
    this.changes = changes;
    this.blobUrl = blobUrl;
    this.rawUrl = rawUrl;
    this.contentsUrl = contentsUrl;
    this.patch = patch;
  }

  /**
   *Commit sha value. 
   */
  @JsonProperty
  @Override
  public String sha() {
    return sha;
  }

  /**
   *Commit node_id. 
   */
  @JsonProperty
  @Override
  public String filename() {
    return filename;
  }

  /**
   *Commit API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable String status() {
    return status;
  }

  /**
   * @return The value of the {@code additions} attribute
   */
  @JsonProperty
  @Override
  public @Nullable Integer additions() {
    return additions;
  }

  /**
   *Author commit user. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer deletions() {
    return deletions;
  }

  /**
   * @return The value of the {@code changes} attribute
   */
  @JsonProperty
  @Override
  public @Nullable Integer changes() {
    return changes;
  }

  /**
   * @return The value of the {@code blobUrl} attribute
   */
  @JsonProperty("blob_url")
  @Override
  public @Nullable URI blobUrl() {
    return blobUrl;
  }

  /**
   * @return The value of the {@code rawUrl} attribute
   */
  @JsonProperty("raw_url")
  @Override
  public @Nullable URI rawUrl() {
    return rawUrl;
  }

  /**
   * @return The value of the {@code contentsUrl} attribute
   */
  @JsonProperty("contents_url")
  @Override
  public @Nullable URI contentsUrl() {
    return contentsUrl;
  }

  /**
   * @return The value of the {@code patch} attribute
   */
  @JsonProperty
  @Override
  public @Nullable String patch() {
    return patch;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileItem#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileItem withSha(String value) {
    String newValue = Objects.requireNonNull(value, "sha");
    if (this.sha.equals(newValue)) return this;
    return new ImmutableFileItem(
        newValue,
        this.filename,
        this.status,
        this.additions,
        this.deletions,
        this.changes,
        this.blobUrl,
        this.rawUrl,
        this.contentsUrl,
        this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileItem#filename() filename} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for filename
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileItem withFilename(String value) {
    String newValue = Objects.requireNonNull(value, "filename");
    if (this.filename.equals(newValue)) return this;
    return new ImmutableFileItem(
        this.sha,
        newValue,
        this.status,
        this.additions,
        this.deletions,
        this.changes,
        this.blobUrl,
        this.rawUrl,
        this.contentsUrl,
        this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileItem#status() status} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileItem withStatus(@Nullable String value) {
    if (Objects.equals(this.status, value)) return this;
    return new ImmutableFileItem(
        this.sha,
        this.filename,
        value,
        this.additions,
        this.deletions,
        this.changes,
        this.blobUrl,
        this.rawUrl,
        this.contentsUrl,
        this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileItem#additions() additions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for additions (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileItem withAdditions(@Nullable Integer value) {
    if (Objects.equals(this.additions, value)) return this;
    return new ImmutableFileItem(
        this.sha,
        this.filename,
        this.status,
        value,
        this.deletions,
        this.changes,
        this.blobUrl,
        this.rawUrl,
        this.contentsUrl,
        this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileItem#deletions() deletions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deletions (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileItem withDeletions(@Nullable Integer value) {
    if (Objects.equals(this.deletions, value)) return this;
    return new ImmutableFileItem(
        this.sha,
        this.filename,
        this.status,
        this.additions,
        value,
        this.changes,
        this.blobUrl,
        this.rawUrl,
        this.contentsUrl,
        this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileItem#changes() changes} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for changes (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileItem withChanges(@Nullable Integer value) {
    if (Objects.equals(this.changes, value)) return this;
    return new ImmutableFileItem(
        this.sha,
        this.filename,
        this.status,
        this.additions,
        this.deletions,
        value,
        this.blobUrl,
        this.rawUrl,
        this.contentsUrl,
        this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileItem#blobUrl() blobUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blobUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileItem withBlobUrl(@Nullable URI value) {
    if (this.blobUrl == value) return this;
    return new ImmutableFileItem(
        this.sha,
        this.filename,
        this.status,
        this.additions,
        this.deletions,
        this.changes,
        value,
        this.rawUrl,
        this.contentsUrl,
        this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileItem#rawUrl() rawUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rawUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileItem withRawUrl(@Nullable URI value) {
    if (this.rawUrl == value) return this;
    return new ImmutableFileItem(
        this.sha,
        this.filename,
        this.status,
        this.additions,
        this.deletions,
        this.changes,
        this.blobUrl,
        value,
        this.contentsUrl,
        this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileItem#contentsUrl() contentsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileItem withContentsUrl(@Nullable URI value) {
    if (this.contentsUrl == value) return this;
    return new ImmutableFileItem(
        this.sha,
        this.filename,
        this.status,
        this.additions,
        this.deletions,
        this.changes,
        this.blobUrl,
        this.rawUrl,
        value,
        this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileItem#patch() patch} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for patch (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileItem withPatch(@Nullable String value) {
    if (Objects.equals(this.patch, value)) return this;
    return new ImmutableFileItem(
        this.sha,
        this.filename,
        this.status,
        this.additions,
        this.deletions,
        this.changes,
        this.blobUrl,
        this.rawUrl,
        this.contentsUrl,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFileItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFileItem
        && equalTo(0, (ImmutableFileItem) another);
  }

  private boolean equalTo(int synthetic, ImmutableFileItem another) {
    return sha.equals(another.sha)
        && filename.equals(another.filename)
        && Objects.equals(status, another.status)
        && Objects.equals(additions, another.additions)
        && Objects.equals(deletions, another.deletions)
        && Objects.equals(changes, another.changes)
        && Objects.equals(blobUrl, another.blobUrl)
        && Objects.equals(rawUrl, another.rawUrl)
        && Objects.equals(contentsUrl, another.contentsUrl)
        && Objects.equals(patch, another.patch);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code filename}, {@code status}, {@code additions}, {@code deletions}, {@code changes}, {@code blobUrl}, {@code rawUrl}, {@code contentsUrl}, {@code patch}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + sha.hashCode();
    h += (h << 5) + filename.hashCode();
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + Objects.hashCode(additions);
    h += (h << 5) + Objects.hashCode(deletions);
    h += (h << 5) + Objects.hashCode(changes);
    h += (h << 5) + Objects.hashCode(blobUrl);
    h += (h << 5) + Objects.hashCode(rawUrl);
    h += (h << 5) + Objects.hashCode(contentsUrl);
    h += (h << 5) + Objects.hashCode(patch);
    return h;
  }

  /**
   * Prints the immutable value {@code FileItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FileItem{"
        + "sha=" + sha
        + ", filename=" + filename
        + ", status=" + status
        + ", additions=" + additions
        + ", deletions=" + deletions
        + ", changes=" + changes
        + ", blobUrl=" + blobUrl
        + ", rawUrl=" + rawUrl
        + ", contentsUrl=" + contentsUrl
        + ", patch=" + patch
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FileItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FileItem {
    @Nullable String sha;
    @Nullable String filename;
    @Nullable String status;
    @Nullable Integer additions;
    @Nullable Integer deletions;
    @Nullable Integer changes;
    @Nullable URI blobUrl;
    @Nullable URI rawUrl;
    @Nullable URI contentsUrl;
    @Nullable String patch;
    @JsonProperty
    public void setSha(String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setFilename(String filename) {
      this.filename = filename;
    }
    @JsonProperty
    public void setStatus(@Nullable String status) {
      this.status = status;
    }
    @JsonProperty
    public void setAdditions(@Nullable Integer additions) {
      this.additions = additions;
    }
    @JsonProperty
    public void setDeletions(@Nullable Integer deletions) {
      this.deletions = deletions;
    }
    @JsonProperty
    public void setChanges(@Nullable Integer changes) {
      this.changes = changes;
    }
    @JsonProperty("blob_url")
    public void setBlobUrl(@Nullable URI blobUrl) {
      this.blobUrl = blobUrl;
    }
    @JsonProperty("raw_url")
    public void setRawUrl(@Nullable URI rawUrl) {
      this.rawUrl = rawUrl;
    }
    @JsonProperty("contents_url")
    public void setContentsUrl(@Nullable URI contentsUrl) {
      this.contentsUrl = contentsUrl;
    }
    @JsonProperty
    public void setPatch(@Nullable String patch) {
      this.patch = patch;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public String filename() { throw new UnsupportedOperationException(); }
    @Override
    public String status() { throw new UnsupportedOperationException(); }
    @Override
    public Integer additions() { throw new UnsupportedOperationException(); }
    @Override
    public Integer deletions() { throw new UnsupportedOperationException(); }
    @Override
    public Integer changes() { throw new UnsupportedOperationException(); }
    @Override
    public URI blobUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI rawUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI contentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String patch() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFileItem fromJson(Json json) {
    ImmutableFileItem.Builder builder = ImmutableFileItem.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.filename != null) {
      builder.filename(json.filename);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.additions != null) {
      builder.additions(json.additions);
    }
    if (json.deletions != null) {
      builder.deletions(json.deletions);
    }
    if (json.changes != null) {
      builder.changes(json.changes);
    }
    if (json.blobUrl != null) {
      builder.blobUrl(json.blobUrl);
    }
    if (json.rawUrl != null) {
      builder.rawUrl(json.rawUrl);
    }
    if (json.contentsUrl != null) {
      builder.contentsUrl(json.contentsUrl);
    }
    if (json.patch != null) {
      builder.patch(json.patch);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FileItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FileItem instance
   */
  public static ImmutableFileItem copyOf(FileItem instance) {
    if (instance instanceof ImmutableFileItem) {
      return (ImmutableFileItem) instance;
    }
    return ImmutableFileItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFileItem ImmutableFileItem}.
   * <pre>
   * ImmutableFileItem.builder()
   *    .sha(String) // required {@link FileItem#sha() sha}
   *    .filename(String) // required {@link FileItem#filename() filename}
   *    .status(String | null) // nullable {@link FileItem#status() status}
   *    .additions(Integer | null) // nullable {@link FileItem#additions() additions}
   *    .deletions(Integer | null) // nullable {@link FileItem#deletions() deletions}
   *    .changes(Integer | null) // nullable {@link FileItem#changes() changes}
   *    .blobUrl(java.net.URI | null) // nullable {@link FileItem#blobUrl() blobUrl}
   *    .rawUrl(java.net.URI | null) // nullable {@link FileItem#rawUrl() rawUrl}
   *    .contentsUrl(java.net.URI | null) // nullable {@link FileItem#contentsUrl() contentsUrl}
   *    .patch(String | null) // nullable {@link FileItem#patch() patch}
   *    .build();
   * </pre>
   * @return A new ImmutableFileItem builder
   */
  public static ImmutableFileItem.Builder builder() {
    return new ImmutableFileItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFileItem ImmutableFileItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FileItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SHA = 0x1L;
    private static final long INIT_BIT_FILENAME = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String sha;
    private @Nullable String filename;
    private @Nullable String status;
    private @Nullable Integer additions;
    private @Nullable Integer deletions;
    private @Nullable Integer changes;
    private @Nullable URI blobUrl;
    private @Nullable URI rawUrl;
    private @Nullable URI contentsUrl;
    private @Nullable String patch;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FileItem} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FileItem instance) {
      Objects.requireNonNull(instance, "instance");
      sha(instance.sha());
      filename(instance.filename());
      @Nullable String statusValue = instance.status();
      if (statusValue != null) {
        status(statusValue);
      }
      @Nullable Integer additionsValue = instance.additions();
      if (additionsValue != null) {
        additions(additionsValue);
      }
      @Nullable Integer deletionsValue = instance.deletions();
      if (deletionsValue != null) {
        deletions(deletionsValue);
      }
      @Nullable Integer changesValue = instance.changes();
      if (changesValue != null) {
        changes(changesValue);
      }
      @Nullable URI blobUrlValue = instance.blobUrl();
      if (blobUrlValue != null) {
        blobUrl(blobUrlValue);
      }
      @Nullable URI rawUrlValue = instance.rawUrl();
      if (rawUrlValue != null) {
        rawUrl(rawUrlValue);
      }
      @Nullable URI contentsUrlValue = instance.contentsUrl();
      if (contentsUrlValue != null) {
        contentsUrl(contentsUrlValue);
      }
      @Nullable String patchValue = instance.patch();
      if (patchValue != null) {
        patch(patchValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FileItem#sha() sha} attribute.
     * @param sha The value for sha 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(String sha) {
      this.sha = Objects.requireNonNull(sha, "sha");
      initBits &= ~INIT_BIT_SHA;
      return this;
    }

    /**
     * Initializes the value for the {@link FileItem#filename() filename} attribute.
     * @param filename The value for filename 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder filename(String filename) {
      this.filename = Objects.requireNonNull(filename, "filename");
      initBits &= ~INIT_BIT_FILENAME;
      return this;
    }

    /**
     * Initializes the value for the {@link FileItem#status() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder status(@Nullable String status) {
      this.status = status;
      return this;
    }

    /**
     * Initializes the value for the {@link FileItem#additions() additions} attribute.
     * @param additions The value for additions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder additions(@Nullable Integer additions) {
      this.additions = additions;
      return this;
    }

    /**
     * Initializes the value for the {@link FileItem#deletions() deletions} attribute.
     * @param deletions The value for deletions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder deletions(@Nullable Integer deletions) {
      this.deletions = deletions;
      return this;
    }

    /**
     * Initializes the value for the {@link FileItem#changes() changes} attribute.
     * @param changes The value for changes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder changes(@Nullable Integer changes) {
      this.changes = changes;
      return this;
    }

    /**
     * Initializes the value for the {@link FileItem#blobUrl() blobUrl} attribute.
     * @param blobUrl The value for blobUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("blob_url")
    public final Builder blobUrl(@Nullable URI blobUrl) {
      this.blobUrl = blobUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link FileItem#rawUrl() rawUrl} attribute.
     * @param rawUrl The value for rawUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("raw_url")
    public final Builder rawUrl(@Nullable URI rawUrl) {
      this.rawUrl = rawUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link FileItem#contentsUrl() contentsUrl} attribute.
     * @param contentsUrl The value for contentsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("contents_url")
    public final Builder contentsUrl(@Nullable URI contentsUrl) {
      this.contentsUrl = contentsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link FileItem#patch() patch} attribute.
     * @param patch The value for patch (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder patch(@Nullable String patch) {
      this.patch = patch;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFileItem ImmutableFileItem}.
     * @return An immutable instance of FileItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFileItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFileItem(sha, filename, status, additions, deletions, changes, blobUrl, rawUrl, contentsUrl, patch);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SHA) != 0) attributes.add("sha");
      if ((initBits & INIT_BIT_FILENAME) != 0) attributes.add("filename");
      return "Cannot build FileItem, some of required attributes are not set " + attributes;
    }
  }
}
