package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Reference}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReference.builder()}.
 */
@Generated(from = "Reference", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReference implements Reference {
  private final @Nullable String ref;
  private final @Nullable URI url;
  private final @Nullable ReferenceObject object;

  private ImmutableReference(
      @Nullable String ref,
      @Nullable URI url,
      @Nullable ReferenceObject object) {
    this.ref = ref;
    this.url = url;
    this.object = object;
  }

  /**
   *Full reference path. E.g. lrefs/heads/featureA. 
   */
  @JsonProperty
  @Override
  public @Nullable String ref() {
    return ref;
  }

  /**
   *Reference API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Reference object. 
   */
  @JsonProperty
  @Override
  public @Nullable ReferenceObject object() {
    return object;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Reference#ref() ref} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ref (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReference withRef(@Nullable String value) {
    if (Objects.equals(this.ref, value)) return this;
    return new ImmutableReference(value, this.url, this.object);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Reference#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReference withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableReference(this.ref, value, this.object);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Reference#object() object} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for object (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReference withObject(@Nullable ReferenceObject value) {
    if (this.object == value) return this;
    return new ImmutableReference(this.ref, this.url, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReference} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReference
        && equalTo(0, (ImmutableReference) another);
  }

  private boolean equalTo(int synthetic, ImmutableReference another) {
    return Objects.equals(ref, another.ref)
        && Objects.equals(url, another.url)
        && Objects.equals(object, another.object);
  }

  /**
   * Computes a hash code from attributes: {@code ref}, {@code url}, {@code object}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(ref);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(object);
    return h;
  }

  /**
   * Prints the immutable value {@code Reference} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Reference{"
        + "ref=" + ref
        + ", url=" + url
        + ", object=" + object
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Reference", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Reference {
    @Nullable String ref;
    @Nullable URI url;
    @Nullable ReferenceObject object;
    @JsonProperty
    public void setRef(@Nullable String ref) {
      this.ref = ref;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setObject(@Nullable ReferenceObject object) {
      this.object = object;
    }
    @Override
    public String ref() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public ReferenceObject object() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableReference fromJson(Json json) {
    ImmutableReference.Builder builder = ImmutableReference.builder();
    if (json.ref != null) {
      builder.ref(json.ref);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.object != null) {
      builder.object(json.object);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Reference} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Reference instance
   */
  public static ImmutableReference copyOf(Reference instance) {
    if (instance instanceof ImmutableReference) {
      return (ImmutableReference) instance;
    }
    return ImmutableReference.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReference ImmutableReference}.
   * <pre>
   * ImmutableReference.builder()
   *    .ref(String | null) // nullable {@link Reference#ref() ref}
   *    .url(java.net.URI | null) // nullable {@link Reference#url() url}
   *    .object(com.spotify.github.v3.git.ReferenceObject | null) // nullable {@link Reference#object() object}
   *    .build();
   * </pre>
   * @return A new ImmutableReference builder
   */
  public static ImmutableReference.Builder builder() {
    return new ImmutableReference.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReference ImmutableReference}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Reference", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String ref;
    private @Nullable URI url;
    private @Nullable ReferenceObject object;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Reference} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Reference instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String refValue = instance.ref();
      if (refValue != null) {
        ref(refValue);
      }
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable ReferenceObject objectValue = instance.object();
      if (objectValue != null) {
        object(objectValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Reference#ref() ref} attribute.
     * @param ref The value for ref (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder ref(@Nullable String ref) {
      this.ref = ref;
      return this;
    }

    /**
     * Initializes the value for the {@link Reference#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Reference#object() object} attribute.
     * @param object The value for object (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder object(@Nullable ReferenceObject object) {
      this.object = object;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReference ImmutableReference}.
     * @return An immutable instance of Reference
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReference build() {
      return new ImmutableReference(ref, url, object);
    }
  }
}
