package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StatItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStatItem.builder()}.
 */
@Generated(from = "StatItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStatItem implements StatItem {
  private final @Nullable Integer total;
  private final @Nullable Integer additions;
  private final @Nullable Integer deletions;

  private ImmutableStatItem(
      @Nullable Integer total,
      @Nullable Integer additions,
      @Nullable Integer deletions) {
    this.total = total;
    this.additions = additions;
    this.deletions = deletions;
  }

  /**
   * @return The value of the {@code total} attribute
   */
  @JsonProperty
  @Override
  public @Nullable Integer total() {
    return total;
  }

  /**
   * @return The value of the {@code additions} attribute
   */
  @JsonProperty
  @Override
  public @Nullable Integer additions() {
    return additions;
  }

  /**
   * @return The value of the {@code deletions} attribute
   */
  @JsonProperty
  @Override
  public @Nullable Integer deletions() {
    return deletions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatItem#total() total} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for total (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatItem withTotal(@Nullable Integer value) {
    if (Objects.equals(this.total, value)) return this;
    return new ImmutableStatItem(value, this.additions, this.deletions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatItem#additions() additions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for additions (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatItem withAdditions(@Nullable Integer value) {
    if (Objects.equals(this.additions, value)) return this;
    return new ImmutableStatItem(this.total, value, this.deletions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatItem#deletions() deletions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deletions (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatItem withDeletions(@Nullable Integer value) {
    if (Objects.equals(this.deletions, value)) return this;
    return new ImmutableStatItem(this.total, this.additions, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStatItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStatItem
        && equalTo(0, (ImmutableStatItem) another);
  }

  private boolean equalTo(int synthetic, ImmutableStatItem another) {
    return Objects.equals(total, another.total)
        && Objects.equals(additions, another.additions)
        && Objects.equals(deletions, another.deletions);
  }

  /**
   * Computes a hash code from attributes: {@code total}, {@code additions}, {@code deletions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(total);
    h += (h << 5) + Objects.hashCode(additions);
    h += (h << 5) + Objects.hashCode(deletions);
    return h;
  }

  /**
   * Prints the immutable value {@code StatItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StatItem{"
        + "total=" + total
        + ", additions=" + additions
        + ", deletions=" + deletions
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StatItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StatItem {
    @Nullable Integer total;
    @Nullable Integer additions;
    @Nullable Integer deletions;
    @JsonProperty
    public void setTotal(@Nullable Integer total) {
      this.total = total;
    }
    @JsonProperty
    public void setAdditions(@Nullable Integer additions) {
      this.additions = additions;
    }
    @JsonProperty
    public void setDeletions(@Nullable Integer deletions) {
      this.deletions = deletions;
    }
    @Override
    public Integer total() { throw new UnsupportedOperationException(); }
    @Override
    public Integer additions() { throw new UnsupportedOperationException(); }
    @Override
    public Integer deletions() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStatItem fromJson(Json json) {
    ImmutableStatItem.Builder builder = ImmutableStatItem.builder();
    if (json.total != null) {
      builder.total(json.total);
    }
    if (json.additions != null) {
      builder.additions(json.additions);
    }
    if (json.deletions != null) {
      builder.deletions(json.deletions);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StatItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StatItem instance
   */
  public static ImmutableStatItem copyOf(StatItem instance) {
    if (instance instanceof ImmutableStatItem) {
      return (ImmutableStatItem) instance;
    }
    return ImmutableStatItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStatItem ImmutableStatItem}.
   * <pre>
   * ImmutableStatItem.builder()
   *    .total(Integer | null) // nullable {@link StatItem#total() total}
   *    .additions(Integer | null) // nullable {@link StatItem#additions() additions}
   *    .deletions(Integer | null) // nullable {@link StatItem#deletions() deletions}
   *    .build();
   * </pre>
   * @return A new ImmutableStatItem builder
   */
  public static ImmutableStatItem.Builder builder() {
    return new ImmutableStatItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStatItem ImmutableStatItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StatItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer total;
    private @Nullable Integer additions;
    private @Nullable Integer deletions;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StatItem} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StatItem instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer totalValue = instance.total();
      if (totalValue != null) {
        total(totalValue);
      }
      @Nullable Integer additionsValue = instance.additions();
      if (additionsValue != null) {
        additions(additionsValue);
      }
      @Nullable Integer deletionsValue = instance.deletions();
      if (deletionsValue != null) {
        deletions(deletionsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link StatItem#total() total} attribute.
     * @param total The value for total (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder total(@Nullable Integer total) {
      this.total = total;
      return this;
    }

    /**
     * Initializes the value for the {@link StatItem#additions() additions} attribute.
     * @param additions The value for additions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder additions(@Nullable Integer additions) {
      this.additions = additions;
      return this;
    }

    /**
     * Initializes the value for the {@link StatItem#deletions() deletions} attribute.
     * @param deletions The value for deletions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder deletions(@Nullable Integer deletions) {
      this.deletions = deletions;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStatItem ImmutableStatItem}.
     * @return An immutable instance of StatItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStatItem build() {
      return new ImmutableStatItem(total, additions, deletions);
    }
  }
}
