package com.spotify.github.v3.hooks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WebhookConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWebhookConfig.builder()}.
 */
@Generated(from = "WebhookConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWebhookConfig implements WebhookConfig {
  private final @Nullable URI url;
  private final @Nullable String contentType;

  private ImmutableWebhookConfig(
      @Nullable URI url,
      @Nullable String contentType) {
    this.url = url;
    this.contentType = contentType;
  }

  /**
   *A required string defining the URL to which the payloads will be delivered. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   * An optional string defining the media type used to serialize the payloads. Supported values
   * include json and form. The default is form.
   */
  @JsonProperty
  @Override
  public @Nullable String contentType() {
    return contentType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookConfig#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhookConfig withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableWebhookConfig(value, this.contentType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookConfig#contentType() contentType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhookConfig withContentType(@Nullable String value) {
    if (Objects.equals(this.contentType, value)) return this;
    return new ImmutableWebhookConfig(this.url, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWebhookConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWebhookConfig
        && equalTo(0, (ImmutableWebhookConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableWebhookConfig another) {
    return Objects.equals(url, another.url)
        && Objects.equals(contentType, another.contentType);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code contentType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(contentType);
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookConfig{"
        + "url=" + url
        + ", contentType=" + contentType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "WebhookConfig", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements WebhookConfig {
    @Nullable URI url;
    @Nullable String contentType;
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setContentType(@Nullable String contentType) {
      this.contentType = contentType;
    }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public String contentType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableWebhookConfig fromJson(Json json) {
    ImmutableWebhookConfig.Builder builder = ImmutableWebhookConfig.builder();
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.contentType != null) {
      builder.contentType(json.contentType);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link WebhookConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookConfig instance
   */
  public static ImmutableWebhookConfig copyOf(WebhookConfig instance) {
    if (instance instanceof ImmutableWebhookConfig) {
      return (ImmutableWebhookConfig) instance;
    }
    return ImmutableWebhookConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWebhookConfig ImmutableWebhookConfig}.
   * <pre>
   * ImmutableWebhookConfig.builder()
   *    .url(java.net.URI | null) // nullable {@link WebhookConfig#url() url}
   *    .contentType(String | null) // nullable {@link WebhookConfig#contentType() contentType}
   *    .build();
   * </pre>
   * @return A new ImmutableWebhookConfig builder
   */
  public static ImmutableWebhookConfig.Builder builder() {
    return new ImmutableWebhookConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWebhookConfig ImmutableWebhookConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WebhookConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable URI url;
    private @Nullable String contentType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WebhookConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WebhookConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable String contentTypeValue = instance.contentType();
      if (contentTypeValue != null) {
        contentType(contentTypeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link WebhookConfig#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link WebhookConfig#contentType() contentType} attribute.
     * @param contentType The value for contentType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder contentType(@Nullable String contentType) {
      this.contentType = contentType;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWebhookConfig ImmutableWebhookConfig}.
     * @return An immutable instance of WebhookConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWebhookConfig build() {
      return new ImmutableWebhookConfig(url, contentType);
    }
  }
}
