package com.spotify.github.v3.issues.changes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Changes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableChanges.builder()}.
 */
@Generated(from = "Changes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableChanges implements Changes {
  private final @Nullable Body body;

  private ImmutableChanges(@Nullable Body body) {
    this.body = body;
  }

  /**
   * The previous version of the body if the action was "edited".
   * @return The previous version of the body if the action was "edited".
   */
  @JsonProperty
  @Override
  public @Nullable Body body() {
    return body;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Changes#body() body} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableChanges withBody(@Nullable Body value) {
    if (this.body == value) return this;
    return new ImmutableChanges(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableChanges} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableChanges
        && equalTo(0, (ImmutableChanges) another);
  }

  private boolean equalTo(int synthetic, ImmutableChanges another) {
    return Objects.equals(body, another.body);
  }

  /**
   * Computes a hash code from attributes: {@code body}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(body);
    return h;
  }

  /**
   * Prints the immutable value {@code Changes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Changes{"
        + "body=" + body
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Changes", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Changes {
    @Nullable Body body;
    @JsonProperty
    public void setBody(@Nullable Body body) {
      this.body = body;
    }
    @Override
    public Body body() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableChanges fromJson(Json json) {
    ImmutableChanges.Builder builder = ImmutableChanges.builder();
    if (json.body != null) {
      builder.body(json.body);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Changes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Changes instance
   */
  public static ImmutableChanges copyOf(Changes instance) {
    if (instance instanceof ImmutableChanges) {
      return (ImmutableChanges) instance;
    }
    return ImmutableChanges.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableChanges ImmutableChanges}.
   * <pre>
   * ImmutableChanges.builder()
   *    .body(com.spotify.github.v3.issues.changes.Body | null) // nullable {@link Changes#body() body}
   *    .build();
   * </pre>
   * @return A new ImmutableChanges builder
   */
  public static ImmutableChanges.Builder builder() {
    return new ImmutableChanges.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableChanges ImmutableChanges}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Changes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Body body;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Changes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Changes instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Body bodyValue = instance.body();
      if (bodyValue != null) {
        body(bodyValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Changes#body() body} attribute.
     * @param body The value for body (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(@Nullable Body body) {
      this.body = body;
      return this;
    }

    /**
     * Builds a new {@link ImmutableChanges ImmutableChanges}.
     * @return An immutable instance of Changes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableChanges build() {
      return new ImmutableChanges(body);
    }
  }
}
