package com.spotify.github.v3.orgs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TeamCreate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTeamCreate.builder()}.
 */
@Generated(from = "TeamCreate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTeamCreate implements TeamCreate {
  private final String name;
  private final @Nullable String description;
  private final @Nullable String privacy;
  private final @Nullable String notificationSetting;
  private final @Nullable List<String> maintainers;
  private final @Nullable List<String> repoNames;
  private final @Nullable Integer parentTeamId;

  private ImmutableTeamCreate(
      String name,
      @Nullable String description,
      @Nullable String privacy,
      @Nullable String notificationSetting,
      @Nullable List<String> maintainers,
      @Nullable List<String> repoNames,
      @Nullable Integer parentTeamId) {
    this.name = name;
    this.description = description;
    this.privacy = privacy;
    this.notificationSetting = notificationSetting;
    this.maintainers = maintainers;
    this.repoNames = repoNames;
    this.parentTeamId = parentTeamId;
  }

  /**
   *The name of the team. 
   */
  @JsonProperty
  @Override
  public String name() {
    return name;
  }

  /**
   *The description of the team. 
   */
  @JsonProperty
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   * The level of privacy this team should have. For a non-nested team: secret - only visible to
   * organization owners and members of this team. closed - visible to all members of this
   * organization. Default: secret For a parent or child team: closed - visible to all members of
   * this organization. Default for child team: closed Can be one of: secret, closed
   */
  @JsonProperty
  @Override
  public Optional<String> privacy() {
    return Optional.ofNullable(privacy);
  }

  /**
   * The notification setting the team has chosen. The options are:
   * <p>notifications_enabled - team members receive notifications when the team is @mentioned.
   * <p>notifications_disabled - no one receives notifications.
   * <p>Default: notifications_enabled
   * <p>Can be one of: notifications_enabled, notifications_disabled
   */
  @JsonProperty("notification_setting")
  @Override
  public Optional<String> notificationSetting() {
    return Optional.ofNullable(notificationSetting);
  }

  /**
   *List GitHub IDs for organization members who will become team maintainers. 
   */
  @JsonProperty
  @Override
  public Optional<List<String>> maintainers() {
    return Optional.ofNullable(maintainers);
  }

  /**
   * The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
   */
  @JsonProperty("repo_names")
  @Override
  public Optional<List<String>> repoNames() {
    return Optional.ofNullable(repoNames);
  }

  /**
   *The ID of a team to set as the parent team. 
   */
  @JsonProperty("parent_team_id")
  @Override
  public Optional<Integer> parentTeamId() {
    return Optional.ofNullable(parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamCreate#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamCreate withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTeamCreate(
        newValue,
        this.description,
        this.privacy,
        this.notificationSetting,
        this.maintainers,
        this.repoNames,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TeamCreate#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamCreate withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableTeamCreate(
        this.name,
        newValue,
        this.privacy,
        this.notificationSetting,
        this.maintainers,
        this.repoNames,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TeamCreate#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamCreate withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableTeamCreate(
        this.name,
        value,
        this.privacy,
        this.notificationSetting,
        this.maintainers,
        this.repoNames,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TeamCreate#privacy() privacy} attribute.
   * @param value The value for privacy
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamCreate withPrivacy(String value) {
    String newValue = Objects.requireNonNull(value, "privacy");
    if (Objects.equals(this.privacy, newValue)) return this;
    return new ImmutableTeamCreate(
        this.name,
        this.description,
        newValue,
        this.notificationSetting,
        this.maintainers,
        this.repoNames,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TeamCreate#privacy() privacy} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for privacy
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamCreate withPrivacy(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.privacy, value)) return this;
    return new ImmutableTeamCreate(
        this.name,
        this.description,
        value,
        this.notificationSetting,
        this.maintainers,
        this.repoNames,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TeamCreate#notificationSetting() notificationSetting} attribute.
   * @param value The value for notificationSetting
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamCreate withNotificationSetting(String value) {
    String newValue = Objects.requireNonNull(value, "notificationSetting");
    if (Objects.equals(this.notificationSetting, newValue)) return this;
    return new ImmutableTeamCreate(
        this.name,
        this.description,
        this.privacy,
        newValue,
        this.maintainers,
        this.repoNames,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TeamCreate#notificationSetting() notificationSetting} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notificationSetting
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamCreate withNotificationSetting(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.notificationSetting, value)) return this;
    return new ImmutableTeamCreate(
        this.name,
        this.description,
        this.privacy,
        value,
        this.maintainers,
        this.repoNames,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TeamCreate#maintainers() maintainers} attribute.
   * @param value The value for maintainers
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamCreate withMaintainers(List<String> value) {
    List<String> newValue = Objects.requireNonNull(value, "maintainers");
    if (this.maintainers == newValue) return this;
    return new ImmutableTeamCreate(
        this.name,
        this.description,
        this.privacy,
        this.notificationSetting,
        newValue,
        this.repoNames,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TeamCreate#maintainers() maintainers} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for maintainers
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableTeamCreate withMaintainers(Optional<? extends List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.maintainers == value) return this;
    return new ImmutableTeamCreate(
        this.name,
        this.description,
        this.privacy,
        this.notificationSetting,
        value,
        this.repoNames,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TeamCreate#repoNames() repoNames} attribute.
   * @param value The value for repoNames
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamCreate withRepoNames(List<String> value) {
    List<String> newValue = Objects.requireNonNull(value, "repoNames");
    if (this.repoNames == newValue) return this;
    return new ImmutableTeamCreate(
        this.name,
        this.description,
        this.privacy,
        this.notificationSetting,
        this.maintainers,
        newValue,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TeamCreate#repoNames() repoNames} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for repoNames
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableTeamCreate withRepoNames(Optional<? extends List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.repoNames == value) return this;
    return new ImmutableTeamCreate(
        this.name,
        this.description,
        this.privacy,
        this.notificationSetting,
        this.maintainers,
        value,
        this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TeamCreate#parentTeamId() parentTeamId} attribute.
   * @param value The value for parentTeamId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamCreate withParentTeamId(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.parentTeamId, newValue)) return this;
    return new ImmutableTeamCreate(
        this.name,
        this.description,
        this.privacy,
        this.notificationSetting,
        this.maintainers,
        this.repoNames,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TeamCreate#parentTeamId() parentTeamId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for parentTeamId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamCreate withParentTeamId(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.parentTeamId, value)) return this;
    return new ImmutableTeamCreate(
        this.name,
        this.description,
        this.privacy,
        this.notificationSetting,
        this.maintainers,
        this.repoNames,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTeamCreate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTeamCreate
        && equalTo(0, (ImmutableTeamCreate) another);
  }

  private boolean equalTo(int synthetic, ImmutableTeamCreate another) {
    return name.equals(another.name)
        && Objects.equals(description, another.description)
        && Objects.equals(privacy, another.privacy)
        && Objects.equals(notificationSetting, another.notificationSetting)
        && Objects.equals(maintainers, another.maintainers)
        && Objects.equals(repoNames, another.repoNames)
        && Objects.equals(parentTeamId, another.parentTeamId);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}, {@code privacy}, {@code notificationSetting}, {@code maintainers}, {@code repoNames}, {@code parentTeamId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(privacy);
    h += (h << 5) + Objects.hashCode(notificationSetting);
    h += (h << 5) + Objects.hashCode(maintainers);
    h += (h << 5) + Objects.hashCode(repoNames);
    h += (h << 5) + Objects.hashCode(parentTeamId);
    return h;
  }

  /**
   * Prints the immutable value {@code TeamCreate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("TeamCreate{");
    builder.append("name=").append(name);
    if (description != null) {
      builder.append(", ");
      builder.append("description=").append(description);
    }
    if (privacy != null) {
      builder.append(", ");
      builder.append("privacy=").append(privacy);
    }
    if (notificationSetting != null) {
      builder.append(", ");
      builder.append("notificationSetting=").append(notificationSetting);
    }
    if (maintainers != null) {
      builder.append(", ");
      builder.append("maintainers=").append(maintainers);
    }
    if (repoNames != null) {
      builder.append(", ");
      builder.append("repoNames=").append(repoNames);
    }
    if (parentTeamId != null) {
      builder.append(", ");
      builder.append("parentTeamId=").append(parentTeamId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TeamCreate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TeamCreate {
    @Nullable String name;
    @Nullable Optional<String> description = Optional.empty();
    @Nullable Optional<String> privacy = Optional.empty();
    @Nullable Optional<String> notificationSetting = Optional.empty();
    @Nullable Optional<List<String>> maintainers = Optional.empty();
    @Nullable Optional<List<String>> repoNames = Optional.empty();
    @Nullable Optional<Integer> parentTeamId = Optional.empty();
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty
    public void setPrivacy(Optional<String> privacy) {
      this.privacy = privacy;
    }
    @JsonProperty("notification_setting")
    public void setNotificationSetting(Optional<String> notificationSetting) {
      this.notificationSetting = notificationSetting;
    }
    @JsonProperty
    public void setMaintainers(Optional<List<String>> maintainers) {
      this.maintainers = maintainers;
    }
    @JsonProperty("repo_names")
    public void setRepoNames(Optional<List<String>> repoNames) {
      this.repoNames = repoNames;
    }
    @JsonProperty("parent_team_id")
    public void setParentTeamId(Optional<Integer> parentTeamId) {
      this.parentTeamId = parentTeamId;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> privacy() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> notificationSetting() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<String>> maintainers() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<String>> repoNames() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> parentTeamId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTeamCreate fromJson(Json json) {
    ImmutableTeamCreate.Builder builder = ImmutableTeamCreate.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.privacy != null) {
      builder.privacy(json.privacy);
    }
    if (json.notificationSetting != null) {
      builder.notificationSetting(json.notificationSetting);
    }
    if (json.maintainers != null) {
      builder.maintainers(json.maintainers);
    }
    if (json.repoNames != null) {
      builder.repoNames(json.repoNames);
    }
    if (json.parentTeamId != null) {
      builder.parentTeamId(json.parentTeamId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TeamCreate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TeamCreate instance
   */
  public static ImmutableTeamCreate copyOf(TeamCreate instance) {
    if (instance instanceof ImmutableTeamCreate) {
      return (ImmutableTeamCreate) instance;
    }
    return ImmutableTeamCreate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTeamCreate ImmutableTeamCreate}.
   * <pre>
   * ImmutableTeamCreate.builder()
   *    .name(String) // required {@link TeamCreate#name() name}
   *    .description(String) // optional {@link TeamCreate#description() description}
   *    .privacy(String) // optional {@link TeamCreate#privacy() privacy}
   *    .notificationSetting(String) // optional {@link TeamCreate#notificationSetting() notificationSetting}
   *    .maintainers(List&amp;lt;String&amp;gt;) // optional {@link TeamCreate#maintainers() maintainers}
   *    .repoNames(List&amp;lt;String&amp;gt;) // optional {@link TeamCreate#repoNames() repoNames}
   *    .parentTeamId(Integer) // optional {@link TeamCreate#parentTeamId() parentTeamId}
   *    .build();
   * </pre>
   * @return A new ImmutableTeamCreate builder
   */
  public static ImmutableTeamCreate.Builder builder() {
    return new ImmutableTeamCreate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTeamCreate ImmutableTeamCreate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TeamCreate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable String description;
    private @Nullable String privacy;
    private @Nullable String notificationSetting;
    private @Nullable List<String> maintainers;
    private @Nullable List<String> repoNames;
    private @Nullable Integer parentTeamId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TeamCreate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TeamCreate instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      Optional<String> descriptionOptional = instance.description();
      if (descriptionOptional.isPresent()) {
        description(descriptionOptional);
      }
      Optional<String> privacyOptional = instance.privacy();
      if (privacyOptional.isPresent()) {
        privacy(privacyOptional);
      }
      Optional<String> notificationSettingOptional = instance.notificationSetting();
      if (notificationSettingOptional.isPresent()) {
        notificationSetting(notificationSettingOptional);
      }
      Optional<List<String>> maintainersOptional = instance.maintainers();
      if (maintainersOptional.isPresent()) {
        maintainers(maintainersOptional);
      }
      Optional<List<String>> repoNamesOptional = instance.repoNames();
      if (repoNamesOptional.isPresent()) {
        repoNames(repoNamesOptional);
      }
      Optional<Integer> parentTeamIdOptional = instance.parentTeamId();
      if (parentTeamIdOptional.isPresent()) {
        parentTeamId(parentTeamIdOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TeamCreate#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#privacy() privacy} to privacy.
     * @param privacy The value for privacy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder privacy(String privacy) {
      this.privacy = Objects.requireNonNull(privacy, "privacy");
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#privacy() privacy} to privacy.
     * @param privacy The value for privacy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder privacy(Optional<String> privacy) {
      this.privacy = privacy.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#notificationSetting() notificationSetting} to notificationSetting.
     * @param notificationSetting The value for notificationSetting
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder notificationSetting(String notificationSetting) {
      this.notificationSetting = Objects.requireNonNull(notificationSetting, "notificationSetting");
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#notificationSetting() notificationSetting} to notificationSetting.
     * @param notificationSetting The value for notificationSetting
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("notification_setting")
    public final Builder notificationSetting(Optional<String> notificationSetting) {
      this.notificationSetting = notificationSetting.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#maintainers() maintainers} to maintainers.
     * @param maintainers The value for maintainers
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder maintainers(List<String> maintainers) {
      this.maintainers = Objects.requireNonNull(maintainers, "maintainers");
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#maintainers() maintainers} to maintainers.
     * @param maintainers The value for maintainers
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder maintainers(Optional<? extends List<String>> maintainers) {
      this.maintainers = maintainers.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#repoNames() repoNames} to repoNames.
     * @param repoNames The value for repoNames
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repoNames(List<String> repoNames) {
      this.repoNames = Objects.requireNonNull(repoNames, "repoNames");
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#repoNames() repoNames} to repoNames.
     * @param repoNames The value for repoNames
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("repo_names")
    public final Builder repoNames(Optional<? extends List<String>> repoNames) {
      this.repoNames = repoNames.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#parentTeamId() parentTeamId} to parentTeamId.
     * @param parentTeamId The value for parentTeamId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parentTeamId(int parentTeamId) {
      this.parentTeamId = parentTeamId;
      return this;
    }

    /**
     * Initializes the optional value {@link TeamCreate#parentTeamId() parentTeamId} to parentTeamId.
     * @param parentTeamId The value for parentTeamId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parent_team_id")
    public final Builder parentTeamId(Optional<Integer> parentTeamId) {
      this.parentTeamId = parentTeamId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTeamCreate ImmutableTeamCreate}.
     * @return An immutable instance of TeamCreate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTeamCreate build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTeamCreate(name, description, privacy, notificationSetting, maintainers, repoNames, parentTeamId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build TeamCreate, some of required attributes are not set " + attributes;
    }
  }
}
