package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.Links;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequestLinks}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequestLinks.builder()}.
 */
@Generated(from = "PullRequestLinks", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequestLinks implements PullRequestLinks {
  private final @Nullable Links.Href<URI> self;
  private final @Nullable Links.Href<URI> html;
  private final @Nullable Links.Href<URI> issue;
  private final @Nullable Links.Href<URI> comments;
  private final @Nullable Links.Href<String> reviewComment;
  private final @Nullable Links.Href<URI> reviewComments;
  private final @Nullable Links.Href<URI> commits;
  private final @Nullable Links.Href<URI> statuses;

  private ImmutablePullRequestLinks(
      @Nullable Links.Href<URI> self,
      @Nullable Links.Href<URI> html,
      @Nullable Links.Href<URI> issue,
      @Nullable Links.Href<URI> comments,
      @Nullable Links.Href<String> reviewComment,
      @Nullable Links.Href<URI> reviewComments,
      @Nullable Links.Href<URI> commits,
      @Nullable Links.Href<URI> statuses) {
    this.self = self;
    this.html = html;
    this.issue = issue;
    this.comments = comments;
    this.reviewComment = reviewComment;
    this.reviewComments = reviewComments;
    this.commits = commits;
    this.statuses = statuses;
  }

  /**
   * Link to this entity in the API.
   * @return The link to the API of this entity
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> self() {
    return self;
  }

  /**
   * Link to the HTML representaion of this item.
   * @return The link to the HTML representation of this entity
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> html() {
    return html;
  }

  /**
   *API link to the pull request. 
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> issue() {
    return issue;
  }

  /**
   *API link to the comments on this pull request. {@link Comment} 
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> comments() {
    return comments;
  }

  /**
   *API link template to a specific review comments on this pull request. 
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<String> reviewComment() {
    return reviewComment;
  }

  /**
   *API link to the review comments on this pull request. {@link Comment} 
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> reviewComments() {
    return reviewComments;
  }

  /**
   * API link to the commits on this pull request. {@link com.spotify.github.v3.repos.CommitItem}
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> commits() {
    return commits;
  }

  /**
   *API link to the statuses on this pull request. {@link com.spotify.github.v3.repos.Status} 
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> statuses() {
    return statuses;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestLinks#self() self} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for self (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestLinks withSelf(@Nullable Links.Href<URI> value) {
    if (this.self == value) return this;
    return new ImmutablePullRequestLinks(
        value,
        this.html,
        this.issue,
        this.comments,
        this.reviewComment,
        this.reviewComments,
        this.commits,
        this.statuses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestLinks#html() html} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for html (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestLinks withHtml(@Nullable Links.Href<URI> value) {
    if (this.html == value) return this;
    return new ImmutablePullRequestLinks(
        this.self,
        value,
        this.issue,
        this.comments,
        this.reviewComment,
        this.reviewComments,
        this.commits,
        this.statuses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestLinks#issue() issue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for issue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestLinks withIssue(@Nullable Links.Href<URI> value) {
    if (this.issue == value) return this;
    return new ImmutablePullRequestLinks(
        this.self,
        this.html,
        value,
        this.comments,
        this.reviewComment,
        this.reviewComments,
        this.commits,
        this.statuses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestLinks#comments() comments} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comments (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestLinks withComments(@Nullable Links.Href<URI> value) {
    if (this.comments == value) return this;
    return new ImmutablePullRequestLinks(
        this.self,
        this.html,
        this.issue,
        value,
        this.reviewComment,
        this.reviewComments,
        this.commits,
        this.statuses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestLinks#reviewComment() reviewComment} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reviewComment (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestLinks withReviewComment(@Nullable Links.Href<String> value) {
    if (this.reviewComment == value) return this;
    return new ImmutablePullRequestLinks(
        this.self,
        this.html,
        this.issue,
        this.comments,
        value,
        this.reviewComments,
        this.commits,
        this.statuses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestLinks#reviewComments() reviewComments} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reviewComments (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestLinks withReviewComments(@Nullable Links.Href<URI> value) {
    if (this.reviewComments == value) return this;
    return new ImmutablePullRequestLinks(
        this.self,
        this.html,
        this.issue,
        this.comments,
        this.reviewComment,
        value,
        this.commits,
        this.statuses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestLinks#commits() commits} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commits (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestLinks withCommits(@Nullable Links.Href<URI> value) {
    if (this.commits == value) return this;
    return new ImmutablePullRequestLinks(
        this.self,
        this.html,
        this.issue,
        this.comments,
        this.reviewComment,
        this.reviewComments,
        value,
        this.statuses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestLinks#statuses() statuses} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for statuses (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestLinks withStatuses(@Nullable Links.Href<URI> value) {
    if (this.statuses == value) return this;
    return new ImmutablePullRequestLinks(
        this.self,
        this.html,
        this.issue,
        this.comments,
        this.reviewComment,
        this.reviewComments,
        this.commits,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequestLinks} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequestLinks
        && equalTo(0, (ImmutablePullRequestLinks) another);
  }

  private boolean equalTo(int synthetic, ImmutablePullRequestLinks another) {
    return Objects.equals(self, another.self)
        && Objects.equals(html, another.html)
        && Objects.equals(issue, another.issue)
        && Objects.equals(comments, another.comments)
        && Objects.equals(reviewComment, another.reviewComment)
        && Objects.equals(reviewComments, another.reviewComments)
        && Objects.equals(commits, another.commits)
        && Objects.equals(statuses, another.statuses);
  }

  /**
   * Computes a hash code from attributes: {@code self}, {@code html}, {@code issue}, {@code comments}, {@code reviewComment}, {@code reviewComments}, {@code commits}, {@code statuses}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(self);
    h += (h << 5) + Objects.hashCode(html);
    h += (h << 5) + Objects.hashCode(issue);
    h += (h << 5) + Objects.hashCode(comments);
    h += (h << 5) + Objects.hashCode(reviewComment);
    h += (h << 5) + Objects.hashCode(reviewComments);
    h += (h << 5) + Objects.hashCode(commits);
    h += (h << 5) + Objects.hashCode(statuses);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequestLinks} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PullRequestLinks{"
        + "self=" + self
        + ", html=" + html
        + ", issue=" + issue
        + ", comments=" + comments
        + ", reviewComment=" + reviewComment
        + ", reviewComments=" + reviewComments
        + ", commits=" + commits
        + ", statuses=" + statuses
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequestLinks", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequestLinks {
    @Nullable Links.Href<URI> self;
    @Nullable Links.Href<URI> html;
    @Nullable Links.Href<URI> issue;
    @Nullable Links.Href<URI> comments;
    @Nullable Links.Href<String> reviewComment;
    @Nullable Links.Href<URI> reviewComments;
    @Nullable Links.Href<URI> commits;
    @Nullable Links.Href<URI> statuses;
    @JsonProperty
    public void setSelf(@Nullable Links.Href<URI> self) {
      this.self = self;
    }
    @JsonProperty
    public void setHtml(@Nullable Links.Href<URI> html) {
      this.html = html;
    }
    @JsonProperty
    public void setIssue(@Nullable Links.Href<URI> issue) {
      this.issue = issue;
    }
    @JsonProperty
    public void setComments(@Nullable Links.Href<URI> comments) {
      this.comments = comments;
    }
    @JsonProperty
    public void setReviewComment(@Nullable Links.Href<String> reviewComment) {
      this.reviewComment = reviewComment;
    }
    @JsonProperty
    public void setReviewComments(@Nullable Links.Href<URI> reviewComments) {
      this.reviewComments = reviewComments;
    }
    @JsonProperty
    public void setCommits(@Nullable Links.Href<URI> commits) {
      this.commits = commits;
    }
    @JsonProperty
    public void setStatuses(@Nullable Links.Href<URI> statuses) {
      this.statuses = statuses;
    }
    @Override
    public Links.Href<URI> self() { throw new UnsupportedOperationException(); }
    @Override
    public Links.Href<URI> html() { throw new UnsupportedOperationException(); }
    @Override
    public Links.Href<URI> issue() { throw new UnsupportedOperationException(); }
    @Override
    public Links.Href<URI> comments() { throw new UnsupportedOperationException(); }
    @Override
    public Links.Href<String> reviewComment() { throw new UnsupportedOperationException(); }
    @Override
    public Links.Href<URI> reviewComments() { throw new UnsupportedOperationException(); }
    @Override
    public Links.Href<URI> commits() { throw new UnsupportedOperationException(); }
    @Override
    public Links.Href<URI> statuses() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequestLinks fromJson(Json json) {
    ImmutablePullRequestLinks.Builder builder = ImmutablePullRequestLinks.builder();
    if (json.self != null) {
      builder.self(json.self);
    }
    if (json.html != null) {
      builder.html(json.html);
    }
    if (json.issue != null) {
      builder.issue(json.issue);
    }
    if (json.comments != null) {
      builder.comments(json.comments);
    }
    if (json.reviewComment != null) {
      builder.reviewComment(json.reviewComment);
    }
    if (json.reviewComments != null) {
      builder.reviewComments(json.reviewComments);
    }
    if (json.commits != null) {
      builder.commits(json.commits);
    }
    if (json.statuses != null) {
      builder.statuses(json.statuses);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequestLinks} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequestLinks instance
   */
  public static ImmutablePullRequestLinks copyOf(PullRequestLinks instance) {
    if (instance instanceof ImmutablePullRequestLinks) {
      return (ImmutablePullRequestLinks) instance;
    }
    return ImmutablePullRequestLinks.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequestLinks ImmutablePullRequestLinks}.
   * <pre>
   * ImmutablePullRequestLinks.builder()
   *    .self(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link PullRequestLinks#self() self}
   *    .html(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link PullRequestLinks#html() html}
   *    .issue(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link PullRequestLinks#issue() issue}
   *    .comments(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link PullRequestLinks#comments() comments}
   *    .reviewComment(com.spotify.github.Links.Href&amp;lt;String&amp;gt; | null) // nullable {@link PullRequestLinks#reviewComment() reviewComment}
   *    .reviewComments(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link PullRequestLinks#reviewComments() reviewComments}
   *    .commits(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link PullRequestLinks#commits() commits}
   *    .statuses(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link PullRequestLinks#statuses() statuses}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequestLinks builder
   */
  public static ImmutablePullRequestLinks.Builder builder() {
    return new ImmutablePullRequestLinks.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequestLinks ImmutablePullRequestLinks}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequestLinks", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Links.Href<URI> self;
    private @Nullable Links.Href<URI> html;
    private @Nullable Links.Href<URI> issue;
    private @Nullable Links.Href<URI> comments;
    private @Nullable Links.Href<String> reviewComment;
    private @Nullable Links.Href<URI> reviewComments;
    private @Nullable Links.Href<URI> commits;
    private @Nullable Links.Href<URI> statuses;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.Links} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Links instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.prs.PullRequestLinks} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequestLinks instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Links) {
        Links instance = (Links) object;
        if ((bits & 0x1L) == 0) {
          @Nullable Links.Href<URI> selfValue = instance.self();
          if (selfValue != null) {
            self(selfValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable Links.Href<URI> htmlValue = instance.html();
          if (htmlValue != null) {
            html(htmlValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof PullRequestLinks) {
        PullRequestLinks instance = (PullRequestLinks) object;
        @Nullable Links.Href<URI> commentsValue = instance.comments();
        if (commentsValue != null) {
          comments(commentsValue);
        }
        @Nullable Links.Href<URI> issueValue = instance.issue();
        if (issueValue != null) {
          issue(issueValue);
        }
        @Nullable Links.Href<String> reviewCommentValue = instance.reviewComment();
        if (reviewCommentValue != null) {
          reviewComment(reviewCommentValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable Links.Href<URI> selfValue = instance.self();
          if (selfValue != null) {
            self(selfValue);
          }
          bits |= 0x1L;
        }
        @Nullable Links.Href<URI> commitsValue = instance.commits();
        if (commitsValue != null) {
          commits(commitsValue);
        }
        @Nullable Links.Href<URI> statusesValue = instance.statuses();
        if (statusesValue != null) {
          statuses(statusesValue);
        }
        if ((bits & 0x2L) == 0) {
          @Nullable Links.Href<URI> htmlValue = instance.html();
          if (htmlValue != null) {
            html(htmlValue);
          }
          bits |= 0x2L;
        }
        @Nullable Links.Href<URI> reviewCommentsValue = instance.reviewComments();
        if (reviewCommentsValue != null) {
          reviewComments(reviewCommentsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link PullRequestLinks#self() self} attribute.
     * @param self The value for self (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder self(@Nullable Links.Href<URI> self) {
      this.self = self;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestLinks#html() html} attribute.
     * @param html The value for html (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder html(@Nullable Links.Href<URI> html) {
      this.html = html;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestLinks#issue() issue} attribute.
     * @param issue The value for issue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder issue(@Nullable Links.Href<URI> issue) {
      this.issue = issue;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestLinks#comments() comments} attribute.
     * @param comments The value for comments (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder comments(@Nullable Links.Href<URI> comments) {
      this.comments = comments;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestLinks#reviewComment() reviewComment} attribute.
     * @param reviewComment The value for reviewComment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reviewComment(@Nullable Links.Href<String> reviewComment) {
      this.reviewComment = reviewComment;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestLinks#reviewComments() reviewComments} attribute.
     * @param reviewComments The value for reviewComments (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reviewComments(@Nullable Links.Href<URI> reviewComments) {
      this.reviewComments = reviewComments;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestLinks#commits() commits} attribute.
     * @param commits The value for commits (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commits(@Nullable Links.Href<URI> commits) {
      this.commits = commits;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestLinks#statuses() statuses} attribute.
     * @param statuses The value for statuses (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder statuses(@Nullable Links.Href<URI> statuses) {
      this.statuses = statuses;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequestLinks ImmutablePullRequestLinks}.
     * @return An immutable instance of PullRequestLinks
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequestLinks build() {
      return new ImmutablePullRequestLinks(self, html, issue, comments, reviewComment, reviewComments, commits, statuses);
    }
  }
}
