package com.spotify.github.v3.prs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequestParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequestParameters.builder()}.
 */
@Generated(from = "PullRequestParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequestParameters
    implements PullRequestParameters {
  private final @Nullable String state;
  private final @Nullable String head;
  private final @Nullable String base;
  private final @Nullable String sort;
  private final @Nullable String direction;
  private final @Nullable Integer per_page;
  private final @Nullable Integer page;

  private ImmutablePullRequestParameters(
      @Nullable String state,
      @Nullable String head,
      @Nullable String base,
      @Nullable String sort,
      @Nullable String direction,
      @Nullable Integer per_page,
      @Nullable Integer page) {
    this.state = state;
    this.head = head;
    this.base = base;
    this.sort = sort;
    this.direction = direction;
    this.per_page = per_page;
    this.page = page;
  }

  /**
   *Either open, closed, or all to filter by state. Default: open 
   */
  @JsonProperty
  @Override
  public Optional<String> state() {
    return Optional.ofNullable(state);
  }

  /**
   * Filter pulls by head user and branch name in the format of user:ref-name. Example:
   * github:new-script-format.
   */
  @JsonProperty
  @Override
  public Optional<String> head() {
    return Optional.ofNullable(head);
  }

  /**
   *Filter pulls by base branch name. Example: gh-pages. 
   */
  @JsonProperty
  @Override
  public Optional<String> base() {
    return Optional.ofNullable(base);
  }

  /**
   * What to sort results by. Can be either created, updated, popularity (comment count) or
   * long-running (age, filtering by pulls updated in the last month). Default: created
   */
  @JsonProperty
  @Override
  public Optional<String> sort() {
    return Optional.ofNullable(sort);
  }

  /**
   * The direction of the sort. Can be either asc or desc. Default: desc when sort is created or
   * sort is not specified, otherwise asc.
   */
  @JsonProperty
  @Override
  public Optional<String> direction() {
    return Optional.ofNullable(direction);
  }

  /**
   * Results per page (max 100)
   */
  @JsonProperty
  @Override
  public Optional<Integer> per_page() {
    return Optional.ofNullable(per_page);
  }

  /**
   * Page number of the results to fetch.
   */
  @JsonProperty
  @Override
  public Optional<Integer> page() {
    return Optional.ofNullable(page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestParameters#state() state} attribute.
   * @param value The value for state
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withState(String value) {
    String newValue = Objects.requireNonNull(value, "state");
    if (Objects.equals(this.state, newValue)) return this;
    return new ImmutablePullRequestParameters(newValue, this.head, this.base, this.sort, this.direction, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestParameters#state() state} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for state
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withState(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.state, value)) return this;
    return new ImmutablePullRequestParameters(value, this.head, this.base, this.sort, this.direction, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestParameters#head() head} attribute.
   * @param value The value for head
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withHead(String value) {
    String newValue = Objects.requireNonNull(value, "head");
    if (Objects.equals(this.head, newValue)) return this;
    return new ImmutablePullRequestParameters(this.state, newValue, this.base, this.sort, this.direction, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestParameters#head() head} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for head
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withHead(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.head, value)) return this;
    return new ImmutablePullRequestParameters(this.state, value, this.base, this.sort, this.direction, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestParameters#base() base} attribute.
   * @param value The value for base
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withBase(String value) {
    String newValue = Objects.requireNonNull(value, "base");
    if (Objects.equals(this.base, newValue)) return this;
    return new ImmutablePullRequestParameters(this.state, this.head, newValue, this.sort, this.direction, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestParameters#base() base} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for base
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withBase(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.base, value)) return this;
    return new ImmutablePullRequestParameters(this.state, this.head, value, this.sort, this.direction, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestParameters#sort() sort} attribute.
   * @param value The value for sort
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withSort(String value) {
    String newValue = Objects.requireNonNull(value, "sort");
    if (Objects.equals(this.sort, newValue)) return this;
    return new ImmutablePullRequestParameters(this.state, this.head, this.base, newValue, this.direction, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestParameters#sort() sort} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sort
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withSort(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.sort, value)) return this;
    return new ImmutablePullRequestParameters(this.state, this.head, this.base, value, this.direction, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestParameters#direction() direction} attribute.
   * @param value The value for direction
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withDirection(String value) {
    String newValue = Objects.requireNonNull(value, "direction");
    if (Objects.equals(this.direction, newValue)) return this;
    return new ImmutablePullRequestParameters(this.state, this.head, this.base, this.sort, newValue, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestParameters#direction() direction} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for direction
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withDirection(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.direction, value)) return this;
    return new ImmutablePullRequestParameters(this.state, this.head, this.base, this.sort, value, this.per_page, this.page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestParameters#per_page() per_page} attribute.
   * @param value The value for per_page
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withPer_page(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.per_page, newValue)) return this;
    return new ImmutablePullRequestParameters(this.state, this.head, this.base, this.sort, this.direction, newValue, this.page);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestParameters#per_page() per_page} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for per_page
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withPer_page(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.per_page, value)) return this;
    return new ImmutablePullRequestParameters(this.state, this.head, this.base, this.sort, this.direction, value, this.page);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestParameters#page() page} attribute.
   * @param value The value for page
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withPage(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.page, newValue)) return this;
    return new ImmutablePullRequestParameters(this.state, this.head, this.base, this.sort, this.direction, this.per_page, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestParameters#page() page} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for page
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestParameters withPage(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.page, value)) return this;
    return new ImmutablePullRequestParameters(this.state, this.head, this.base, this.sort, this.direction, this.per_page, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequestParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequestParameters
        && equalTo(0, (ImmutablePullRequestParameters) another);
  }

  private boolean equalTo(int synthetic, ImmutablePullRequestParameters another) {
    return Objects.equals(state, another.state)
        && Objects.equals(head, another.head)
        && Objects.equals(base, another.base)
        && Objects.equals(sort, another.sort)
        && Objects.equals(direction, another.direction)
        && Objects.equals(per_page, another.per_page)
        && Objects.equals(page, another.page);
  }

  /**
   * Computes a hash code from attributes: {@code state}, {@code head}, {@code base}, {@code sort}, {@code direction}, {@code per_page}, {@code page}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(head);
    h += (h << 5) + Objects.hashCode(base);
    h += (h << 5) + Objects.hashCode(sort);
    h += (h << 5) + Objects.hashCode(direction);
    h += (h << 5) + Objects.hashCode(per_page);
    h += (h << 5) + Objects.hashCode(page);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequestParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PullRequestParameters{");
    if (state != null) {
      builder.append("state=").append(state);
    }
    if (head != null) {
      if (builder.length() > 22) builder.append(", ");
      builder.append("head=").append(head);
    }
    if (base != null) {
      if (builder.length() > 22) builder.append(", ");
      builder.append("base=").append(base);
    }
    if (sort != null) {
      if (builder.length() > 22) builder.append(", ");
      builder.append("sort=").append(sort);
    }
    if (direction != null) {
      if (builder.length() > 22) builder.append(", ");
      builder.append("direction=").append(direction);
    }
    if (per_page != null) {
      if (builder.length() > 22) builder.append(", ");
      builder.append("per_page=").append(per_page);
    }
    if (page != null) {
      if (builder.length() > 22) builder.append(", ");
      builder.append("page=").append(page);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequestParameters", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequestParameters {
    @Nullable Optional<String> state = Optional.empty();
    @Nullable Optional<String> head = Optional.empty();
    @Nullable Optional<String> base = Optional.empty();
    @Nullable Optional<String> sort = Optional.empty();
    @Nullable Optional<String> direction = Optional.empty();
    @Nullable Optional<Integer> per_page = Optional.empty();
    @Nullable Optional<Integer> page = Optional.empty();
    @JsonProperty
    public void setState(Optional<String> state) {
      this.state = state;
    }
    @JsonProperty
    public void setHead(Optional<String> head) {
      this.head = head;
    }
    @JsonProperty
    public void setBase(Optional<String> base) {
      this.base = base;
    }
    @JsonProperty
    public void setSort(Optional<String> sort) {
      this.sort = sort;
    }
    @JsonProperty
    public void setDirection(Optional<String> direction) {
      this.direction = direction;
    }
    @JsonProperty
    public void setPer_page(Optional<Integer> per_page) {
      this.per_page = per_page;
    }
    @JsonProperty
    public void setPage(Optional<Integer> page) {
      this.page = page;
    }
    @Override
    public Optional<String> state() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> head() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> base() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> sort() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> direction() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> per_page() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> page() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequestParameters fromJson(Json json) {
    ImmutablePullRequestParameters.Builder builder = ImmutablePullRequestParameters.builder();
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.head != null) {
      builder.head(json.head);
    }
    if (json.base != null) {
      builder.base(json.base);
    }
    if (json.sort != null) {
      builder.sort(json.sort);
    }
    if (json.direction != null) {
      builder.direction(json.direction);
    }
    if (json.per_page != null) {
      builder.per_page(json.per_page);
    }
    if (json.page != null) {
      builder.page(json.page);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequestParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequestParameters instance
   */
  public static ImmutablePullRequestParameters copyOf(PullRequestParameters instance) {
    if (instance instanceof ImmutablePullRequestParameters) {
      return (ImmutablePullRequestParameters) instance;
    }
    return ImmutablePullRequestParameters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequestParameters ImmutablePullRequestParameters}.
   * <pre>
   * ImmutablePullRequestParameters.builder()
   *    .state(String) // optional {@link PullRequestParameters#state() state}
   *    .head(String) // optional {@link PullRequestParameters#head() head}
   *    .base(String) // optional {@link PullRequestParameters#base() base}
   *    .sort(String) // optional {@link PullRequestParameters#sort() sort}
   *    .direction(String) // optional {@link PullRequestParameters#direction() direction}
   *    .per_page(Integer) // optional {@link PullRequestParameters#per_page() per_page}
   *    .page(Integer) // optional {@link PullRequestParameters#page() page}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequestParameters builder
   */
  public static ImmutablePullRequestParameters.Builder builder() {
    return new ImmutablePullRequestParameters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequestParameters ImmutablePullRequestParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequestParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String state;
    private @Nullable String head;
    private @Nullable String base;
    private @Nullable String sort;
    private @Nullable String direction;
    private @Nullable Integer per_page;
    private @Nullable Integer page;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PullRequestParameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequestParameters instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> stateOptional = instance.state();
      if (stateOptional.isPresent()) {
        state(stateOptional);
      }
      Optional<String> headOptional = instance.head();
      if (headOptional.isPresent()) {
        head(headOptional);
      }
      Optional<String> baseOptional = instance.base();
      if (baseOptional.isPresent()) {
        base(baseOptional);
      }
      Optional<String> sortOptional = instance.sort();
      if (sortOptional.isPresent()) {
        sort(sortOptional);
      }
      Optional<String> directionOptional = instance.direction();
      if (directionOptional.isPresent()) {
        direction(directionOptional);
      }
      Optional<Integer> per_pageOptional = instance.per_page();
      if (per_pageOptional.isPresent()) {
        per_page(per_pageOptional);
      }
      Optional<Integer> pageOptional = instance.page();
      if (pageOptional.isPresent()) {
        page(pageOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#state() state} to state.
     * @param state The value for state
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder state(String state) {
      this.state = Objects.requireNonNull(state, "state");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#state() state} to state.
     * @param state The value for state
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(Optional<String> state) {
      this.state = state.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#head() head} to head.
     * @param head The value for head
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder head(String head) {
      this.head = Objects.requireNonNull(head, "head");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#head() head} to head.
     * @param head The value for head
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder head(Optional<String> head) {
      this.head = head.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#base() base} to base.
     * @param base The value for base
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder base(String base) {
      this.base = Objects.requireNonNull(base, "base");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#base() base} to base.
     * @param base The value for base
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder base(Optional<String> base) {
      this.base = base.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#sort() sort} to sort.
     * @param sort The value for sort
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sort(String sort) {
      this.sort = Objects.requireNonNull(sort, "sort");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#sort() sort} to sort.
     * @param sort The value for sort
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sort(Optional<String> sort) {
      this.sort = sort.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#direction() direction} to direction.
     * @param direction The value for direction
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder direction(String direction) {
      this.direction = Objects.requireNonNull(direction, "direction");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#direction() direction} to direction.
     * @param direction The value for direction
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder direction(Optional<String> direction) {
      this.direction = direction.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#per_page() per_page} to per_page.
     * @param per_page The value for per_page
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder per_page(int per_page) {
      this.per_page = per_page;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#per_page() per_page} to per_page.
     * @param per_page The value for per_page
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder per_page(Optional<Integer> per_page) {
      this.per_page = per_page.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#page() page} to page.
     * @param page The value for page
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder page(int page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestParameters#page() page} to page.
     * @param page The value for page
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder page(Optional<Integer> page) {
      this.page = page.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequestParameters ImmutablePullRequestParameters}.
     * @return An immutable instance of PullRequestParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequestParameters build() {
      return new ImmutablePullRequestParameters(state, head, base, sort, direction, per_page, page);
    }
  }
}
