package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.git.ShaLink;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Branch}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBranch.builder()}.
 */
@Generated(from = "Branch", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBranch implements Branch {
  private final @Nullable String name;
  private final @Nullable ShaLink commit;
  private final @Nullable Boolean isProtected;
  private final @Nullable URI protectionUrl;
  private final @Nullable Protection protection;

  private ImmutableBranch(
      @Nullable String name,
      @Nullable ShaLink commit,
      @Nullable Boolean isProtected,
      @Nullable URI protectionUrl,
      @Nullable Protection protection) {
    this.name = name;
    this.commit = commit;
    this.isProtected = isProtected;
    this.protectionUrl = protectionUrl;
    this.protection = protection;
  }

  /**
   *Branch name 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *Commit details branch is labeling 
   */
  @JsonProperty
  @Override
  public @Nullable ShaLink commit() {
    return commit;
  }

  /**
   *True if branch is protected 
   */
  @JsonProperty("protected")
  @Override
  public Optional<Boolean> isProtected() {
    return Optional.ofNullable(isProtected);
  }

  /**
   *Branch protection API URL 
   */
  @JsonProperty
  @JsonDeserialize(using = BranchProtectionUrlDeserializer.class)
  @Override
  public Optional<URI> protectionUrl() {
    return Optional.ofNullable(protectionUrl);
  }

  /**
   * @return The value of the {@code protection} attribute
   */
  @JsonProperty
  @Override
  public Optional<Protection> protection() {
    return Optional.ofNullable(protection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Branch#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBranch withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableBranch(value, this.commit, this.isProtected, this.protectionUrl, this.protection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Branch#commit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBranch withCommit(@Nullable ShaLink value) {
    if (this.commit == value) return this;
    return new ImmutableBranch(this.name, value, this.isProtected, this.protectionUrl, this.protection);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Branch#isProtected() isProtected} attribute.
   * @param value The value for isProtected
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBranch withIsProtected(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isProtected, newValue)) return this;
    return new ImmutableBranch(this.name, this.commit, newValue, this.protectionUrl, this.protection);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Branch#isProtected() isProtected} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isProtected
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBranch withIsProtected(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isProtected, value)) return this;
    return new ImmutableBranch(this.name, this.commit, value, this.protectionUrl, this.protection);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Branch#protectionUrl() protectionUrl} attribute.
   * @param value The value for protectionUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBranch withProtectionUrl(URI value) {
    URI newValue = Objects.requireNonNull(value, "protectionUrl");
    if (this.protectionUrl == newValue) return this;
    return new ImmutableBranch(this.name, this.commit, this.isProtected, newValue, this.protection);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Branch#protectionUrl() protectionUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for protectionUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableBranch withProtectionUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.protectionUrl == value) return this;
    return new ImmutableBranch(this.name, this.commit, this.isProtected, value, this.protection);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Branch#protection() protection} attribute.
   * @param value The value for protection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBranch withProtection(Protection value) {
    Protection newValue = Objects.requireNonNull(value, "protection");
    if (this.protection == newValue) return this;
    return new ImmutableBranch(this.name, this.commit, this.isProtected, this.protectionUrl, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Branch#protection() protection} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for protection
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableBranch withProtection(Optional<? extends Protection> optional) {
    @Nullable Protection value = optional.orElse(null);
    if (this.protection == value) return this;
    return new ImmutableBranch(this.name, this.commit, this.isProtected, this.protectionUrl, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBranch} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBranch
        && equalTo(0, (ImmutableBranch) another);
  }

  private boolean equalTo(int synthetic, ImmutableBranch another) {
    return Objects.equals(name, another.name)
        && Objects.equals(commit, another.commit)
        && Objects.equals(isProtected, another.isProtected)
        && Objects.equals(protectionUrl, another.protectionUrl)
        && Objects.equals(protection, another.protection);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code commit}, {@code isProtected}, {@code protectionUrl}, {@code protection}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(commit);
    h += (h << 5) + Objects.hashCode(isProtected);
    h += (h << 5) + Objects.hashCode(protectionUrl);
    h += (h << 5) + Objects.hashCode(protection);
    return h;
  }

  /**
   * Prints the immutable value {@code Branch} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Branch{");
    if (name != null) {
      builder.append("name=").append(name);
    }
    if (commit != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("commit=").append(commit);
    }
    if (isProtected != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("isProtected=").append(isProtected);
    }
    if (protectionUrl != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("protectionUrl=").append(protectionUrl);
    }
    if (protection != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("protection=").append(protection);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Branch", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Branch {
    @Nullable String name;
    @Nullable ShaLink commit;
    @Nullable Optional<Boolean> isProtected = Optional.empty();
    @Nullable Optional<URI> protectionUrl = Optional.empty();
    @Nullable Optional<Protection> protection = Optional.empty();
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setCommit(@Nullable ShaLink commit) {
      this.commit = commit;
    }
    @JsonProperty("protected")
    public void setIsProtected(Optional<Boolean> isProtected) {
      this.isProtected = isProtected;
    }
    @JsonProperty
    @JsonDeserialize(using = BranchProtectionUrlDeserializer.class)
    public void setProtectionUrl(Optional<URI> protectionUrl) {
      this.protectionUrl = protectionUrl;
    }
    @JsonProperty
    public void setProtection(Optional<Protection> protection) {
      this.protection = protection;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public ShaLink commit() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isProtected() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> protectionUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Protection> protection() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBranch fromJson(Json json) {
    ImmutableBranch.Builder builder = ImmutableBranch.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.commit != null) {
      builder.commit(json.commit);
    }
    if (json.isProtected != null) {
      builder.isProtected(json.isProtected);
    }
    if (json.protectionUrl != null) {
      builder.protectionUrl(json.protectionUrl);
    }
    if (json.protection != null) {
      builder.protection(json.protection);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Branch} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Branch instance
   */
  public static ImmutableBranch copyOf(Branch instance) {
    if (instance instanceof ImmutableBranch) {
      return (ImmutableBranch) instance;
    }
    return ImmutableBranch.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBranch ImmutableBranch}.
   * <pre>
   * ImmutableBranch.builder()
   *    .name(String | null) // nullable {@link Branch#name() name}
   *    .commit(com.spotify.github.v3.git.ShaLink | null) // nullable {@link Branch#commit() commit}
   *    .isProtected(Boolean) // optional {@link Branch#isProtected() isProtected}
   *    .protectionUrl(java.net.URI) // optional {@link Branch#protectionUrl() protectionUrl}
   *    .protection(com.spotify.github.v3.repos.Protection) // optional {@link Branch#protection() protection}
   *    .build();
   * </pre>
   * @return A new ImmutableBranch builder
   */
  public static ImmutableBranch.Builder builder() {
    return new ImmutableBranch.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBranch ImmutableBranch}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Branch", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String name;
    private @Nullable ShaLink commit;
    private @Nullable Boolean isProtected;
    private @Nullable URI protectionUrl;
    private @Nullable Protection protection;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Branch} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Branch instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable ShaLink commitValue = instance.commit();
      if (commitValue != null) {
        commit(commitValue);
      }
      Optional<Boolean> isProtectedOptional = instance.isProtected();
      if (isProtectedOptional.isPresent()) {
        isProtected(isProtectedOptional);
      }
      Optional<URI> protectionUrlOptional = instance.protectionUrl();
      if (protectionUrlOptional.isPresent()) {
        protectionUrl(protectionUrlOptional);
      }
      Optional<Protection> protectionOptional = instance.protection();
      if (protectionOptional.isPresent()) {
        protection(protectionOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Branch#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Branch#commit() commit} attribute.
     * @param commit The value for commit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commit(@Nullable ShaLink commit) {
      this.commit = commit;
      return this;
    }

    /**
     * Initializes the optional value {@link Branch#isProtected() isProtected} to isProtected.
     * @param isProtected The value for isProtected
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isProtected(boolean isProtected) {
      this.isProtected = isProtected;
      return this;
    }

    /**
     * Initializes the optional value {@link Branch#isProtected() isProtected} to isProtected.
     * @param isProtected The value for isProtected
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("protected")
    public final Builder isProtected(Optional<Boolean> isProtected) {
      this.isProtected = isProtected.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Branch#protectionUrl() protectionUrl} to protectionUrl.
     * @param protectionUrl The value for protectionUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder protectionUrl(URI protectionUrl) {
      this.protectionUrl = Objects.requireNonNull(protectionUrl, "protectionUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link Branch#protectionUrl() protectionUrl} to protectionUrl.
     * @param protectionUrl The value for protectionUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    @JsonDeserialize(using = BranchProtectionUrlDeserializer.class)
    public final Builder protectionUrl(Optional<? extends URI> protectionUrl) {
      this.protectionUrl = protectionUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Branch#protection() protection} to protection.
     * @param protection The value for protection
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder protection(Protection protection) {
      this.protection = Objects.requireNonNull(protection, "protection");
      return this;
    }

    /**
     * Initializes the optional value {@link Branch#protection() protection} to protection.
     * @param protection The value for protection
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder protection(Optional<? extends Protection> protection) {
      this.protection = protection.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableBranch ImmutableBranch}.
     * @return An immutable instance of Branch
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBranch build() {
      return new ImmutableBranch(name, commit, isProtected, protectionUrl, protection);
    }
  }
}
