package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RequiredStatusChecks}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRequiredStatusChecks.builder()}.
 */
@Generated(from = "RequiredStatusChecks", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRequiredStatusChecks implements RequiredStatusChecks {
  private final String enforcementLevel;
  private final List<String> contexts;

  private ImmutableRequiredStatusChecks(ImmutableRequiredStatusChecks.Builder builder) {
    this.enforcementLevel = builder.enforcementLevel;
    this.contexts = builder.contextsIsSet()
        ? createUnmodifiableList(true, builder.contexts)
        : createUnmodifiableList(false, createSafeList(RequiredStatusChecks.super.contexts(), true, false));
  }

  private ImmutableRequiredStatusChecks(String enforcementLevel, List<String> contexts) {
    this.enforcementLevel = enforcementLevel;
    this.contexts = contexts;
  }

  /**
   * @return The value of the {@code enforcementLevel} attribute
   */
  @JsonProperty("enforcement_level")
  @Override
  public String enforcementLevel() {
    return enforcementLevel;
  }

  /**
   * @return The value of the {@code contexts} attribute
   */
  @JsonProperty
  @Override
  public List<String> contexts() {
    return contexts;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RequiredStatusChecks#enforcementLevel() enforcementLevel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enforcementLevel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRequiredStatusChecks withEnforcementLevel(String value) {
    String newValue = Objects.requireNonNull(value, "enforcementLevel");
    if (this.enforcementLevel.equals(newValue)) return this;
    return new ImmutableRequiredStatusChecks(newValue, this.contexts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RequiredStatusChecks#contexts() contexts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRequiredStatusChecks withContexts(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableRequiredStatusChecks(this.enforcementLevel, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RequiredStatusChecks#contexts() contexts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of contexts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRequiredStatusChecks withContexts(Iterable<String> elements) {
    if (this.contexts == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableRequiredStatusChecks(this.enforcementLevel, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRequiredStatusChecks} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRequiredStatusChecks
        && equalTo(0, (ImmutableRequiredStatusChecks) another);
  }

  private boolean equalTo(int synthetic, ImmutableRequiredStatusChecks another) {
    return enforcementLevel.equals(another.enforcementLevel)
        && contexts.equals(another.contexts);
  }

  /**
   * Computes a hash code from attributes: {@code enforcementLevel}, {@code contexts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + enforcementLevel.hashCode();
    h += (h << 5) + contexts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RequiredStatusChecks} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RequiredStatusChecks{"
        + "enforcementLevel=" + enforcementLevel
        + ", contexts=" + contexts
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RequiredStatusChecks", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RequiredStatusChecks {
    @Nullable String enforcementLevel;
    @Nullable List<String> contexts = Collections.emptyList();
    boolean contextsIsSet;
    @JsonProperty("enforcement_level")
    public void setEnforcementLevel(String enforcementLevel) {
      this.enforcementLevel = enforcementLevel;
    }
    @JsonProperty
    public void setContexts(List<String> contexts) {
      this.contexts = contexts;
      this.contextsIsSet = null != contexts;
    }
    @Override
    public String enforcementLevel() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> contexts() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRequiredStatusChecks fromJson(Json json) {
    ImmutableRequiredStatusChecks.Builder builder = ImmutableRequiredStatusChecks.builder();
    if (json.enforcementLevel != null) {
      builder.enforcementLevel(json.enforcementLevel);
    }
    if (json.contextsIsSet) {
      builder.addAllContexts(json.contexts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RequiredStatusChecks} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RequiredStatusChecks instance
   */
  public static ImmutableRequiredStatusChecks copyOf(RequiredStatusChecks instance) {
    if (instance instanceof ImmutableRequiredStatusChecks) {
      return (ImmutableRequiredStatusChecks) instance;
    }
    return ImmutableRequiredStatusChecks.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRequiredStatusChecks ImmutableRequiredStatusChecks}.
   * <pre>
   * ImmutableRequiredStatusChecks.builder()
   *    .enforcementLevel(String) // required {@link RequiredStatusChecks#enforcementLevel() enforcementLevel}
   *    .addContexts|addAllContexts(String) // {@link RequiredStatusChecks#contexts() contexts} elements
   *    .build();
   * </pre>
   * @return A new ImmutableRequiredStatusChecks builder
   */
  public static ImmutableRequiredStatusChecks.Builder builder() {
    return new ImmutableRequiredStatusChecks.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRequiredStatusChecks ImmutableRequiredStatusChecks}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RequiredStatusChecks", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ENFORCEMENT_LEVEL = 0x1L;
    private static final long OPT_BIT_CONTEXTS = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String enforcementLevel;
    private List<String> contexts = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RequiredStatusChecks} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RequiredStatusChecks instance) {
      Objects.requireNonNull(instance, "instance");
      enforcementLevel(instance.enforcementLevel());
      addAllContexts(instance.contexts());
      return this;
    }

    /**
     * Initializes the value for the {@link RequiredStatusChecks#enforcementLevel() enforcementLevel} attribute.
     * @param enforcementLevel The value for enforcementLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("enforcement_level")
    public final Builder enforcementLevel(String enforcementLevel) {
      this.enforcementLevel = Objects.requireNonNull(enforcementLevel, "enforcementLevel");
      initBits &= ~INIT_BIT_ENFORCEMENT_LEVEL;
      return this;
    }

    /**
     * Adds one element to {@link RequiredStatusChecks#contexts() contexts} list.
     * @param element A contexts element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addContexts(String element) {
      this.contexts.add(Objects.requireNonNull(element, "contexts element"));
      optBits |= OPT_BIT_CONTEXTS;
      return this;
    }

    /**
     * Adds elements to {@link RequiredStatusChecks#contexts() contexts} list.
     * @param elements An array of contexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addContexts(String... elements) {
      for (String element : elements) {
        this.contexts.add(Objects.requireNonNull(element, "contexts element"));
      }
      optBits |= OPT_BIT_CONTEXTS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RequiredStatusChecks#contexts() contexts} list.
     * @param elements An iterable of contexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder contexts(Iterable<String> elements) {
      this.contexts.clear();
      return addAllContexts(elements);
    }

    /**
     * Adds elements to {@link RequiredStatusChecks#contexts() contexts} list.
     * @param elements An iterable of contexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllContexts(Iterable<String> elements) {
      for (String element : elements) {
        this.contexts.add(Objects.requireNonNull(element, "contexts element"));
      }
      optBits |= OPT_BIT_CONTEXTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRequiredStatusChecks ImmutableRequiredStatusChecks}.
     * @return An immutable instance of RequiredStatusChecks
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRequiredStatusChecks build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRequiredStatusChecks(this);
    }

    private boolean contextsIsSet() {
      return (optBits & OPT_BIT_CONTEXTS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ENFORCEMENT_LEVEL) != 0) attributes.add("enforcementLevel");
      return "Cannot build RequiredStatusChecks, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
