package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FileUpdate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFileUpdate.builder()}.
 */
@Generated(from = "FileUpdate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFileUpdate implements FileUpdate {
  private final String message;
  private final String content;
  private final String sha;
  private final @Nullable String branch;

  private ImmutableFileUpdate(
      String message,
      String content,
      String sha,
      @Nullable String branch) {
    this.message = message;
    this.content = content;
    this.sha = sha;
    this.branch = branch;
  }

  /**
   *The commit message 
   */
  @JsonProperty
  @Override
  public String message() {
    return message;
  }

  /**
   *The new file content, using Base64 encoding 
   */
  @JsonProperty
  @Override
  public String content() {
    return content;
  }

  /**
   *The SHA of the file being replaced. 
   */
  @JsonProperty
  @Override
  public String sha() {
    return sha;
  }

  /**
   *The branch name. Default: the repository’s default branch  
   */
  @JsonProperty
  @Override
  public @Nullable String branch() {
    return branch;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileUpdate#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileUpdate withMessage(String value) {
    String newValue = Objects.requireNonNull(value, "message");
    if (this.message.equals(newValue)) return this;
    return new ImmutableFileUpdate(newValue, this.content, this.sha, this.branch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileUpdate#content() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileUpdate withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutableFileUpdate(this.message, newValue, this.sha, this.branch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileUpdate#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileUpdate withSha(String value) {
    String newValue = Objects.requireNonNull(value, "sha");
    if (this.sha.equals(newValue)) return this;
    return new ImmutableFileUpdate(this.message, this.content, newValue, this.branch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileUpdate#branch() branch} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for branch (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileUpdate withBranch(@Nullable String value) {
    if (Objects.equals(this.branch, value)) return this;
    return new ImmutableFileUpdate(this.message, this.content, this.sha, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFileUpdate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFileUpdate
        && equalTo(0, (ImmutableFileUpdate) another);
  }

  private boolean equalTo(int synthetic, ImmutableFileUpdate another) {
    return message.equals(another.message)
        && content.equals(another.content)
        && sha.equals(another.sha)
        && Objects.equals(branch, another.branch);
  }

  /**
   * Computes a hash code from attributes: {@code message}, {@code content}, {@code sha}, {@code branch}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + message.hashCode();
    h += (h << 5) + content.hashCode();
    h += (h << 5) + sha.hashCode();
    h += (h << 5) + Objects.hashCode(branch);
    return h;
  }

  /**
   * Prints the immutable value {@code FileUpdate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FileUpdate{"
        + "message=" + message
        + ", content=" + content
        + ", sha=" + sha
        + ", branch=" + branch
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FileUpdate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FileUpdate {
    @Nullable String message;
    @Nullable String content;
    @Nullable String sha;
    @Nullable String branch;
    @JsonProperty
    public void setMessage(String message) {
      this.message = message;
    }
    @JsonProperty
    public void setContent(String content) {
      this.content = content;
    }
    @JsonProperty
    public void setSha(String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setBranch(@Nullable String branch) {
      this.branch = branch;
    }
    @Override
    public String message() { throw new UnsupportedOperationException(); }
    @Override
    public String content() { throw new UnsupportedOperationException(); }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public String branch() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFileUpdate fromJson(Json json) {
    ImmutableFileUpdate.Builder builder = ImmutableFileUpdate.builder();
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.branch != null) {
      builder.branch(json.branch);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FileUpdate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FileUpdate instance
   */
  public static ImmutableFileUpdate copyOf(FileUpdate instance) {
    if (instance instanceof ImmutableFileUpdate) {
      return (ImmutableFileUpdate) instance;
    }
    return ImmutableFileUpdate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFileUpdate ImmutableFileUpdate}.
   * <pre>
   * ImmutableFileUpdate.builder()
   *    .message(String) // required {@link FileUpdate#message() message}
   *    .content(String) // required {@link FileUpdate#content() content}
   *    .sha(String) // required {@link FileUpdate#sha() sha}
   *    .branch(String | null) // nullable {@link FileUpdate#branch() branch}
   *    .build();
   * </pre>
   * @return A new ImmutableFileUpdate builder
   */
  public static ImmutableFileUpdate.Builder builder() {
    return new ImmutableFileUpdate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFileUpdate ImmutableFileUpdate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FileUpdate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MESSAGE = 0x1L;
    private static final long INIT_BIT_CONTENT = 0x2L;
    private static final long INIT_BIT_SHA = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String message;
    private @Nullable String content;
    private @Nullable String sha;
    private @Nullable String branch;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FileUpdate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FileUpdate instance) {
      Objects.requireNonNull(instance, "instance");
      message(instance.message());
      content(instance.content());
      sha(instance.sha());
      @Nullable String branchValue = instance.branch();
      if (branchValue != null) {
        branch(branchValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FileUpdate#message() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link FileUpdate#content() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Initializes the value for the {@link FileUpdate#sha() sha} attribute.
     * @param sha The value for sha 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(String sha) {
      this.sha = Objects.requireNonNull(sha, "sha");
      initBits &= ~INIT_BIT_SHA;
      return this;
    }

    /**
     * Initializes the value for the {@link FileUpdate#branch() branch} attribute.
     * @param branch The value for branch (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder branch(@Nullable String branch) {
      this.branch = branch;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFileUpdate ImmutableFileUpdate}.
     * @return An immutable instance of FileUpdate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFileUpdate build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFileUpdate(message, content, sha, branch);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      if ((initBits & INIT_BIT_SHA) != 0) attributes.add("sha");
      return "Cannot build FileUpdate, some of required attributes are not set " + attributes;
    }
  }
}
