package com.spotify.github.v3.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.repos.Repository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SearchRepositories}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearchRepositories.builder()}.
 */
@Generated(from = "SearchRepositories", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSearchRepositories implements SearchRepositories {
  private final @Nullable Integer totalCount;
  private final @Nullable Boolean incompleteResults;
  private final @Nullable List<Repository> items;

  private ImmutableSearchRepositories(
      @Nullable Integer totalCount,
      @Nullable Boolean incompleteResults,
      @Nullable List<Repository> items) {
    this.totalCount = totalCount;
    this.incompleteResults = incompleteResults;
    this.items = items;
  }

  /**
   *Total count of search hits 
   */
  @JsonProperty
  @Override
  public @Nullable Integer totalCount() {
    return totalCount;
  }

  /**
   *Are returned results incomplete 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean incompleteResults() {
    return incompleteResults;
  }

  /**
   *Repositories search results 
   */
  @JsonProperty
  @Override
  public @Nullable List<Repository> items() {
    return items;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchRepositories#totalCount() totalCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchRepositories withTotalCount(@Nullable Integer value) {
    if (Objects.equals(this.totalCount, value)) return this;
    return new ImmutableSearchRepositories(value, this.incompleteResults, this.items);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchRepositories#incompleteResults() incompleteResults} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for incompleteResults (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchRepositories withIncompleteResults(@Nullable Boolean value) {
    if (Objects.equals(this.incompleteResults, value)) return this;
    return new ImmutableSearchRepositories(this.totalCount, value, this.items);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SearchRepositories#items() items}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchRepositories withItems(@Nullable Repository... elements) {
    if (elements == null) {
      return new ImmutableSearchRepositories(this.totalCount, this.incompleteResults, null);
    }
    @Nullable List<Repository> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableSearchRepositories(this.totalCount, this.incompleteResults, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SearchRepositories#items() items}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of items elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchRepositories withItems(@Nullable Iterable<? extends Repository> elements) {
    if (this.items == elements) return this;
    @Nullable List<Repository> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableSearchRepositories(this.totalCount, this.incompleteResults, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearchRepositories} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearchRepositories
        && equalTo(0, (ImmutableSearchRepositories) another);
  }

  private boolean equalTo(int synthetic, ImmutableSearchRepositories another) {
    return Objects.equals(totalCount, another.totalCount)
        && Objects.equals(incompleteResults, another.incompleteResults)
        && Objects.equals(items, another.items);
  }

  /**
   * Computes a hash code from attributes: {@code totalCount}, {@code incompleteResults}, {@code items}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(totalCount);
    h += (h << 5) + Objects.hashCode(incompleteResults);
    h += (h << 5) + Objects.hashCode(items);
    return h;
  }

  /**
   * Prints the immutable value {@code SearchRepositories} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SearchRepositories{"
        + "totalCount=" + totalCount
        + ", incompleteResults=" + incompleteResults
        + ", items=" + items
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SearchRepositories", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchRepositories {
    @Nullable Integer totalCount;
    @Nullable Boolean incompleteResults;
    @Nullable List<Repository> items = null;
    @JsonProperty
    public void setTotalCount(@Nullable Integer totalCount) {
      this.totalCount = totalCount;
    }
    @JsonProperty
    public void setIncompleteResults(@Nullable Boolean incompleteResults) {
      this.incompleteResults = incompleteResults;
    }
    @JsonProperty
    public void setItems(@Nullable List<Repository> items) {
      this.items = items;
    }
    @Override
    public Integer totalCount() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean incompleteResults() { throw new UnsupportedOperationException(); }
    @Override
    public List<Repository> items() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearchRepositories fromJson(Json json) {
    ImmutableSearchRepositories.Builder builder = ImmutableSearchRepositories.builder();
    if (json.totalCount != null) {
      builder.totalCount(json.totalCount);
    }
    if (json.incompleteResults != null) {
      builder.incompleteResults(json.incompleteResults);
    }
    if (json.items != null) {
      builder.addAllItems(json.items);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchRepositories} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchRepositories instance
   */
  public static ImmutableSearchRepositories copyOf(SearchRepositories instance) {
    if (instance instanceof ImmutableSearchRepositories) {
      return (ImmutableSearchRepositories) instance;
    }
    return ImmutableSearchRepositories.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearchRepositories ImmutableSearchRepositories}.
   * <pre>
   * ImmutableSearchRepositories.builder()
   *    .totalCount(Integer | null) // nullable {@link SearchRepositories#totalCount() totalCount}
   *    .incompleteResults(Boolean | null) // nullable {@link SearchRepositories#incompleteResults() incompleteResults}
   *    .items(List&amp;lt;com.spotify.github.v3.repos.Repository&amp;gt; | null) // nullable {@link SearchRepositories#items() items}
   *    .build();
   * </pre>
   * @return A new ImmutableSearchRepositories builder
   */
  public static ImmutableSearchRepositories.Builder builder() {
    return new ImmutableSearchRepositories.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearchRepositories ImmutableSearchRepositories}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SearchRepositories", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer totalCount;
    private @Nullable Boolean incompleteResults;
    private List<Repository> items = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.search.SearchRepositories} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SearchRepositories instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.search.Search} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Search instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof SearchRepositories) {
        SearchRepositories instance = (SearchRepositories) object;
        if ((bits & 0x2L) == 0) {
          @Nullable Integer totalCountValue = instance.totalCount();
          if (totalCountValue != null) {
            totalCount(totalCountValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable Boolean incompleteResultsValue = instance.incompleteResults();
          if (incompleteResultsValue != null) {
            incompleteResults(incompleteResultsValue);
          }
          bits |= 0x1L;
        }
        @Nullable List<Repository> itemsValue = instance.items();
        if (itemsValue != null) {
          addAllItems(itemsValue);
        }
      }
      if (object instanceof Search) {
        Search instance = (Search) object;
        if ((bits & 0x2L) == 0) {
          @Nullable Integer totalCountValue = instance.totalCount();
          if (totalCountValue != null) {
            totalCount(totalCountValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable Boolean incompleteResultsValue = instance.incompleteResults();
          if (incompleteResultsValue != null) {
            incompleteResults(incompleteResultsValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link SearchRepositories#totalCount() totalCount} attribute.
     * @param totalCount The value for totalCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder totalCount(@Nullable Integer totalCount) {
      this.totalCount = totalCount;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchRepositories#incompleteResults() incompleteResults} attribute.
     * @param incompleteResults The value for incompleteResults (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder incompleteResults(@Nullable Boolean incompleteResults) {
      this.incompleteResults = incompleteResults;
      return this;
    }

    /**
     * Adds one element to {@link SearchRepositories#items() items} list.
     * @param element A items element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItems(Repository element) {
      if (this.items == null) {
        this.items = new ArrayList<Repository>();
      }
      this.items.add(Objects.requireNonNull(element, "items element"));
      return this;
    }

    /**
     * Adds elements to {@link SearchRepositories#items() items} list.
     * @param elements An array of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItems(Repository... elements) {
      if (this.items == null) {
        this.items = new ArrayList<Repository>();
      }
      for (Repository element : elements) {
        this.items.add(Objects.requireNonNull(element, "items element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SearchRepositories#items() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder items(@Nullable Iterable<? extends Repository> elements) {
      if (elements == null) {
        this.items = null;
        return this;
      }
      this.items = new ArrayList<Repository>();
      return addAllItems(elements);
    }

    /**
     * Adds elements to {@link SearchRepositories#items() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllItems(Iterable<? extends Repository> elements) {
      Objects.requireNonNull(elements, "items element");
      if (this.items == null) {
        this.items = new ArrayList<Repository>();
      }
      for (Repository element : elements) {
        this.items.add(Objects.requireNonNull(element, "items element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearchRepositories ImmutableSearchRepositories}.
     * @return An immutable instance of SearchRepositories
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearchRepositories build() {
      return new ImmutableSearchRepositories(totalCount, incompleteResults, items == null ? null : createUnmodifiableList(true, items));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
