package com.spotify.github.v3.user.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SuspensionReason}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSuspensionReason.builder()}.
 */
@Generated(from = "SuspensionReason", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSuspensionReason implements SuspensionReason {
  private final String reason;

  private ImmutableSuspensionReason(String reason) {
    this.reason = reason;
  }

  /**
   * @return The value of the {@code reason} attribute
   */
  @JsonProperty
  @Override
  public String reason() {
    return reason;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SuspensionReason#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSuspensionReason withReason(String value) {
    String newValue = Objects.requireNonNull(value, "reason");
    if (this.reason.equals(newValue)) return this;
    return new ImmutableSuspensionReason(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSuspensionReason} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSuspensionReason
        && equalTo(0, (ImmutableSuspensionReason) another);
  }

  private boolean equalTo(int synthetic, ImmutableSuspensionReason another) {
    return reason.equals(another.reason);
  }

  /**
   * Computes a hash code from attributes: {@code reason}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + reason.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SuspensionReason} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SuspensionReason{"
        + "reason=" + reason
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SuspensionReason", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SuspensionReason {
    @Nullable String reason;
    @JsonProperty
    public void setReason(String reason) {
      this.reason = reason;
    }
    @Override
    public String reason() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSuspensionReason fromJson(Json json) {
    ImmutableSuspensionReason.Builder builder = ImmutableSuspensionReason.builder();
    if (json.reason != null) {
      builder.reason(json.reason);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SuspensionReason} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SuspensionReason instance
   */
  public static ImmutableSuspensionReason copyOf(SuspensionReason instance) {
    if (instance instanceof ImmutableSuspensionReason) {
      return (ImmutableSuspensionReason) instance;
    }
    return ImmutableSuspensionReason.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSuspensionReason ImmutableSuspensionReason}.
   * <pre>
   * ImmutableSuspensionReason.builder()
   *    .reason(String) // required {@link SuspensionReason#reason() reason}
   *    .build();
   * </pre>
   * @return A new ImmutableSuspensionReason builder
   */
  public static ImmutableSuspensionReason.Builder builder() {
    return new ImmutableSuspensionReason.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSuspensionReason ImmutableSuspensionReason}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SuspensionReason", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REASON = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String reason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SuspensionReason} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SuspensionReason instance) {
      Objects.requireNonNull(instance, "instance");
      reason(instance.reason());
      return this;
    }

    /**
     * Initializes the value for the {@link SuspensionReason#reason() reason} attribute.
     * @param reason The value for reason 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reason(String reason) {
      this.reason = Objects.requireNonNull(reason, "reason");
      initBits &= ~INIT_BIT_REASON;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSuspensionReason ImmutableSuspensionReason}.
     * @return An immutable instance of SuspensionReason
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSuspensionReason build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSuspensionReason(reason);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REASON) != 0) attributes.add("reason");
      return "Cannot build SuspensionReason, some of required attributes are not set " + attributes;
    }
  }
}
