/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.git.Commit;
import com.spotify.github.v3.git.ShaLink;
import com.spotify.github.v3.repos.CommitItem;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitItem", generator="Immutables")
@Immutable
public final class ImmutableCommitItem
implements CommitItem {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;
    @Nullable
    private final Commit commit;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final URI commentsUrl;
    @Nullable
    private final User author;
    @Nullable
    private final List<ShaLink> parents;

    private ImmutableCommitItem(@Nullable String sha, @Nullable URI url, @Nullable Commit commit, @Nullable URI htmlUrl, @Nullable URI commentsUrl, @Nullable User author, @Nullable List<ShaLink> parents) {
        this.sha = sha;
        this.url = url;
        this.commit = commit;
        this.htmlUrl = htmlUrl;
        this.commentsUrl = commentsUrl;
        this.author = author;
        this.parents = parents;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public Commit commit() {
        return this.commit;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI commentsUrl() {
        return this.commentsUrl;
    }

    @Override
    @JsonProperty
    public Optional<User> author() {
        return Optional.ofNullable(this.author);
    }

    @Override
    @JsonProperty
    @Nullable
    public List<ShaLink> parents() {
        return this.parents;
    }

    public final ImmutableCommitItem withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableCommitItem(value, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents);
    }

    public final ImmutableCommitItem withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableCommitItem(this.sha, value, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents);
    }

    public final ImmutableCommitItem withCommit(@Nullable Commit value) {
        if (this.commit == value) {
            return this;
        }
        return new ImmutableCommitItem(this.sha, this.url, value, this.htmlUrl, this.commentsUrl, this.author, this.parents);
    }

    public final ImmutableCommitItem withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutableCommitItem(this.sha, this.url, this.commit, value, this.commentsUrl, this.author, this.parents);
    }

    public final ImmutableCommitItem withCommentsUrl(@Nullable URI value) {
        if (this.commentsUrl == value) {
            return this;
        }
        return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, value, this.author, this.parents);
    }

    public final ImmutableCommitItem withAuthor(User value) {
        User newValue = Objects.requireNonNull(value, "author");
        if (this.author == newValue) {
            return this;
        }
        return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, newValue, this.parents);
    }

    public final ImmutableCommitItem withAuthor(Optional<? extends User> optional) {
        User value = optional.orElse(null);
        if (this.author == value) {
            return this;
        }
        return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, value, this.parents);
    }

    public final ImmutableCommitItem withParents(ShaLink ... elements) {
        if (elements == null) {
            return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, null);
        }
        List<ShaLink> newValue = Arrays.asList(elements) == null ? null : ImmutableCommitItem.createUnmodifiableList(false, ImmutableCommitItem.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, newValue);
    }

    public final ImmutableCommitItem withParents(@Nullable Iterable<? extends ShaLink> elements) {
        if (this.parents == elements) {
            return this;
        }
        List<ShaLink> newValue = elements == null ? null : ImmutableCommitItem.createUnmodifiableList(false, ImmutableCommitItem.createSafeList(elements, true, false));
        return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitItem && this.equalTo(0, (ImmutableCommitItem)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitItem another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url) && Objects.equals(this.commit, another.commit) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.commentsUrl, another.commentsUrl) && Objects.equals(this.author, another.author) && Objects.equals(this.parents, another.parents);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.commit);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.commentsUrl);
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + Objects.hashCode(this.parents);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CommitItem{");
        if (this.sha != null) {
            builder.append("sha=").append(this.sha);
        }
        if (this.url != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.commit != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("commit=").append(this.commit);
        }
        if (this.htmlUrl != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("htmlUrl=").append(this.htmlUrl);
        }
        if (this.commentsUrl != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("commentsUrl=").append(this.commentsUrl);
        }
        if (this.author != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("author=").append(this.author);
        }
        if (this.parents != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("parents=").append(this.parents);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommitItem fromJson(Json json) {
        Builder builder = ImmutableCommitItem.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.commit != null) {
            builder.commit(json.commit);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.commentsUrl != null) {
            builder.commentsUrl(json.commentsUrl);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.parents != null) {
            builder.addAllParents(json.parents);
        }
        return builder.build();
    }

    public static ImmutableCommitItem copyOf(CommitItem instance) {
        if (instance instanceof ImmutableCommitItem) {
            return (ImmutableCommitItem)instance;
        }
        return ImmutableCommitItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CommitItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;
        @Nullable
        private Commit commit;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private URI commentsUrl;
        @Nullable
        private User author;
        private List<ShaLink> parents = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ShaLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ShaLink instance;
            long bits = 0L;
            if (object instanceof ShaLink) {
                instance = (ShaLink)object;
                if ((bits & 1L) == 0L) {
                    String shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CommitItem) {
                List<ShaLink> parentsValue;
                URI htmlUrlValue;
                Commit commitValue;
                Optional<User> authorOptional;
                instance = (CommitItem)object;
                URI commentsUrlValue = instance.commentsUrl();
                if (commentsUrlValue != null) {
                    this.commentsUrl(commentsUrlValue);
                }
                if ((authorOptional = instance.author()).isPresent()) {
                    this.author(authorOptional);
                }
                if ((commitValue = instance.commit()) != null) {
                    this.commit(commitValue);
                }
                if ((htmlUrlValue = instance.htmlUrl()) != null) {
                    this.htmlUrl(htmlUrlValue);
                }
                if ((bits & 1L) == 0L) {
                    String shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 2L;
                }
                if ((parentsValue = instance.parents()) != null) {
                    this.addAllParents(parentsValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commit(@Nullable Commit commit) {
            this.commit = commit;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder author(User author) {
            this.author = Objects.requireNonNull(author, "author");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder author(Optional<? extends User> author) {
            this.author = author.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParents(ShaLink element) {
            if (this.parents == null) {
                this.parents = new ArrayList<ShaLink>();
            }
            this.parents.add(Objects.requireNonNull(element, "parents element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParents(ShaLink ... elements) {
            if (this.parents == null) {
                this.parents = new ArrayList<ShaLink>();
            }
            for (ShaLink element : elements) {
                this.parents.add(Objects.requireNonNull(element, "parents element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder parents(@Nullable Iterable<? extends ShaLink> elements) {
            if (elements == null) {
                this.parents = null;
                return this;
            }
            this.parents = new ArrayList<ShaLink>();
            return this.addAllParents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParents(Iterable<? extends ShaLink> elements) {
            Objects.requireNonNull(elements, "parents element");
            if (this.parents == null) {
                this.parents = new ArrayList<ShaLink>();
            }
            for (ShaLink shaLink : elements) {
                this.parents.add(Objects.requireNonNull(shaLink, "parents element"));
            }
            return this;
        }

        public ImmutableCommitItem build() {
            return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents == null ? null : ImmutableCommitItem.createUnmodifiableList(true, this.parents));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommitItem", generator="Immutables")
    static final class Json
    implements CommitItem {
        @Nullable
        String sha;
        @Nullable
        URI url;
        @Nullable
        Commit commit;
        @Nullable
        URI htmlUrl;
        @Nullable
        URI commentsUrl;
        @Nullable
        Optional<User> author = Optional.empty();
        @Nullable
        List<ShaLink> parents = null;

        Json() {
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setCommit(@Nullable Commit commit) {
            this.commit = commit;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setCommentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
        }

        @JsonProperty
        public void setAuthor(Optional<User> author) {
            this.author = author;
        }

        @JsonProperty
        public void setParents(@Nullable List<ShaLink> parents) {
            this.parents = parents;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Commit commit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI commentsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<User> author() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ShaLink> parents() {
            throw new UnsupportedOperationException();
        }
    }
}

