/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.user.requests.SuspensionReason;
import java.util.concurrent.CompletableFuture;

public class UserClient {
    public static final int NO_CONTENT = 204;
    private final GitHubClient github;
    private static final String SUSPEND_USER_TEMPLATE = "/users/%s/suspended";

    UserClient(GitHubClient github) {
        this.github = github;
    }

    static UserClient create(GitHubClient github) {
        return new UserClient(github);
    }

    public CompletableFuture<Boolean> suspendUser(String username, SuspensionReason reason) {
        String path = String.format(SUSPEND_USER_TEMPLATE, username);
        return this.github.put(path, this.github.json().toJsonUnchecked(reason)).thenApply(resp -> resp.code() == 204);
    }

    public CompletableFuture<Boolean> unSuspendUser(String username, SuspensionReason reason) {
        String path = String.format(SUSPEND_USER_TEMPLATE, username);
        return this.github.delete(path, this.github.json().toJsonUnchecked(reason)).thenApply(resp -> resp.code() == 204);
    }
}

