/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.opencensus;

import com.spotify.github.Span;
import com.spotify.github.Tracer;
import com.spotify.github.opencensus.OpenCensusSpan;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public class OpenCensusTracer
implements Tracer {
    private static final io.opencensus.trace.Tracer TRACER = Tracing.getTracer();

    @Override
    public Span span(String name, String method, CompletionStage<?> future) {
        return this.internalSpan(name, method, future);
    }

    private Span internalSpan(String path, String method, CompletionStage<?> future) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(future);
        io.opencensus.trace.Span ocSpan = TRACER.spanBuilder("GitHub Request").setSpanKind(Span.Kind.CLIENT).startSpan();
        ocSpan.putAttribute("component", AttributeValue.stringAttributeValue((String)"github-api-client"));
        ocSpan.putAttribute("peer.service", AttributeValue.stringAttributeValue((String)"github"));
        ocSpan.putAttribute("http.url", AttributeValue.stringAttributeValue((String)path));
        ocSpan.putAttribute("method", AttributeValue.stringAttributeValue((String)method));
        OpenCensusSpan span = new OpenCensusSpan(ocSpan);
        future.whenComplete((result, t) -> {
            if (t == null) {
                span.success();
            } else {
                span.failure((Throwable)t);
            }
            span.close();
        });
        return span;
    }
}

