/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.CheckRunImage;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckRunImage", generator="Immutables")
@Immutable
public final class ImmutableCheckRunImage
implements CheckRunImage {
    private final String alt;
    private final String imageUrl;
    @Nullable
    private final String caption;

    private ImmutableCheckRunImage(String alt, String imageUrl, @Nullable String caption) {
        this.alt = alt;
        this.imageUrl = imageUrl;
        this.caption = caption;
    }

    @Override
    @JsonProperty
    public String alt() {
        return this.alt;
    }

    @Override
    @JsonProperty
    public String imageUrl() {
        return this.imageUrl;
    }

    @Override
    @JsonProperty
    public Optional<String> caption() {
        return Optional.ofNullable(this.caption);
    }

    public final ImmutableCheckRunImage withAlt(String value) {
        String newValue = Objects.requireNonNull(value, "alt");
        if (this.alt.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckRunImage(newValue, this.imageUrl, this.caption);
    }

    public final ImmutableCheckRunImage withImageUrl(String value) {
        String newValue = Objects.requireNonNull(value, "imageUrl");
        if (this.imageUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckRunImage(this.alt, newValue, this.caption);
    }

    public final ImmutableCheckRunImage withCaption(String value) {
        String newValue = Objects.requireNonNull(value, "caption");
        if (Objects.equals(this.caption, newValue)) {
            return this;
        }
        return new ImmutableCheckRunImage(this.alt, this.imageUrl, newValue);
    }

    public final ImmutableCheckRunImage withCaption(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.caption, value)) {
            return this;
        }
        return new ImmutableCheckRunImage(this.alt, this.imageUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckRunImage && this.equalTo(0, (ImmutableCheckRunImage)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckRunImage another) {
        return this.alt.equals(another.alt) && this.imageUrl.equals(another.imageUrl) && Objects.equals(this.caption, another.caption);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.alt.hashCode();
        h += (h << 5) + this.imageUrl.hashCode();
        h += (h << 5) + Objects.hashCode(this.caption);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CheckRunImage{");
        builder.append("alt=").append(this.alt);
        builder.append(", ");
        builder.append("imageUrl=").append(this.imageUrl);
        if (this.caption != null) {
            builder.append(", ");
            builder.append("caption=").append(this.caption);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckRunImage fromJson(Json json) {
        Builder builder = ImmutableCheckRunImage.builder();
        if (json.alt != null) {
            builder.alt(json.alt);
        }
        if (json.imageUrl != null) {
            builder.imageUrl(json.imageUrl);
        }
        if (json.caption != null) {
            builder.caption(json.caption);
        }
        return builder.build();
    }

    public static ImmutableCheckRunImage copyOf(CheckRunImage instance) {
        if (instance instanceof ImmutableCheckRunImage) {
            return (ImmutableCheckRunImage)instance;
        }
        return ImmutableCheckRunImage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CheckRunImage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ALT = 1L;
        private static final long INIT_BIT_IMAGE_URL = 2L;
        private long initBits = 3L;
        @Nullable
        private String alt;
        @Nullable
        private String imageUrl;
        @Nullable
        private String caption;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckRunImage instance) {
            Objects.requireNonNull(instance, "instance");
            this.alt(instance.alt());
            this.imageUrl(instance.imageUrl());
            Optional<String> captionOptional = instance.caption();
            if (captionOptional.isPresent()) {
                this.caption(captionOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder alt(String alt) {
            this.alt = Objects.requireNonNull(alt, "alt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder caption(String caption) {
            this.caption = Objects.requireNonNull(caption, "caption");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder caption(Optional<String> caption) {
            this.caption = caption.orElse(null);
            return this;
        }

        public ImmutableCheckRunImage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckRunImage(this.alt, this.imageUrl, this.caption);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("alt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("imageUrl");
            }
            return "Cannot build CheckRunImage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckRunImage", generator="Immutables")
    static final class Json
    implements CheckRunImage {
        @Nullable
        String alt;
        @Nullable
        String imageUrl;
        @Nullable
        Optional<String> caption = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setAlt(String alt) {
            this.alt = alt;
        }

        @JsonProperty
        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @JsonProperty
        public void setCaption(Optional<String> caption) {
            this.caption = caption;
        }

        @Override
        public String alt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String imageUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> caption() {
            throw new UnsupportedOperationException();
        }
    }
}

