/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.Commit;
import com.spotify.github.v3.repos.CommitWithFolderContent;
import com.spotify.github.v3.repos.FolderContent;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitWithFolderContent", generator="Immutables")
@Immutable
public final class ImmutableCommitWithFolderContent
implements CommitWithFolderContent {
    private final FolderContent content;
    private final Commit commit;

    private ImmutableCommitWithFolderContent(FolderContent content, Commit commit) {
        this.content = content;
        this.commit = commit;
    }

    @Override
    @JsonProperty
    public FolderContent content() {
        return this.content;
    }

    @Override
    @JsonProperty
    public Commit commit() {
        return this.commit;
    }

    public final ImmutableCommitWithFolderContent withContent(FolderContent value) {
        if (this.content == value) {
            return this;
        }
        FolderContent newValue = Objects.requireNonNull(value, "content");
        return new ImmutableCommitWithFolderContent(newValue, this.commit);
    }

    public final ImmutableCommitWithFolderContent withCommit(Commit value) {
        if (this.commit == value) {
            return this;
        }
        Commit newValue = Objects.requireNonNull(value, "commit");
        return new ImmutableCommitWithFolderContent(this.content, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitWithFolderContent && this.equalTo(0, (ImmutableCommitWithFolderContent)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitWithFolderContent another) {
        return this.content.equals(another.content) && this.commit.equals(another.commit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.commit.hashCode();
        return h;
    }

    public String toString() {
        return "CommitWithFolderContent{content=" + this.content + ", commit=" + this.commit + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommitWithFolderContent fromJson(Json json) {
        Builder builder = ImmutableCommitWithFolderContent.builder();
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.commit != null) {
            builder.commit(json.commit);
        }
        return builder.build();
    }

    public static ImmutableCommitWithFolderContent copyOf(CommitWithFolderContent instance) {
        if (instance instanceof ImmutableCommitWithFolderContent) {
            return (ImmutableCommitWithFolderContent)instance;
        }
        return ImmutableCommitWithFolderContent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitWithFolderContent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTENT = 1L;
        private static final long INIT_BIT_COMMIT = 2L;
        private long initBits = 3L;
        @Nullable
        private FolderContent content;
        @Nullable
        private Commit commit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitWithFolderContent instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.commit(instance.commit());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder content(FolderContent content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commit(Commit commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCommitWithFolderContent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitWithFolderContent(this.content, this.commit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commit");
            }
            return "Cannot build CommitWithFolderContent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommitWithFolderContent", generator="Immutables")
    static final class Json
    implements CommitWithFolderContent {
        @Nullable
        FolderContent content;
        @Nullable
        Commit commit;

        Json() {
        }

        @JsonProperty
        public void setContent(FolderContent content) {
            this.content = content;
        }

        @JsonProperty
        public void setCommit(Commit commit) {
            this.commit = commit;
        }

        @Override
        public FolderContent content() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Commit commit() {
            throw new UnsupportedOperationException();
        }
    }
}

