package com.spotify.github.http;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Pagination}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePagination.builder()}.
 */
@Generated(from = "Pagination", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePagination implements Pagination {
  private final Integer current;
  private final Integer last;
  private final @Nullable Integer previous;
  private final @Nullable Integer next;

  private ImmutablePagination(
      Integer current,
      Integer last,
      @Nullable Integer previous,
      @Nullable Integer next) {
    this.current = current;
    this.last = last;
    this.previous = previous;
    this.next = next;
  }

  /**
   * Current page number.
   * @return page number
   */
  @JsonProperty
  @Override
  public Integer current() {
    return current;
  }

  /**
   * Last page number.
   * @return page number
   */
  @JsonProperty
  @Override
  public Integer last() {
    return last;
  }

  /**
   * Previous page number.
   * @return page number
   */
  @JsonProperty
  @Override
  public Optional<Integer> previous() {
    return Optional.ofNullable(previous);
  }

  /**
   * Next page number.
   * @return page number
   */
  @JsonProperty
  @Override
  public Optional<Integer> next() {
    return Optional.ofNullable(next);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pagination#current() current} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for current
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePagination withCurrent(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "current");
    if (this.current.equals(newValue)) return this;
    return new ImmutablePagination(newValue, this.last, this.previous, this.next);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pagination#last() last} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for last
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePagination withLast(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "last");
    if (this.last.equals(newValue)) return this;
    return new ImmutablePagination(this.current, newValue, this.previous, this.next);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Pagination#previous() previous} attribute.
   * @param value The value for previous
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePagination withPrevious(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.previous, newValue)) return this;
    return new ImmutablePagination(this.current, this.last, newValue, this.next);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Pagination#previous() previous} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for previous
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePagination withPrevious(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.previous, value)) return this;
    return new ImmutablePagination(this.current, this.last, value, this.next);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Pagination#next() next} attribute.
   * @param value The value for next
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePagination withNext(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.next, newValue)) return this;
    return new ImmutablePagination(this.current, this.last, this.previous, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Pagination#next() next} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for next
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePagination withNext(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.next, value)) return this;
    return new ImmutablePagination(this.current, this.last, this.previous, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePagination} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePagination
        && equalTo(0, (ImmutablePagination) another);
  }

  private boolean equalTo(int synthetic, ImmutablePagination another) {
    return current.equals(another.current)
        && last.equals(another.last)
        && Objects.equals(previous, another.previous)
        && Objects.equals(next, another.next);
  }

  /**
   * Computes a hash code from attributes: {@code current}, {@code last}, {@code previous}, {@code next}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + current.hashCode();
    h += (h << 5) + last.hashCode();
    h += (h << 5) + Objects.hashCode(previous);
    h += (h << 5) + Objects.hashCode(next);
    return h;
  }

  /**
   * Prints the immutable value {@code Pagination} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Pagination{");
    builder.append("current=").append(current);
    builder.append(", ");
    builder.append("last=").append(last);
    if (previous != null) {
      builder.append(", ");
      builder.append("previous=").append(previous);
    }
    if (next != null) {
      builder.append(", ");
      builder.append("next=").append(next);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Pagination", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Pagination {
    @Nullable Integer current;
    @Nullable Integer last;
    @Nullable Optional<Integer> previous = Optional.empty();
    @Nullable Optional<Integer> next = Optional.empty();
    @JsonProperty
    public void setCurrent(Integer current) {
      this.current = current;
    }
    @JsonProperty
    public void setLast(Integer last) {
      this.last = last;
    }
    @JsonProperty
    public void setPrevious(Optional<Integer> previous) {
      this.previous = previous;
    }
    @JsonProperty
    public void setNext(Optional<Integer> next) {
      this.next = next;
    }
    @Override
    public Integer current() { throw new UnsupportedOperationException(); }
    @Override
    public Integer last() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> previous() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> next() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePagination fromJson(Json json) {
    ImmutablePagination.Builder builder = ImmutablePagination.builder();
    if (json.current != null) {
      builder.current(json.current);
    }
    if (json.last != null) {
      builder.last(json.last);
    }
    if (json.previous != null) {
      builder.previous(json.previous);
    }
    if (json.next != null) {
      builder.next(json.next);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Pagination} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Pagination instance
   */
  public static ImmutablePagination copyOf(Pagination instance) {
    if (instance instanceof ImmutablePagination) {
      return (ImmutablePagination) instance;
    }
    return ImmutablePagination.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePagination ImmutablePagination}.
   * <pre>
   * ImmutablePagination.builder()
   *    .current(Integer) // required {@link Pagination#current() current}
   *    .last(Integer) // required {@link Pagination#last() last}
   *    .previous(Integer) // optional {@link Pagination#previous() previous}
   *    .next(Integer) // optional {@link Pagination#next() next}
   *    .build();
   * </pre>
   * @return A new ImmutablePagination builder
   */
  public static ImmutablePagination.Builder builder() {
    return new ImmutablePagination.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePagination ImmutablePagination}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Pagination", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CURRENT = 0x1L;
    private static final long INIT_BIT_LAST = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Integer current;
    private @Nullable Integer last;
    private @Nullable Integer previous;
    private @Nullable Integer next;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Pagination} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Pagination instance) {
      Objects.requireNonNull(instance, "instance");
      current(instance.current());
      last(instance.last());
      Optional<Integer> previousOptional = instance.previous();
      if (previousOptional.isPresent()) {
        previous(previousOptional);
      }
      Optional<Integer> nextOptional = instance.next();
      if (nextOptional.isPresent()) {
        next(nextOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Pagination#current() current} attribute.
     * @param current The value for current 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder current(Integer current) {
      this.current = Objects.requireNonNull(current, "current");
      initBits &= ~INIT_BIT_CURRENT;
      return this;
    }

    /**
     * Initializes the value for the {@link Pagination#last() last} attribute.
     * @param last The value for last 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder last(Integer last) {
      this.last = Objects.requireNonNull(last, "last");
      initBits &= ~INIT_BIT_LAST;
      return this;
    }

    /**
     * Initializes the optional value {@link Pagination#previous() previous} to previous.
     * @param previous The value for previous
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder previous(int previous) {
      this.previous = previous;
      return this;
    }

    /**
     * Initializes the optional value {@link Pagination#previous() previous} to previous.
     * @param previous The value for previous
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder previous(Optional<Integer> previous) {
      this.previous = previous.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Pagination#next() next} to next.
     * @param next The value for next
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder next(int next) {
      this.next = next;
      return this;
    }

    /**
     * Initializes the optional value {@link Pagination#next() next} to next.
     * @param next The value for next
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder next(Optional<Integer> next) {
      this.next = next.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePagination ImmutablePagination}.
     * @return An immutable instance of Pagination
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePagination build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePagination(current, last, previous, next);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CURRENT) != 0) attributes.add("current");
      if ((initBits & INIT_BIT_LAST) != 0) attributes.add("last");
      return "Cannot build Pagination, some of required attributes are not set " + attributes;
    }
  }
}
