package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.prs.PullRequestItem;
import com.spotify.github.v3.prs.Review;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequestReviewEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequestReviewEvent.builder()}.
 */
@Generated(from = "PullRequestReviewEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequestReviewEvent
    implements PullRequestReviewEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable String action;
  private final @Nullable Review review;
  private final @Nullable PullRequestItem pullRequest;

  private ImmutablePullRequestReviewEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable String action,
      @Nullable Review review,
      @Nullable PullRequestItem pullRequest) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.action = action;
    this.review = review;
    this.pullRequest = pullRequest;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   *State of the action. 
   */
  @JsonProperty
  @Override
  public @Nullable String action() {
    return action;
  }

  /**
   *Review. 
   */
  @JsonProperty
  @Override
  public @Nullable Review review() {
    return review;
  }

  /**
   *Pull Request. 
   */
  @JsonProperty
  @Override
  public @Nullable PullRequestItem pullRequest() {
    return pullRequest;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutablePullRequestReviewEvent(value, this.sender, this.eventInstallation, this.action, this.review, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutablePullRequestReviewEvent(this.repository, value, this.eventInstallation, this.action, this.review, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutablePullRequestReviewEvent(this.repository, this.sender, value, this.action, this.review, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewEvent#action() action} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewEvent withAction(@Nullable String value) {
    if (Objects.equals(this.action, value)) return this;
    return new ImmutablePullRequestReviewEvent(this.repository, this.sender, this.eventInstallation, value, this.review, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewEvent#review() review} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for review (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewEvent withReview(@Nullable Review value) {
    if (this.review == value) return this;
    return new ImmutablePullRequestReviewEvent(this.repository, this.sender, this.eventInstallation, this.action, value, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewEvent#pullRequest() pullRequest} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pullRequest (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewEvent withPullRequest(@Nullable PullRequestItem value) {
    if (this.pullRequest == value) return this;
    return new ImmutablePullRequestReviewEvent(this.repository, this.sender, this.eventInstallation, this.action, this.review, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequestReviewEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequestReviewEvent
        && equalTo(0, (ImmutablePullRequestReviewEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutablePullRequestReviewEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(action, another.action)
        && Objects.equals(review, another.review)
        && Objects.equals(pullRequest, another.pullRequest);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code action}, {@code review}, {@code pullRequest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(review);
    h += (h << 5) + Objects.hashCode(pullRequest);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequestReviewEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PullRequestReviewEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", action=" + action
        + ", review=" + review
        + ", pullRequest=" + pullRequest
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequestReviewEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequestReviewEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable String action;
    @Nullable Review review;
    @Nullable PullRequestItem pullRequest;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setAction(@Nullable String action) {
      this.action = action;
    }
    @JsonProperty
    public void setReview(@Nullable Review review) {
      this.review = review;
    }
    @JsonProperty
    public void setPullRequest(@Nullable PullRequestItem pullRequest) {
      this.pullRequest = pullRequest;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public String action() { throw new UnsupportedOperationException(); }
    @Override
    public Review review() { throw new UnsupportedOperationException(); }
    @Override
    public PullRequestItem pullRequest() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequestReviewEvent fromJson(Json json) {
    ImmutablePullRequestReviewEvent.Builder builder = ImmutablePullRequestReviewEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.action != null) {
      builder.action(json.action);
    }
    if (json.review != null) {
      builder.review(json.review);
    }
    if (json.pullRequest != null) {
      builder.pullRequest(json.pullRequest);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequestReviewEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequestReviewEvent instance
   */
  public static ImmutablePullRequestReviewEvent copyOf(PullRequestReviewEvent instance) {
    if (instance instanceof ImmutablePullRequestReviewEvent) {
      return (ImmutablePullRequestReviewEvent) instance;
    }
    return ImmutablePullRequestReviewEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequestReviewEvent ImmutablePullRequestReviewEvent}.
   * <pre>
   * ImmutablePullRequestReviewEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link PullRequestReviewEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link PullRequestReviewEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link PullRequestReviewEvent#eventInstallation() eventInstallation}
   *    .action(String | null) // nullable {@link PullRequestReviewEvent#action() action}
   *    .review(com.spotify.github.v3.prs.Review | null) // nullable {@link PullRequestReviewEvent#review() review}
   *    .pullRequest(com.spotify.github.v3.prs.PullRequestItem | null) // nullable {@link PullRequestReviewEvent#pullRequest() pullRequest}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequestReviewEvent builder
   */
  public static ImmutablePullRequestReviewEvent.Builder builder() {
    return new ImmutablePullRequestReviewEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequestReviewEvent ImmutablePullRequestReviewEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequestReviewEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable String action;
    private @Nullable Review review;
    private @Nullable PullRequestItem pullRequest;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.PullRequestReviewEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequestReviewEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof PullRequestReviewEvent) {
        PullRequestReviewEvent instance = (PullRequestReviewEvent) object;
        @Nullable String actionValue = instance.action();
        if (actionValue != null) {
          action(actionValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x2L;
        }
        @Nullable Review reviewValue = instance.review();
        if (reviewValue != null) {
          review(reviewValue);
        }
        @Nullable PullRequestItem pullRequestValue = instance.pullRequest();
        if (pullRequestValue != null) {
          pullRequest(pullRequestValue);
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        if ((bits & 0x4L) == 0) {
          @Nullable Repository repositoryValue = instance.repository();
          if (repositoryValue != null) {
            repository(repositoryValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable User senderValue = instance.sender();
          if (senderValue != null) {
            sender(senderValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
          if (eventInstallationValue != null) {
            eventInstallation(eventInstallationValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link PullRequestReviewEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestReviewEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestReviewEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestReviewEvent#action() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder action(@Nullable String action) {
      this.action = action;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestReviewEvent#review() review} attribute.
     * @param review The value for review (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder review(@Nullable Review review) {
      this.review = review;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestReviewEvent#pullRequest() pullRequest} attribute.
     * @param pullRequest The value for pullRequest (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pullRequest(@Nullable PullRequestItem pullRequest) {
      this.pullRequest = pullRequest;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequestReviewEvent ImmutablePullRequestReviewEvent}.
     * @return An immutable instance of PullRequestReviewEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequestReviewEvent build() {
      return new ImmutablePullRequestReviewEvent(repository, sender, eventInstallation, action, review, pullRequest);
    }
  }
}
