package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckRunOutput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckRunOutput.builder()}.
 */
@Generated(from = "CheckRunOutput", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckRunOutput implements CheckRunOutput {
  private final @Nullable String title;
  private final @Nullable String summary;
  private final @Nullable String text;
  private final List<CheckRunImage> images;
  private final List<Annotation> annotations;
  private final @Nullable Integer annotationsCount;
  private final @Nullable String annotationsUrl;

  private ImmutableCheckRunOutput(
      @Nullable String title,
      @Nullable String summary,
      @Nullable String text,
      List<CheckRunImage> images,
      List<Annotation> annotations,
      @Nullable Integer annotationsCount,
      @Nullable String annotationsUrl) {
    this.title = title;
    this.summary = summary;
    this.text = text;
    this.images = images;
    this.annotations = annotations;
    this.annotationsCount = annotationsCount;
    this.annotationsUrl = annotationsUrl;
  }

  /**
   * The title of the check run.
   * @return the string
   */
  @JsonProperty
  @Override
  public Optional<String> title() {
    return Optional.ofNullable(title);
  }

  /**
   * The summary of the check run. This parameter supports Markdown.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<String> summary() {
    return Optional.ofNullable(summary);
  }

  /**
   * The details of the check run. This parameter supports Markdown.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<String> text() {
    return Optional.ofNullable(text);
  }

  /**
   * Adds images to the output displayed in the GitHub pull request UI.
   * @return the list
   */
  @JsonProperty
  @Override
  public List<CheckRunImage> images() {
    return images;
  }

  /**
   * Adds information from your analysis to specific lines of code. Annotations are visible on
   * GitHub in the Checks and Files changed tab of the pull request.
   * @return the list
   */
  @JsonProperty
  @Override
  public List<Annotation> annotations() {
    return annotations;
  }

  /**
   * The count of annotations. Used on response objects.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<Integer> annotationsCount() {
    return Optional.ofNullable(annotationsCount);
  }

  /**
   * Annotations URL, used on response objects.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<String> annotationsUrl() {
    return Optional.ofNullable(annotationsUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunOutput#title() title} attribute.
   * @param value The value for title
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (Objects.equals(this.title, newValue)) return this;
    return validate(new ImmutableCheckRunOutput(
        newValue,
        this.summary,
        this.text,
        this.images,
        this.annotations,
        this.annotationsCount,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunOutput#title() title} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for title
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.title, value)) return this;
    return validate(new ImmutableCheckRunOutput(
        value,
        this.summary,
        this.text,
        this.images,
        this.annotations,
        this.annotationsCount,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunOutput#summary() summary} attribute.
   * @param value The value for summary
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withSummary(String value) {
    String newValue = Objects.requireNonNull(value, "summary");
    if (Objects.equals(this.summary, newValue)) return this;
    return validate(new ImmutableCheckRunOutput(
        this.title,
        newValue,
        this.text,
        this.images,
        this.annotations,
        this.annotationsCount,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunOutput#summary() summary} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for summary
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withSummary(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.summary, value)) return this;
    return validate(new ImmutableCheckRunOutput(
        this.title,
        value,
        this.text,
        this.images,
        this.annotations,
        this.annotationsCount,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunOutput#text() text} attribute.
   * @param value The value for text
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withText(String value) {
    String newValue = Objects.requireNonNull(value, "text");
    if (Objects.equals(this.text, newValue)) return this;
    return validate(new ImmutableCheckRunOutput(
        this.title,
        this.summary,
        newValue,
        this.images,
        this.annotations,
        this.annotationsCount,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunOutput#text() text} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for text
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withText(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.text, value)) return this;
    return validate(new ImmutableCheckRunOutput(
        this.title,
        this.summary,
        value,
        this.images,
        this.annotations,
        this.annotationsCount,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckRunOutput#images() images}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withImages(CheckRunImage... elements) {
    List<CheckRunImage> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableCheckRunOutput(
        this.title,
        this.summary,
        this.text,
        newValue,
        this.annotations,
        this.annotationsCount,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckRunOutput#images() images}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of images elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withImages(Iterable<? extends CheckRunImage> elements) {
    if (this.images == elements) return this;
    List<CheckRunImage> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableCheckRunOutput(
        this.title,
        this.summary,
        this.text,
        newValue,
        this.annotations,
        this.annotationsCount,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckRunOutput#annotations() annotations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withAnnotations(Annotation... elements) {
    List<Annotation> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableCheckRunOutput(
        this.title,
        this.summary,
        this.text,
        this.images,
        newValue,
        this.annotationsCount,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckRunOutput#annotations() annotations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of annotations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withAnnotations(Iterable<? extends Annotation> elements) {
    if (this.annotations == elements) return this;
    List<Annotation> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableCheckRunOutput(
        this.title,
        this.summary,
        this.text,
        this.images,
        newValue,
        this.annotationsCount,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunOutput#annotationsCount() annotationsCount} attribute.
   * @param value The value for annotationsCount
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withAnnotationsCount(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.annotationsCount, newValue)) return this;
    return validate(new ImmutableCheckRunOutput(
        this.title,
        this.summary,
        this.text,
        this.images,
        this.annotations,
        newValue,
        this.annotationsUrl));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunOutput#annotationsCount() annotationsCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for annotationsCount
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withAnnotationsCount(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.annotationsCount, value)) return this;
    return validate(new ImmutableCheckRunOutput(this.title, this.summary, this.text, this.images, this.annotations, value, this.annotationsUrl));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunOutput#annotationsUrl() annotationsUrl} attribute.
   * @param value The value for annotationsUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withAnnotationsUrl(String value) {
    String newValue = Objects.requireNonNull(value, "annotationsUrl");
    if (Objects.equals(this.annotationsUrl, newValue)) return this;
    return validate(new ImmutableCheckRunOutput(
        this.title,
        this.summary,
        this.text,
        this.images,
        this.annotations,
        this.annotationsCount,
        newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunOutput#annotationsUrl() annotationsUrl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for annotationsUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunOutput withAnnotationsUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.annotationsUrl, value)) return this;
    return validate(new ImmutableCheckRunOutput(
        this.title,
        this.summary,
        this.text,
        this.images,
        this.annotations,
        this.annotationsCount,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckRunOutput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckRunOutput
        && equalTo(0, (ImmutableCheckRunOutput) another);
  }

  private boolean equalTo(int synthetic, ImmutableCheckRunOutput another) {
    return Objects.equals(title, another.title)
        && Objects.equals(summary, another.summary)
        && Objects.equals(text, another.text)
        && images.equals(another.images)
        && annotations.equals(another.annotations)
        && Objects.equals(annotationsCount, another.annotationsCount)
        && Objects.equals(annotationsUrl, another.annotationsUrl);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code summary}, {@code text}, {@code images}, {@code annotations}, {@code annotationsCount}, {@code annotationsUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(summary);
    h += (h << 5) + Objects.hashCode(text);
    h += (h << 5) + images.hashCode();
    h += (h << 5) + annotations.hashCode();
    h += (h << 5) + Objects.hashCode(annotationsCount);
    h += (h << 5) + Objects.hashCode(annotationsUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code CheckRunOutput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("CheckRunOutput{");
    if (title != null) {
      builder.append("title=").append(title);
    }
    if (summary != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("summary=").append(summary);
    }
    if (text != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("text=").append(text);
    }
    if (builder.length() > 15) builder.append(", ");
    builder.append("images=").append(images);
    builder.append(", ");
    builder.append("annotations=").append(annotations);
    if (annotationsCount != null) {
      builder.append(", ");
      builder.append("annotationsCount=").append(annotationsCount);
    }
    if (annotationsUrl != null) {
      builder.append(", ");
      builder.append("annotationsUrl=").append(annotationsUrl);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CheckRunOutput", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CheckRunOutput {
    @Nullable Optional<String> title = Optional.empty();
    @Nullable Optional<String> summary = Optional.empty();
    @Nullable Optional<String> text = Optional.empty();
    @Nullable List<CheckRunImage> images = Collections.emptyList();
    @Nullable List<Annotation> annotations = Collections.emptyList();
    @Nullable Optional<Integer> annotationsCount = Optional.empty();
    @Nullable Optional<String> annotationsUrl = Optional.empty();
    @JsonProperty
    public void setTitle(Optional<String> title) {
      this.title = title;
    }
    @JsonProperty
    public void setSummary(Optional<String> summary) {
      this.summary = summary;
    }
    @JsonProperty
    public void setText(Optional<String> text) {
      this.text = text;
    }
    @JsonProperty
    public void setImages(List<CheckRunImage> images) {
      this.images = images;
    }
    @JsonProperty
    public void setAnnotations(List<Annotation> annotations) {
      this.annotations = annotations;
    }
    @JsonProperty
    public void setAnnotationsCount(Optional<Integer> annotationsCount) {
      this.annotationsCount = annotationsCount;
    }
    @JsonProperty
    public void setAnnotationsUrl(Optional<String> annotationsUrl) {
      this.annotationsUrl = annotationsUrl;
    }
    @Override
    public Optional<String> title() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> summary() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> text() { throw new UnsupportedOperationException(); }
    @Override
    public List<CheckRunImage> images() { throw new UnsupportedOperationException(); }
    @Override
    public List<Annotation> annotations() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> annotationsCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> annotationsUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCheckRunOutput fromJson(Json json) {
    ImmutableCheckRunOutput.Builder builder = ImmutableCheckRunOutput.builder();
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.summary != null) {
      builder.summary(json.summary);
    }
    if (json.text != null) {
      builder.text(json.text);
    }
    if (json.images != null) {
      builder.addAllImages(json.images);
    }
    if (json.annotations != null) {
      builder.addAllAnnotations(json.annotations);
    }
    if (json.annotationsCount != null) {
      builder.annotationsCount(json.annotationsCount);
    }
    if (json.annotationsUrl != null) {
      builder.annotationsUrl(json.annotationsUrl);
    }
    return builder.build();
  }

  private static ImmutableCheckRunOutput validate(ImmutableCheckRunOutput instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link CheckRunOutput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckRunOutput instance
   */
  public static ImmutableCheckRunOutput copyOf(CheckRunOutput instance) {
    if (instance instanceof ImmutableCheckRunOutput) {
      return (ImmutableCheckRunOutput) instance;
    }
    return ImmutableCheckRunOutput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckRunOutput ImmutableCheckRunOutput}.
   * <pre>
   * ImmutableCheckRunOutput.builder()
   *    .title(String) // optional {@link CheckRunOutput#title() title}
   *    .summary(String) // optional {@link CheckRunOutput#summary() summary}
   *    .text(String) // optional {@link CheckRunOutput#text() text}
   *    .addImages|addAllImages(com.spotify.github.v3.checks.CheckRunImage) // {@link CheckRunOutput#images() images} elements
   *    .addAnnotations|addAllAnnotations(com.spotify.github.v3.checks.Annotation) // {@link CheckRunOutput#annotations() annotations} elements
   *    .annotationsCount(Integer) // optional {@link CheckRunOutput#annotationsCount() annotationsCount}
   *    .annotationsUrl(String) // optional {@link CheckRunOutput#annotationsUrl() annotationsUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableCheckRunOutput builder
   */
  public static ImmutableCheckRunOutput.Builder builder() {
    return new ImmutableCheckRunOutput.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckRunOutput ImmutableCheckRunOutput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckRunOutput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String title;
    private @Nullable String summary;
    private @Nullable String text;
    private List<CheckRunImage> images = new ArrayList<CheckRunImage>();
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private @Nullable Integer annotationsCount;
    private @Nullable String annotationsUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckRunOutput} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckRunOutput instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> titleOptional = instance.title();
      if (titleOptional.isPresent()) {
        title(titleOptional);
      }
      Optional<String> summaryOptional = instance.summary();
      if (summaryOptional.isPresent()) {
        summary(summaryOptional);
      }
      Optional<String> textOptional = instance.text();
      if (textOptional.isPresent()) {
        text(textOptional);
      }
      addAllImages(instance.images());
      addAllAnnotations(instance.annotations());
      Optional<Integer> annotationsCountOptional = instance.annotationsCount();
      if (annotationsCountOptional.isPresent()) {
        annotationsCount(annotationsCountOptional);
      }
      Optional<String> annotationsUrlOptional = instance.annotationsUrl();
      if (annotationsUrlOptional.isPresent()) {
        annotationsUrl(annotationsUrlOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunOutput#title() title} to title.
     * @param title The value for title
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunOutput#title() title} to title.
     * @param title The value for title
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder title(Optional<String> title) {
      this.title = title.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunOutput#summary() summary} to summary.
     * @param summary The value for summary
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder summary(String summary) {
      this.summary = Objects.requireNonNull(summary, "summary");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunOutput#summary() summary} to summary.
     * @param summary The value for summary
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder summary(Optional<String> summary) {
      this.summary = summary.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunOutput#text() text} to text.
     * @param text The value for text
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder text(String text) {
      this.text = Objects.requireNonNull(text, "text");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunOutput#text() text} to text.
     * @param text The value for text
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder text(Optional<String> text) {
      this.text = text.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link CheckRunOutput#images() images} list.
     * @param element A images element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImages(CheckRunImage element) {
      this.images.add(Objects.requireNonNull(element, "images element"));
      return this;
    }

    /**
     * Adds elements to {@link CheckRunOutput#images() images} list.
     * @param elements An array of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImages(CheckRunImage... elements) {
      for (CheckRunImage element : elements) {
        this.images.add(Objects.requireNonNull(element, "images element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CheckRunOutput#images() images} list.
     * @param elements An iterable of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder images(Iterable<? extends CheckRunImage> elements) {
      this.images.clear();
      return addAllImages(elements);
    }

    /**
     * Adds elements to {@link CheckRunOutput#images() images} list.
     * @param elements An iterable of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllImages(Iterable<? extends CheckRunImage> elements) {
      for (CheckRunImage element : elements) {
        this.images.add(Objects.requireNonNull(element, "images element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CheckRunOutput#annotations() annotations} list.
     * @param element A annotations element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAnnotations(Annotation element) {
      this.annotations.add(Objects.requireNonNull(element, "annotations element"));
      return this;
    }

    /**
     * Adds elements to {@link CheckRunOutput#annotations() annotations} list.
     * @param elements An array of annotations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAnnotations(Annotation... elements) {
      for (Annotation element : elements) {
        this.annotations.add(Objects.requireNonNull(element, "annotations element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CheckRunOutput#annotations() annotations} list.
     * @param elements An iterable of annotations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder annotations(Iterable<? extends Annotation> elements) {
      this.annotations.clear();
      return addAllAnnotations(elements);
    }

    /**
     * Adds elements to {@link CheckRunOutput#annotations() annotations} list.
     * @param elements An iterable of annotations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAnnotations(Iterable<? extends Annotation> elements) {
      for (Annotation element : elements) {
        this.annotations.add(Objects.requireNonNull(element, "annotations element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunOutput#annotationsCount() annotationsCount} to annotationsCount.
     * @param annotationsCount The value for annotationsCount
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder annotationsCount(int annotationsCount) {
      this.annotationsCount = annotationsCount;
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunOutput#annotationsCount() annotationsCount} to annotationsCount.
     * @param annotationsCount The value for annotationsCount
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder annotationsCount(Optional<Integer> annotationsCount) {
      this.annotationsCount = annotationsCount.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunOutput#annotationsUrl() annotationsUrl} to annotationsUrl.
     * @param annotationsUrl The value for annotationsUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder annotationsUrl(String annotationsUrl) {
      this.annotationsUrl = Objects.requireNonNull(annotationsUrl, "annotationsUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunOutput#annotationsUrl() annotationsUrl} to annotationsUrl.
     * @param annotationsUrl The value for annotationsUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder annotationsUrl(Optional<String> annotationsUrl) {
      this.annotationsUrl = annotationsUrl.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckRunOutput ImmutableCheckRunOutput}.
     * @return An immutable instance of CheckRunOutput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckRunOutput build() {
      return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(
          title,
          summary,
          text,
          createUnmodifiableList(true, images),
          createUnmodifiableList(true, annotations),
          annotationsCount,
          annotationsUrl));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
