package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckRunResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckRunResponse.builder()}.
 */
@Generated(from = "CheckRunResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckRunResponse implements CheckRunResponse {
  private final String headSha;
  private final String name;
  private final CheckRunStatus status;
  private final @Nullable CheckRunConclusion conclusion;
  private final @Nullable ZonedDateTime startedAt;
  private final @Nullable ZonedDateTime completedAt;
  private final @Nullable String externalId;
  private final @Nullable String detailsUrl;
  private final long id;
  private final String url;
  private final String htmlUrl;
  private final CheckRunOutput output;
  private final @Nullable CheckSuite checkSuite;
  private final @Nullable App app;

  private ImmutableCheckRunResponse(
      String headSha,
      String name,
      CheckRunStatus status,
      @Nullable CheckRunConclusion conclusion,
      @Nullable ZonedDateTime startedAt,
      @Nullable ZonedDateTime completedAt,
      @Nullable String externalId,
      @Nullable String detailsUrl,
      long id,
      String url,
      String htmlUrl,
      CheckRunOutput output,
      @Nullable CheckSuite checkSuite,
      @Nullable App app) {
    this.headSha = headSha;
    this.name = name;
    this.status = status;
    this.conclusion = conclusion;
    this.startedAt = startedAt;
    this.completedAt = completedAt;
    this.externalId = externalId;
    this.detailsUrl = detailsUrl;
    this.id = id;
    this.url = url;
    this.htmlUrl = htmlUrl;
    this.output = output;
    this.checkSuite = checkSuite;
    this.app = app;
  }

  /**
   * The SHA of the commit.
   * @return the string
   */
  @JsonProperty
  @Override
  public String headSha() {
    return headSha;
  }

  /**
   * The name of the check. For example, "code-coverage".
   * @return the string
   */
  @JsonProperty
  @Override
  public String name() {
    return name;
  }

  /**
   * The current status. Can be one of queued, in_progress, or completed.
   * @return the check run status enum
   */
  @JsonProperty
  @Override
  public CheckRunStatus status() {
    return status;
  }

  /**
   * The final conclusion of the check. Can be one of success, failure, neutral, cancelled,
   * timed_out, or action_required. When the conclusion is action_required, additional details
   * should be provided on the site specified by details_url. Required if you provide completedAt or
   * a status of completed.
   * @return the conclusion
   */
  @JsonProperty
  @Override
  public Optional<CheckRunConclusion> conclusion() {
    return Optional.ofNullable(conclusion);
  }

  /**
   * The time that the check run began.
   * @return the zoned date time
   */
  @JsonProperty
  @Override
  public Optional<ZonedDateTime> startedAt() {
    return Optional.ofNullable(startedAt);
  }

  /**
   * The time that the check completed.
   * @return the zoned date time
   */
  @JsonProperty
  @Override
  public Optional<ZonedDateTime> completedAt() {
    return Optional.ofNullable(completedAt);
  }

  /**
   * A reference for the run on the integrator's system.
   * @return the optional string
   */
  @JsonProperty
  @Override
  public Optional<String> externalId() {
    return Optional.ofNullable(externalId);
  }

  /**
   * The URL of the integrator's site that has the full details of the check. If the integrator does
   * not provide this, then the homepage of the GitHub app is used.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<String> detailsUrl() {
    return Optional.ofNullable(detailsUrl);
  }

  /**
   * The CheckRun ID.
   * @return the int
   */
  @JsonProperty
  @Override
  public long id() {
    return id;
  }

  /**
   * Url string.
   * @return the string
   */
  @JsonProperty
  @Override
  public String url() {
    return url;
  }

  /**
   * Html url string.
   * @return the string
   */
  @JsonProperty
  @Override
  public String htmlUrl() {
    return htmlUrl;
  }

  /**
   * The check run output.
   * @see com.spotify.github.v3.checks.CheckRunOutput
   * @return the check run output
   */
  @JsonProperty
  @Override
  public CheckRunOutput output() {
    return output;
  }

  /**
   * Check suite this CheckRun belongs to.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<CheckSuite> checkSuite() {
    return Optional.ofNullable(checkSuite);
  }

  /**
   * App which this check ran.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<App> app() {
    return Optional.ofNullable(app);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunResponse#headSha() headSha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for headSha
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunResponse withHeadSha(String value) {
    String newValue = Objects.requireNonNull(value, "headSha");
    if (this.headSha.equals(newValue)) return this;
    return new ImmutableCheckRunResponse(
        newValue,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunResponse#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunResponse withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        newValue,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunResponse#status() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunResponse withStatus(CheckRunStatus value) {
    CheckRunStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status == newValue) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        newValue,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunResponse#conclusion() conclusion} attribute.
   * @param value The value for conclusion
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponse withConclusion(CheckRunConclusion value) {
    CheckRunConclusion newValue = Objects.requireNonNull(value, "conclusion");
    if (this.conclusion == newValue) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        newValue,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunResponse#conclusion() conclusion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for conclusion
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheckRunResponse withConclusion(Optional<? extends CheckRunConclusion> optional) {
    @Nullable CheckRunConclusion value = optional.orElse(null);
    if (this.conclusion == value) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        value,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunResponse#startedAt() startedAt} attribute.
   * @param value The value for startedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponse withStartedAt(ZonedDateTime value) {
    ZonedDateTime newValue = Objects.requireNonNull(value, "startedAt");
    if (this.startedAt == newValue) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        newValue,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunResponse#startedAt() startedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for startedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheckRunResponse withStartedAt(Optional<? extends ZonedDateTime> optional) {
    @Nullable ZonedDateTime value = optional.orElse(null);
    if (this.startedAt == value) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        value,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunResponse#completedAt() completedAt} attribute.
   * @param value The value for completedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponse withCompletedAt(ZonedDateTime value) {
    ZonedDateTime newValue = Objects.requireNonNull(value, "completedAt");
    if (this.completedAt == newValue) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        newValue,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunResponse#completedAt() completedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for completedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheckRunResponse withCompletedAt(Optional<? extends ZonedDateTime> optional) {
    @Nullable ZonedDateTime value = optional.orElse(null);
    if (this.completedAt == value) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        value,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunResponse#externalId() externalId} attribute.
   * @param value The value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponse withExternalId(String value) {
    String newValue = Objects.requireNonNull(value, "externalId");
    if (Objects.equals(this.externalId, newValue)) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        newValue,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunResponse#externalId() externalId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponse withExternalId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.externalId, value)) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        value,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunResponse#detailsUrl() detailsUrl} attribute.
   * @param value The value for detailsUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponse withDetailsUrl(String value) {
    String newValue = Objects.requireNonNull(value, "detailsUrl");
    if (Objects.equals(this.detailsUrl, newValue)) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        newValue,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunResponse#detailsUrl() detailsUrl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for detailsUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponse withDetailsUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.detailsUrl, value)) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        value,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunResponse#id() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunResponse withId(long value) {
    if (this.id == value) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        value,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunResponse#url() url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunResponse withUrl(String value) {
    String newValue = Objects.requireNonNull(value, "url");
    if (this.url.equals(newValue)) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        newValue,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunResponse#htmlUrl() htmlUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunResponse withHtmlUrl(String value) {
    String newValue = Objects.requireNonNull(value, "htmlUrl");
    if (this.htmlUrl.equals(newValue)) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        newValue,
        this.output,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunResponse#output() output} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for output
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunResponse withOutput(CheckRunOutput value) {
    if (this.output == value) return this;
    CheckRunOutput newValue = Objects.requireNonNull(value, "output");
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        newValue,
        this.checkSuite,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunResponse#checkSuite() checkSuite} attribute.
   * @param value The value for checkSuite
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponse withCheckSuite(CheckSuite value) {
    CheckSuite newValue = Objects.requireNonNull(value, "checkSuite");
    if (this.checkSuite == newValue) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        newValue,
        this.app);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunResponse#checkSuite() checkSuite} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for checkSuite
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheckRunResponse withCheckSuite(Optional<? extends CheckSuite> optional) {
    @Nullable CheckSuite value = optional.orElse(null);
    if (this.checkSuite == value) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        value,
        this.app);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunResponse#app() app} attribute.
   * @param value The value for app
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunResponse withApp(App value) {
    App newValue = Objects.requireNonNull(value, "app");
    if (this.app == newValue) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunResponse#app() app} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for app
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheckRunResponse withApp(Optional<? extends App> optional) {
    @Nullable App value = optional.orElse(null);
    if (this.app == value) return this;
    return new ImmutableCheckRunResponse(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.id,
        this.url,
        this.htmlUrl,
        this.output,
        this.checkSuite,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckRunResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckRunResponse
        && equalTo(0, (ImmutableCheckRunResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableCheckRunResponse another) {
    return headSha.equals(another.headSha)
        && name.equals(another.name)
        && status.equals(another.status)
        && Objects.equals(conclusion, another.conclusion)
        && Objects.equals(startedAt, another.startedAt)
        && Objects.equals(completedAt, another.completedAt)
        && Objects.equals(externalId, another.externalId)
        && Objects.equals(detailsUrl, another.detailsUrl)
        && id == another.id
        && url.equals(another.url)
        && htmlUrl.equals(another.htmlUrl)
        && output.equals(another.output)
        && Objects.equals(checkSuite, another.checkSuite)
        && Objects.equals(app, another.app);
  }

  /**
   * Computes a hash code from attributes: {@code headSha}, {@code name}, {@code status}, {@code conclusion}, {@code startedAt}, {@code completedAt}, {@code externalId}, {@code detailsUrl}, {@code id}, {@code url}, {@code htmlUrl}, {@code output}, {@code checkSuite}, {@code app}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + headSha.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(conclusion);
    h += (h << 5) + Objects.hashCode(startedAt);
    h += (h << 5) + Objects.hashCode(completedAt);
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + Objects.hashCode(detailsUrl);
    h += (h << 5) + Long.hashCode(id);
    h += (h << 5) + url.hashCode();
    h += (h << 5) + htmlUrl.hashCode();
    h += (h << 5) + output.hashCode();
    h += (h << 5) + Objects.hashCode(checkSuite);
    h += (h << 5) + Objects.hashCode(app);
    return h;
  }

  /**
   * Prints the immutable value {@code CheckRunResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("CheckRunResponse{");
    builder.append("headSha=").append(headSha);
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("status=").append(status);
    if (conclusion != null) {
      builder.append(", ");
      builder.append("conclusion=").append(conclusion);
    }
    if (startedAt != null) {
      builder.append(", ");
      builder.append("startedAt=").append(startedAt);
    }
    if (completedAt != null) {
      builder.append(", ");
      builder.append("completedAt=").append(completedAt);
    }
    if (externalId != null) {
      builder.append(", ");
      builder.append("externalId=").append(externalId);
    }
    if (detailsUrl != null) {
      builder.append(", ");
      builder.append("detailsUrl=").append(detailsUrl);
    }
    builder.append(", ");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("url=").append(url);
    builder.append(", ");
    builder.append("htmlUrl=").append(htmlUrl);
    builder.append(", ");
    builder.append("output=").append(output);
    if (checkSuite != null) {
      builder.append(", ");
      builder.append("checkSuite=").append(checkSuite);
    }
    if (app != null) {
      builder.append(", ");
      builder.append("app=").append(app);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CheckRunResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CheckRunResponse {
    @Nullable String headSha;
    @Nullable String name;
    @Nullable CheckRunStatus status;
    @Nullable Optional<CheckRunConclusion> conclusion = Optional.empty();
    @Nullable Optional<ZonedDateTime> startedAt = Optional.empty();
    @Nullable Optional<ZonedDateTime> completedAt = Optional.empty();
    @Nullable Optional<String> externalId = Optional.empty();
    @Nullable Optional<String> detailsUrl = Optional.empty();
    long id;
    boolean idIsSet;
    @Nullable String url;
    @Nullable String htmlUrl;
    @Nullable CheckRunOutput output;
    @Nullable Optional<CheckSuite> checkSuite = Optional.empty();
    @Nullable Optional<App> app = Optional.empty();
    @JsonProperty
    public void setHeadSha(String headSha) {
      this.headSha = headSha;
    }
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setStatus(CheckRunStatus status) {
      this.status = status;
    }
    @JsonProperty
    public void setConclusion(Optional<CheckRunConclusion> conclusion) {
      this.conclusion = conclusion;
    }
    @JsonProperty
    public void setStartedAt(Optional<ZonedDateTime> startedAt) {
      this.startedAt = startedAt;
    }
    @JsonProperty
    public void setCompletedAt(Optional<ZonedDateTime> completedAt) {
      this.completedAt = completedAt;
    }
    @JsonProperty
    public void setExternalId(Optional<String> externalId) {
      this.externalId = externalId;
    }
    @JsonProperty
    public void setDetailsUrl(Optional<String> detailsUrl) {
      this.detailsUrl = detailsUrl;
    }
    @JsonProperty
    public void setId(long id) {
      this.id = id;
      this.idIsSet = true;
    }
    @JsonProperty
    public void setUrl(String url) {
      this.url = url;
    }
    @JsonProperty
    public void setHtmlUrl(String htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setOutput(CheckRunOutput output) {
      this.output = output;
    }
    @JsonProperty
    public void setCheckSuite(Optional<CheckSuite> checkSuite) {
      this.checkSuite = checkSuite;
    }
    @JsonProperty
    public void setApp(Optional<App> app) {
      this.app = app;
    }
    @Override
    public String headSha() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public CheckRunStatus status() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<CheckRunConclusion> conclusion() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ZonedDateTime> startedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ZonedDateTime> completedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> externalId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> detailsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public long id() { throw new UnsupportedOperationException(); }
    @Override
    public String url() { throw new UnsupportedOperationException(); }
    @Override
    public String htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public CheckRunOutput output() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<CheckSuite> checkSuite() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<App> app() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCheckRunResponse fromJson(Json json) {
    ImmutableCheckRunResponse.Builder builder = ImmutableCheckRunResponse.builder();
    if (json.headSha != null) {
      builder.headSha(json.headSha);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.conclusion != null) {
      builder.conclusion(json.conclusion);
    }
    if (json.startedAt != null) {
      builder.startedAt(json.startedAt);
    }
    if (json.completedAt != null) {
      builder.completedAt(json.completedAt);
    }
    if (json.externalId != null) {
      builder.externalId(json.externalId);
    }
    if (json.detailsUrl != null) {
      builder.detailsUrl(json.detailsUrl);
    }
    if (json.idIsSet) {
      builder.id(json.id);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.output != null) {
      builder.output(json.output);
    }
    if (json.checkSuite != null) {
      builder.checkSuite(json.checkSuite);
    }
    if (json.app != null) {
      builder.app(json.app);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CheckRunResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckRunResponse instance
   */
  public static ImmutableCheckRunResponse copyOf(CheckRunResponse instance) {
    if (instance instanceof ImmutableCheckRunResponse) {
      return (ImmutableCheckRunResponse) instance;
    }
    return ImmutableCheckRunResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckRunResponse ImmutableCheckRunResponse}.
   * <pre>
   * ImmutableCheckRunResponse.builder()
   *    .headSha(String) // required {@link CheckRunResponse#headSha() headSha}
   *    .name(String) // required {@link CheckRunResponse#name() name}
   *    .status(com.spotify.github.v3.checks.CheckRunStatus) // required {@link CheckRunResponse#status() status}
   *    .conclusion(com.spotify.github.v3.checks.CheckRunConclusion) // optional {@link CheckRunResponse#conclusion() conclusion}
   *    .startedAt(java.time.ZonedDateTime) // optional {@link CheckRunResponse#startedAt() startedAt}
   *    .completedAt(java.time.ZonedDateTime) // optional {@link CheckRunResponse#completedAt() completedAt}
   *    .externalId(String) // optional {@link CheckRunResponse#externalId() externalId}
   *    .detailsUrl(String) // optional {@link CheckRunResponse#detailsUrl() detailsUrl}
   *    .id(long) // required {@link CheckRunResponse#id() id}
   *    .url(String) // required {@link CheckRunResponse#url() url}
   *    .htmlUrl(String) // required {@link CheckRunResponse#htmlUrl() htmlUrl}
   *    .output(com.spotify.github.v3.checks.CheckRunOutput) // required {@link CheckRunResponse#output() output}
   *    .checkSuite(com.spotify.github.v3.checks.CheckSuite) // optional {@link CheckRunResponse#checkSuite() checkSuite}
   *    .app(com.spotify.github.v3.checks.App) // optional {@link CheckRunResponse#app() app}
   *    .build();
   * </pre>
   * @return A new ImmutableCheckRunResponse builder
   */
  public static ImmutableCheckRunResponse.Builder builder() {
    return new ImmutableCheckRunResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckRunResponse ImmutableCheckRunResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckRunResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HEAD_SHA = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_STATUS = 0x4L;
    private static final long INIT_BIT_ID = 0x8L;
    private static final long INIT_BIT_URL = 0x10L;
    private static final long INIT_BIT_HTML_URL = 0x20L;
    private static final long INIT_BIT_OUTPUT = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable String headSha;
    private @Nullable String name;
    private @Nullable CheckRunStatus status;
    private @Nullable CheckRunConclusion conclusion;
    private @Nullable ZonedDateTime startedAt;
    private @Nullable ZonedDateTime completedAt;
    private @Nullable String externalId;
    private @Nullable String detailsUrl;
    private long id;
    private @Nullable String url;
    private @Nullable String htmlUrl;
    private @Nullable CheckRunOutput output;
    private @Nullable CheckSuite checkSuite;
    private @Nullable App app;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.checks.CheckRunBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckRunBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.checks.CheckRunResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckRunResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof CheckRunBase) {
        CheckRunBase instance = (CheckRunBase) object;
        if ((bits & 0x20L) == 0) {
          Optional<CheckRunConclusion> conclusionOptional = instance.conclusion();
          if (conclusionOptional.isPresent()) {
            conclusion(conclusionOptional);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x1L) == 0) {
          Optional<ZonedDateTime> completedAtOptional = instance.completedAt();
          if (completedAtOptional.isPresent()) {
            completedAt(completedAtOptional);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          Optional<String> detailsUrlOptional = instance.detailsUrl();
          if (detailsUrlOptional.isPresent()) {
            detailsUrl(detailsUrlOptional);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x40L) == 0) {
          name(instance.name());
          bits |= 0x40L;
        }
        if ((bits & 0x4L) == 0) {
          Optional<ZonedDateTime> startedAtOptional = instance.startedAt();
          if (startedAtOptional.isPresent()) {
            startedAt(startedAtOptional);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          Optional<String> externalIdOptional = instance.externalId();
          if (externalIdOptional.isPresent()) {
            externalId(externalIdOptional);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          headSha(instance.headSha());
          bits |= 0x10L;
        }
        if ((bits & 0x80L) == 0) {
          status(instance.status());
          bits |= 0x80L;
        }
      }
      if (object instanceof CheckRunResponse) {
        CheckRunResponse instance = (CheckRunResponse) object;
        Optional<App> appOptional = instance.app();
        if (appOptional.isPresent()) {
          app(appOptional);
        }
        if ((bits & 0x1L) == 0) {
          Optional<ZonedDateTime> completedAtOptional = instance.completedAt();
          if (completedAtOptional.isPresent()) {
            completedAt(completedAtOptional);
          }
          bits |= 0x1L;
        }
        Optional<CheckSuite> checkSuiteOptional = instance.checkSuite();
        if (checkSuiteOptional.isPresent()) {
          checkSuite(checkSuiteOptional);
        }
        if ((bits & 0x2L) == 0) {
          Optional<String> detailsUrlOptional = instance.detailsUrl();
          if (detailsUrlOptional.isPresent()) {
            detailsUrl(detailsUrlOptional);
          }
          bits |= 0x2L;
        }
        htmlUrl(instance.htmlUrl());
        if ((bits & 0x4L) == 0) {
          Optional<ZonedDateTime> startedAtOptional = instance.startedAt();
          if (startedAtOptional.isPresent()) {
            startedAt(startedAtOptional);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          Optional<String> externalIdOptional = instance.externalId();
          if (externalIdOptional.isPresent()) {
            externalId(externalIdOptional);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          headSha(instance.headSha());
          bits |= 0x10L;
        }
        url(instance.url());
        if ((bits & 0x20L) == 0) {
          Optional<CheckRunConclusion> conclusionOptional = instance.conclusion();
          if (conclusionOptional.isPresent()) {
            conclusion(conclusionOptional);
          }
          bits |= 0x20L;
        }
        output(instance.output());
        if ((bits & 0x40L) == 0) {
          name(instance.name());
          bits |= 0x40L;
        }
        id(instance.id());
        if ((bits & 0x80L) == 0) {
          status(instance.status());
          bits |= 0x80L;
        }
      }
    }

    /**
     * Initializes the value for the {@link CheckRunResponse#headSha() headSha} attribute.
     * @param headSha The value for headSha 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder headSha(String headSha) {
      this.headSha = Objects.requireNonNull(headSha, "headSha");
      initBits &= ~INIT_BIT_HEAD_SHA;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunResponse#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunResponse#status() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder status(CheckRunStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#conclusion() conclusion} to conclusion.
     * @param conclusion The value for conclusion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder conclusion(CheckRunConclusion conclusion) {
      this.conclusion = Objects.requireNonNull(conclusion, "conclusion");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#conclusion() conclusion} to conclusion.
     * @param conclusion The value for conclusion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder conclusion(Optional<? extends CheckRunConclusion> conclusion) {
      this.conclusion = conclusion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#startedAt() startedAt} to startedAt.
     * @param startedAt The value for startedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder startedAt(ZonedDateTime startedAt) {
      this.startedAt = Objects.requireNonNull(startedAt, "startedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#startedAt() startedAt} to startedAt.
     * @param startedAt The value for startedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder startedAt(Optional<? extends ZonedDateTime> startedAt) {
      this.startedAt = startedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#completedAt() completedAt} to completedAt.
     * @param completedAt The value for completedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder completedAt(ZonedDateTime completedAt) {
      this.completedAt = Objects.requireNonNull(completedAt, "completedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#completedAt() completedAt} to completedAt.
     * @param completedAt The value for completedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder completedAt(Optional<? extends ZonedDateTime> completedAt) {
      this.completedAt = completedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#externalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder externalId(String externalId) {
      this.externalId = Objects.requireNonNull(externalId, "externalId");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#externalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder externalId(Optional<String> externalId) {
      this.externalId = externalId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#detailsUrl() detailsUrl} to detailsUrl.
     * @param detailsUrl The value for detailsUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder detailsUrl(String detailsUrl) {
      this.detailsUrl = Objects.requireNonNull(detailsUrl, "detailsUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#detailsUrl() detailsUrl} to detailsUrl.
     * @param detailsUrl The value for detailsUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder detailsUrl(Optional<String> detailsUrl) {
      this.detailsUrl = detailsUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunResponse#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(long id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunResponse#url() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunResponse#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(String htmlUrl) {
      this.htmlUrl = Objects.requireNonNull(htmlUrl, "htmlUrl");
      initBits &= ~INIT_BIT_HTML_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunResponse#output() output} attribute.
     * @param output The value for output 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder output(CheckRunOutput output) {
      this.output = Objects.requireNonNull(output, "output");
      initBits &= ~INIT_BIT_OUTPUT;
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#checkSuite() checkSuite} to checkSuite.
     * @param checkSuite The value for checkSuite
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder checkSuite(CheckSuite checkSuite) {
      this.checkSuite = Objects.requireNonNull(checkSuite, "checkSuite");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#checkSuite() checkSuite} to checkSuite.
     * @param checkSuite The value for checkSuite
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder checkSuite(Optional<? extends CheckSuite> checkSuite) {
      this.checkSuite = checkSuite.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#app() app} to app.
     * @param app The value for app
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder app(App app) {
      this.app = Objects.requireNonNull(app, "app");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunResponse#app() app} to app.
     * @param app The value for app
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder app(Optional<? extends App> app) {
      this.app = app.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckRunResponse ImmutableCheckRunResponse}.
     * @return An immutable instance of CheckRunResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckRunResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCheckRunResponse(
          headSha,
          name,
          status,
          conclusion,
          startedAt,
          completedAt,
          externalId,
          detailsUrl,
          id,
          url,
          htmlUrl,
          output,
          checkSuite,
          app);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HEAD_SHA) != 0) attributes.add("headSha");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      if ((initBits & INIT_BIT_HTML_URL) != 0) attributes.add("htmlUrl");
      if ((initBits & INIT_BIT_OUTPUT) != 0) attributes.add("output");
      return "Cannot build CheckRunResponse, some of required attributes are not set " + attributes;
    }
  }
}
