package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Installation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInstallation.builder()}.
 */
@Generated(from = "Installation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableInstallation implements Installation {
  private final int id;
  private final User account;
  private final String accessTokensUrl;
  private final String repositoriesUrl;
  private final @Nullable String htmlUrl;
  private final int appId;
  private final int targetId;
  private final String targetType;
  private final Map<String, String> permissions;
  private final List<String> events;
  private final @Nullable String singleFileName;
  private final @Nullable String repositorySelection;

  private ImmutableInstallation(
      int id,
      User account,
      String accessTokensUrl,
      String repositoriesUrl,
      @Nullable String htmlUrl,
      int appId,
      int targetId,
      String targetType,
      Map<String, String> permissions,
      List<String> events,
      @Nullable String singleFileName,
      @Nullable String repositorySelection) {
    this.id = id;
    this.account = account;
    this.accessTokensUrl = accessTokensUrl;
    this.repositoriesUrl = repositoriesUrl;
    this.htmlUrl = htmlUrl;
    this.appId = appId;
    this.targetId = targetId;
    this.targetType = targetType;
    this.permissions = permissions;
    this.events = events;
    this.singleFileName = singleFileName;
    this.repositorySelection = repositorySelection;
  }

  /**
   * The installation ID.
   * @return the int
   */
  @JsonProperty
  @Override
  public int id() {
    return id;
  }

  /**
   * Account user.
   * @return the user
   */
  @JsonProperty
  @Override
  public User account() {
    return account;
  }

  /**
   * Access tokens url.
   * @return the url string
   */
  @JsonProperty
  @Override
  public String accessTokensUrl() {
    return accessTokensUrl;
  }

  /**
   * Repositories url.
   * @return the url string
   */
  @JsonProperty
  @Override
  public String repositoriesUrl() {
    return repositoriesUrl;
  }

  /**
   * Html URL to Github.
   * @return the optional url
   */
  @JsonProperty
  @Override
  public Optional<String> htmlUrl() {
    return Optional.ofNullable(htmlUrl);
  }

  /**
   * The APP ID the installations refers to.
   * @return the int
   */
  @JsonProperty
  @Override
  public int appId() {
    return appId;
  }

  /**
   * The ID of the entity it is installed on. Usually a repo.
   * @return the int
   */
  @JsonProperty
  @Override
  public int targetId() {
    return targetId;
  }

  /**
   * Target type. Can be Organization.
   * @return the string
   */
  @JsonProperty
  @Override
  public String targetType() {
    return targetType;
  }

  /**
   * Permissions map this installation has.
   * @return the map
   */
  @JsonProperty
  @Override
  public Map<String, String> permissions() {
    return permissions;
  }

  /**
   * Events list this installation will consume, such as push, pull_request, etc.
   * @return the list
   */
  @JsonProperty
  @Override
  public List<String> events() {
    return events;
  }

  /**
   * Single file name optional.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<String> singleFileName() {
    return Optional.ofNullable(singleFileName);
  }

  /**
   * Indicates if the App is installed in all repos of the org, or just selected. Can be all or
   * selected.
   * @return the optional string
   */
  @JsonProperty
  @Override
  public Optional<String> repositorySelection() {
    return Optional.ofNullable(repositorySelection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Installation#id() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstallation withId(int value) {
    if (this.id == value) return this;
    return new ImmutableInstallation(
        value,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Installation#account() account} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for account
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstallation withAccount(User value) {
    if (this.account == value) return this;
    User newValue = Objects.requireNonNull(value, "account");
    return new ImmutableInstallation(
        this.id,
        newValue,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Installation#accessTokensUrl() accessTokensUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for accessTokensUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstallation withAccessTokensUrl(String value) {
    String newValue = Objects.requireNonNull(value, "accessTokensUrl");
    if (this.accessTokensUrl.equals(newValue)) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        newValue,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Installation#repositoriesUrl() repositoriesUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repositoriesUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstallation withRepositoriesUrl(String value) {
    String newValue = Objects.requireNonNull(value, "repositoriesUrl");
    if (this.repositoriesUrl.equals(newValue)) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        newValue,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Installation#htmlUrl() htmlUrl} attribute.
   * @param value The value for htmlUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallation withHtmlUrl(String value) {
    String newValue = Objects.requireNonNull(value, "htmlUrl");
    if (Objects.equals(this.htmlUrl, newValue)) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        newValue,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Installation#htmlUrl() htmlUrl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for htmlUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallation withHtmlUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.htmlUrl, value)) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        value,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Installation#appId() appId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for appId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstallation withAppId(int value) {
    if (this.appId == value) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        value,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Installation#targetId() targetId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstallation withTargetId(int value) {
    if (this.targetId == value) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        value,
        this.targetType,
        this.permissions,
        this.events,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Installation#targetType() targetType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstallation withTargetType(String value) {
    String newValue = Objects.requireNonNull(value, "targetType");
    if (this.targetType.equals(newValue)) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        newValue,
        this.permissions,
        this.events,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by replacing the {@link Installation#permissions() permissions} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the permissions map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallation withPermissions(Map<String, ? extends String> entries) {
    if (this.permissions == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        newValue,
        this.events,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Installation#events() events}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallation withEvents(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        newValue,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Installation#events() events}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of events elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallation withEvents(Iterable<String> elements) {
    if (this.events == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        newValue,
        this.singleFileName,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Installation#singleFileName() singleFileName} attribute.
   * @param value The value for singleFileName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallation withSingleFileName(String value) {
    String newValue = Objects.requireNonNull(value, "singleFileName");
    if (Objects.equals(this.singleFileName, newValue)) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        newValue,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Installation#singleFileName() singleFileName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for singleFileName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallation withSingleFileName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.singleFileName, value)) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        value,
        this.repositorySelection);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Installation#repositorySelection() repositorySelection} attribute.
   * @param value The value for repositorySelection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallation withRepositorySelection(String value) {
    String newValue = Objects.requireNonNull(value, "repositorySelection");
    if (Objects.equals(this.repositorySelection, newValue)) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        this.singleFileName,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Installation#repositorySelection() repositorySelection} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for repositorySelection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInstallation withRepositorySelection(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.repositorySelection, value)) return this;
    return new ImmutableInstallation(
        this.id,
        this.account,
        this.accessTokensUrl,
        this.repositoriesUrl,
        this.htmlUrl,
        this.appId,
        this.targetId,
        this.targetType,
        this.permissions,
        this.events,
        this.singleFileName,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInstallation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInstallation
        && equalTo(0, (ImmutableInstallation) another);
  }

  private boolean equalTo(int synthetic, ImmutableInstallation another) {
    return id == another.id
        && account.equals(another.account)
        && accessTokensUrl.equals(another.accessTokensUrl)
        && repositoriesUrl.equals(another.repositoriesUrl)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && appId == another.appId
        && targetId == another.targetId
        && targetType.equals(another.targetType)
        && permissions.equals(another.permissions)
        && events.equals(another.events)
        && Objects.equals(singleFileName, another.singleFileName)
        && Objects.equals(repositorySelection, another.repositorySelection);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code account}, {@code accessTokensUrl}, {@code repositoriesUrl}, {@code htmlUrl}, {@code appId}, {@code targetId}, {@code targetType}, {@code permissions}, {@code events}, {@code singleFileName}, {@code repositorySelection}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id;
    h += (h << 5) + account.hashCode();
    h += (h << 5) + accessTokensUrl.hashCode();
    h += (h << 5) + repositoriesUrl.hashCode();
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + appId;
    h += (h << 5) + targetId;
    h += (h << 5) + targetType.hashCode();
    h += (h << 5) + permissions.hashCode();
    h += (h << 5) + events.hashCode();
    h += (h << 5) + Objects.hashCode(singleFileName);
    h += (h << 5) + Objects.hashCode(repositorySelection);
    return h;
  }

  /**
   * Prints the immutable value {@code Installation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Installation{");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("account=").append(account);
    builder.append(", ");
    builder.append("accessTokensUrl=").append(accessTokensUrl);
    builder.append(", ");
    builder.append("repositoriesUrl=").append(repositoriesUrl);
    if (htmlUrl != null) {
      builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    builder.append(", ");
    builder.append("appId=").append(appId);
    builder.append(", ");
    builder.append("targetId=").append(targetId);
    builder.append(", ");
    builder.append("targetType=").append(targetType);
    builder.append(", ");
    builder.append("permissions=").append(permissions);
    builder.append(", ");
    builder.append("events=").append(events);
    if (singleFileName != null) {
      builder.append(", ");
      builder.append("singleFileName=").append(singleFileName);
    }
    if (repositorySelection != null) {
      builder.append(", ");
      builder.append("repositorySelection=").append(repositorySelection);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Installation", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Installation {
    int id;
    boolean idIsSet;
    @Nullable User account;
    @Nullable String accessTokensUrl;
    @Nullable String repositoriesUrl;
    @Nullable Optional<String> htmlUrl = Optional.empty();
    int appId;
    boolean appIdIsSet;
    int targetId;
    boolean targetIdIsSet;
    @Nullable String targetType;
    @Nullable Map<String, String> permissions = Collections.emptyMap();
    @Nullable List<String> events = Collections.emptyList();
    @Nullable Optional<String> singleFileName = Optional.empty();
    @Nullable Optional<String> repositorySelection = Optional.empty();
    @JsonProperty
    public void setId(int id) {
      this.id = id;
      this.idIsSet = true;
    }
    @JsonProperty
    public void setAccount(User account) {
      this.account = account;
    }
    @JsonProperty
    public void setAccessTokensUrl(String accessTokensUrl) {
      this.accessTokensUrl = accessTokensUrl;
    }
    @JsonProperty
    public void setRepositoriesUrl(String repositoriesUrl) {
      this.repositoriesUrl = repositoriesUrl;
    }
    @JsonProperty
    public void setHtmlUrl(Optional<String> htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setAppId(int appId) {
      this.appId = appId;
      this.appIdIsSet = true;
    }
    @JsonProperty
    public void setTargetId(int targetId) {
      this.targetId = targetId;
      this.targetIdIsSet = true;
    }
    @JsonProperty
    public void setTargetType(String targetType) {
      this.targetType = targetType;
    }
    @JsonProperty
    public void setPermissions(Map<String, String> permissions) {
      this.permissions = permissions;
    }
    @JsonProperty
    public void setEvents(List<String> events) {
      this.events = events;
    }
    @JsonProperty
    public void setSingleFileName(Optional<String> singleFileName) {
      this.singleFileName = singleFileName;
    }
    @JsonProperty
    public void setRepositorySelection(Optional<String> repositorySelection) {
      this.repositorySelection = repositorySelection;
    }
    @Override
    public int id() { throw new UnsupportedOperationException(); }
    @Override
    public User account() { throw new UnsupportedOperationException(); }
    @Override
    public String accessTokensUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String repositoriesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public int appId() { throw new UnsupportedOperationException(); }
    @Override
    public int targetId() { throw new UnsupportedOperationException(); }
    @Override
    public String targetType() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> permissions() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> events() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> singleFileName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> repositorySelection() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableInstallation fromJson(Json json) {
    ImmutableInstallation.Builder builder = ImmutableInstallation.builder();
    if (json.idIsSet) {
      builder.id(json.id);
    }
    if (json.account != null) {
      builder.account(json.account);
    }
    if (json.accessTokensUrl != null) {
      builder.accessTokensUrl(json.accessTokensUrl);
    }
    if (json.repositoriesUrl != null) {
      builder.repositoriesUrl(json.repositoriesUrl);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.appIdIsSet) {
      builder.appId(json.appId);
    }
    if (json.targetIdIsSet) {
      builder.targetId(json.targetId);
    }
    if (json.targetType != null) {
      builder.targetType(json.targetType);
    }
    if (json.permissions != null) {
      builder.putAllPermissions(json.permissions);
    }
    if (json.events != null) {
      builder.addAllEvents(json.events);
    }
    if (json.singleFileName != null) {
      builder.singleFileName(json.singleFileName);
    }
    if (json.repositorySelection != null) {
      builder.repositorySelection(json.repositorySelection);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Installation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Installation instance
   */
  public static ImmutableInstallation copyOf(Installation instance) {
    if (instance instanceof ImmutableInstallation) {
      return (ImmutableInstallation) instance;
    }
    return ImmutableInstallation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInstallation ImmutableInstallation}.
   * <pre>
   * ImmutableInstallation.builder()
   *    .id(int) // required {@link Installation#id() id}
   *    .account(com.spotify.github.v3.User) // required {@link Installation#account() account}
   *    .accessTokensUrl(String) // required {@link Installation#accessTokensUrl() accessTokensUrl}
   *    .repositoriesUrl(String) // required {@link Installation#repositoriesUrl() repositoriesUrl}
   *    .htmlUrl(String) // optional {@link Installation#htmlUrl() htmlUrl}
   *    .appId(int) // required {@link Installation#appId() appId}
   *    .targetId(int) // required {@link Installation#targetId() targetId}
   *    .targetType(String) // required {@link Installation#targetType() targetType}
   *    .putPermissions|putAllPermissions(String =&gt; String) // {@link Installation#permissions() permissions} mappings
   *    .addEvents|addAllEvents(String) // {@link Installation#events() events} elements
   *    .singleFileName(String) // optional {@link Installation#singleFileName() singleFileName}
   *    .repositorySelection(String) // optional {@link Installation#repositorySelection() repositorySelection}
   *    .build();
   * </pre>
   * @return A new ImmutableInstallation builder
   */
  public static ImmutableInstallation.Builder builder() {
    return new ImmutableInstallation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInstallation ImmutableInstallation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Installation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_ACCOUNT = 0x2L;
    private static final long INIT_BIT_ACCESS_TOKENS_URL = 0x4L;
    private static final long INIT_BIT_REPOSITORIES_URL = 0x8L;
    private static final long INIT_BIT_APP_ID = 0x10L;
    private static final long INIT_BIT_TARGET_ID = 0x20L;
    private static final long INIT_BIT_TARGET_TYPE = 0x40L;
    private long initBits = 0x7fL;

    private int id;
    private @Nullable User account;
    private @Nullable String accessTokensUrl;
    private @Nullable String repositoriesUrl;
    private @Nullable String htmlUrl;
    private int appId;
    private int targetId;
    private @Nullable String targetType;
    private Map<String, String> permissions = new LinkedHashMap<String, String>();
    private List<String> events = new ArrayList<String>();
    private @Nullable String singleFileName;
    private @Nullable String repositorySelection;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Installation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Installation instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      account(instance.account());
      accessTokensUrl(instance.accessTokensUrl());
      repositoriesUrl(instance.repositoriesUrl());
      Optional<String> htmlUrlOptional = instance.htmlUrl();
      if (htmlUrlOptional.isPresent()) {
        htmlUrl(htmlUrlOptional);
      }
      appId(instance.appId());
      targetId(instance.targetId());
      targetType(instance.targetType());
      putAllPermissions(instance.permissions());
      addAllEvents(instance.events());
      Optional<String> singleFileNameOptional = instance.singleFileName();
      if (singleFileNameOptional.isPresent()) {
        singleFileName(singleFileNameOptional);
      }
      Optional<String> repositorySelectionOptional = instance.repositorySelection();
      if (repositorySelectionOptional.isPresent()) {
        repositorySelection(repositorySelectionOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Installation#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(int id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Installation#account() account} attribute.
     * @param account The value for account 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder account(User account) {
      this.account = Objects.requireNonNull(account, "account");
      initBits &= ~INIT_BIT_ACCOUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link Installation#accessTokensUrl() accessTokensUrl} attribute.
     * @param accessTokensUrl The value for accessTokensUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder accessTokensUrl(String accessTokensUrl) {
      this.accessTokensUrl = Objects.requireNonNull(accessTokensUrl, "accessTokensUrl");
      initBits &= ~INIT_BIT_ACCESS_TOKENS_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link Installation#repositoriesUrl() repositoriesUrl} attribute.
     * @param repositoriesUrl The value for repositoriesUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repositoriesUrl(String repositoriesUrl) {
      this.repositoriesUrl = Objects.requireNonNull(repositoriesUrl, "repositoriesUrl");
      initBits &= ~INIT_BIT_REPOSITORIES_URL;
      return this;
    }

    /**
     * Initializes the optional value {@link Installation#htmlUrl() htmlUrl} to htmlUrl.
     * @param htmlUrl The value for htmlUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder htmlUrl(String htmlUrl) {
      this.htmlUrl = Objects.requireNonNull(htmlUrl, "htmlUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link Installation#htmlUrl() htmlUrl} to htmlUrl.
     * @param htmlUrl The value for htmlUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(Optional<String> htmlUrl) {
      this.htmlUrl = htmlUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Installation#appId() appId} attribute.
     * @param appId The value for appId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder appId(int appId) {
      this.appId = appId;
      initBits &= ~INIT_BIT_APP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Installation#targetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder targetId(int targetId) {
      this.targetId = targetId;
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Installation#targetType() targetType} attribute.
     * @param targetType The value for targetType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder targetType(String targetType) {
      this.targetType = Objects.requireNonNull(targetType, "targetType");
      initBits &= ~INIT_BIT_TARGET_TYPE;
      return this;
    }

    /**
     * Put one entry to the {@link Installation#permissions() permissions} map.
     * @param key The key in the permissions map
     * @param value The associated value in the permissions map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPermissions(String key, String value) {
      this.permissions.put(
          Objects.requireNonNull(key, "permissions key"),
          value == null ? Objects.requireNonNull(value, "permissions value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link Installation#permissions() permissions} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPermissions(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.permissions.put(
          Objects.requireNonNull(k, "permissions key"),
          v == null ? Objects.requireNonNull(v, "permissions value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Installation#permissions() permissions} map. Nulls are not permitted
     * @param entries The entries that will be added to the permissions map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder permissions(Map<String, ? extends String> entries) {
      this.permissions.clear();
      return putAllPermissions(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Installation#permissions() permissions} map. Nulls are not permitted
     * @param entries The entries that will be added to the permissions map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllPermissions(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.permissions.put(
            Objects.requireNonNull(k, "permissions key"),
            v == null ? Objects.requireNonNull(v, "permissions value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Adds one element to {@link Installation#events() events} list.
     * @param element A events element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEvents(String element) {
      this.events.add(Objects.requireNonNull(element, "events element"));
      return this;
    }

    /**
     * Adds elements to {@link Installation#events() events} list.
     * @param elements An array of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEvents(String... elements) {
      for (String element : elements) {
        this.events.add(Objects.requireNonNull(element, "events element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Installation#events() events} list.
     * @param elements An iterable of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder events(Iterable<String> elements) {
      this.events.clear();
      return addAllEvents(elements);
    }

    /**
     * Adds elements to {@link Installation#events() events} list.
     * @param elements An iterable of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEvents(Iterable<String> elements) {
      for (String element : elements) {
        this.events.add(Objects.requireNonNull(element, "events element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Installation#singleFileName() singleFileName} to singleFileName.
     * @param singleFileName The value for singleFileName
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder singleFileName(String singleFileName) {
      this.singleFileName = Objects.requireNonNull(singleFileName, "singleFileName");
      return this;
    }

    /**
     * Initializes the optional value {@link Installation#singleFileName() singleFileName} to singleFileName.
     * @param singleFileName The value for singleFileName
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder singleFileName(Optional<String> singleFileName) {
      this.singleFileName = singleFileName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Installation#repositorySelection() repositorySelection} to repositorySelection.
     * @param repositorySelection The value for repositorySelection
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repositorySelection(String repositorySelection) {
      this.repositorySelection = Objects.requireNonNull(repositorySelection, "repositorySelection");
      return this;
    }

    /**
     * Initializes the optional value {@link Installation#repositorySelection() repositorySelection} to repositorySelection.
     * @param repositorySelection The value for repositorySelection
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repositorySelection(Optional<String> repositorySelection) {
      this.repositorySelection = repositorySelection.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableInstallation ImmutableInstallation}.
     * @return An immutable instance of Installation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInstallation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInstallation(
          id,
          account,
          accessTokensUrl,
          repositoriesUrl,
          htmlUrl,
          appId,
          targetId,
          targetType,
          createUnmodifiableMap(false, false, permissions),
          createUnmodifiableList(true, events),
          singleFileName,
          repositorySelection);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_ACCOUNT) != 0) attributes.add("account");
      if ((initBits & INIT_BIT_ACCESS_TOKENS_URL) != 0) attributes.add("accessTokensUrl");
      if ((initBits & INIT_BIT_REPOSITORIES_URL) != 0) attributes.add("repositoriesUrl");
      if ((initBits & INIT_BIT_APP_ID) != 0) attributes.add("appId");
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      if ((initBits & INIT_BIT_TARGET_TYPE) != 0) attributes.add("targetType");
      return "Cannot build Installation, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
