package com.spotify.github.v3.comment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Comment}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComment.builder()}.
 */
@Generated(from = "Comment", generator = "Immutables")
@SuppressWarnings({"all", "deprecation", "removal"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableComment implements Comment {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable URI url;
  private final @Nullable URI htmlUrl;
  private final int id;
  private final @Nullable User user;
  private final @Nullable Integer position;
  private final @Nullable Integer line;
  private final @Nullable String path;
  private final @Nullable String commitId;
  private final @Nullable String body;
  private final @Nullable URI issueUrl;

  private ImmutableComment(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable URI url,
      @Nullable URI htmlUrl,
      int id,
      @Nullable User user,
      @Nullable Integer position,
      @Nullable Integer line,
      @Nullable String path,
      @Nullable String commitId,
      @Nullable String body,
      @Nullable URI issueUrl) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.url = url;
    this.htmlUrl = htmlUrl;
    this.id = id;
    this.user = user;
    this.position = position;
    this.line = line;
    this.path = path;
    this.commitId = commitId;
    this.body = body;
    this.issueUrl = issueUrl;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   *Comment API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Comment URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Comment ID. 
   */
  @JsonProperty
  @Override
  public int id() {
    return id;
  }

  /**
   *The {@link User} that made the comment. 
   */
  @JsonProperty
  @Override
  public @Nullable User user() {
    return user;
  }

  /**
   *Line index in the diff to comment on. 
   */
  @JsonProperty
  @Override
  public Optional<Integer> position() {
    return Optional.ofNullable(position);
  }

  /**
   * Line number in the file to comment on.
   * @deprecated Use {@link #position()} instead
   */
  @JsonProperty
  @Deprecated
  @Override
  public Optional<Integer> line() {
    return Optional.ofNullable(line);
  }

  /**
   *Relative path of the file to comment on. 
   */
  @JsonProperty
  @Override
  public Optional<String> path() {
    return Optional.ofNullable(path);
  }

  /**
   *Commit sha this comment relates to 
   */
  @JsonProperty
  @Override
  public Optional<String> commitId() {
    return Optional.ofNullable(commitId);
  }

  /**
   *The contents of the comment. 
   */
  @JsonProperty
  @Override
  public @Nullable String body() {
    return body;
  }

  /**
   *The issueURL which the comment belongs to. 
   */
  @JsonProperty
  @Override
  public Optional<URI> issueUrl() {
    return Optional.ofNullable(issueUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableComment(
        value,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        this.line,
        this.path,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableComment(
        this.createdAt,
        value,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        this.line,
        this.path,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        value,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        this.line,
        this.path,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        value,
        this.id,
        this.user,
        this.position,
        this.line,
        this.path,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#id() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withId(int value) {
    if (this.id == value) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        value,
        this.user,
        this.position,
        this.line,
        this.path,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#user() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withUser(@Nullable User value) {
    if (this.user == value) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        value,
        this.position,
        this.line,
        this.path,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Comment#position() position} attribute.
   * @param value The value for position
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComment withPosition(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.position, newValue)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        newValue,
        this.line,
        this.path,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Comment#position() position} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for position
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComment withPosition(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.position, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        value,
        this.line,
        this.path,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Comment#line() line} attribute.
   * @param value The value for line
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableComment withLine(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.line, newValue)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        newValue,
        this.path,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Comment#line() line} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for line
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableComment withLine(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.line, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        value,
        this.path,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Comment#path() path} attribute.
   * @param value The value for path
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComment withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (Objects.equals(this.path, newValue)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        this.line,
        newValue,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Comment#path() path} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for path
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComment withPath(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.path, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        this.line,
        value,
        this.commitId,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Comment#commitId() commitId} attribute.
   * @param value The value for commitId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComment withCommitId(String value) {
    String newValue = Objects.requireNonNull(value, "commitId");
    if (Objects.equals(this.commitId, newValue)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        this.line,
        this.path,
        newValue,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Comment#commitId() commitId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for commitId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComment withCommitId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.commitId, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        this.line,
        this.path,
        value,
        this.body,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Comment#body() body} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComment withBody(@Nullable String value) {
    if (Objects.equals(this.body, value)) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        this.line,
        this.path,
        this.commitId,
        value,
        this.issueUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Comment#issueUrl() issueUrl} attribute.
   * @param value The value for issueUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComment withIssueUrl(URI value) {
    URI newValue = Objects.requireNonNull(value, "issueUrl");
    if (this.issueUrl == newValue) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        this.line,
        this.path,
        this.commitId,
        this.body,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Comment#issueUrl() issueUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for issueUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableComment withIssueUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.issueUrl == value) return this;
    return new ImmutableComment(
        this.createdAt,
        this.updatedAt,
        this.url,
        this.htmlUrl,
        this.id,
        this.user,
        this.position,
        this.line,
        this.path,
        this.commitId,
        this.body,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComment} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComment
        && equalTo(0, (ImmutableComment) another);
  }

  private boolean equalTo(int synthetic, ImmutableComment another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(url, another.url)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && id == another.id
        && Objects.equals(user, another.user)
        && Objects.equals(position, another.position)
        && Objects.equals(line, another.line)
        && Objects.equals(path, another.path)
        && Objects.equals(commitId, another.commitId)
        && Objects.equals(body, another.body)
        && Objects.equals(issueUrl, another.issueUrl);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code url}, {@code htmlUrl}, {@code id}, {@code user}, {@code position}, {@code line}, {@code path}, {@code commitId}, {@code body}, {@code issueUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + id;
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(position);
    h += (h << 5) + Objects.hashCode(line);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(commitId);
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Objects.hashCode(issueUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code Comment} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Comment{");
    if (createdAt != null) {
      builder.append("createdAt=").append(createdAt);
    }
    if (updatedAt != null) {
      if (builder.length() > 8) builder.append(", ");
      builder.append("updatedAt=").append(updatedAt);
    }
    if (url != null) {
      if (builder.length() > 8) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (htmlUrl != null) {
      if (builder.length() > 8) builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    if (builder.length() > 8) builder.append(", ");
    builder.append("id=").append(id);
    if (user != null) {
      builder.append(", ");
      builder.append("user=").append(user);
    }
    if (position != null) {
      builder.append(", ");
      builder.append("position=").append(position);
    }
    if (line != null) {
      builder.append(", ");
      builder.append("line=").append(line);
    }
    if (path != null) {
      builder.append(", ");
      builder.append("path=").append(path);
    }
    if (commitId != null) {
      builder.append(", ");
      builder.append("commitId=").append(commitId);
    }
    if (body != null) {
      builder.append(", ");
      builder.append("body=").append(body);
    }
    if (issueUrl != null) {
      builder.append(", ");
      builder.append("issueUrl=").append(issueUrl);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Comment", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Comment {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable URI url;
    @Nullable URI htmlUrl;
    int id;
    boolean idIsSet;
    @Nullable User user;
    @Nullable Optional<Integer> position = Optional.empty();
    @Nullable Optional<Integer> line = Optional.empty();
    @Nullable Optional<String> path = Optional.empty();
    @Nullable Optional<String> commitId = Optional.empty();
    @Nullable String body;
    @Nullable Optional<URI> issueUrl = Optional.empty();
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setId(int id) {
      this.id = id;
      this.idIsSet = true;
    }
    @JsonProperty
    public void setUser(@Nullable User user) {
      this.user = user;
    }
    @JsonProperty
    public void setPosition(Optional<Integer> position) {
      this.position = position;
    }
    @JsonProperty
    public void setLine(Optional<Integer> line) {
      this.line = line;
    }
    @JsonProperty
    public void setPath(Optional<String> path) {
      this.path = path;
    }
    @JsonProperty
    public void setCommitId(Optional<String> commitId) {
      this.commitId = commitId;
    }
    @JsonProperty
    public void setBody(@Nullable String body) {
      this.body = body;
    }
    @JsonProperty
    public void setIssueUrl(Optional<URI> issueUrl) {
      this.issueUrl = issueUrl;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public int id() { throw new UnsupportedOperationException(); }
    @Override
    public User user() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> position() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> line() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> path() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> commitId() { throw new UnsupportedOperationException(); }
    @Override
    public String body() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> issueUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableComment fromJson(Json json) {
    ImmutableComment.Builder builder = ImmutableComment.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.idIsSet) {
      builder.id(json.id);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.position != null) {
      builder.position(json.position);
    }
    if (json.line != null) {
      builder.line(json.line);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.commitId != null) {
      builder.commitId(json.commitId);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.issueUrl != null) {
      builder.issueUrl(json.issueUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Comment} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Comment instance
   */
  public static ImmutableComment copyOf(Comment instance) {
    if (instance instanceof ImmutableComment) {
      return (ImmutableComment) instance;
    }
    return ImmutableComment.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComment ImmutableComment}.
   * <pre>
   * ImmutableComment.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link Comment#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link Comment#updatedAt() updatedAt}
   *    .url(java.net.URI | null) // nullable {@link Comment#url() url}
   *    .htmlUrl(java.net.URI | null) // nullable {@link Comment#htmlUrl() htmlUrl}
   *    .id(int) // required {@link Comment#id() id}
   *    .user(com.spotify.github.v3.User | null) // nullable {@link Comment#user() user}
   *    .position(Integer) // optional {@link Comment#position() position}
   *    .line(Integer) // optional {@link Comment#line() line}
   *    .path(String) // optional {@link Comment#path() path}
   *    .commitId(String) // optional {@link Comment#commitId() commitId}
   *    .body(String | null) // nullable {@link Comment#body() body}
   *    .issueUrl(java.net.URI) // optional {@link Comment#issueUrl() issueUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableComment builder
   */
  public static ImmutableComment.Builder builder() {
    return new ImmutableComment.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComment ImmutableComment}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Comment", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable URI url;
    private @Nullable URI htmlUrl;
    private int id;
    private @Nullable User user;
    private @Nullable Integer position;
    private @Nullable Integer line;
    private @Nullable String path;
    private @Nullable String commitId;
    private @Nullable String body;
    private @Nullable URI issueUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.comment.Comment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Comment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Comment) {
        Comment instance = (Comment) object;
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        Optional<String> pathOptional = instance.path();
        if (pathOptional.isPresent()) {
          path(pathOptional);
        }
        Optional<URI> issueUrlOptional = instance.issueUrl();
        if (issueUrlOptional.isPresent()) {
          issueUrl(issueUrlOptional);
        }
        Optional<Integer> lineOptional = instance.line();
        if (lineOptional.isPresent()) {
          line(lineOptional);
        }
        @Nullable URI htmlUrlValue = instance.htmlUrl();
        if (htmlUrlValue != null) {
          htmlUrl(htmlUrlValue);
        }
        id(instance.id());
        Optional<Integer> positionOptional = instance.position();
        if (positionOptional.isPresent()) {
          position(positionOptional);
        }
        Optional<String> commitIdOptional = instance.commitId();
        if (commitIdOptional.isPresent()) {
          commitId(commitIdOptional);
        }
        @Nullable String bodyValue = instance.body();
        if (bodyValue != null) {
          body(bodyValue);
        }
        @Nullable User userValue = instance.user();
        if (userValue != null) {
          user(userValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        if ((bits & 0x2L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        if ((bits & 0x1L) == 0) {
          @Nullable GitHubInstant createdAtValue = instance.createdAt();
          if (createdAtValue != null) {
            createdAt(createdAtValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Comment#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(int id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#user() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder user(@Nullable User user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the optional value {@link Comment#position() position} to position.
     * @param position The value for position
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder position(int position) {
      this.position = position;
      return this;
    }

    /**
     * Initializes the optional value {@link Comment#position() position} to position.
     * @param position The value for position
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder position(Optional<Integer> position) {
      this.position = position.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Comment#line() line} to line.
     * @param line The value for line
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder line(int line) {
      this.line = line;
      return this;
    }

    /**
     * Initializes the optional value {@link Comment#line() line} to line.
     * @param line The value for line
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    @Deprecated
    public final Builder line(Optional<Integer> line) {
      this.line = line.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Comment#path() path} to path.
     * @param path The value for path
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      return this;
    }

    /**
     * Initializes the optional value {@link Comment#path() path} to path.
     * @param path The value for path
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder path(Optional<String> path) {
      this.path = path.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Comment#commitId() commitId} to commitId.
     * @param commitId The value for commitId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitId(String commitId) {
      this.commitId = Objects.requireNonNull(commitId, "commitId");
      return this;
    }

    /**
     * Initializes the optional value {@link Comment#commitId() commitId} to commitId.
     * @param commitId The value for commitId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitId(Optional<String> commitId) {
      this.commitId = commitId.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Comment#body() body} attribute.
     * @param body The value for body (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(@Nullable String body) {
      this.body = body;
      return this;
    }

    /**
     * Initializes the optional value {@link Comment#issueUrl() issueUrl} to issueUrl.
     * @param issueUrl The value for issueUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder issueUrl(URI issueUrl) {
      this.issueUrl = Objects.requireNonNull(issueUrl, "issueUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link Comment#issueUrl() issueUrl} to issueUrl.
     * @param issueUrl The value for issueUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder issueUrl(Optional<? extends URI> issueUrl) {
      this.issueUrl = issueUrl.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableComment ImmutableComment}.
     * @return An immutable instance of Comment
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComment build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableComment(createdAt, updatedAt, url, htmlUrl, id, user, position, line, path, commitId, body, issueUrl);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Comment, some of required attributes are not set " + attributes;
    }
  }
}
