package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Commit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommit.builder()}.
 */
@Generated(from = "Commit", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommit implements Commit {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable Author author;
  private final @Nullable Author committer;
  private final @Nullable String message;
  private final @Nullable ShaLink tree;
  private final @Nullable Integer commentCount;

  private ImmutableCommit(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable Author author,
      @Nullable Author committer,
      @Nullable String message,
      @Nullable ShaLink tree,
      @Nullable Integer commentCount) {
    this.sha = sha;
    this.url = url;
    this.author = author;
    this.committer = committer;
    this.message = message;
    this.tree = tree;
    this.commentCount = commentCount;
  }

  /**
   *Commit sha value. 
   */
  @JsonProperty
  @Override
  public Optional<String> sha() {
    return Optional.ofNullable(sha);
  }

  /**
   *Commit API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Author commit user. 
   */
  @JsonProperty
  @Override
  public @Nullable Author author() {
    return author;
  }

  /**
   *Committer commit user. 
   */
  @JsonProperty
  @Override
  public @Nullable Author committer() {
    return committer;
  }

  /**
   *Commit message. 
   */
  @JsonProperty
  @Override
  public @Nullable String message() {
    return message;
  }

  /**
   *The SHA of the tree object this commit points to. 
   */
  @JsonProperty
  @Override
  public @Nullable ShaLink tree() {
    return tree;
  }

  /**
   *Number of comments. 
   */
  @JsonProperty
  @Override
  public Optional<Integer> commentCount() {
    return Optional.ofNullable(commentCount);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Commit#sha() sha} attribute.
   * @param value The value for sha
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withSha(String value) {
    String newValue = Objects.requireNonNull(value, "sha");
    if (Objects.equals(this.sha, newValue)) return this;
    return new ImmutableCommit(newValue, this.url, this.author, this.committer, this.message, this.tree, this.commentCount);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Commit#sha() sha} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sha
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withSha(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableCommit(value, this.url, this.author, this.committer, this.message, this.tree, this.commentCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableCommit(this.sha, value, this.author, this.committer, this.message, this.tree, this.commentCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#author() author} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withAuthor(@Nullable Author value) {
    if (this.author == value) return this;
    return new ImmutableCommit(this.sha, this.url, value, this.committer, this.message, this.tree, this.commentCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#committer() committer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for committer (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withCommitter(@Nullable Author value) {
    if (this.committer == value) return this;
    return new ImmutableCommit(this.sha, this.url, this.author, value, this.message, this.tree, this.commentCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withMessage(@Nullable String value) {
    if (Objects.equals(this.message, value)) return this;
    return new ImmutableCommit(this.sha, this.url, this.author, this.committer, value, this.tree, this.commentCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Commit#tree() tree} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tree (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withTree(@Nullable ShaLink value) {
    if (this.tree == value) return this;
    return new ImmutableCommit(this.sha, this.url, this.author, this.committer, this.message, value, this.commentCount);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Commit#commentCount() commentCount} attribute.
   * @param value The value for commentCount
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withCommentCount(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.commentCount, newValue)) return this;
    return new ImmutableCommit(this.sha, this.url, this.author, this.committer, this.message, this.tree, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Commit#commentCount() commentCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for commentCount
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withCommentCount(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.commentCount, value)) return this;
    return new ImmutableCommit(this.sha, this.url, this.author, this.committer, this.message, this.tree, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommit
        && equalTo(0, (ImmutableCommit) another);
  }

  private boolean equalTo(int synthetic, ImmutableCommit another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(author, another.author)
        && Objects.equals(committer, another.committer)
        && Objects.equals(message, another.message)
        && Objects.equals(tree, another.tree)
        && Objects.equals(commentCount, another.commentCount);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code author}, {@code committer}, {@code message}, {@code tree}, {@code commentCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(author);
    h += (h << 5) + Objects.hashCode(committer);
    h += (h << 5) + Objects.hashCode(message);
    h += (h << 5) + Objects.hashCode(tree);
    h += (h << 5) + Objects.hashCode(commentCount);
    return h;
  }

  /**
   * Prints the immutable value {@code Commit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Commit{");
    if (sha != null) {
      builder.append("sha=").append(sha);
    }
    if (url != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (author != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("author=").append(author);
    }
    if (committer != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("committer=").append(committer);
    }
    if (message != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("message=").append(message);
    }
    if (tree != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("tree=").append(tree);
    }
    if (commentCount != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("commentCount=").append(commentCount);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Commit", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Commit {
    @Nullable Optional<String> sha = Optional.empty();
    @Nullable URI url;
    @Nullable Author author;
    @Nullable Author committer;
    @Nullable String message;
    @Nullable ShaLink tree;
    @Nullable Optional<Integer> commentCount = Optional.empty();
    @JsonProperty
    public void setSha(Optional<String> sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setAuthor(@Nullable Author author) {
      this.author = author;
    }
    @JsonProperty
    public void setCommitter(@Nullable Author committer) {
      this.committer = committer;
    }
    @JsonProperty
    public void setMessage(@Nullable String message) {
      this.message = message;
    }
    @JsonProperty
    public void setTree(@Nullable ShaLink tree) {
      this.tree = tree;
    }
    @JsonProperty
    public void setCommentCount(Optional<Integer> commentCount) {
      this.commentCount = commentCount;
    }
    @Override
    public Optional<String> sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public Author author() { throw new UnsupportedOperationException(); }
    @Override
    public Author committer() { throw new UnsupportedOperationException(); }
    @Override
    public String message() { throw new UnsupportedOperationException(); }
    @Override
    public ShaLink tree() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> commentCount() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCommit fromJson(Json json) {
    ImmutableCommit.Builder builder = ImmutableCommit.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.author != null) {
      builder.author(json.author);
    }
    if (json.committer != null) {
      builder.committer(json.committer);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.tree != null) {
      builder.tree(json.tree);
    }
    if (json.commentCount != null) {
      builder.commentCount(json.commentCount);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Commit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Commit instance
   */
  public static ImmutableCommit copyOf(Commit instance) {
    if (instance instanceof ImmutableCommit) {
      return (ImmutableCommit) instance;
    }
    return ImmutableCommit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommit ImmutableCommit}.
   * <pre>
   * ImmutableCommit.builder()
   *    .sha(String) // optional {@link Commit#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link Commit#url() url}
   *    .author(com.spotify.github.v3.git.Author | null) // nullable {@link Commit#author() author}
   *    .committer(com.spotify.github.v3.git.Author | null) // nullable {@link Commit#committer() committer}
   *    .message(String | null) // nullable {@link Commit#message() message}
   *    .tree(com.spotify.github.v3.git.ShaLink | null) // nullable {@link Commit#tree() tree}
   *    .commentCount(Integer) // optional {@link Commit#commentCount() commentCount}
   *    .build();
   * </pre>
   * @return A new ImmutableCommit builder
   */
  public static ImmutableCommit.Builder builder() {
    return new ImmutableCommit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommit ImmutableCommit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Commit", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private @Nullable Author author;
    private @Nullable Author committer;
    private @Nullable String message;
    private @Nullable ShaLink tree;
    private @Nullable Integer commentCount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Commit} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Commit instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> shaOptional = instance.sha();
      if (shaOptional.isPresent()) {
        sha(shaOptional);
      }
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable Author authorValue = instance.author();
      if (authorValue != null) {
        author(authorValue);
      }
      @Nullable Author committerValue = instance.committer();
      if (committerValue != null) {
        committer(committerValue);
      }
      @Nullable String messageValue = instance.message();
      if (messageValue != null) {
        message(messageValue);
      }
      @Nullable ShaLink treeValue = instance.tree();
      if (treeValue != null) {
        tree(treeValue);
      }
      Optional<Integer> commentCountOptional = instance.commentCount();
      if (commentCountOptional.isPresent()) {
        commentCount(commentCountOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Commit#sha() sha} to sha.
     * @param sha The value for sha
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sha(String sha) {
      this.sha = Objects.requireNonNull(sha, "sha");
      return this;
    }

    /**
     * Initializes the optional value {@link Commit#sha() sha} to sha.
     * @param sha The value for sha
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(Optional<String> sha) {
      this.sha = sha.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Commit#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Commit#author() author} attribute.
     * @param author The value for author (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder author(@Nullable Author author) {
      this.author = author;
      return this;
    }

    /**
     * Initializes the value for the {@link Commit#committer() committer} attribute.
     * @param committer The value for committer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder committer(@Nullable Author committer) {
      this.committer = committer;
      return this;
    }

    /**
     * Initializes the value for the {@link Commit#message() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder message(@Nullable String message) {
      this.message = message;
      return this;
    }

    /**
     * Initializes the value for the {@link Commit#tree() tree} attribute.
     * @param tree The value for tree (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder tree(@Nullable ShaLink tree) {
      this.tree = tree;
      return this;
    }

    /**
     * Initializes the optional value {@link Commit#commentCount() commentCount} to commentCount.
     * @param commentCount The value for commentCount
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commentCount(int commentCount) {
      this.commentCount = commentCount;
      return this;
    }

    /**
     * Initializes the optional value {@link Commit#commentCount() commentCount} to commentCount.
     * @param commentCount The value for commentCount
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commentCount(Optional<Integer> commentCount) {
      this.commentCount = commentCount.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommit ImmutableCommit}.
     * @return An immutable instance of Commit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommit build() {
      return new ImmutableCommit(sha, url, author, committer, message, tree, commentCount);
    }
  }
}
